<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Email Update</title>
    <link rel="icon" href="gplogofinal.png" type="png">

    <!-- Custom fonts for this template-->
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link rel="stylesheet" href="{{ asset('frontend/css/sb-admin-2.min.css')}}">
    <style>
        .a:hover {
            color: #fff;
        }
    </style>

    <script>
        window.onload = function() {
            var inputElement = document.getElementById('i_box');
            inputElement.focus();
        };
    </script>
</head>

<body class="body_1">
    @php
    $head_det = \App\Models\orgs::where('user_id_number', Session::get('user_data'))->get();
    $empl_tno = Session::get('user_data');
    @endphp


    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-6  col-lg-12 col-md-9">
                <div id="card" class=" card o-hidden border-0 shadow-lg my-5">
                    <div class="card-body p-0">
                        <div class="row">
                            <div class="col-lg-12">
                                @if ($message = Session::get('success'))
                                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                    {{$message}}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                        <div id="error-message" style="color: red;"></div>
                                    </button>
                                </div>
                                @endif
                                <div class="p-5">
                                    <div class="text-center">
                                        <h1 class="h4 text-white mb-5">Change Your Email?</h1>
                                    </div>
                                    @if(!session('otp_sent'))
                                    <form method="POST" action="{{ route('Send_otp') }}">
                                        @csrf
                                        <div class="form-group">
                                            <input type="hidden" name="empl_tno" value="{{ $empl_tno }}">
                                            <input type="email" name="new_email" id="i_box" class="form-control mb-5 text-white  form-control-user" placeholder="Enter New Email" title="Please enter a valid email in the format '.it@gainup.in' or 'richworld.online' or '@eazybuy.in" required style="background:none; border:none; border-bottom:1px solid red; outline:none; border-radious:80%; " onfocus="this.style.background='none';" onblur="this.style.background='none';">
                                        </div>
                                        <div class="d-flex justify-content-center">
                                            <button type="submit" class="btn d-flex justify-content-center btn-primary btn-user w-50 ">Send OTP</button>
                                        </div>
                                    </form>
                                    @endif
                                    <hr>
                                    @if ($errors->has('new_email'))
                                    <span class="text-danger">{{ $errors->first('new_email') }}Please enter a valid email in the format '.@gainup.in or @eazybuy.com or richworld.online</span>
                                    @endif
                                    @if(session('exists'))
                                    <!-- CHECKING THE MAIL IF ALREADY EXISTS -->
                                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                        <strong>Email </strong> is already Exists.
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                            <div id="error-message" style="color: red;"></div>
                                        </button>
                                    </div>
                                    @endif
                                    <div class="text-center">
                                        <a href="profile" class="a ">Don't want to change. Go profile /<a class=" a" href="dashboard">Go Home.</a></a>
                                    </div>
                                    <div class="text-center">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script>
        const emailInput = document.getElementById('new_email');
        const errorMessage = document.getElementById('error-message');

        emailInput.addEventListener('input', function() {
            if (!emailInput.validity.valid) {
                errorMessage.textContent = 'Please enter a valid 4-digit value.';
            } else {
                errorMessage.textContent = '';
            }
        });
    </script>



</body>

</html>