<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>PROJECT DETAIL</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <!-- FOR STAR RATING -->
    <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">

    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }
    </style>

    <!-- APPROVE AND AMOUNT DETAILS -->
    <style>
        .total-order ul li {
            align-items: center;
            -webkit-box-align: center;
            -ms-flex-align: center
        }

        .total-order ul li {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex
        }

        .total-order {
            max-width: 430px;
            width: 100%;
            margin: 30px 30px 30px auto
        }

        .total-order ul {
            margin: 0;
            padding: 0
        }

        .total-order ul li {
            border: 1px solid #f8f8f8;
            border-top: 0
        }

        .total-order ul li h4 {
            width: 50%;
            color: #637381;
            font-size: 14px;
            font-weight: 500;
            padding: 10px;
            border-right: 1px solid #f8f8f8;
            background: #fafbfe
        }

        .total-order ul li h5 {
            color: #212b36;
            font-size: 14px;
            padding: 10px;
            font-weight: 700;
            text-align: right;
            width: 50%
        }

        .total-order ul li:first-child {
            border-top: 1px solid #f8f8f8
        }

        .total-order ul li.total h5 {
            color: #212b36;
            font-weight: 700
        }

        .total-order ul li.total h4 {
            color: #5e5873;
            font-weight: 700
        }
    </style>

    <!-- STYLE FOR STAR -->
    <style>
        @import url(https://fonts.googleapis.com/css?family=Roboto:500,100,300,700,400);

        body {
            background-color: #eee;

        }

        div.stars {

            display: inline-block;
        }

        input.star {

            display: none;
        }

        label.star {

            float: right;

            padding-left: 10px;

            font-size: 35px !important;

            color: #4A148C;

            transition: all .2s;

        }

        input.star:checked~label.star:before {

            content: '\f005';

            color: #FD4;

            transition: all .25s;

        }

        input.star-5:checked~label.star:before {

            color: #FE7;

            text-shadow: 0 0 20px #952;

        }

        input.star-1:checked~label.star:before {
            color: #F62;
        }

        label.star:hover {
            transform: rotate(-15deg) scale(1.3);
        }

        label.star:before {

            content: '\f006';

            font-family: FontAwesome;

        }
    </style>
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->
</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->
    @section('tittle') {{"PROJECT DETAIL"}}@endsection

    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="live-preview">
                                        <!-- BACK BUTTON -->
                                        <div class="navbar-nav topbar-nav ml-md-auto align-items-end text-center">
                                            <button type="button" class="btn" title="Back" onclick="window.location.href = '/project'" style="border: 2px solid black;">
                                                <i class="fa-solid fa-arrow-left-long"></i>
                                            </button>
                                        </div>
                                        <div class="row">
                                            <!-- INV NO -->
                                            <div class="col-md-3">
                                                <div class="mb-3">
                                                    <label class="form-label">INVOICE NO<span class="login-danger"></span></label>
                                                    <input type="text" value="{{ request ('Invoice_No') }}" class="form-control dull" readonly>
                                                </div>
                                            </div>
                                            <!-- INV DATE -->
                                            <div class="col-md-3">
                                                <div class="mb-3">
                                                    <label class="form-label">INVOICE DATE<span class="login-danger"></span></label>
                                                    <input type="text" value="{{ date('d-m-Y', strtotime(request('Invoice_Date'))) }}" class="form-control dull" readonly>
                                                </div>
                                            </div>
                                            <!-- PARTY -->
                                            <div class="col-md-3">
                                                <div class="mb-3">
                                                    <label for="firstNameinput" class="form-label">PARTY</label>
                                                    <input type="text" value="{{ request ('Party') }}" class="form-control dull" readonly>
                                                </div>
                                            </div>
                                            <!-- DEP -->
                                            <div class="col-md-3">
                                                <div class="mb-3">
                                                    <label for="firstNameinput" class="form-label">DEPARTMENT</label>
                                                    <input type="text" value="{{ request ('Department') }}" class="form-control dull" readonly>
                                                </div>
                                            </div>
                                        </div>
                                        <br>
                                        <div class="row">
                                            <!-- DIVISION -->
                                            <div class="col-md-3">
                                                <div class="mb-3">
                                                    <label for="firstNameinput" class="form-label">DIVISION</label>
                                                    <input type="text" value="{{ request ('Division') }}" class="form-control dull" readonly>
                                                </div>
                                            </div>
                                            <!-- MODULES -->
                                            <div class="col-md-3">
                                                <div class="mb-3">
                                                    <label for="firstNameinput" class="form-label">MODULES</label>
                                                    <input type="text" value="{{ request ('Modules') }}" class="form-control dull" readonly>
                                                </div>
                                            </div>
                                            <!-- TOT HRS -->
                                            <div class="col-md-2">
                                                <div class="mb-3">
                                                    <label for="firstNameinput" class="form-label">TOT HRS</label>
                                                    <input type="text" value="{{ request ('Total_hrs') }}" class="form-control dull" readonly>
                                                </div>
                                            </div>
                                            <!-- DEVELOPER -->
                                            <div class="col-md-2">
                                                <div class="mb-3">
                                                    <label for="firstNameinput" class="form-label">DEVELOPER</label>
                                                    <input type="text" value="{{ request ('Developer') }}" class="form-control dull" readonly>
                                                </div>
                                            </div>
                                            <!-- FC -->
                                            <div class="col-md-2">
                                                <div class="mb-3">
                                                    <label for="validationTextarea" class="form-label">FC<span class="login-danger">*</span></label>
                                                    <input type="text" value="{{ request ('FC_Name') }}" class="form-control dull" readonly>
                                                </div>
                                            </div>
                                        </div>
                                        <br>

                                        <!-- TABLE -->
                                        <div class="card-body">
                                            <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                                <table class="table table-centered align-middle table-nowrap mb-0" id="dataTable" style="line-height: 30px !important;">
                                                    <thead class="text-muted table-light">
                                                        <tr>
                                                            <th data-sort="sno"> SNO <span class="sort-icon"></th>
                                                            <th data-sort="entry_no"> W-Subject <span class="sort-icon"></th>
                                                            <th data-sort="date"> Activity Hrs <span class="sort-icon"></th>
                                                            <th data-sort="eff-from"> Dev Hrs <span class="sort-icon"></th>
                                                            <th data-sort="Rate"> Rate <span class="sort-icon"></th>
                                                            <th data-sort="Amount"> Amount <span class="sort-icon"></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($result1 as $row)
                                                        <tr>
                                                            <td>{{ $row['Slno'] }}</td>
                                                            <td>{{ $row['Subject'] }}</td>
                                                            <td>{{ $row['Activity_Hrs'] }}</td>
                                                            <td>{{ $row['Dev_Hrs'] }}</td>
                                                            <td>{{ $row['Rate'] }}</td>
                                                            <td>{{ $row['Amount'] }}</td>
                                                        </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>

                                        <br>

                                        <div class="row">
                                            <!-- TO PRINT -->
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="firstNameinput" class="form-label">To Print</label>
                                                    <input type="text" value="{{ request ('To_Print') }}" class="form-control dull" readonly>
                                                </div>
                                            </div>
                                            <!-- REMARKS -->
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="validationTextarea" class="form-label">REMARKS<span class="login-danger">*</span></label>
                                                    <input type="text" value="{{ request ('Remarks_To_Print') }}" class="form-control dull" readonly>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="row">
                                            <div class="col-lg-6 float-md-left">
                                                <div class="total-order">
                                                    <ul>
                                                        <li>
                                                            <h4>Level-1 Approval</h4>
                                                            <h5 class="rateDebit">{{ request ('Approval_Level_1') }}</h5>
                                                            @if(request ('AF1') == 'F')
                                                            <!-- <h2><i class="fa-regular fa-thumbs-up fa-bounce" style="color: #19e126;"></i></h2> -->
                                                            <h2><i class="fa-regular fa-hourglass-half fa-spin" style="color: #FFD43B;"></i></h2>
                                                            @else
                                                            <h2><i class="fa-regular fa-thumbs-up fa-bounce" style="color: #19e126;"></i></h2>
                                                            @endif
                                                        </li>
                                                        @if(request('Approval_Level_2' ) == null)
                                                        @else
                                                        <li>
                                                            <h4>Level-2 Approval</h4>
                                                            <h5 class="rateDebit">{{ request ('Approval_Level_2') }}</h5>
                                                            @if(request ('AF2') == 'T')
                                                            <h2><i class="fa-regular fa-thumbs-up fa-bounce" style="color: #19e126;"></i></h2>
                                                            @else
                                                            <h2><i class="fa-regular fa-hourglass-half fa-spin" style="color: #FFD43B;"></i></h2>
                                                            @endif
                                                        </li>
                                                        @endif
                                                        @if(request('Approval_Level_3') == null)
                                                        @else
                                                        <li>
                                                            <h4>Level-3 Approval</h4>
                                                            <h5 class="rateDebit">{{ request ('Approval_Level_3') }}</h5>
                                                            @if(request ('AF3') == 'T')
                                                            <h2><i class="fa-regular fa-thumbs-up" style="color: #19e126;"></i></h2>
                                                            @else
                                                            <h2><i class="fa-regular fa-hourglass-half fa-spin" style="color: #FFD43B;"></i></h2>
                                                            @endif
                                                        </li>
                                                        @endif
                                                    </ul>
                                                </div>
                                            </div>

                                            <div class="col-lg-6 float-md-right">
                                                <div class="total-order">
                                                    <ul>
                                                        <li>
                                                            <h4>Gross</h4>
                                                            <h5 class="totalTaxCost">{{ request ('Gross_Amount') }} &#8377;</h5>
                                                            <input type="hidden" name="totalTaxCost" class="totalTaxCost-input">
                                                        </li>
                                                        <li>
                                                            <h4>SGST</h4>
                                                            <h5 class="totalDiscountCost">{{ request ('SGST') }} &#8377;</h5>
                                                            <input type="hidden" name="totalDiscountCost" class="totalDiscountCost-input">
                                                        </li>
                                                        <li>
                                                            <h4>CGST</h4>
                                                            <h5 class="totalGrandCost">{{ request ('CGST') }} &#8377;</h5>
                                                        </li>
                                                        <li class="total">
                                                            <h4>Net Amount</h4>
                                                            <h5 class="totalGrandCost">{{ request ('Net_Amount') }} &#8377;</h5>
                                                            <input type="hidden" name="totalGrandCost" class="totalGrandCost-input">
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>

                                        <form method="POST" action="{{ route('soft_project_save_LV1') }}">
                                            @csrf
                                            @php
                                            $loginID = Session::get('empl_id');
                                            $loginNAME = Session::get('emp_name')
                                            @endphp

                                            @if(request ('Approval_Level_1') == $loginNAME)
                                            <div class="text-center">
                                                <button type="button" class="btn btn-primary ml-4 pl-3 pr-3 approve" data-toggle="modal" data-target="#exampleModalCenter" onclick="setModalFormAction('{{ request ('RowID') }}', '{{ route('soft_project_save_LV1') }}')">
                                                    Approve
                                                </button>
                                            </div>
                                            @endif
                                        </form>

                                        <form method="POST" action="{{ route('soft_project_save_LV2') }}">
                                            @csrf
                                            @php
                                            $loginID = Session::get('empl_id');
                                            $loginNAME = Session::get('emp_name')
                                            @endphp

                                            @if(request ('Approval_Level_2') == $loginNAME)
                                            <div class="text-center">
                                                <button type="button" class="btn btn-primary ml-4 pl-3 pr-3 approve" data-toggle="modal" data-target="#exampleModalCenter" onclick="setModalFormAction('{{ request ('RowID') }}', '{{ route('soft_project_save_LV2') }}')">
                                                    Approve
                                                </button>
                                            </div>
                                            @endif
                                        </form>

                                        <form method="POST" action="{{ route('soft_project_save_LV3') }}">
                                            @csrf
                                            @php
                                            $loginID = Session::get('empl_id');
                                            $loginNAME = Session::get('emp_name')
                                            @endphp

                                            @if(request ('Approval_Level_3') == $loginNAME)
                                            <div class="text-center">
                                                <button type="button" class="btn btn-primary ml-4 pl-3 pr-3 approve" data-toggle="modal" data-target="#exampleModalCenter" onclick="setModalFormAction('{{ request ('RowID') }}', '{{ route('soft_project_save_LV3') }}')">
                                                    Approve
                                                </button>
                                            </div>
                                            @endif
                                        </form>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--  MODAL -->
    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modaL" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title mr-5" id="exampleModalLongTitle">PROJECT APPROVE</h5>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" style="max-height: calc(100vh - 200px); overflow-y: auto;">
                    <form action="" method="post" id="modalForm" onsubmit="return validateForm()">
                        @csrf
                        <div class="row">
                            <div class="col-lg-12">
                                <label for="" class="h5 " style="font-weight: 700;">Marks</label>
                                <div class="form-group  text-center">
                                    <div class="stars">

                                        <input class="star star-5" id="star-5" type="radio" value="5" name="mark">
                                        <label class="star star-5" for="star-5"></label>
                                        <input class="star star-4" id="star-4" type="radio" value="4" name="mark">
                                        <label class="star star-4" for="star-4"></label>
                                        <input class="star star-3" id="star-3" type="radio" value="3" name="mark">
                                        <label class="star star-3" for="star-3"></label>
                                        <input class="star star-2" id="star-2" type="radio" value="2" name="mark">
                                        <label class="star star-2" for="star-2"></label>
                                        <input class="star star-1" id="star-1" type="radio" value="1" name="mark">
                                        <label class="star star-1" for="star-1"></label>

                                    </div>
                                    <input type="hidden" name="rowid" value="" id="rowid">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-12">
                                <h5 class="" style="font-weight: 700;">Remarks</h5>
                            </div>
                            <div class="col-lg-12">
                                <textarea name="remarks" id="remarks" cols="10" class="form-control" rows="4"></textarea>
                            </div>
                        </div>
                </div>
                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Approve</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="alertModal" tabindex="-1" role="dialog" aria-labelledby="alertModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-top modaL" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title mr-5" id="exampleModalLongTitle">Notification</h5>

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" style="max-height: calc(100vh - 200px); overflow-y: auto;">
                    <div class="row">
                        <div class="col-lg-12">
                            <h5>Minimum one star want to choose. </h5>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">

                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

                </div>

            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>


    <!-- MODAL  -->
    <script src="{{ asset('frontend/js/core/bootstrap.min.js')}}"></script>
    <script>
        function setModalFormAction(rowid, actionRoute, remarks) {
            // Construct the URL for the form action using the rowid
            var formAction = actionRoute;
            let rowID = rowid;
            let remarks1 = (remarks == undefined) ? "" : "";
            document.getElementById('modalForm').action = formAction;
            document.getElementById('rowid').value = rowID;

            document.getElementById('remarks').value = remarks1;
            var stars = document.querySelectorAll('.star');
            for (var i = 0; i < stars.length; i++) {
                stars[i].checked = false;
            }
        }

        $('#modalForm').submit(function(event) {
            // Check if at least one star is selected
            if ($('input[name="mark"]:checked').length === 0) {
                $('#alertModal').modal('show'); // Show the alert modal
                event.preventDefault(); // Prevent form submission
            }
        });
    </script>


    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($message = Session::get('alert'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>