<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>
        @if(\Route::currentRouteName() == 'NRgp_AppList')
        NRGP REFERENCE APPROVAL
        @endif

        @if(\Route::currentRouteName() == 'NRgp_DivAppList')
        NRGP DIVISION APPROVAL
        @endif

    </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <!-- EXCEL -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.3/xlsx.full.min.js"></script>

    <!-- STYLE FOR PAGINATION -->
    <style>
        .pagination {
            justify-content: space-between;
            margin-left: 10px;
        }

        #pagination {
            margin-right: 15px;
            display: inline-block;
            vertical-align: middle;
            border-radius: 4px;
            padding: 1px 2px 4px 2px;
            border-top: 1px solid #AEAEAE;
            border-bottom: 1px solid #FFFFFF;
            background-color: #DADADA;
            background-image: -webkit-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -moz-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -ms-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -o-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: linear-gradient(top, #DBDBDB, #E2E2E2);
        }

        #pagination #pag_a,
        #pagination #pag_i {
            display: inline-block;
            vertical-align: middle;
            width: 22px;
            color: #7D7D7D;
            text-align: center;
            font-size: 10px;
            padding: 3px 0 2px 0;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            -o-user-select: none;
            user-select: none;
        }

        #pagination #pag_a {
            margin: 0 2px 0 2px;
            border-radius: 4px;
            border: 1px solid #E3E3E3;
            cursor: pointer;
            box-shadow: inset 0 1px 0 0 #FFF, 0 1px 2px #666;
            text-shadow: 0 1px 1px #FFF;
            background-color: #E6E6E6;
            background-image: -webkit-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -moz-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -ms-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -o-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: linear-gradient(top, #F3F3F3, #D7D7D7);
        }

        #pagination #pag_i {
            margin: 0 3px 0 3px;
        }

        #pagination #pag_a.current {
            border: 1px solid #E9E9E9;
            box-shadow: 0 1px 1px #999;
            background-color: #DFDFDF;
            background-image: -webkit-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -moz-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -ms-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -o-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: linear-gradient(top, #D0D0D0, #EBEBEB);
        }
    </style>

    <!-- FONT -->
    <!-- <style>
        .row label,
        .card-title {
            font-weight: bold;
            font-size: medium;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .form-heading h4 {
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .card-body .table-responsive table thead th {
            color: black;
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .card-body .table-responsive table tbody td {
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }
    </style> -->

    <!-- TABLE DESIGN -->
    <style>
        .card-body .table-responsive .table tbody tr td {
            padding: 0 25px !important;
            height: 3px;
            vertical-align: middle !important;
        }

        .card-header {
            height: 60px;
        }

        .card-header .col-md-3 select {
            margin-top: 10px;
        }

        .table-responsive {
            position: relative;
            overflow: auto;
        }

        .table thead th {
            position: sticky;
            top: 0;
            z-index: 1;
        }
    </style>

    <!-- <style>
        .approve-btn {
            background: radial-gradient(100% 100% at 100% 0, #5adaff 0, #4a8da7 100%);
            color: #fff;

        }

        .approve-home {
            margin-left: 40%;
            margin-bottom: 20px;
        }

        .load-btn {
            background: radial-gradient(100% 100% at 100% 0, #5adaff 0, #074d66 100%);
            color: #fff;
        }

        .pal-5 {
            padding-left: 8% !important;
        }

        .reject-btn {
            background: radial-gradient(100% 100% at 100% 0, #d91c2e 0, #dc3545);
            color: #fff;

        }
    </style> -->

    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->
</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->
    @section('tittle')
    @if(\Route::currentRouteName() == 'NRgp_AppList')
    {{"NRGP REFERENCE APPROVAL"}}
    @endif

    @if(\Route::currentRouteName() == 'NRgp_DivAppList')
    {{"NRGP DIVISION APPROVAL"}}
    @endif
    @endsection

    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">

                                <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ EMPLOYEE SELECT & EXPORT @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->

                                <div class="card-header d-flex justify-content-between align-items-center">

                                    <h4 class="card-title">
                                        @if(\Route::currentRouteName() == 'NRgp_AppList')
                                        NRGP REFERENCE APPROVAL
                                        @endif

                                        @if(\Route::currentRouteName() == 'NRgp_DivAppList')
                                        NRGP DIVISION APPROVAL
                                        @endif

                                    </h4>
                                </div>

                                <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ SEARCH AND SHOW ENTRIES @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="page-table-header mb-2">
                                            <div class="row align-items-center">
                                                <div class="doctor-table-blk">
                                                    <div class="doctor-search-blk">
                                                        <div class="top-nav-search table-search-blk">
                                                            <form action="javascript:;">
                                                                <div class="d-flex justify-content-between align-items-center">
                                                                    <div class="search-container" style="margin-left: 10px;">
                                                                        <input type="text" id="search-input" class="form-control" placeholder="Search here">
                                                                    </div>
                                                                    <div class="ml-2 col-md-1" style="margin-right: 10px;">
                                                                        <select name="state" id="maxRows" class="form-select">
                                                                            <option value="10">10</option>
                                                                            <option value="50">50</option>
                                                                            <option value="70">70</option>
                                                                            <option value="100">100</option>
                                                                            <option value="5000">Show ALL Rows</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                @if(\Route::currentRouteName() == 'NRgp_AppList')
                                <form id="validate" method="POST" action="{{ route('NRgp_AppSave') }}">
                                    @csrf
                                    <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ TABLE @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->
                                    <div class="card-body">
                                        <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                            <table class="table table-centered align-middle table-nowrap mb-0" id="dataTable" style="line-height: 30px !important;">
                                                <thead class="text-muted table-light">
                                                    <tr>
                                                        <th>
                                                            <div class="checkbox">
                                                                <input type="checkbox" class="check" id="checkboxElement">
                                                            </div>
                                                        </th>
                                                        <th data-sort="sno"> SNO <span class="sort-icon"></th>
                                                        <th data-sort="rgp"> NRGPNO <span class="sort-icon"></th>
                                                        <th data-sort="rgpdate"> RGP Date <span class="sort-icon"></th>
                                                        <th data-sort="rgptyp"> RGP Type <span class="sort-icon"></th>
                                                        <th data-sort="entby">Entry By <span class="sort-icon"></th>
                                                        <th data-sort="supp"> Supp Name <span class="sort-icon"></th>
                                                        <th data-sort="div">Remarks <span class="sort-icon"></th>
                                                        <th data-sort="div">Division <span class="sort-icon"></th>
                                                        <th data-sort="comp">Comp Name <span class="sort-icon"></th>
                                                        <th data-sort="comp">RefNo / RefDate <span class="sort-icon"></th>
                                                        <th data-sort="courier"> Desp <span class="sort-icon"></th>
                                                        <th data-sort="courier"> Courier <span class="sort-icon"></th>
                                                        <th data-sort="courier"> Sample <span class="sort-icon"></th>
                                                        <th data-sort="courier"> OrderNo / Color <span class="sort-icon"></th>
                                                        <th data-sort="courier"> RGP Remarks <span class="sort-icon"></th>
                                                        <!-- <th data-sort="remark">Reason<span class="sort-icon"></th> -->
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($NRgpAppList as $index => $row)
                                                    <tr>
                                                        <td>
                                                            <div class="row-item">
                                                                <div class="checkbox">
                                                                    <input class="check" type="checkbox" id="checkboxElement" onchange="toggleRemarksRequired(this)" id="trial" name="Rgpno[]" value="{{ $row['rgpNO'] }}//{{ $row['Emplno'] }}//{{ date('Y-m-d', strtotime($row['rgpDATE'])) }}//{{ $row['EntryBy'] }}//{{ $row['Releavechk'] }}" />

                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>
                                                            <a href="#" style="color: red; font-weight: bold;" class="invoice-link text-primary" data-rgpno="{{ $row['rgpNO'] }}">{{ $row['rgpNO'] }}</a>
                                                            <!-- Row-specific Spinner -->
                                                            <div class="spinner-border text-primary spinner-sm ms-2 d-none" role="status" style="width: 1rem; height: 1rem;" id="spinner-{{ $row['rgpNO'] }}">
                                                                <span class="visually-hidden">Loading...</span>
                                                            </div>
                                                        </td>
                                                        <!-- <td>{{ $row['rgpDATE'] }}</td> -->
                                                        <td>{{ date('Y-m-d', strtotime($row['rgpDATE'])) }}</td>
                                                        <td>
                                                            @if($row['POTYPE'] == 0)
                                                            GENERAL
                                                            @elseif ($row['POTYPE'] == 1)
                                                            SAMPLE
                                                            @else
                                                            -
                                                            @endif
                                                        </td>
                                                        <td>{{ $row['EntryBy'] }}/{{ $row['tno'] }}</td>
                                                        <td>{{ $row['LedgerName'] }}</td>
                                                        <td> <input type="text" name="Remarks[]" class="form-group" oninput="updateCheckboxValue(this)"> </td>
                                                        <td>{{ $row['DivisionName'] }}</td>
                                                        <td>{{ $row['CompName'] }}</td>
                                                        <td>{{ $row['REFQUOTNO'] }} / {{ date('Y-m-d', strtotime($row['REFQUOTDATE'])) }}</td>
                                                        <td>{{ $row['DESP'] }}</td>
                                                        <td>
                                                            @if($row['Courier_Mode'] == 'Y')
                                                            YES
                                                            @elseif($row['Courier_Mode'] == 'N')
                                                            NO
                                                            @else
                                                            -
                                                            @endif

                                                        </td>
                                                        <td>{{ $row['Sample_Name'] }}</td>
                                                        <td>{{ $row['Order_No'] }}/{{ $row['Color'] }}</td>
                                                        <td>{{ $row['SPLINST'] }}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>


                                    <!--############################### PAGINATION ###############################-->
                                    <div class="pagination">
                                        <div id="entryCount">Total entries: <span id="rowCount"></span></div>
                                        <div id="searchCount"></div>
                                        <div id="pagination"></div>
                                    </div>


                                    <div class=" d-flex justify-content-around pb-2">
                                        <input type="submit" name="submit" value="APPROVE" id="approve" class="btn btn-primary">
                                        <input type="submit" name="submit" value="REJECT" id="reject" class="btn btn-danger">
                                    </div>
                                </form>
                                @endif

                                @if(\Route::currentRouteName() == 'NRgp_DivAppList')
                                <form id="validate" method="POST" action="{{ route('NRgp_DivAppSave') }}">
                                    @csrf
                                    <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ TABLE @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->
                                    <div class="card-body">
                                        <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                            <table class="table table-centered align-middle table-nowrap mb-0" id="dataTable" style="line-height: 30px !important;">
                                                <thead class="text-muted table-light">
                                                    <tr>
                                                        <th>
                                                            <div class="checkbox">
                                                                <input type="checkbox" class="check" id="checkboxElement">
                                                            </div>
                                                        </th>
                                                        <th data-sort="sno"> SNO <span class="sort-icon"></th>
                                                        <th data-sort="rgp"> NRGPNO <span class="sort-icon"></th>
                                                        <th data-sort="rgpdate"> RGP Date <span class="sort-icon"></th>
                                                        <th data-sort="rgptyp"> RGP Type <span class="sort-icon"></th>
                                                        <th data-sort="entby">Entry By <span class="sort-icon"></th>
                                                        <th data-sort="supp"> Supp Name <span class="sort-icon"></th>
                                                        <th data-sort="div">Remarks <span class="sort-icon"></th>
                                                        <th data-sort="div">Division <span class="sort-icon"></th>
                                                        <th data-sort="comp">Comp Name <span class="sort-icon"></th>
                                                        <th data-sort="comp">RefNo / RefDate <span class="sort-icon"></th>
                                                        <th data-sort="courier"> Desp <span class="sort-icon"></th>
                                                        <th data-sort="courier"> Courier <span class="sort-icon"></th>
                                                        <th data-sort="courier"> Sample <span class="sort-icon"></th>
                                                        <th data-sort="courier"> OrderNo / Color <span class="sort-icon"></th>
                                                        <th data-sort="courier"> RGP Remarks <span class="sort-icon"></th>
                                                        <!-- <th data-sort="remark">Reason<span class="sort-icon"></th> -->
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($NRgpDivAppList as $index => $row)
                                                    <tr>
                                                        <td>
                                                            <div class="row-item">
                                                                <div class="checkbox">
                                                                    <input class="check" type="checkbox" id="checkboxElement" onchange="toggleRemarksRequired(this)" id="trial" name="Rgpno[]" value="{{ $row['rgpNO'] }}//{{ $row['Emplno'] }}//{{ date('Y-m-d', strtotime($row['rgpDATE'])) }}//{{ $row['EntryBy'] }}//{{ $row['Releavechk'] }}" />

                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>
                                                            <a href="#" style="color: red; font-weight: bold;" class="invoice-link text-primary" data-rgpno="{{ $row['rgpNO'] }}">{{ $row['rgpNO'] }}</a>
                                                            <!-- Row-specific Spinner -->
                                                            <div class="spinner-border text-primary spinner-sm ms-2 d-none" role="status" style="width: 1rem; height: 1rem;" id="spinner-{{ $row['rgpNO'] }}">
                                                                <span class="visually-hidden">Loading...</span>
                                                            </div>
                                                        </td>
                                                        <!-- <td>{{ $row['rgpDATE'] }}</td> -->
                                                        <td>{{ date('Y-m-d', strtotime($row['rgpDATE'])) }}</td>
                                                        <td>
                                                            @if($row['POTYPE'] == 0)
                                                            GENERAL
                                                            @elseif ($row['POTYPE'] == 1)
                                                            SAMPLE
                                                            @else
                                                            -
                                                            @endif
                                                        </td>
                                                        <td>{{ $row['EntryBy'] }}/{{ $row['tno'] }}</td>
                                                        <td>{{ $row['LedgerName'] }}</td>
                                                        <td> <input type="text" name="Remarks[]" class="form-group" oninput="updateCheckboxValue(this)"> </td>
                                                        <td>{{ $row['DivisionName'] }}</td>
                                                        <td>{{ $row['CompName'] }}</td>
                                                        <td>{{ $row['REFQUOTNO'] }} / {{ date('Y-m-d', strtotime($row['REFQUOTDATE'])) }}</td>
                                                        <td>{{ $row['DESP'] }}</td>
                                                        <td>
                                                            @if($row['Courier_Mode'] == 'Y')
                                                            YES
                                                            @elseif($row['Courier_Mode'] == 'N')
                                                            NO
                                                            @else
                                                            -
                                                            @endif

                                                        </td>
                                                        <td>{{ $row['Sample_Name'] }}</td>
                                                        <td>{{ $row['Order_No'] }}/{{ $row['Color'] }}</td>
                                                        <td>{{ $row['SPLINST'] }}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>


                                    <!--############################### PAGINATION ###############################-->
                                    <div class="pagination">
                                        <div id="entryCount">Total entries: <span id="rowCount"></span></div>
                                        <div id="searchCount"></div>
                                        <div id="pagination"></div>
                                    </div>


                                    <div class=" d-flex justify-content-around pb-2">
                                        <input type="submit" name="submit" value="APPROVE" id="approve" class="btn btn-primary">
                                        <input type="submit" name="submit" value="REJECT" id="reject" class="btn btn-danger">
                                    </div>
                                </form>
                                @endif

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- NRGP MODAL DETAILS  -->
    <div class="modal fade" id="NRgpModal" tabindex="-1" aria-labelledby="NRgpModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="NRgpModalLabel">NRGP Details - <span id="rgpNoTitle"></span></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>

                </div>
                <div class="modal-body">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Item Description</th>
                                <th>Purpose</th>
                                <th>Rgp Qty</th>
                                <th>UOM</th>
                                <th>Due Date</th>
                            </tr>
                        </thead>
                        <tbody id="NRGPDetailsTable">
                            <!-- Dynamic Data will be inserted here -->
                        </tbody>

                    </table>
                </div>
            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

    <!-- FOR ADDING REQUIRED FIELD IN CHECKED CHECKBOX -->
    <script>
        function toggleRemarksRequired(checkbox) {
            // Find the row (tr) of the checkbox
            var row = checkbox.closest("tr");

            // Find the Remarks input field in the same row
            var remarksInput = row.querySelector('input[name="Remarks[]"]');

            // Toggle 'required' attribute
            if (checkbox.checked) {
                remarksInput.setAttribute("required", "required");
            } else {
                remarksInput.removeAttribute("required");
            }
            updateCheckboxValue(remarksInput);
        }

        function updateCheckboxValue(input) {
            var row = input.closest("tr");
            var checkbox = row.querySelector('input[type="checkbox"].check');
            var rgpValue = checkbox.getAttribute("value").split("//");
            var remarks = input.value.trim();

            // Compose the new value
            var newValue = `${rgpValue[0]}//${rgpValue[1]}//${rgpValue[2]}//${rgpValue[3]}//${rgpValue[4]}//${remarks}`;
            checkbox.setAttribute("value", newValue);
        }
    </script>


    <!-- NRGP MODAL DETAILS -->
    <script>
        $(document).on('click', '.invoice-link', function(event) {
            event.preventDefault();

            var RgpNO = $(this).data('rgpno');
            console.log('RGPNO:', RgpNO);

            var spinnerId = '#spinner-' + RgpNO;

            $(spinnerId).removeClass('d-none');


            $.ajax({
                url: "{{ route('NRgp_AppDet') }}",
                type: "GET",
                data: {
                    RgpNO: RgpNO,
                },
                dataType: 'json',
                success: function(nrgpDet) {
                    console.log(':', nrgpDet);

                    $('#rgpNoTitle').text(nrgpDet[0].rgpNO);
                    var modalBody = $('#NRGPDetailsTable');

                    modalBody.empty();

                    if (nrgpDet.length > 0) {
                        nrgpDet.forEach(function(detail) {
                            var itemRow = `<tr>
                            <td>${detail. itemdesc || '-'}</td>
                            <td>${detail.purpose || '-'}</td>
                            <td>${detail.rgpQTY || '0'}</td>
                            <td>${detail.uom || '-'}</td>
                        </tr>`;
                            modalBody.append(itemRow);

                        });

                    } else {
                        modalBody.append('<tr><td colspan="3" class="text-center">No Details Found</td></tr>');
                    }

                    $('#NRgpModal').modal('show');
                    $(spinnerId).addClass('d-none');
                },
                error: function(xhr, status, error) {

                    console.error('AJAX Error:', error);
                    alert("AJAX Error:", xhr.responseText);
                    $(spinnerId).addClass('d-none');

                }
            });
        });
        $(document).on('click', '.close', function() {
            $('#NRgpModal').modal('hide');
        });
    </script>



    <!-- BUTTON SHOW -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // Get references to the checkboxes and buttons
            const checkboxes = $('.check');
            const approveButton = $('#approve');
            const rejectButton = $('#reject');

            // Hide the buttons initially
            approveButton.hide();
            rejectButton.hide();

            // Function to prevent Enter key press
            function preventEnterKeyPress(event) {
                if (event.which === 13) { // 13 is the key code for Enter
                    event.preventDefault();
                }
            }

            // Add a change event handler to all checkboxes
            checkboxes.change(function() {
                // Check if at least one checkbox is checked
                if (checkboxes.is(':checked')) {
                    // At least one checkbox is checked, show the buttons
                    approveButton.show();
                    rejectButton.show();

                    // Add an event listener to the document to prevent Enter key press
                    $(document).on('keypress', preventEnterKeyPress);
                } else {
                    // No checkboxes are checked, hide the buttons
                    approveButton.hide();
                    rejectButton.hide();

                    // Remove the event listener to allow Enter key press
                    $(document).off('keypress', preventEnterKeyPress);
                }
            });
        });
    </script>

    <!-- SELECT ALL -->
    <script>
        $("#checkboxElement").click(function() {
            $(".check").prop('checked', $(this).prop('checked'));
        });
    </script>

    <!-- POPUP FOR APPROVE -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Get a reference to the "REJECT" button by its ID
            var approveButton = document.getElementById("approve");

            // Add a click event listener to the button
            approveButton.addEventListener("click", function(event) {
                // Display a confirmation dialog with "OK" and "Cancel" options
                var confirmation = confirm("Are you sure you want to approve?");

                // Check the user's choice in the confirmation dialog
                if (!confirmation) {
                    // If the user clicked "Cancel," prevent the default action of the button
                    event.preventDefault();
                }
            });

            // Prevent Enter key from submitting the form (assuming the button is inside a form)
            document.addEventListener("keydown", function(event) {
                if (event.key === "Enter" && event.target === approveButton) {
                    event.preventDefault();
                }
            });
        });
    </script>

    <!-- POPUP FOR REJECT -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Get a reference to the "REJECT" button by its ID
            var rejectButton = document.getElementById("reject");

            // Add a click event listener to the button
            rejectButton.addEventListener("click", function(event) {
                // Display a confirmation dialog with "OK" and "Cancel" options
                var confirmation = confirm("Are you sure you want to reject?");

                // Check the user's choice in the confirmation dialog
                if (!confirmation) {
                    // If the user clicked "Cancel," prevent the default action of the button
                    event.preventDefault();
                }
            });

            // Prevent Enter key from submitting the form (assuming the button is inside a form)
            document.addEventListener("keydown", function(event) {
                if (event.key === "Enter" && event.target === rejectButton) {
                    event.preventDefault();
                }
            });
        });
    </script>

    <!-- SORTING -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#dataTable.sort-icon').html('<i class="fas fa-sort"></i>'); // Display the sort icon by default

            $('#dataTable th[data-sort]').click(function() {
                const column = $(this).data('sort');
                const sortOrder = $(this).hasClass('asc') ? 'desc' : 'asc';

                // Reset sorting indicators
                $('#dataTable th[data-sort]').removeClass('asc desc');
                $('#dataTable .sort-icon').html('<i class="fas fa-sort"></i>');

                // Apply sorting indicator to the clicked column
                $(this).addClass(sortOrder);
                $(this).find('.sort-icon i').removeClass().addClass(sortOrder === 'asc' ? 'fas fa-sort-up' : 'fas fa-sort-down');

                // Perform sorting logic based on the column and sortOrder
                sortTable(column, sortOrder);
            });

            function sortTable(column, sortOrder) {
                const rows = $('#dataTable tbody tr').get();

                rows.sort(function(a, b) {
                    let keyA = $(a).find(`td:eq(${getColumnIndex(column)})`).text();
                    let keyB = $(b).find(`td:eq(${getColumnIndex(column)})`).text();

                    if (!isNaN(parseFloat(keyA)) && !isNaN(parseFloat(keyB))) {
                        keyA = parseFloat(keyA);
                        keyB = parseFloat(keyB);
                    }

                    if (sortOrder === 'asc') {
                        if (isNaN(keyA) || isNaN(keyB)) {
                            return keyA.localeCompare(keyB);
                        } else {
                            return keyA - keyB;
                        }
                    } else {
                        if (isNaN(keyA) || isNaN(keyB)) {
                            return keyB.localeCompare(keyA);
                        } else {
                            return keyB - keyA;
                        }
                    }
                });

                $.each(rows, function(index, row) {
                    $('#dataTable tbody').append(row);
                });
            }

            function getColumnIndex(column) {
                return $('#dataTable thead th[data-sort="' + column + '"]').index();
            }
        });
    </script>



    <!-- SEARCH -->
    <script>
        $(document).ready(function() {
            // Define a variable to store the search value
            var searchValue = "";

            // Search function
            function performSearch() {
                var matches = $("#dataTable tbody tr").filter(function() {
                    return $(this).text().toLowerCase().indexOf(searchValue) > -1;
                });

                if (searchValue === "") {
                    // If the search bar is empty, clear the search results and count
                    $("#searchCount").text("");
                    $("#entryCount").show(); // Show the entry count
                    $("#dataTable tbody tr").toggle(true);
                    updateRowsPerPage(); // Call the function to reset displayed rows
                } else {
                    $("#entryCount").hide(); // Hide the entry count
                    // Show the search count and hide rows that don't match the search criteria
                    $("#searchCount").text(matches.length + " result(s) found");

                    // Get the selected rows per page value
                    var maxRows = parseInt($("#maxRows").val());

                    // Limit the matches to the selected rows per page
                    matches.slice(maxRows).toggle(false);
                    matches.slice(0, maxRows).toggle(true);
                    $("#dataTable tbody tr").not(matches).toggle(false);
                }
            }

            // Search input keyup event
            $("#search-input").on("keyup", function() {
                searchValue = $(this).val().toLowerCase();
                performSearch();
            });

            // maxRows dropdown change event
            $("#maxRows").on("change", function() {
                // Update rows per page and reapply search
                updateRowsPerPage();
                performSearch();
            });

            // Initialize search and rows per page
            performSearch();
            updateRowsPerPage();
        });
    </script>

    <!-- SHOW ENTRIES TABLE -->
    <script>
        // Function to update the number of displayed rows
        function updateRowsPerPage() {
            var maxRows = parseInt(document.getElementById("maxRows").value);
            var tableBody = document.getElementById("tableBody");
            var dataTable = document.getElementById("dataTable");
            var rows = dataTable.getElementsByTagName("tr");

            for (var i = 1; i < rows.length; i++) {
                if (i <= maxRows) {
                    rows[i].style.display = "";
                } else {
                    rows[i].style.display = "none";
                }
            }
        }

        // Add an event listener to the maxRows dropdown
        document.getElementById("maxRows").addEventListener("change", updateRowsPerPage);

        // Initial call to set the initial number of displayed rows
        updateRowsPerPage();
    </script>

    <!-- PAGINATION -->
    <script>
        var Pagination = {

            code: '',

            // --------------------
            // Utility
            // --------------------

            // converting initialize data
            Extend: function(data) {
                data = data || {};
                Pagination.size = data.size || 3000;
                Pagination.page = data.page || 5;
                Pagination.step = data.step || 5;
            },

            // add pages by number (from [s] to [f])
            Add: function(s, f) {
                for (var i = s; i < f; i++) {
                    Pagination.code += '<a id="pag_a">' + i + '</a>';
                }
            },

            // add last page with separator
            Last: function() {
                Pagination.code += '<i id="pag_i">...</i> <a id="pag_a">' + Pagination.size + '</a>';

            },

            // add first page with separator
            First: function() {
                Pagination.code += '<a id="pag_a">1</a> <i id="pag_i">...</i>';

            },



            // --------------------
            // Handlers
            // --------------------

            // change page
            Click: function() {
                Pagination.page = +this.innerHTML;
                Pagination.Start();
            },

            // previous page
            Prev: function() {
                Pagination.page--;
                if (Pagination.page < 1) {
                    Pagination.page = 1;
                }
                Pagination.Start();
            },

            // next page
            Next: function() {
                Pagination.page++;
                if (Pagination.page > Pagination.size) {
                    Pagination.page = Pagination.size;
                }
                Pagination.Start();
            },



            // --------------------
            // Script
            // --------------------

            // binding pages
            Bind: function() {
                var a = Pagination.e.getElementsByTagName('a');
                for (var i = 0; i < a.length; i++) {
                    if (+a[i].innerHTML === Pagination.page) a[i].className = 'current';
                    a[i].addEventListener('click', Pagination.Click, false);
                }

                // Retrieve the maxRows value
                var maxRows = parseInt(document.getElementById("maxRows").value);

                // Add this block to handle table pagination
                var table = document.getElementById('dataTable');
                var tbody = table.getElementsByTagName('tbody')[0];
                var rows = tbody.getElementsByTagName('tr');
                for (var i = 0; i < rows.length; i++) {
                    rows[i].style.display = 'none';
                }
                var start = (Pagination.page - 1) * maxRows;
                var end = start + maxRows;
                for (var i = start; i < end && i < rows.length; i++) {
                    rows[i].style.display = '';
                }
            },

            // write pagination
            Finish: function() {
                Pagination.e.innerHTML = Pagination.code;
                Pagination.code = '';
                Pagination.Bind();
            },

            // find pagination type
            Start: function() {
                var table = document.getElementById('dataTable');
                var rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

                // Retrieve the maxRows value
                var maxRows = parseInt(document.getElementById("maxRows").value);

                Pagination.size = Math.ceil(rows.length / maxRows);

                // Reset the code
                Pagination.code = '';

                if (Pagination.size < Pagination.step * 2 + 6) {
                    Pagination.Add(1, Pagination.size + 1);
                } else if (Pagination.page < Pagination.step * 2 + 1) {
                    Pagination.Add(1, Pagination.step * 2 + 4);
                    Pagination.Last();
                } else if (Pagination.page > Pagination.size - Pagination.step * 2) {
                    Pagination.First();
                    Pagination.Add(Pagination.size - Pagination.step * 2 - 2, Pagination.size + 1);
                } else {
                    Pagination.First();
                    Pagination.Add(Pagination.page - Pagination.step, Pagination.page + Pagination.step + 1);
                    Pagination.Last();
                }
                Pagination.Finish();
                Pagination.Bind();
            },



            // --------------------
            // Initialization
            // --------------------

            // binding buttons
            Buttons: function(e) {
                var nav = e.getElementsByTagName('a');
                nav[0].addEventListener('click', Pagination.Prev, false);
                nav[1].addEventListener('click', Pagination.Next, false);
            },

            // create skeleton
            Create: function(e) {

                var html = [
                    '<a id="pag_a">◄</a>', // previous button
                    '<span></span>', // pagination container
                    '<a id="pag_a">►</a>' // next button
                ];

                e.innerHTML = html.join('');
                Pagination.e = e.getElementsByTagName('span')[0];
                Pagination.Buttons(e);
            },

            // init
            Init: function(e, data) {
                Pagination.Extend(data);
                Pagination.Create(e);
                Pagination.Start();
            }
        };



        /* * * * * * * * * * * * * * * * *
         * Initialization
         * * * * * * * * * * * * * * * * */

        var init = function() {
            // Initialize with data from the table
            Pagination.Init(document.getElementById('pagination'), {
                page: 1, // selected page
                step: '' // pages before and after current
            });
        };

        document.addEventListener('DOMContentLoaded', init, false);
    </script>

    <!-- SHOWS HOW MANY ENTRIES IN THE TABLE -->
    <script>
        // Add this code to update the entry count:

        function updateEntryCount() {
            var rowCount = $("#dataTable tbody tr").length;
            $("#rowCount").text(rowCount);
        }

        // Call the function to update the entry count after the page loads
        $(document).ready(function() {
            updateEntryCount();
        });
    </script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 15000);
    </script>
    @endif
    @if ($message = Session::get('alert'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 15000);
    </script>
    @endif

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>