<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Review</title>
    <link rel="icon" href="gplogofinal.png" type="png">
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.3.1/dist/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
    <!-- for star rating -->
    <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">

    <!-- for alert message -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.1/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <!-- for reply to comments -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <!-- for send button -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css">

    <!-- For review slider  -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.3/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js"></script>

    <link href="https://cdn.rawgit.com/arafkarim/BootstrapPlusPlus/a32c1a63/dist/dark/css/bootstrap.min.css" rel="stylesheet" id="bootstrap-css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.4.0/css/font-awesome.min.css" rel="stylesheet" id="bootstrap-css">
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:400,700&amp" rel="stylesheet" id="bootstrap-css">

    <style>
        /* For Star Rating submit form*/

        @import url(https://fonts.googleapis.com/css?family=Roboto:500,100,300,700,400);

        body {
            background-color: #eee;

        }

        div.stars {

            /* width: 270px; */

            display: inline-block;

        }

        input.star {
            display: none;
        }

        label.star {

            float: right;

            padding: 10px;

            font-size: 36px;

            color: #4A148C;

            transition: all .2s;

        }



        input.star:checked~label.star:before {

            content: '\f005';

            color: #FD4;

            transition: all .25s;

        }


        input.star-5:checked~label.star:before {

            color: #FE7;

            text-shadow: 0 0 20px #952;

        }



        input.star-1:checked~label.star:before {
            color: #F62;
        }



        label.star:hover {
            transform: rotate(-15deg) scale(1.3);
        }



        label.star:before {

            content: '\f006';

            font-family: FontAwesome;

        }


        /* for button */

        .review-btn {
            background-image: linear-gradient(to right, #3ab5b0 0%, #3d99be 31%, #56317a 100%);
            color: #fff;
            position: absolute;
            margin: 0 auto;
            left: 95%;
            right: 0;
            bottom: -30px;
        }

        .btn-circle {
            width: 10vw;
            /* Set the width to 10% of the viewport width */
            height: 10vw;
            /* Set the height to 10% of the viewport width */
            line-height: 10vw;
            /* Set the line height to 10% of the viewport width */
            text-align: center;
            padding: 0;
            border-radius: 50%;
        }

        .btn-circle i {
            position: relative;
            top: -1px;
        }

        .btn-circle-lg {
            width: 4vw;
            /* Set the width to 15% of the viewport width */
            height: 4vw;
            /* Set the height to 15% of the viewport width */
            line-height: 4vw;
            /* Set the line height to 15% of the viewport width */
            font-size: 1.5rem;
        }

        /* for comments --- */

        .link-muted {
            color: #aaa;
        }

        .link-muted:hover {
            color: #1266f1;
        }

        /* for comments stars---- */

        .ratings i {

            color: #cecece;
            font-size: 32px;
        }

        .rating-color {
            color: #fbc634 !important;
        }


        .small-ratings i {
            color: #cecece;
        }

        /* for value display */
        .valuename {
            position: fixed;
            top: 2.4rem;
            right: 3rem;
            font-size: 1.5rem;

        }


        /* for home icon */
        .custom-icon-size {
            position: fixed;
            top: 2.4rem;
            left: 3rem;
            z-index: 999;
            /* Ensure it's on top of other elements */
        }

        .custom-icon-size a {
            text-decoration: none;
            color: inherit;
        }

        .custom-icon-size i {
            font-size: 2rem;
        }

        /* Responsive styles */
        @media (max-width: 768px) {
            .custom-icon-size {
                top: 1rem;
                right: 1rem;
            }
        }

        .top-center {
            position: fixed;
            top: 40px;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 9999;
            /* Ensure it's on top of other elements */
            width: 630px;
            animation: fadeIn 1s ease forwards;

            animation: fadeOut 6s ease forwards;

        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 0.4;
            }
        }

        @keyframes fadeOut {
            from {
                opacity: 0.4;
            }

            to {
                opacity: 0;
            }
        }

        /* For reply to comments */
        /* Add this to your CSS */
        .sub_div {
            /* border: 1px solid grey;  */
            padding: 10px;
            margin-bottom: 5px;
            max-width: 100%;
            /* Make the div responsive */
            box-sizing: border-box;
            /* Ensure padding is included in width */
            background: #ebecf0;
            border-radius: 30px 0px;

        }

        .flex_div {
            display: flex;
        }

        .flex_div1 {
            display: flex;
        }

        .replyBut {
            padding: 0.1em 0.8em;
            border: none;
            outline: none;
            color: rgb(255, 255, 255);
            background: #111;
            font-size: 0.8rem;
            cursor: pointer;
            position: relative;
            z-index: 0;
            border-radius: 10px;
            user-select: none;
            -webkit-user-select: none;
            touch-action: manipulation;
        }

        .replyBut:before {
            content: "";
            background: linear-gradient(45deg,
                    #ff0000,
                    #ff7300,
                    #fffb00,
                    #48ff00,
                    #00ffd5,
                    #002bff,
                    #7a00ff,
                    #ff00c8,
                    #ff0000);
            position: absolute;
            top: -2px;
            left: -2px;
            background-size: 400%;
            z-index: -1;
            filter: blur(5px);
            -webkit-filter: blur(5px);
            width: calc(100% + 4px);
            height: calc(100% + 4px);
            animation: glowing-replyBut 20s linear infinite;
            transition: opacity 0.3s ease-in-out;
            border-radius: 10px;
        }

        @keyframes glowing-replyBut {
            0% {
                background-position: 0 0;
            }

            50% {
                background-position: 400% 0;
            }

            100% {
                background-position: 0 0;
            }
        }

        .replyBut:after {
            z-index: -1;
            content: "";
            position: absolute;
            width: 100%;
            height: 100%;
            background: #222;
            left: 0;
            top: 0;
            border-radius: 10px;
        }


        .viewreplyBut {
            padding: 0.1em 0.8em;
            border: none;
            outline: none;
            color: rgb(255, 255, 255);
            background: #111;
            font-size: 0.8rem;

            cursor: pointer;
            position: relative;
            z-index: 0;
            border-radius: 10px;
            user-select: none;
            -webkit-user-select: none;
            touch-action: manipulation;
        }

        .viewreplyBut:before {
            content: "";
            background: linear-gradient(45deg,
                    #ff0000,
                    #ff7300,
                    #fffb00,
                    #48ff00,
                    #00ffd5,
                    #002bff,
                    #7a00ff,
                    #ff00c8,
                    #ff0000);
            position: absolute;
            top: -2px;
            left: -2px;
            background-size: 400%;
            z-index: -1;
            filter: blur(5px);
            -webkit-filter: blur(5px);
            width: calc(100% + 4px);
            height: calc(100% + 4px);
            animation: glowing-viewreplyBut 20s linear infinite;
            transition: opacity 0.3s ease-in-out;
            border-radius: 10px;
        }

        @keyframes glowing-viewreplyBut {
            0% {
                background-position: 0 0;
            }

            50% {
                background-position: 400% 0;
            }

            100% {
                background-position: 0 0;
            }
        }

        .viewreplyBut:after {
            z-index: -1;
            content: "";
            position: absolute;
            width: 100%;
            height: 100%;
            background: #222;
            left: 0;
            top: 0;
            border-radius: 10px;
        }


        #viewreply span {
            top: 0;
            right: -10px;

        }

        .replyDiv .close {
            background: grey;
            position: absolute;
            color: #fff;
            text-shadow: none;
            opacity: 0.5;
            width: 20px;
            height: 20px;
            padding: 0;
            border-radius: 20px;
            font-size: 16px;
        }

        .replyDiv .close:hover {
            opacity: 0.8;
        }

        .showreplyDiv .close {
            background: grey;
            position: absolute;
            color: #fff;
            text-shadow: none;
            opacity: 0.5;
            width: 20px;
            height: 20px;
            padding: 0;
            border-radius: 20px;
            font-size: 16px;
        }

        .showreplyDiv .close:hover {
            opacity: 0.8;
        }

        #showreplyDiv {
            position: relative;
        }

        /* for send button */
        .custom-button {
            background-color: transparent;
            border: none;
            color: black;
        }



        /* for review slider */
        .carousel-control-prev-icon,
        .carousel-control-next-icon {
            filter: invert(100%);

        }

        /* CSS to adjust the position of carousel controls */
        .carousel-control-prev,
        .carousel-control-next {
            position: absolute;
            top: 30%;
            transform: translateY(-50%);
        }

        .carousel-control-prev {
            left: 1%;
            /* Adjust this value to move it left */
        }

        .carousel-control-next {
            right: 1%;
            /* Adjust this value to move it right */
        }
    </style>

</head>

<body style="background-image: linear-gradient(to right, #eea2a2 0%, #bbc1bf 19%, #57c6e1 42%, #b49fda 79%, #7ac5d8 100%);">
    @if(\Session::has('message'))
    <div class="alert alert-dismissible top-center" style="background-color:black;opacity: 0.4;color:white;text-align:center;" role="alert">
        {{ \Session::get('message') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    @endif
    <div class="custom-icon-size m-1">
        <a href="dashboard">
            <i class="fa fa-home text-light" aria-hidden="true"><b>HOME</b></i>
        </a>
    </div>

    <div class="valuename">
        <p>
            {{$value}}
        </p>
    </div>


    <form id="validate" method="POST" action="{{ route('post_review') }}">
        @csrf
        <section style="background-image: linear-gradient(to right, #eea2a2 0%, #bbc1bf 19%, #57c6e1 42%, #b49fda 79%, #7ac5d8 100%);" class="p-2 p-md-5 text-center text-lg-start shadow-1-strong rounded">
            <div class="containermy-2 py-2">
                <div class="row d-flex justify-content-center">
                    <div class="col-md-6">
                        <div class="bg-white card" style="border:none">
                            <div class="card-body p-4">
                                <div class="btn-contain">
                                    <button class="btn review-btn btn-circle btn-circle-lg m-1"><i class="fa fa-check"></i></button>
                                </div>
                                <div class="row">
                                    <div class="col-lg-4">
                                        <img src="logo-gp.jfif" class="center" height="170" width="140"><br><br>
                                    </div>
                                    <div class="col-lg-8">
                                        <div class="row justify-content-center">
                                            <div class="stars">
                                                <input class="star star-5" id="star-5" type="radio" value="5" name="star" required />

                                                <label class="star star-5" for="star-5"></label>

                                                <input class="star star-4" id="star-4" type="radio" value="4" name="star" required />

                                                <label class="star star-4" for="star-4"></label>

                                                <input class="star star-3" id="star-3" type="radio" value="3" name="star" required />

                                                <label class="star star-3" for="star-3"></label>

                                                <input class="star star-2" id="star-2" type="radio" value="2" name="star" required />

                                                <label class="star star-2" for="star-2"></label>

                                                <input class="star star-1" id="star-1" type="radio" value="1" name="star" required />

                                                <label class="star star-1" for="star-1"></label>
                                            </div>
                                        </div>

                                        <textarea class="form-control" id="comment" name="comment" placeholder="Enter your review here..." cols="40" rows="3" required></textarea>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </form>

    <section style="background-image: linear-gradient(to right, #eea2a2 0%, #bbc1bf 19%, #57c6e1 42%, #b49fda 79%, #7ac5d8 100%);">
        <div class="bg-white p-2 mx-auto mt-2 mb-2" style="max-width:620px;">
            <div id="carouselTestimonial" class="carousel carousel-testimonial slide">
                <div class="carousel-inner p-2">
                    @foreach ($groupedData as $key => $testimonial)
                    <div class="carousel-item text-center {{ $key === 0 ? 'active' : '' }}">
                        <div class="carousel-testimonial-img p-4 rounded-circle m-auto">
                            <img src="{{ asset('frontend/emplphotos/'.$testimonial['emplno'].'.jpeg')}}" alt="..." class="rounded-circle shadow-1-strong mb-4" alt="avatar" width="100" height="100">
                        </div>
                        <h5 class="mt-2 mb-0"><strong class="text-primary text-uppercase">{{ $testimonial['name'] }} - {{ $testimonial['tno'] }}</strong></h5>
                        <!-- <h6 class="text-dark m-0">{{ Carbon\Carbon::createFromFormat('d-m-Y H:i:s', $testimonial['ETime'])->format('F d, Y') }}</h6> -->
                        <h6 class="text-dark m-0">{{ date('d-M-Y', strtotime($testimonial['ETime'])) }}</h6>

                        <div class="small-ratings mb-3">
                            @for ($i = 1; $i <= 5; $i++) @if ($i <=$testimonial['Rating']) <i class="fa fa-star rating-color"></i>
                                @else
                                <i class="fa fa-star"></i>
                                @endif
                                @endfor
                        </div>
                        <p class="text-dark mr-5 ml-5 pt-1">{{ $testimonial['Comments'] }}</p>
                        <p class="text-dark mr-5 pt-1 text-right">- {{$value}}</p>
                        <div class="d-flex mt-2 justify-content-center">
                            <button class="btn btn-sm btn-primary replyBut mx-2" onclick="reply(this)" data-Commentid="{{ $testimonial['rowid'] }}" data-emplno="{{ $testimonial['emplno'] }}">Reply</button>
                            <button class="btn btn-sm btn-info viewreply viewreplyBut mx-2" onclick="view_reply(this)" id="viewreply" data-CommentId="{{ $testimonial['rowid'] }}">View Comments
                                <span class="count position-absolute translate-middle badge rounded-pill bg-danger" id="count">0</span>
                            </button>
                        </div>
                        <div class="mt-3">
                            <label style="display:block; " class="showreplyDiv" id="showreplyDiv"></label>
                        </div>
                    </div>
                    @endforeach
                </div>

                <a class="carousel-control-prev" href="#carouselTestimonial" role="button" data-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="sr-only">Previous</span>
                </a>
                <a class="carousel-control-next" href="#carouselTestimonial" role="button" data-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="sr-only">Next</span>
                </a>
            </div>
        </div>

        <div class="replyDiv mt-3" style="display:none;">
            <form method="POST" action="{{ route('post_reply') }}">
                @csrf
                <input type="text" id="commentId" name="commentId" hidden="">
                <input type="text" id="emplId" name="emplId" hidden="">
                <div class="row">
                    <div class="col-11">
                        <div class="position-relative">
                            <button type="button" onclick="reply_close(this)" class="close" style="position: absolute; top: 0; right: 5px;"><span>&times;</span></button>
                            <textarea class="form-control" id="comment" name="reply" placeholder="Reply here..." rows="1" required></textarea>
                        </div>
                    </div>
                    <div class="d-flex align-items-center">
                        <button type="submit" class="btn  form-control custom-button">
                            <i class="fa fa-send"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </section>



    <!-- for reply to comments -->
    <script>
        function reply(caller) {
            var commentId = $(caller).attr('data-Commentid');
            $('#commentId').val(commentId);

            var emplNo = $(caller).attr('data-emplno');
            $('#emplId').val(emplNo);
            console.log(emplNo);

            var replyDiv = $('.replyDiv'); // Assuming .replyDiv is a jQuery object

            $(caller).closest('div').after(replyDiv); // Insert replyDiv after the closest div to the caller

            replyDiv.show();
            $('.showreplyDiv').hide();
        }

        function reply_close(caller) {
            $('.replyDiv').hide();

        }

        function view_reply(caller) {
            var replyDiv = $('.showreplyDiv');
            $(caller).closest('div').after(replyDiv);
            $('.showreplyDiv').show();
            $('.replyDiv').hide();
        }

        function view_reply_close(caller) {
            $('.showreplyDiv').hide();
        }
    </script>

    <script>
        var viewbutton = document.getElementsByClassName('viewreply');
        for (let i = 0; i < viewbutton.length; i++) {
            const element = viewbutton[i];

            document.addEventListener('DOMContentLoaded', function() {

                var com_Id = element.getAttribute('data-CommentId');
                $.ajax({
                    url: "{{ route('show_reply') }}",
                    type: 'get', // Change to POST
                    dataType: 'json',
                    data: {
                        'row_id': com_Id
                    },

                    success: function(data) {
                        var countSpan = document.getElementsByClassName("count");
                        var count_reply = data.length;
                        console.log(count_reply);
                        countSpan[i].textContent = count_reply;
                    }
                })
            });
        }


        document.addEventListener('DOMContentLoaded', function() {
            var selectButtons = document.querySelectorAll('.viewreply');

            selectButtons.forEach(function(button) {
                button.addEventListener('click', function(e) {
                    e.preventDefault();

                    var selectedRowId = button.getAttribute('data-CommentId');
                    var showreplyDiv = document.getElementById("showreplyDiv");
                    console.log(selectedRowId);
                    showreplyDiv.innerHTML = '';

                    $.ajax({
                        url: "{{ route('show_reply') }}",
                        type: 'get', // Change to POST
                        dataType: 'json',
                        data: {
                            'row_id': selectedRowId
                        },

                        success: function(data) {
                            console.log(data);
                            if (data.length > 0) {
                                const subdiv = document.getElementById("showreplyDiv");
                                subdiv.style.padding = "10px";
                                subdiv.style.width = "100%"; // Adjust the width

                                for (let i = 0; i < data.length; i++) {
                                    const DevName = data[i]["Name"];
                                    const tno = data[i]["Tno"];

                                    const time = data[i]["Reply_Time"];
                                    const dateObj = new Date(time);
                                    const options = {
                                        year: 'numeric',
                                        month: 'long',
                                        day: 'numeric'
                                    };
                                    const formattedDate = dateObj.toLocaleDateString('en-US', options);
                                    const comments = data[i]["reply_comments"];

                                    const subdiv = document.createElement('div');
                                    subdiv.className = 'sub_div';
                                    subdiv.style.marginBottom = '5px';


                                    const option = document.createElement("h6");
                                    option.className = 'fw-bold', 'ml-2';
                                    option.className = 'text-dark';


                                    const option3 = document.createElement("h6");
                                    option3.className = 'fw-bold', 'ml-2';
                                    option3.className = 'text-dark';

                                    const option1 = document.createElement("p");
                                    option1.className = 'text-dark';
                                    option1.style.fontSize = '.8rem';
                                    option1.style.marginLeft = "100px";

                                    const option2 = document.createElement("p");
                                    option2.className = 'ml-2';
                                    option2.className = 'text-dark';

                                    option.textContent = DevName;
                                    option3.textContent = tno;
                                    option1.textContent = formattedDate;
                                    option2.textContent = comments;
                                    const dashElement = document.createElement('span');
                                    dashElement.textContent = ' - ';

                                    const flexdiv = document.createElement('div');
                                    flexdiv.className = 'flex_div', 'col-3';
                                    flexdiv.appendChild(option);
                                    flexdiv.appendChild(dashElement);
                                    flexdiv.appendChild(option3);

                                    const flexdiv1 = document.createElement('div');
                                    flexdiv1.className = 'flex_div1';
                                    flexdiv1.appendChild(flexdiv);
                                    flexdiv1.appendChild(option1);

                                    // Create the button element
                                    var closeButton = document.createElement('button');
                                    closeButton.type = 'button';
                                    closeButton.onclick = function() {
                                        view_reply_close(this);
                                    };
                                    closeButton.className = 'close';
                                    closeButton.style.position = 'absolute';
                                    closeButton.style.top = '0px';
                                    closeButton.style.right = '5px';
                                    closeButton.id = 'closeId';

                                    // Create the span element within the button
                                    var spanElement = document.createElement('span');
                                    spanElement.innerHTML = '&times;';

                                    // Append the span element to the button
                                    closeButton.appendChild(spanElement);

                                    subdiv.appendChild(flexdiv1);
                                    subdiv.appendChild(option2);
                                    subdiv.appendChild(closeButton);

                                    showreplyDiv.appendChild(subdiv);

                                }
                            } else {

                                document.getElementById('viewreply').disabled = true;
                                $('.showreplyDiv').remove();
                                $('.closeId').remove();
                            }
                        }
                    })
                })
            })
        });
    </script>

</body>

</html>