<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- <title>Review</title> -->
    <link rel="icon" href="gplogofinal.png" type="png">
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.3.1/dist/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
    <!-- for star rating -->
    <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">

    <!-- for alert message -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.1/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <!-- for reply to comments -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <!-- for send button -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css">



    <style>
        /* for button */

        .review-btn {
            background-image: linear-gradient(to right, #3ab5b0 0%, #3d99be 31%, #56317a 100%);
            color: #fff;
            position: absolute;
            margin: 0 auto;
            left: 95%;
            right: 0;
            bottom: -30px;
        }

        .btn-circle {
            width: 10vw;
            /* Set the width to 10% of the viewport width */
            height: 10vw;
            /* Set the height to 10% of the viewport width */
            line-height: 10vw;
            /* Set the line height to 10% of the viewport width */
            text-align: center;
            padding: 0;
            border-radius: 50%;
        }

        .btn-circle i {
            position: relative;
            top: -1px;
        }

        .btn-circle-lg {
            width: 4vw;
            /* Set the width to 15% of the viewport width */
            height: 4vw;
            /* Set the height to 15% of the viewport width */
            line-height: 4vw;
            /* Set the line height to 15% of the viewport width */
            font-size: 1.5rem;
        }

        /* for comments --- */

        .link-muted {
            color: #aaa;
        }

        .link-muted:hover {
            color: #1266f1;
        }

        /* for comments stars---- */

        .ratings i {

            color: #cecece;
            font-size: 32px;
        }

        .rating-color {
            color: #fbc634 !important;
        }


        .small-ratings i {
            color: #cecece;
        }

        /* for home icon */


        .custom-icon-size {
            position: fixed;
            top: 2.4rem;
            right: 3rem;
            z-index: 999;
            /* Ensure it's on top of other elements */
        }

        .custom-icon-size a {
            text-decoration: none;
            color: inherit;
        }

        .custom-icon-size i {
            font-size: 2rem;
        }

        /* Responsive styles */
        @media (max-width: 768px) {
            .custom-icon-size {
                top: 1rem;
                right: 1rem;
            }
        }







        .top-center {
            position: fixed;
            top: 40px;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 9999;
            /* Ensure it's on top of other elements */
            width: 630px;
            animation: fadeIn 1s ease forwards;

            animation: fadeOut 6s ease forwards;

        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 0.4;
            }
        }

        @keyframes fadeOut {
            from {
                opacity: 0.4;
            }

            to {
                opacity: 0;
            }
        }

        /* For reply to comments */
        /* Add this to your CSS */
        .sub_div {
            /* border: 1px solid grey;  */
            padding: 10px;
            margin-bottom: 5px;
            max-width: 100%;
            /* Make the div responsive */
            box-sizing: border-box;
            /* Ensure padding is included in width */
            background: #ebecf0;
            border-radius: 30px 0px;

        }

        .flex_div {
            display: flex;
        }

        .flex_div1 {
            display: flex;
        }

        .replyBut {
            padding: 0.1em 0.8em;
            border: none;
            outline: none;
            color: rgb(255, 255, 255);
            background: #111;
            font-size: 0.8rem;
            cursor: pointer;
            position: relative;
            z-index: 0;
            border-radius: 10px;
            user-select: none;
            -webkit-user-select: none;
            touch-action: manipulation;
        }

        .replyBut:before {
            content: "";
            background: linear-gradient(45deg,
                    #ff0000,
                    #ff7300,
                    #fffb00,
                    #48ff00,
                    #00ffd5,
                    #002bff,
                    #7a00ff,
                    #ff00c8,
                    #ff0000);
            position: absolute;
            top: -2px;
            left: -2px;
            background-size: 400%;
            z-index: -1;
            filter: blur(5px);
            -webkit-filter: blur(5px);
            width: calc(100% + 4px);
            height: calc(100% + 4px);
            animation: glowing-replyBut 20s linear infinite;
            transition: opacity 0.3s ease-in-out;
            border-radius: 10px;
        }

        @keyframes glowing-replyBut {
            0% {
                background-position: 0 0;
            }

            50% {
                background-position: 400% 0;
            }

            100% {
                background-position: 0 0;
            }
        }

        .replyBut:after {
            z-index: -1;
            content: "";
            position: absolute;
            width: 100%;
            height: 100%;
            background: #222;
            left: 0;
            top: 0;
            border-radius: 10px;
        }


        .viewreplyBut {
            padding: 0.1em 0.8em;
            border: none;
            outline: none;
            color: rgb(255, 255, 255);
            background: #111;
            font-size: 0.8rem;

            cursor: pointer;
            position: relative;
            z-index: 0;
            border-radius: 10px;
            user-select: none;
            -webkit-user-select: none;
            touch-action: manipulation;
        }

        .viewreplyBut:before {
            content: "";
            background: linear-gradient(45deg,
                    #ff0000,
                    #ff7300,
                    #fffb00,
                    #48ff00,
                    #00ffd5,
                    #002bff,
                    #7a00ff,
                    #ff00c8,
                    #ff0000);
            position: absolute;
            top: -2px;
            left: -2px;
            background-size: 400%;
            z-index: -1;
            filter: blur(5px);
            -webkit-filter: blur(5px);
            width: calc(100% + 4px);
            height: calc(100% + 4px);
            animation: glowing-viewreplyBut 20s linear infinite;
            transition: opacity 0.3s ease-in-out;
            border-radius: 10px;
        }

        @keyframes glowing-viewreplyBut {
            0% {
                background-position: 0 0;
            }

            50% {
                background-position: 400% 0;
            }

            100% {
                background-position: 0 0;
            }
        }

        .viewreplyBut:after {
            z-index: -1;
            content: "";
            position: absolute;
            width: 100%;
            height: 100%;
            background: #222;
            left: 0;
            top: 0;
            border-radius: 10px;
        }


        #viewreply span {
            top: 0;
            right: -10px;

        }

        .replyDiv .close {
            background: grey;
            position: absolute;
            color: #fff;
            text-shadow: none;
            opacity: 0.5;
            width: 20px;
            height: 20px;
            padding: 0;
            border-radius: 20px;
            font-size: 16px;
        }

        .replyDiv .close:hover {
            opacity: 0.8;
        }

        .showreplyDiv .close {
            background: grey;
            position: absolute;
            color: #fff;
            text-shadow: none;
            opacity: 0.5;
            width: 20px;
            height: 20px;
            padding: 0;
            border-radius: 20px;
            font-size: 16px;
        }

        .showreplyDiv .close:hover {
            opacity: 0.8;
        }

        #showreplyDiv {
            position: relative;
        }

        /* for send button */
        .custom-button {
            background-color: transparent;
            border: none;
            color: black;
        }
    </style>
</head>

<body style="background-image: linear-gradient(to right, #eea2a2 0%, #bbc1bf 19%, #57c6e1 42%, #b49fda 79%, #7ac5d8 100%);">

    @if(\Session::has('message'))
    <div class="alert alert-dismissible top-center" style="background-color:black;opacity: 0.4;color:white;text-align:center;" role="alert">
        {{ \Session::get('message') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    @endif


    <div class="custom-icon-size m-1">
        <a href="dashboard">
            <i class="fa fa-home text-light" aria-hidden="true"><b>HOME</b></i>
        </a>
    </div>

    <section style="background-image: linear-gradient(to right, #eea2a2 0%, #bbc1bf 19%, #57c6e1 42%, #b49fda 79%, #7ac5d8 100%);" class="">
        <div class="container my-2 py-2">
            <div class="row justify-content-center">
                <div class="col-md-7 col-lg-7">
                    <div class="card p-4 text-dark">
                        <div class="d-flex justify-content-between">
                            <div class="p-4">
                                <h4 class="mb-0">Recent comments</h4>
                                <p class="fw-light mb-4 pb-2">Latest Comments section by users</p>
                            </div>
                        </div>
                        @foreach($groupedData as $item)
                        <div class="card-body p-4">
                            <div class="d-flex flex-row align-items-start">
                                <img src="{{ asset('frontend/emplphotos/'.$item['emplno'].'.jpeg')}}" alt="..." class="rounded-circle shadow-1-strong me-3" alt="avatar" width="60" height="60">
                                <div class="flex-grow-1">
                                    <h6 class="fw-bold ml-2 mb-1">{{ $item['name'] }} - {{ $item['tno'] }}</h6>
                                    <div class="d-flex align-items-center ml-2 mb-3">
                                        <p style="font-size: .8rem;" class="mb-0">
                                            <!-- {{ Carbon\Carbon::createFromFormat('d-m-Y H:i:s', $item['Edate'])->format('F d, Y') }} -->
                                            {{ date('d-M-Y', strtotime($item['Edate'])) }}
                                        </p>
                                        <div class="small-ratings ml-2">
                                            @for ($i = 1; $i <= 5; $i++) @if ($i <=$item['Rating']) <i class="fa fa-star rating-color"></i>
                                                @else
                                                <i class="fa fa-star"></i>
                                                @endif
                                                @endfor
                                        </div>
                                    </div>
                                    <div class="row">
                                        <p class="ml-2">
                                            {{ $item['Comments'] }}
                                        </p>
                                    </div>
                                    <div class="d-flex justify-content-end align-items-center">
                                        <button class="btn btn-sm btn-primary replyBut mx-2" onclick="reply(this)" data-Commentid="{{ $item['rowid'] }}" data-emplid="{{ $item['emplno'] }}">Reply</button>

                                        <button class="btn btn-sm btn-info viewreply  viewreplyBut mx-2" onclick="view_reply(this)" id="viewreply" data-CommentId="{{ $item['rowid'] }}">View Comments
                                            <span class="count position-absolute translate-middle badge rounded-pill bg-danger" id="count">0</span>
                                        </button>
                                    </div>
                                    <div class="mt-3">
                                        <label style="display:block; " class="showreplyDiv" id="showreplyDiv"></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr class="my-0" />
                        @endforeach

                        <br>

                        <div class="replyDiv mt-3" style="display:none;">
                            <form method="POST" action="{{ route('post_reply') }}">
                                @csrf
                                <input type="text" id="commentId" name="commentId" hidden="">
                                <input type="text" id="emplId" name="emplId" hidden="">

                                <div class="row">
                                    <div class="col-11">
                                        <div class="position-relative">
                                            <button type="button" onclick="reply_close(this)" class="close" style="position: absolute; top: 0; right: 5px;"><span>&times;</span></button>
                                            <textarea class="form-control" id="comment" name="reply" placeholder="Reply here..." rows="1" required></textarea>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <button type="submit" class="btn  form-control custom-button">
                                            <i class="fa fa-send"></i>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- TO SHOW REPLY INPUT BOX -->
    <script>
        function reply(caller) {
            document.getElementById('commentId').value = $(caller).attr('data-Commentid');
            document.getElementById('emplId').value = $(caller).attr('data-emplid');
            var replyDiv = $('.replyDiv'); // Assuming .replyDiv is a jQuery object

            $(caller).closest('div').after(replyDiv); // Insert replyDiv after the closest div to the caller

            replyDiv.show();
            $('.showreplyDiv').hide();
        }

        function reply_close(caller) {
            $('.replyDiv').hide();
        }

        function view_reply(caller) {
            var replyDiv = $('.showreplyDiv');
            $(caller).closest('div').after(replyDiv);
            $('.showreplyDiv').show();
            $('.replyDiv').hide();
        }

        function view_reply_close(caller) {
            $('.showreplyDiv').hide();

        }
    </script>

    <!-- VIEW COMMENT -->
    <script>
        var viewbutton = document.getElementsByClassName('viewreply');
        for (let i = 0; i < viewbutton.length; i++) {
            const element = viewbutton[i];

            document.addEventListener('DOMContentLoaded', function() {

                var com_Id = element.getAttribute('data-CommentId');
                $.ajax({
                    url: "{{ route('show_reply') }}",
                    type: 'get',
                    dataType: 'json',
                    data: {
                        'row_id': com_Id
                    },
                    success: function(data) {
                        var countSpan = document.getElementsByClassName("count");
                        var count_reply = data.length;
                        console.log(count_reply);
                        countSpan[i].textContent = count_reply;
                    }
                })
            });
        }

        document.addEventListener('DOMContentLoaded', function() {
            var selectButtons = document.querySelectorAll('.viewreply');

            selectButtons.forEach(function(button) {
                button.addEventListener('click', function(e) {
                    e.preventDefault();

                    var selectedRowId = button.getAttribute('data-CommentId');

                    var showreplyDiv = document.getElementById("showreplyDiv");
                    console.log(selectedRowId);

                    showreplyDiv.innerHTML = '';

                    $.ajax({
                        url: "{{ route('show_reply') }}",
                        type: 'get',
                        dataType: 'json',
                        data: {
                            'row_id': selectedRowId
                        },
                        success: function(data) {
                            console.log(data);

                            if (data.length > 0) {
                                const subdiv = document.getElementById("showreplyDiv");
                                subdiv.style.padding = "10px";
                                subdiv.style.width = "100%"; // Adjust the width

                                for (let i = 0; i < data.length; i++) {
                                    const DevName = data[i]["Name"];
                                    const tno = data[i]["Tno"];

                                    const time = data[i]["Reply_Time"];
                                    const dateObj = new Date(time);
                                    const options = {
                                        year: 'numeric',
                                        month: 'long',
                                        day: 'numeric'
                                    };
                                    const formattedDate = dateObj.toLocaleDateString('en-US', options);
                                    const comments = data[i]["reply_comments"];
                                    const subdiv = document.createElement('div');
                                    subdiv.className = 'sub_div';
                                    subdiv.style.marginBottom = '5px';

                                    const option = document.createElement("h6");
                                    option.className = 'fw-bold', 'ml-2 ';

                                    const option3 = document.createElement("h6");
                                    option.className = 'fw-bold', 'ml-2 ';

                                    const option1 = document.createElement("p");
                                    option1.style.fontSize = '.8rem';
                                    option1.style.marginLeft = "100px";


                                    const option2 = document.createElement("p");
                                    option2.className = 'ml-2';

                                    option.textContent = DevName;
                                    option3.textContent = tno;
                                    option1.textContent = formattedDate;
                                    option2.textContent = comments;
                                    const dashElement = document.createElement('span');
                                    dashElement.textContent = ' - ';

                                    const flexdiv = document.createElement('div');
                                    flexdiv.className = 'flex_div', 'col-3';
                                    flexdiv.appendChild(option);
                                    flexdiv.appendChild(dashElement);
                                    flexdiv.appendChild(option3);

                                    const flexdiv1 = document.createElement('div');
                                    flexdiv1.className = 'flex_div1';
                                    flexdiv1.appendChild(flexdiv);
                                    flexdiv1.appendChild(option1);

                                    // Create the button element
                                    var closeButton = document.createElement('button');
                                    closeButton.type = 'button';
                                    closeButton.onclick = function() {
                                        view_reply_close(this);
                                    };
                                    closeButton.className = 'close';
                                    closeButton.style.position = 'absolute';
                                    closeButton.style.top = '0px';
                                    closeButton.style.right = '5px';
                                    closeButton.id = 'closeId';

                                    // Create the span element within the button
                                    var spanElement = document.createElement('span');
                                    spanElement.innerHTML = '&times;';

                                    // Append the span element to the button
                                    closeButton.appendChild(spanElement);

                                    subdiv.appendChild(flexdiv1);
                                    subdiv.appendChild(option2);
                                    subdiv.appendChild(closeButton);

                                    showreplyDiv.appendChild(subdiv);

                                }
                            } else {

                                document.getElementById('viewreply').disabled = true;
                                $('.showreplyDiv').remove();
                                $('.closeId').remove();
                            }
                        }
                    })
                })
            })
        });
    </script>

</body>

</html>