<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>ROLES ALLOCATION</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>


    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }
    </style>


</head>

<body>
    @section('tittle') {{"ROLES ALLOCATION"}}@endsection

    <div id="layout-wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="live-preview">

                                        <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ EMPLOYEE SELECT & EXPORT @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->

                                        <form method="POST" action="{{ route('role_save') }}" enctype="multipart/form-data" class="has-validated" id="validate">
                                            @csrf

                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <select name="grid" id="grid" onchange="nowchange(this.value)" class="form-select select2" required>
                                                            <option value="" disabled selected>--Select Employee--</option>
                                                            @foreach ($people as $person)
                                                            <option value="{{$person['Emplno']}}">{{$person['C_Name']}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="row">
                                                <!-- TNO -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">TNO</label>
                                                        <?php $user_tkno = session('user_data') ?>
                                                        <input type="text" name="TNO" id="TNO" value="{{$user_tkno}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- NAME -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">NAME</label>
                                                        <?php $user_name = session('emp_name') ?>
                                                        <input type="text" name="NAME" id="NAME" value="{{$user_name}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- DEPARTMENT -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">DEPARTMENT</label>
                                                        <?php $user_dep = session('dep_data') ?>
                                                        <input type="text" name="DEPARTMENT" id="DEPARTMENT" value="{{$user_dep}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- POSITION -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">POSITION</label>
                                                        <?php $user_posit = session('des_data') ?>
                                                        <input type="text" name="DESIGNAION" id="DESIGNAION" value="{{$user_posit}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="row">
                                                <div class="card-body">
                                                    <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                                        <table class="table table-centered align-middle table-nowrap mb-0" id="myTable1" style="line-height: 30px !important;">
                                                            <thead class="text-muted table-light">
                                                                <tr>
                                                                    <th data-sort="sno"> SNO <span class="sort-icon"></th>
                                                                    <th data-sort="from_date"> Roles Name <span class="sort-icon"></th>
                                                                    <th data-sort="to_date"> Mode <span class="sort-icon"></th>
                                                                    <th data-sort="tot_days"> Action <span class="sort-icon"></th>
                                                                </tr>
                                                            </thead>
                                                            <tbody id="tableBody"></tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <!--  SUBMIT BUTTON -->
                                            <div class="d-flex justify-content-around mt-3">
                                                <button type='button' class="btn btn-primary add-btn" name='addRow' id='addRow'>ADD NEW</button>
                                                <button type="submit" class="btn btn-success" name="save" id="save">SAVE</button>
                                                <button type="button" class="btn btn-warning" onclick="window.location.reload()">CLEAR</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>


    <!-- AJAX - DETAILS SHOW IN THE TABLE-->
    <script>
        function nowchange(getemplname) {
            var emplno_select_User212 = $("#grid option:selected").val();

            document.getElementById("myTable1").disabled = false;
            var table1 = document.getElementById("myTable1");
            var rowCount1 = table1.rows.length - 1;

            for (var i = 0; i < rowCount1; i++) {
                table1.deleteRow(1);
            }

            $.ajax({
                url: "{{ route('rowset') }}",
                type: "GET",

                data: {
                    empdata: emplno_select_User212,

                },
                dataType: 'json',
                success: function(data2) {
                    console.log(data2);
                    var count = data2.length;

                    var items = 0;
                    for ($i = 0; $i < count; $i++)

                    {
                        items++;

                        var html = "<tr>";
                        html += "<td>" + items + "</td>";
                        html += "<td><select class='form-select select2' title='" + data2[$i]['roles'] + "' name='roles[]' required><option value='" + data2[$i]['roles_id'] + "'>" + data2[$i]['roles'] + "</option></select></td>";
                        html += "<td><input name='mode[]' value='" + data2[$i]['type'] + "' style= width:315px readonly required></td>";
                        html += "<td><button type='button' name='remove' class='btn btn-danger btn_remove' style= width:60px>X</button></td>";
                        html += "<tr>";
                        document.getElementById("myTable1").insertRow().innerHTML = html;
                    }

                    var i = count;

                    $('#addRow').click(function() {
                        $i = $i + 1;

                        $('#tableBody').append('<tr><td id="row_num' + $i + '">' + $i + '<input type="hidden" value=' + $i + '></td>' +
                            '<td><right><select class="form-select select2" name="roles[]" required>' + '<option value="">--Select--</option>' +
                            `@foreach ($kpi_master_full as $full_mas_api_v)<option value="{{$full_mas_api_v['rowid']}}">{{$full_mas_api_v['roles']}}</option>@endforeach</select></center></td>` +
                            '<td><right><select class="form-select select2" name="mode[]" required>' + '<option value="">--Select--</option>' + '<option value="PRIMARY">PRIMARY</option>' + '<option value="SECONDARY">SECONDARY</option></select></center></td>' +
                            '<td><button type="button" name="remove" class="btn btn-danger btn_remove">X</button></td></tr>');
                    });


                    $(document).on('click', '.btn_remove', function() {
                        $(this).closest("tr").remove(); //use closest here
                    });

                }

            });
        }
    </script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($message = Session::get('alert'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>