<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>SKILL ALLOCATION</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/2.11.6/umd/popper.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.6.0/js/bootstrap.min.js"></script>


    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }
    </style>


</head>

<body>
    @section('tittle') {{"SKILL ALLOCATION"}}@endsection

    <div id="layout-wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="live-preview">
                                        <form method="POST" action="{{ route('skill_alloct_save') }}" enctype="multipart/form-data" class="has-validated" id="validate">
                                            @csrf
                                            <div class="row">
                                                <!-- ENTRY NO -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">ENTRY NO</label>
                                                        <input type="text" name="e_no" value="<?php echo $entry_no; ?>" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- EFF-FROM -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">EFF-FROM<span class="login-danger">*</span></label>
                                                        <input type="date" id="eff" name="eff" onchange="datechange(this.value)" class="form-control" required>
                                                    </div>
                                                </div>
                                                <!-- DATE -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">DATE</label>
                                                        <input type="text" name="date" value="{{date('d-m-Y')}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="row">
                                                <!-- DIVIISION -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label">DIVISION<span class="login-danger">*</span></label>
                                                        <div class="input-group">
                                                            <input type="text" class="form-control dull" id="division" name="division" style="pointer-events: none;" required>
                                                            <div class="input-group-append">
                                                                <span class="input-group-text">
                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-hand-index-fill" viewBox="0 0 16 16" data-toggle="modal" data-target="#policyTableModal">
                                                                        <path d="M8.5 4.466V1.75a1.75 1.75 0 1 0-3.5 0v5.34l-1.2.24a1.5 1.5 0 0 0-1.196 1.636l.345 3.106a2.5 2.5 0 0 0 .405 1.11l1.433 2.15A1.5 1.5 0 0 0 6.035 16h6.385a1.5 1.5 0 0 0 1.302-.756l1.395-2.441a3.5 3.5 0 0 0 .444-1.389l.271-2.715a2 2 0 0 0-1.99-2.199h-.581a5.114 5.114 0 0 0-.195-.248c-.191-.229-.51-.568-.88-.716-.364-.146-.846-.132-1.158-.108l-.132.012a1.26 1.26 0 0 0-.56-.642 2.632 2.632 0 0 0-.738-.288c-.31-.062-.739-.058-1.05-.046l-.048.002z" />
                                                                    </svg>
                                                                </span>
                                                            </div>
                                                        </div>
                                                        <input type="hidden" class="form-control" id="division1" name="division1" required>
                                                    </div>
                                                </div>
                                                <!-- DEPARTMENT -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label">DEPARTMENT<span class="login-danger"></span></label>
                                                        <input type="text" id="department" name="department" class="form-control dull" readonly required>
                                                        <input type="hidden" id="department1" name="department1" class="form-control dull" readonly required>
                                                    </div>
                                                </div>
                                                <!-- DESIGNATION -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label">DESIGNATION<span class="login-danger"></span></label>
                                                        <input type="text" id="design" name="design" class="form-control dull" readonly>
                                                        <input type="hidden" class="form-control" id="design1" name="design1" readonly>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="row">
                                                <!-- TEAM -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">TEAM</label>
                                                        <input type="text" id="team" name="team" class="form-control dull" required readonly>
                                                        <input type="hidden" id="team1" name="team1" class="form-control dull" required readonly>
                                                    </div>
                                                </div>
                                                <!-- EMPLOYEE NAME -->
                                                <div class="col-md-4">
                                                    <div class="mb-4">
                                                        <label for="job-category-Input" class="form-label">EMPLOYEE NAME<span class="text-danger">*</span></label>
                                                        <select class="form-control select2" data-choices name="empl_name" id="empl_name" required>
                                                            <option value="">--Select Emp--</option>
                                                            @foreach ($Name as $option)
                                                            <option value="{{$option['tno']}}/ {{$option['emplno']}}">{{$option['name']}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <!-- TNO -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">TNO<span class="login-danger"></span></label>
                                                        <input type="text" id="t_no" name="t_no" class="form-control dull" required readonly>
                                                        <input type="hidden" class="form-control" id="empno" name="empno" value="" readonly>
                                                    </div>
                                                </div>
                                            </div>
                                            <button type="button" class="btn btn-success" onclick="fetchData()">VIEW</button>
                                            <br>
                                            <br>

                                            <!-- TABLE -->
                                            <div class="card-body" id="tableContainer" style="display: none;">
                                                <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                                    <table class="table table-centered align-middle table-nowrap mb-0" id="app_table1" style="line-height: 30px !important;">
                                                        <thead class="text-muted table-light sticky-header">
                                                            <tr>
                                                                <th data-sort="sno"> SNO <span class="sort-icon"></th>
                                                                <th data-sort="skill_desc"> Skill Description <span class="sort-icon"></th>
                                                                <th data-sort="drive_link"> Drive Link <span class="sort-icon"></th>
                                                                <th data-sort="att-1"> Attachment-1 <span class="sort-icon"></th>
                                                                <th data-sort="att-2"> Attachment-2 <span class="sort-icon"></th>
                                                                <th data-sort="att-3"> Attachment-3 <span class="sort-icon"></th>
                                                                <th data-sort="att-4"> Attachment-4 <span class="sort-icon"></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody></tbody>
                                                    </table>
                                                </div>
                                            </div>

                                            <!--  SUBMIT BUTTON -->
                                            <div class="d-flex justify-content-around mt-3">
                                                <button type="submit" id="saveButton" class="btn btn-primary" name="submit">SAVE</button>
                                                <button type="button" id="clearButton" class="btn btn-warning" onclick="window.location.reload()">CLEAR</button>
                                                <button type="button" id="reportButton" class="btn btn-info" onclick="window.location.href = '/skill_alloc_report'">Report</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- POPUP -->
    <div class="modal fade" id="policyTableModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel" style="font-weight: bold;">SELECT FOR ALLOCATIONS *</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" style="max-height: 300px; overflow-y: auto; padding: 0px;">
                    <table id="app_table" class="table table-bordered table-condensed table-hover table-striped">
                        <thead class="sticky-header">
                            <tr>
                                <th></th>
                                <th>SNO</th>
                                <th>Division</th>
                                <th> Department</th>
                                <th>Designation </th>
                                <th>Team </th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Data will be added here via AJAX -->
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">OK</button>
                </div>
            </div>
        </div>
    </div>

    <!-- SPLIT EMP-NAME AND TNO -->
    <script>
        $(document).ready(function() {
            $('#empl_name').change(function() {
                var selectedValue = $(this).val();
                console.log(selectedValue);

                // Split the selected value into parts based on '/'
                var parts = selectedValue.split('/');

                // Assign the values to the respective text boxes
                $('#t_no').val(parts[0].trim());
                $('#empno').val(parts[1].trim());
            });
        });
    </script>

    <!-- ---AJAX METHOD FOR SHOWING THE POPUP ---- -->
    <script>
        function datechange(t_name) {
            var selected_name = t_name;

            $.ajax({
                url: "{{ route('skill_alloc') }}",
                type: "GET",
                data: {
                    eff: selected_name,
                },
                dataType: 'json',
                success: function(details) {
                    console.log(details);

                    var table = $('#app_table').find('tbody');
                    table.empty();

                    for (let i = 0; i < details.length; i++) {
                        var division_name = details[i].Actual_Division_Name;
                        var DeptName = details[i].DeptName;
                        var Designation = details[i].Designation;
                        var Team_name = details[i].Team_name;

                        var newRow = $('<tr>');
                        newRow.append('<td><input type="radio" name="policy_radio" value="' + i + '"></td>');
                        newRow.append('<td>' + (i + 1) + '</td>');
                        newRow.append('<td>' + division_name + '</td>');
                        newRow.append('<td>' + DeptName + '</td>');
                        newRow.append('<td>' + Designation + '</td>');
                        newRow.append('<td>' + Team_name + '</td>');

                        table.append(newRow);
                    }

                    // Add a click event handler for the radio buttons
                    $('input[type=radio][name=policy_radio]').click(function() {
                        var selectedIndex = $(this).val();
                        var selectedRowData = details[selectedIndex];
                        console.log(selectedRowData);
                        // Populate the input boxes with selected data
                        $('#division').val(selectedRowData.Actual_Division_Name);
                        $('#division1').val(selectedRowData.Division_id);
                        $('#department').val(selectedRowData.DeptName);
                        $('#department1').val(selectedRowData.Department_id);
                        $('#design').val(selectedRowData.Designation);
                        $('#design1').val(selectedRowData.Designation_id);
                        $('#team').val(selectedRowData.Team_name);
                        $('#team1').val(selectedRowData.Team);
                        // $('#eff').val(selectedRowData.Eff_from);
                    });
                }
            });
        }
    </script>

    <!-- ---AJAX METHOD FOR SHOWIGNG THE FILES ---- -->
    <script>
        function fetchData() {
            // Get the values of the input fields
            var divisionValue = $('#division1').val();
            var departmentValue = $('#department1').val();
            var designValue = $('#design1').val();
            var teamValue = $('#team1').val();
            console.log(divisionValue, departmentValue, designValue, teamValue);

            $.ajax({
                url: "{{ route('skill_alloc1') }}",
                type: "GET",
                data: {
                    division: divisionValue,
                    department: departmentValue,
                    design: designValue,
                    team: teamValue,
                },
                dataType: 'json',
                success: function(details) {
                    console.log(details);

                    var table = $('#app_table1').find('tbody');
                    table.empty();

                    for (let i = 0; i < details.length; i++) {
                        var skill = details[i].skill;
                        var Attachment_1 = details[i].Attachment_1;
                        var Attachment_2 = details[i].Attachment_2;
                        var Attachment_3 = details[i].Attachment_3;
                        var Attachment_4 = details[i].Attachment_4;
                        var drive_link = details[i].drive_link;

                        var newRow = $('<tr>');

                        newRow.append('<td>' + (i + 1) + '</td>');
                        newRow.append('<td>' + skill + '</td>');
                        if (drive_link !== null && drive_link !== "NO Link") {
                            newRow.append("<td><a href='" + drive_link + "' class='mr-5 file-link' target='_blank' title='" + drive_link + "'>Drive Link</a></td>");
                        } else {
                            newRow.append("<td>---</td>");
                        }

                        if (Attachment_1 !== null && Attachment_1 !== "null") {
                            newRow.append("<td><a href='" + Attachment_1 + "' class='mr-5 file-link' target='_blank' title='" + Attachment_1 + "'>Attachment_1</a></td>");
                        } else {
                            newRow.append("<td>---</td>");
                        }

                        if (Attachment_2 !== null && Attachment_2 !== "null") {
                            newRow.append("<td><a href='" + Attachment_2 + "' class='mr-5 file-link' target='_blank' title='" + Attachment_2 + "'>Attachment_2</a></td>");
                        } else {
                            newRow.append("<td>---</td>");
                        }

                        if (Attachment_3 !== null && Attachment_3 !== "null") {
                            newRow.append("<td><a href='" + Attachment_3 + "' class='mr-5 file-link' target='_blank' title='" + Attachment_3 + "'>Attachment_3</a></td>");
                        } else {
                            newRow.append("<td>---</td>");
                        }

                        if (Attachment_4 !== null && Attachment_4 !== "null") {
                            newRow.append("<td><a href='" + Attachment_4 + "' class='mr-5 file-link' target='_blank' title='" + Attachment_4 + "'>Attachment_4</a></td>");
                        } else {
                            newRow.append("<td>---</td>");
                        }


                        table.append(newRow);
                    }

                    // Assuming you want to show the table when the button is clicked
                    $('#tableContainer').css('display', 'block');
                },
                error: function(error) {
                    console.error("Error fetching data:", error);
                    // Handle the error here
                }
            });
        }
    </script>


    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


    <!-- SEARCH -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>


    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($message = Session::get('alert'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>