<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>SKILL MANAGEMENT ENTRY</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <!-- FOR STAR RATING -->
    <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">

    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }

        .sticky-header {
            position: sticky;
            top: 0;
            z-index: 1;
            text-align: center;
        }
    </style>



</head>

<body>
    @section('tittle') {{"SKILL MANAGEMENT ENTRY"}}@endsection

    <div id="layout-wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-22">
                            <div class="card">
                                <div class="card-body">
                                    <form id="validate" method="POST" action="{{ route('skill_ent_save') }}" enctype="multipart/form-data">
                                        @csrf
                                        <div class="live-preview">
                                            <div class="row">
                                                <!-- E-NO/DATE -->
                                                <div class="col-sm-3">
                                                    <div class="mb-3">
                                                        <label class="form-label">E-NO<span class="login-danger"></span></label>
                                                        <input type="text" name="entry_no" value="<?php echo $entry_no; ?>" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <div class="col-sm-3">
                                                    <label class="form-label">DATE<span class="login-danger"></span></label>
                                                    <input type='text' name="date" class="form-control dull" value="{{now()->format('Y-m-d')}}" readonly>
                                                </div>

                                                <!-- REVISED -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">REVISED</label>
                                                        <input type="text" name="revised" value="1" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- EFF-FROM -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label class="form-label">EFF-FROM<span class="login-danger">*</span></label>
                                                        <input type="date" name="eff" class="form-control" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="row">
                                                <!-- DIVISION -->
                                                <div class="col-md-3">
                                                    <div class="mb-4">
                                                        <label for="job-category-Input" class="form-label">DIVISION<span class="text-danger">*</span></label>
                                                        <select class="form-control select2" data-choices name="Actual_Division_Code" id="Actual_Division_Code" required>
                                                            <option value="">--Select Division--</option>
                                                            @foreach ($points_new as $option)
                                                            <option value="{{$option['Actual_Division_Code']}}">{{$option['Actual_Division_Name']}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <!-- DEPARTMENT -->
                                                <div class="col-md-3">
                                                    <div class="mb-4">
                                                        <label for="job-category-Input" class="form-label">DEPARTMENT<span class="text-danger">*</span></label>
                                                        <select class="form-control select2" data-choices name="department" id="department" required>
                                                            <option value="">--Select Dep--</option>
                                                            @foreach ($result as $items)
                                                            <option value="{{$items['code']}}">{{$items['name']}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <!-- DESIGNATION -->
                                                <div class="col-md-3">
                                                    <div class="mb-4">
                                                        <label for="job-category-Input" class="form-label">DESIGNATION<span class="text-danger">*</span></label>
                                                        <select class="form-control select2" data-choices name="design" id="design" required>
                                                            <option value="">--Select Desig--</option>
                                                            @foreach($design as $des)
                                                            <option value="{{ $des['Rowid'] }}">{{ $des['Name'] }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <!-- TEAM -->
                                                <div class="col-md-3">
                                                    <div class="mb-4">
                                                        <label for="job-category-Input" class="form-label">TEAM<span class="text-danger">*</span></label>
                                                        <select class="form-control select2" data-choices name="team" id="team" onchange="onChangeHandler();" required>
                                                            <option value="">--Select Team--</option>
                                                            @foreach($team as $res)
                                                            <option value="{{ $res['Rowid'] }}">{{ $res['Team'] }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>

                                            <!-- TABLE -->
                                            <div class="card-body" id="tableContainer" style="display:none;">
                                                <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                                    <table class="table table-centered align-middle table-nowrap mb-0" id="app_table" style="line-height: 30px !important;">
                                                        <thead class="text-muted table-light sticky-header">
                                                            <tr>
                                                                <th data-sort="sno"> SNO <span class="sort-icon"></th>
                                                                <th data-sort="desc"> Skill Description <span class="sort-icon"></th>
                                                                <th data-sort="drive"> Drive Link <span class="sort-icon"></th>
                                                                <th data-sort="att-1"> Attachment-1 <span class="sort-icon"></th>
                                                                <th data-sort="att-2"> Attachment-2 <span class="sort-icon"></th>
                                                                <th data-sort="att-3"> Attachment-3 <span class="sort-icon"></th>
                                                                <th data-sort="att-4"> Attachment-4 <span class="sort-icon"></th>
                                                                <th data-sort="remark"> Remark <span class="sort-icon"></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @foreach($skill as $index => $row)
                                                            <tr>
                                                                <td>
                                                                    <div class="row-item">
                                                                        <label>{{ $index + 1 }}</label>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <input type="hidden" name="skill_desc[]" value="{{ $row['Rowid'] }}">
                                                                    <input type="hidden" name="skill_desc_nam[]" value="{{ $row['Name'] }}">
                                                                    {{ $row['Name'] }}
                                                                </td>
                                                                <td>
                                                                    <input type="text" class="col-lg-6form-control" name="drive1[]" id="drive1" placeholder="Drive Link...">
                                                                </td>
                                                                <td>
                                                                    <input class=" col-lg-6form-control" type="file" id="formFile1" name="formFile1[]">
                                                                    <span id="fileNameDisplay1"></span>
                                                                </td>
                                                                <td>
                                                                    <input class="col-lg-6form-control" type="file" id="formFile2" name="formFile2[]">
                                                                    <span id="fileNameDisplay2"></span>
                                                                </td>
                                                                <td>
                                                                    <input class="col-lg-6form-control" type="file" id="formFile3" name="formFile3[]">
                                                                    <span id="fileNameDisplay3"></span>
                                                                </td>
                                                                <td>
                                                                    <input class="col-lg-6form-control" type="file" id="formFile4" name="formFile4[]">
                                                                    <span id="fileNameDisplay4"></span>
                                                                </td>
                                                                <td>
                                                                    <input type="text" class="col-lg-6form-control" name="remarks[]">
                                                                </td>
                                                            </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                            
                                            <!--  SUBMIT BUTTON -->
                                            <div class="d-flex justify-content-around mt-3">
                                                <button type="submit" id="saveButton" class="btn btn-primary" name="submit">SAVE</button>
                                                <button type="button" id="clearButton" class="btn btn-warning" onclick="window.location.reload()">CLEAR</button>
                                                <button type="button" id="reportButton" class="btn btn-info" onclick="window.location.href = '/skill_entry_report'">Report</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

    <!-- SEARCH -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <!-- AJAX - DETAILS SHOW IN TABLE -->
    <script>
        function onChangeHandler() {
            var designSelect = document.getElementById('design');
            var tableContainer = document.getElementById('tableContainer');
            var design = designSelect.value;
            var dept = document.getElementById('department').value;
            var division = document.getElementById('Actual_Division_Code').value;
            var team = document.getElementById('team').value;

            console.log(design, dept, division, team);

            // Check if a designation is selected
            if (design !== "" && dept !== "" && division !== "" && team !== "") {
                // Show the table
                tableContainer.style.display = 'block';

                // AJAX call
                $.ajax({
                    url: "{{ route('skill_copy') }}",
                    type: "GET",
                    data: {
                        design: design,
                        dept: dept,
                        division: division,
                        team: team
                    },
                    dataType: 'json',
                    success: function(details) {
                        console.log(details);

                        if (details && details.length > 0) {
                            var userConfirmed = confirm('Do you want to Copy?');
                            if (userConfirmed) {
                                var table = $('#app_table').find('tbody');
                                table.empty();

                                for (let i = 0; i < details.length; i++) {
                                    var Attachment_1 = details[i].Attachment_1;
                                    var Attachment_2 = details[i].Attachment_2;
                                    var Attachment_3 = details[i].Attachment_3;
                                    var Attachment_4 = details[i].Attachment_4;
                                    var drive_link = details[i].drive_link;
                                    var skill_desc_nam = details[i].skill;
                                    var skill_desc = details[i].skill_desp;
                                    var remarks = details[i].remarks;

                                    var newRow = $('<tr>');
                                    newRow.append('<td>' + (i + 1) + '</td>');
                                    newRow.append('<td>' + skill_desc_nam + '</td>');
                                    var skillInput = $('<input>').attr({
                                        type: 'hidden',
                                        name: 'skill_desc[]', // Change the name attribute as needed
                                        value: skill_desc
                                    });

                                    newRow.append($('<td style="display:none;">').append(skillInput));

                                    var skillValue = skillInput.val();
                                    console.log(skillValue);

                                    // Create and append the input field for the drive link
                                    var driveInput = $('<input>').attr({
                                        type: 'text',
                                        name: 'drive1[]',
                                        value: drive_link
                                    });
                                    newRow.append($('<td>').append(driveInput));
                                    // newRow.append('<td> <input type="text" name="drive_link" value="drive_link' + i + '"></td>');

                                    // Create file input for Attachment_1
                                    var attach_1 = $('<input>').attr({
                                        type: "file",
                                        id: "formFile1",
                                        name: "formFile1[]"
                                    });


                                    // Create a span element to display the file name
                                    var fileNameSpan = $('<span>').addClass('fileNameSpan').text(Attachment_1 ? 'File: ' + getFileName(Attachment_1) : '');

                                    // Add change event to hide the span when file input changes
                                    $(document).on('change', '#formFile1', function() {
                                        var fileNameSpan = $(this).closest('td').find('.fileNameSpan');
                                        fileNameSpan.text(this.files[0] ? 'File: ' + this.files[0].name : '');
                                    });

                                    newRow.append($('<td>').append(attach_1).append(fileNameSpan));

                                    var attach_nam_1 = $('<input>').attr({
                                        type: "hidden",
                                        id: "attach_1",
                                        name: "attach_1[]",
                                        value: Attachment_1
                                    });
                                    newRow.append($('<td style="display:none;">').append(attach_nam_1));

                                    var attach_nam_1 = attach_nam_1.val();
                                    console.log(attach_nam_1);

                                    // newRow.append($('<td>').append(attach_1).append(fileNameSpan));


                                    var attach_2 = $('<input>').attr({
                                        type: "file",
                                        id: "formFile2",
                                        name: "formFile2[]"
                                    });

                                    // Create a span element to display the file name
                                    var fileNameSpan = $('<span>').addClass('fileNameSpan').text(Attachment_2 ? 'File: ' + getFileName(Attachment_2) : '');


                                    // Add change event to hide the span when file input changes
                                    $(document).on('change', '#formFile2', function() {
                                        var fileNameSpan = $(this).closest('td').find('.fileNameSpan');
                                        fileNameSpan.text(this.files[0] ? 'File: ' + this.files[0].name : '');
                                    });

                                    newRow.append($('<td>').append(attach_2).append(fileNameSpan));

                                    var attach_nam_2 = $('<input>').attr({
                                        type: "hidden",
                                        id: "attach_2",
                                        name: "attach_2[]",
                                        value: Attachment_2
                                    });

                                    newRow.append($('<td style="display:none;">').append(attach_nam_2));

                                    var attach_nam_2 = attach_nam_2.val();

                                    var attach_3 = $('<input>').attr({
                                        type: "file",
                                        id: "formFile3",
                                        name: "formFile3[]"
                                    });

                                    // Create a span element to display the file name
                                    var fileNameSpan = $('<span>').addClass('fileNameSpan').text(Attachment_3 ? 'File: ' + getFileName(Attachment_3) : '');

                                    // Add change event to hide the span when file input changes
                                    $(document).on('change', '#formFile3', function() {
                                        var fileNameSpan = $(this).closest('td').find('.fileNameSpan');
                                        fileNameSpan.text(this.files[0] ? 'File: ' + this.files[0].name : '');
                                    });


                                    newRow.append($('<td>').append(attach_3).append(fileNameSpan));

                                    var attach_nam_3 = $('<input>').attr({
                                        type: "text",
                                        id: "attach_3",
                                        name: "attach_3[]",
                                        value: Attachment_3
                                    });

                                    newRow.append($('<td style="display:none;">').append(attach_nam_3));

                                    var attach_nam_3 = attach_nam_3.val();


                                    var attach_4 = $('<input>').attr({
                                        type: "file",
                                        id: "formFile4",
                                        name: "formFile4[]"
                                    });

                                    // Create a span element to display the file name
                                    var fileNameSpan = $('<span>').addClass('fileNameSpan').text(Attachment_4 ? 'File: ' + getFileName(Attachment_4) : '');

                                    // Add change event to hide the span when file input changes
                                    $(document).on('change', '#formFile4', function() {
                                        var fileNameSpan = $(this).closest('td').find('.fileNameSpan');
                                        fileNameSpan.text(this.files[0] ? 'File: ' + this.files[0].name : '');
                                    });

                                    newRow.append($('<td>').append(attach_4).append(fileNameSpan));

                                    var attach_nam_4 = $('<input>').attr({
                                        type: "text",
                                        id: "attach_4",
                                        name: "attach_4[]",
                                        value: Attachment_4
                                    });

                                    newRow.append($('<td style="display:none;">').append(attach_nam_4));

                                    var attach_nam_4 = attach_nam_4.val();

                                    var remarksInput = $('<input>').attr({
                                        type: 'text',
                                        name: 'remarks[]',
                                        value: remarks
                                    });

                                    newRow.append($('<td>').append(remarksInput));

                                    table.append(newRow);


                                }
                            }
                        }
                    },
                    error: function() {
                        // Handle error cases
                        console.log('Error in AJAX request.');
                    }
                });

            } else {
                // Hide the table
                tableContainer.style.display = 'none';
            }

            // Define the getFileName function outside the loop
            function getFileName(path) {
                return path.split('\\').pop().split('/').pop();
            }
        }
    </script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($message = Session::get('alert'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>