<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>SKILL ENTRY REPORT</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- EXCEL -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.3/xlsx.full.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/2.11.6/umd/popper.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.6.0/js/bootstrap.min.js"></script>


    <!-- STYLE FOR PAGINATION -->
    <style>
        .pagination {
            justify-content: space-between;
            margin-left: 10px;
        }

        #pagination {
            margin-right: 15px;
            display: inline-block;
            vertical-align: middle;
            border-radius: 4px;
            padding: 1px 2px 4px 2px;
            border-top: 1px solid #AEAEAE;
            border-bottom: 1px solid #FFFFFF;
            background-color: #DADADA;
            background-image: -webkit-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -moz-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -ms-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -o-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: linear-gradient(top, #DBDBDB, #E2E2E2);
        }

        #pagination #pag_a,
        #pagination #pag_i {
            display: inline-block;
            vertical-align: middle;
            width: 22px;
            color: #7D7D7D;
            text-align: center;
            font-size: 10px;
            padding: 3px 0 2px 0;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            -o-user-select: none;
            user-select: none;
        }

        #pagination #pag_a {
            margin: 0 2px 0 2px;
            border-radius: 4px;
            border: 1px solid #E3E3E3;
            cursor: pointer;
            box-shadow: inset 0 1px 0 0 #FFF, 0 1px 2px #666;
            text-shadow: 0 1px 1px #FFF;
            background-color: #E6E6E6;
            background-image: -webkit-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -moz-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -ms-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -o-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: linear-gradient(top, #F3F3F3, #D7D7D7);
        }

        #pagination #pag_i {
            margin: 0 3px 0 3px;
        }

        #pagination #pag_a.current {
            border: 1px solid #E9E9E9;
            box-shadow: 0 1px 1px #999;
            background-color: #DFDFDF;
            background-image: -webkit-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -moz-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -ms-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -o-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: linear-gradient(top, #D0D0D0, #EBEBEB);
        }
    </style>

    <!-- FONT -->
    <!-- <style>
        .row label,
        .card-title {
            font-weight: bold;
            font-size: medium;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .form-heading h4 {
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .card-body .table-responsive table thead th {
            color: black;
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .card-body .table-responsive table tbody td {
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }
    </style> -->

    <!-- STATUS -->
    <style>
        .status {
            padding: .1rem 0;
            border-radius: 2rem;
            text-align: center;
            margin-top: 10px;
        }

        .status.Approved {
            /* background-color: #86e49d; */
            /* color: #006b21; */
            color: green;
            font-weight: bold;
            border: 1px solid pink;
            outline: 2px dashed greenyellow;
            /* -webkit-text-stroke: 0.5px black; */

        }

        .status.Reject {
            /* background-color: #d893a3; */
            color: #b30021;
            font-weight: bold;
            border: 2px solid pink;
            outline: 2px dashed #d893a3;

        }

        .status.Request {
            /* background-color: #ebc474; */
            color: #FABA5F;
            font-weight: bold;
            border: 2px solid #FF9F00;
            outline: 2px dashed #FF9944;
            width: 100px;

        }

        .status.shipped {
            background-color: #6fcaea;
        }
    </style>

    <!-- TABLE DESIGN -->
    <style>
        .card-body .table-responsive .table tbody tr td {
            padding: 0 25px !important;
            height: 3px;
            vertical-align: middle !important;
        }

        .card-header {
            height: 60px;
        }

        .card-header .col-md-3 select {
            margin-top: 10px;
        }

        .table-responsive {
            position: relative;
            overflow: auto;
        }

        .table thead th {
            position: sticky;
            top: 0;
            z-index: 1;
        }
    </style>

</head>

<body>
    @section('tittle') {{"SKILL ENTRY REPORT"}}@endsection

    <div id="layout-wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">

                                <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ EXPORT @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->

                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h4 class="card-title">
                                        <?php
                                        $user_name = Session('emp_name');
                                        echo $user_name;
                                        ?>
                                    </h4>
                                    <!--########################### PRINT & EXPORT ###########################-->
                                    <div class="col-md-3 text-end flex-shrink-0">

                                        <div class="dropdown card-header-dropdown">
                                            <!-- BACK BUTTON -->
                                            <button type="button" class="btn" title="Back" onclick="window.location.href = '/skill_entry'" style="border: 2px solid black;">
                                                <i class="fa-solid fa-arrow-left-long"></i>
                                            </button>
                                            <a class="text-reset dropdown-btn" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <span class="text-muted fs-18"><i class="mdi mdi-dots-vertical"></i></span>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end">
                                                <a class="dropdown-item" onclick="printtable.printTable()" style="cursor: pointer;">Print</a>
                                                <a class="dropdown-item" id="exportExcelBtn" style="cursor:pointer;">Export to Excel</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ SEARCH AND SHOW ENTRIES @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="page-table-header mb-2">
                                            <div class="row align-items-center">
                                                <div class="doctor-table-blk">
                                                    <div class="doctor-search-blk">
                                                        <div class="top-nav-search table-search-blk">
                                                            <form action="javascript:;">
                                                                <div class="d-flex justify-content-between align-items-center">
                                                                    <div class="search-container" style="margin-left: 10px;">
                                                                        <input type="text" id="search-input" class="form-control" placeholder="Search here">
                                                                    </div>
                                                                    <div class="ml-2 col-md-1" style="margin-right: 10px;">
                                                                        <select name="state" id="maxRows" class="form-select">
                                                                            <option value="10">10</option>
                                                                            <option value="50">50</option>
                                                                            <option value="70">70</option>
                                                                            <option value="100">100</option>
                                                                            <option value="5000">Show ALL Rows</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ TABLE @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->
                                <div class="card-body">
                                    <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                        <table class="table table-centered align-middle table-nowrap mb-0" id="dataTable" style="line-height: 30px !important;">
                                            <thead class="text-muted table-light">
                                                <tr>
                                                    <th data-sort="sno"> SNO <span class="sort-icon"></th>
                                                    <th data-sort="ent_no"> Entry No <span class="sort-icon"></th>
                                                    <th data-sort="efffrom"> Eff-From <span class="sort-icon"></th>
                                                    <th data-sort="divison"> Division <span class="sort-icon"></th>
                                                    <th data-sort="depart"> Department <span class="sort-icon"></th>
                                                    <th data-sort="design"> Designation <span class="sort-icon"></th>
                                                    <th data-sort="skill_desc"> Skill Description <span class="sort-icon"></th>
                                                    <th data-sort="drive_link"> Drive Link <span class="sort-icon"></th>
                                                    <th data-sort="Att1"> Attachment-1 <span class="sort-icon"></th>
                                                    <th data-sort="Att2"> Attachment-2 <span class="sort-icon"></th>
                                                    <th data-sort="Att3"> Attachment-3 <span class="sort-icon"></th>
                                                    <th data-sort="Att3"> Attachment-4 <span class="sort-icon"></th>
                                                    <th data-sort="remarks"> Remarks <span class="sort-icon"></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($result as $index => $row)
                                                <tr>
                                                    <td> {{$index + 1}} </td>
                                                    <td>{{ $row['Entry_no'] }}</td>
                                                    <td>{{ date('Y-m-d', strtotime($row['Eff_from'])) }}</td>
                                                    <td>{{ $row['Actual_Division_Name'] }}</td>
                                                    <td>{{ $row['DeptName'] }}</td>
                                                    <td>{{ $row['Designation'] }}</td>
                                                    <td>{{ $row['skill'] }}</td>
                                                    <td>
                                                        @if($row['drive_link'] !== "NO Link")
                                                        <a href="{{ $row['drive_link'] }}" class="mr-5 file-link">Drivelink</a>
                                                        @else
                                                        --
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($row['Attachment_1'] !== "null")
                                                        <a href="{{ $row['Attachment_1'] }}" class="mr-5 file-link" id="link2" name="filepath" target="_blank" title="{{ $row['Attachment_1'] }}">{{ $row['Attachment_1'] }}</a>
                                                        @else
                                                        --
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($row['Attachment_2'] !== "null")
                                                        <a href="{{ $row['Attachment_2'] }}" class="mr-5 file-link" id="link2" name="filepath" target="_blank" title="{{ $row['Attachment_2'] }}">{{ $row['Attachment_2'] }}</a>
                                                        @else
                                                        --
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($row['Attachment_3'] !== "null")
                                                        <a href="{{ $row['Attachment_3'] }}" class="mr-5 file-link" id="link2" name="filepath" target="_blank" title="{{ $row['Attachment_3'] }}">{{ $row['Attachment_3'] }}</a>
                                                        @else
                                                        --
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($row['Attachment_4'] !== "null")
                                                        <a href="{{ $row['Attachment_4'] }}" class="mr-5 file-link" id="link2" name="filepath" target="_blank" title="{{ $row['Attachment_4'] }}">{{ $row['Attachment_4'] }}</a>
                                                        @else
                                                        --
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($row['remarks'] !== "null")
                                                        {{ $row['remarks'] }}
                                                        @else
                                                        --
                                                        @endif
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <!--############################### PAGINATION ###############################-->
                                <div class="pagination">
                                    <div id="entryCount">Total entries: <span id="rowCount"></span></div>
                                    <div id="searchCount"></div>
                                    <div id="pagination"></div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/plugins.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>


    <!-- SORTING -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.sort-icon').html('<i class="fas fa-sort"></i>'); // Display the sort icon by default

            $('th[data-sort]').click(function() {
                const column = $(this).data('sort');
                const sortOrder = $(this).hasClass('asc') ? 'desc' : 'asc';

                // Reset sorting indicators
                $('th[data-sort]').removeClass('asc desc');
                $('.sort-icon').html('<i class="fas fa-sort"></i>');

                // Apply sorting indicator to the clicked column
                $(this).addClass(sortOrder);
                $(this).find('.sort-icon i').removeClass().addClass(sortOrder === 'asc' ? 'fas fa-sort-up' : 'fas fa-sort-down');

                // Perform sorting logic based on the column and sortOrder
                sortTable(column, sortOrder);
            });

            function sortTable(column, sortOrder) {
                const rows = $('tbody tr').get();

                rows.sort(function(a, b) {
                    let keyA = $(a).find(`td:eq(${getColumnIndex(column)})`).text();
                    let keyB = $(b).find(`td:eq(${getColumnIndex(column)})`).text();

                    if (!isNaN(parseFloat(keyA)) && !isNaN(parseFloat(keyB))) {
                        keyA = parseFloat(keyA);
                        keyB = parseFloat(keyB);
                    }

                    if (sortOrder === 'asc') {
                        if (isNaN(keyA) || isNaN(keyB)) {
                            return keyA.localeCompare(keyB);
                        } else {
                            return keyA - keyB;
                        }
                    } else {
                        if (isNaN(keyA) || isNaN(keyB)) {
                            return keyB.localeCompare(keyA);
                        } else {
                            return keyB - keyA;
                        }
                    }
                });

                $.each(rows, function(index, row) {
                    $('tbody').append(row);
                });
            }

            function getColumnIndex(column) {
                return $('thead th[data-sort="' + column + '"]').index();
            }
        });
    </script>

    <!-- PRINT -->
    <script>
        let printtable = new function() {
            this.printTable = function() {
                let tab = document.getElementById('dataTable');
                let win = window.open('', '', 'height=700,width=700');
                win.document.write(tab.outerHTML);
                win.document.close();
                win.print();
                win.close(); // Add this line to close the window after printing
            }

        }
    </script>

    <!-- EXPORT AS EXCEL -->
    <script>
        function export_table_to_xlsx(table, filename) {
            var wb = XLSX.utils.table_to_book(table, {
                sheet: "Sheet1"
            });
            var ws = wb.Sheets["Sheet1"];

            // Calculate column widths based on content
            var range = XLSX.utils.decode_range(ws['!ref']);
            for (var C = range.s.c; C <= range.e.c; ++C) {
                var max_len = 0;
                for (var R = range.s.r; R <= range.e.r; ++R) {
                    var cell = ws[XLSX.utils.encode_cell({
                        r: R,
                        c: C
                    })];
                    if (cell && cell.v) {
                        var len = String(cell.v).length;
                        if (len > max_len) {
                            max_len = len;
                        }
                    }
                }
                if (max_len > 0) {
                    ws['!cols'] = ws['!cols'] || [];
                    ws['!cols'][C] = {
                        wch: max_len + 2
                    };
                }
            }

            XLSX.writeFile(wb, filename);
        }

        document.querySelector("#exportExcelBtn").addEventListener("click", function(event) {
            event.preventDefault(); // Prevent default action of anchor tag
            var table = document.querySelector("table");
            if (table) {
                export_table_to_xlsx(table, "SKILL_ENTRY_REPORT.xlsx");
            } else {
                console.error("Table not found!");
            }
        });
    </script>

    <!-- SEARCH -->
    <script>
        $(document).ready(function() {
            // Define a variable to store the search value
            var searchValue = "";

            // Search function
            function performSearch() {
                var matches = $("#dataTable tbody tr").filter(function() {
                    return $(this).text().toLowerCase().indexOf(searchValue) > -1;
                });

                if (searchValue === "") {
                    // If the search bar is empty, clear the search results and count
                    $("#searchCount").text("");
                    $("#entryCount").show(); // Show the entry count
                    $("#dataTable tbody tr").toggle(true);
                    updateRowsPerPage(); // Call the function to reset displayed rows
                    $('#pagination').show(); // SHOW THE PAGINATION 
                } else {
                    $("#entryCount").hide(); // Hide the entry count
                    // Show the search count and hide rows that don't match the search criteria
                    $("#searchCount").text(matches.length + " result(s) found");

                    // Get the selected rows per page value
                    var maxRows = parseInt($("#maxRows").val());

                    // Limit the matches to the selected rows per page
                    matches.slice(maxRows).toggle(false);
                    matches.slice(0, maxRows).toggle(true);
                    $("#dataTable tbody tr").not(matches).toggle(false);
                    $('#pagination').hide(); // SHOW THE PAGINATION
                }
            }

            // Search input keyup event
            $("#search-input").on("keyup", function() {
                searchValue = $(this).val().toLowerCase();
                performSearch();
            });

            // maxRows dropdown change event
            $("#maxRows").on("change", function() {
                // Update rows per page and reapply search
                updateRowsPerPage();
                performSearch();
            });

            // Initialize search and rows per page
            performSearch();
            updateRowsPerPage();
        });
    </script>

    <!-- SHOW ENTRIES TABLE -->
    <script>
        // Function to update the number of displayed rows
        function updateRowsPerPage() {
            var maxRows = parseInt(document.getElementById("maxRows").value);
            var tableBody = document.getElementById("tableBody");
            var dataTable = document.getElementById("dataTable");
            var rows = dataTable.getElementsByTagName("tr");

            for (var i = 1; i < rows.length; i++) {
                if (i <= maxRows) {
                    rows[i].style.display = "";
                } else {
                    rows[i].style.display = "none";
                }
            }
        }

        // Add an event listener to the maxRows dropdown
        document.getElementById("maxRows").addEventListener("change", updateRowsPerPage);

        // Initial call to set the initial number of displayed rows
        updateRowsPerPage();
    </script>

    <!-- PAGINATION -->
    <script>
        var Pagination = {

            code: '',

            // --------------------
            // Utility
            // --------------------

            // converting initialize data
            Extend: function(data) {
                data = data || {};
                Pagination.size = data.size || 3000;
                Pagination.page = data.page || 5;
                Pagination.step = data.step || 5;
            },

            // add pages by number (from [s] to [f])
            Add: function(s, f) {
                for (var i = s; i < f; i++) {
                    Pagination.code += '<a id="pag_a">' + i + '</a>';
                }
            },

            // add last page with separator
            Last: function() {
                Pagination.code += '<i id="pag_i">...</i> <a id="pag_a">' + Pagination.size + '</a>';

            },

            // add first page with separator
            First: function() {
                Pagination.code += '<a id="pag_a">1</a> <i id="pag_i">...</i>';

            },



            // --------------------
            // Handlers
            // --------------------

            // change page
            Click: function() {
                Pagination.page = +this.innerHTML;
                Pagination.Start();
            },

            // previous page
            Prev: function() {
                Pagination.page--;
                if (Pagination.page < 1) {
                    Pagination.page = 1;
                }
                Pagination.Start();
            },

            // next page
            Next: function() {
                Pagination.page++;
                if (Pagination.page > Pagination.size) {
                    Pagination.page = Pagination.size;
                }
                Pagination.Start();
            },



            // --------------------
            // Script
            // --------------------

            // binding pages
            Bind: function() {
                var a = Pagination.e.getElementsByTagName('a');
                for (var i = 0; i < a.length; i++) {
                    if (+a[i].innerHTML === Pagination.page) a[i].className = 'current';
                    a[i].addEventListener('click', Pagination.Click, false);
                }

                // Retrieve the maxRows value
                var maxRows = parseInt(document.getElementById("maxRows").value);

                // Add this block to handle table pagination
                var table = document.getElementById('dataTable');
                var tbody = table.getElementsByTagName('tbody')[0];
                var rows = tbody.getElementsByTagName('tr');
                for (var i = 0; i < rows.length; i++) {
                    rows[i].style.display = 'none';
                }
                var start = (Pagination.page - 1) * maxRows;
                var end = start + maxRows;
                for (var i = start; i < end && i < rows.length; i++) {
                    rows[i].style.display = '';
                }
            },

            // write pagination
            Finish: function() {
                Pagination.e.innerHTML = Pagination.code;
                Pagination.code = '';
                Pagination.Bind();
            },

            // find pagination type
            Start: function() {
                var table = document.getElementById('dataTable');
                var rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

                // Retrieve the maxRows value
                var maxRows = parseInt(document.getElementById("maxRows").value);

                Pagination.size = Math.ceil(rows.length / maxRows);

                // Reset the code
                Pagination.code = '';

                if (Pagination.size < Pagination.step * 2 + 6) {
                    Pagination.Add(1, Pagination.size + 1);
                } else if (Pagination.page < Pagination.step * 2 + 1) {
                    Pagination.Add(1, Pagination.step * 2 + 4);
                    Pagination.Last();
                } else if (Pagination.page > Pagination.size - Pagination.step * 2) {
                    Pagination.First();
                    Pagination.Add(Pagination.size - Pagination.step * 2 - 2, Pagination.size + 1);
                } else {
                    Pagination.First();
                    Pagination.Add(Pagination.page - Pagination.step, Pagination.page + Pagination.step + 1);
                    Pagination.Last();
                }
                Pagination.Finish();
                Pagination.Bind();
            },



            // --------------------
            // Initialization
            // --------------------

            // binding buttons
            Buttons: function(e) {
                var nav = e.getElementsByTagName('a');
                nav[0].addEventListener('click', Pagination.Prev, false);
                nav[1].addEventListener('click', Pagination.Next, false);
            },

            // create skeleton
            Create: function(e) {

                var html = [
                    '<a id="pag_a">◄</a>', // previous button
                    '<span></span>', // pagination container
                    '<a id="pag_a">►</a>' // next button
                ];

                e.innerHTML = html.join('');
                Pagination.e = e.getElementsByTagName('span')[0];
                Pagination.Buttons(e);
            },

            // init
            Init: function(e, data) {
                Pagination.Extend(data);
                Pagination.Create(e);
                Pagination.Start();
            }
        };



        /* * * * * * * * * * * * * * * * *
         * Initialization
         * * * * * * * * * * * * * * * * */

        var init = function() {
            // Initialize with data from the table
            Pagination.Init(document.getElementById('pagination'), {
                page: 1, // selected page
                step: '' // pages before and after current
            });
        };

        document.addEventListener('DOMContentLoaded', init, false);
    </script>

    <!-- SHOWS HOW MANY ENTRIES IN THE TABLE -->
    <script>
        // Add this code to update the entry count:

        function updateEntryCount() {
            var rowCount = $("#dataTable tbody tr").length;
            $("#rowCount").text(rowCount);
        }

        // Call the function to update the entry count after the page loads
        $(document).ready(function() {
            updateEntryCount();
        });
    </script>


</body>
@endsection

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>