<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>SKILL MANAGEMENT ENTRY</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <!-- FOR STAR RATING -->
    <link rel="stylesheet" href="http://netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">

    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }

        .sticky-header {
            position: sticky;
            top: 0;
            z-index: 1;
            text-align: center;
        }
    </style>



</head>

<body>
    @section('tittle') {{"COMPONENT MASTER ENTRY"}}@endsection

    <div id="layout-wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="card">
                                <form id="validate" method="POST" action="Comp_Master1" enctype="multipart/form-data">
                                    @csrf
                                    <div class="card-body">
                                        <div class="row justify-content-center">
                                            <div class="col-lg-11">
                                                <!-- TICKER NUMBER -->
                                                <div class="mb-4">
                                                    <label class="form-label">TICKER NUMBER<span class="text-danger">*</span></label>
                                                    <select class="form-control select2" name="Ticket_No" onchange="Description_Show(this.value)" required>
                                                        <option value="">--Select Ticket Number--</option>
                                                        @foreach($Tno as $Tn)
                                                        <option value="{{$Tn['Ticket_No']}}">{{$Tn['Ticket_No']}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <!-- MODULE -->
                                                <div class="mb-4">
                                                    <label class="form-label">MODULE<span class="text-danger">*</span></label>
                                                    <select class="form-control select2" name="Module" required>
                                                        <option value="">--Select Module--</option>
                                                        @foreach($Module as $Mod)
                                                        <option value="{{$Mod['Module_id']}}">{{$Mod['Components']}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <!-- DESCRIPTION -->
                                                <div class="mb-4">
                                                    <label class="form-label">DESCRIPTION<span class="text-danger">*</span></label>
                                                    <textarea name="" class="form-control" id="description" cols="56" rows="3" required></textarea>
                                                </div>
                                                <!-- COMPONENT NAME -->
                                                <div class="mb-4">
                                                    <label class="form-label">COMPONENT NAME<span class="text-danger">*</span></label>
                                                    <input type="text" name="Component_Name" class="form-control" placeholder="Component Name" oninput="convertToUppercase(this)" required />
                                                </div>
                                            </div>
                                            <div class="d-flex justify-content-around">
                                                <button type="submit" id="saveButton" class="btn btn-primary" name="submit">SAVE</button>
                                                <button type="button" id="clearButton" class="btn btn-warning" onclick="window.location.reload()">CLEAR</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

    <!-- SEARCH -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <!-- GET DESCRIPTION -->
    <script>
        function Description_Show(Ticket_No) {
            var selected_Ticket = Ticket_No;

            $.ajax({
                url: "{{ route('Description') }}",
                type: "GET",
                data: {
                    selected_Ticket: selected_Ticket,
                },
                dataType: 'json',
                success: function(api_decode) {
                    console.log(api_decode);
                    if (api_decode.length > 0) {
                        var Description = api_decode[0].Description;
                        $('#description').val(Description);
                    }
                }
            });
        }
    </script>

    <!-- RELOAD PAGE -->
    <script>
        function clearPage() {
            window.location.reload();
        }
    </script>

    <!-- COMPONENT TO UPPER -->
    <script>
        function convertToUppercase(input) {
            input.value = input.value.toUpperCase();
        }
    </script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($message = Session::get('alert'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>