<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>DESIGNER TICKETENTRY</title>
    <link rel="icon" href="gplogofinal.png" type="png">



    <!-- Add Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- for icon -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css" rel="stylesheet">

    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <link rel="stylesheet" href="{{ asset('frontend/css/design_ticket.css')}}">

    <style>
        .card-body {
            max-height: 150vh !important;
        }

        body,
        .card,
        .navbar.navbar-header.navbar-expand-lg.bg-info {
            /* background:yellow; */
            /* background-image:url(Wooden-background.jpg); */
            background-position: fixed;
            background-size: cover;
            background-repeat: no-repeat;
        }

        .navbar.bg-info {
            /* background-image:url(Wooden-background.jpg) !important; */

            background-position: fixed !important;
            background-size: cover !important;
            background-repeat: no-repeat !important;
        }

        table {
            display: none;
            max-height: 300px;
            overflow: scroll;
            word-wrap: normal;
        }

        td,
        th {
            white-space: nowrap;
            /* Prevent text from wrapping within cells */
        }

        tr,
        td,
        tbody,
        tfoot {
            display: block;
        }


        tr {
            padding-bottom: 10px;
        }

        td {
            padding: 10px 10px 0px;
        }

        td:before {
            content: attr(data-title);
            color: #7a91aa;
            text-transform: uppercase;
            font-size: 1.4rem;
            padding-right: 10px;
            display: block;
            overflow: scroll;
        }



        th {
            text-align: left;
            font-weight: 700;
            cursor: pointer;
        }


        thead th {
            background-color: #236db7;
            color: #fff;
            border: 1px solid #202932;
            position: sticky;

        }



        @media (max-width: 540px) {
            td {
                text-align: left;
            }

            table thead {
                display: none;
            }

            table tbody tr td {

                margin: 10px !important;
            }

            table thead tr th {

                margin-top: 10px !important;
            }

            td:before {
                display: table;
                text-align: right;
                width: 140px;
            }


            table {
                display: table;


            }

            .selectBtn a {
                padding: 5px !important;
                /* margin-left:10%; */
                margin-bottom: 10px;
            }

            .exportDiv {

                margin-left: -600% !important;
                margin-right: 100% !important;
            }

            #pagination {
                margin-left: -55% !important;
                /* margin-top: 30% !important; */
            }

        }

        @media (min-width: 550px) {

            table {
                display: table;

            }

            tr {
                display: table-row;
            }

            td,
            th {
                display: table-cell;

            }

            tbody {
                display: table-row-group;

            }

            thead {
                display: table-header-group;

            }

            tfoot {
                display: table-footer-group;
            }

            td {
                border: 1px solid #28333f;
            }

            td:before {
                display: none;
            }

            td,
            th {
                padding: 10px;
            }


            tfoot th {
                display: table-cell;
            }

            .select {
                padding: 10px;
            }

            .exportDiv {

                margin-left: -190% !important;
            }



        }

        [role="region"][aria-labelledby][tabindex] {
            width: 100%;
            max-height: 60vh;
            overflow: auto;
        }

        [role="region"][aria-labelledby][tabindex]:focus {
            box-shadow: 0 0 0.5em rgba(0, 0, 0, 0.5);
            outline: 0;
        }

        .table thead {
            background-color: #236db7;
            color: #fff;
            position: sticky;
            top: 0;
            z-index: 2;
        }

        .table th {
            text-align: left;
            font-weight: 700;
            padding: 10px;
            position: -webkit-sticky;
            position: sticky;
            top: 0;
            background-color: #236db7;
            color: #fff;
        }



        #itTable {
            border-radius: 50% !important;

        }

        #hwTable {
            border-radius: 50% !important;

        }



        table tbody td:first-child,
        table tbody td:nth-child(2) {
            position: sticky;
            left: 0;
            background: #236db7;
            color: white;
            border-bottom: 1px solid #fff !important;
            z-index: 1;

        }



        table thead th:first-child,
        table thead th:nth-child(2) {
            position: sticky;
            left: 0;
            z-index: 1;
            border-bottom: 1px solid #fff !important;
        }


        .new_table thead th,
        .new_table tbody td {
            text-align: left;

        }

        /* Assuming snoD is a class inside a container with the class "container" */

        .snoDD {
            width: 400px;
            display: flex;
            flex-wrap: wrap;
            overflow: auto;
            white-space: normal;
        }

        .clickBtn:hover {
            background: #fff;
            color: #000;
        }

        .navbar {
            background: #13265C;
        }

        .nav-link:hover {
            color: #9ffb00 !important;
        }

        .dropdown-menu.left {
            left: auto;
            right: 0;
        }

        .active {

            border-radius: 10px;
            color: #fff;
            font-weight: 500;
            border: 2px solid white;

        }

        .submit:hover {

            background: #261880;
        }

        .report:hover {
            background: #b7245c;
        }
    </style>


    <style>
        .input-fields {
            height: 40px !important;
        }
    </style>


    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>


</head>

<body id="body" class="">

    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
        </p>
    </div>
    <div id="wrapper" class="">

        @extends('LifeAtGainup.Navbar.Other_Nav')

        @section('content')

        <div class="containers" style="height: 90vh;">
            <div class="form-container">
                <div class="signin-signup">

                    <!--================================= DESIGNER TICKET ENTRY START ============================================-->
                    <form action="Designer_TicketSave" method="POST" enctype="multipart/form-data" class="sign-in-form" onsubmit="return validateFileName()">
                        @csrf
                        <div class="input-field">
                            <?php $empl_name = Session('emp_name'); ?>
                            <input type="text" placeholder="username" class="text-black-50" value="{{$empl_name}}" name="reportedby" id="" readonly style="display:none;">
                        </div>
                        <div class="input-field">
                            <label for="">Division Name <span class="text-danger">*</span> </label>
                            <select name="division" id="division" class="form-select" required>
                                <option value="" class="dropdown-item">--select--</option>
                                @foreach ($division_name_hw as $key => $division_name_hw_dtls)
                                @php
                                $division_hw_id = $division_id_hw[$key];
                                @endphp
                                <option class="dropdown-item" value="{{$division_hw_id}}">{{$division_name_hw_dtls}}</option>
                                @endforeach
                            </select>
                            <input type="hidden" name="Division_name" id="selectedDivision" value="">
                        </div>

                        <div class="input-field">
                            <label for="">Type of Works <span class="text-danger">*</span> </label>
                            <select name="Type_works" id="Type_works" class="form-select" required>
                                <option value="" class="dropdown-item">--select--</option>
                                @foreach ($Typeof_works as $Typ)
                                <option value="{{$Typ['Rowid']}}">{{$Typ['Typeof_Works']}}</option>
                                @endforeach
                            </select>
                            <input type="hidden" name="typeofworks" id="selectedtypeofworks" value="">
                        </div>
                        <div class="input-field">
                            <label for="">No of Designs <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control" name="no_Design" id="no_Design" required>
                        </div>
                        <div class="input-fields">
                            <label for=""> Description <span class="text-danger">*</span> </label>
                            <textarea name="issueDescription" id="issueDes" cols="30" rows="10" class="form-control" required></textarea>
                        </div>
                        <div class="input-field">
                            <label for="">Severity of Issue <span class="text-danger">*</span> </label>
                            <select name="severity" id="severityHW" class="form-select" required>
                                <option value="" class="dropdown-item">--select--</option>
                                @foreach ($severity_name_hw as $key => $severity_hw_dtls)
                                @php
                                $severity_hw_ids = $severity_id_hw[$key];
                                @endphp
                                <option class="dropdown-item" value="{{$severity_hw_ids}}">{{$severity_hw_dtls}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="input-field mb-3">
                            <label for="">Attachment </label>
                            <input type="file" name="files" multiple id="fileInput2" class="">
                            <div id="selectedFilesContainer2" class="d-flex selectedFilesContainer" style="margin-left:100%; height:250%; width:200%; ">
                                <!-- Your content goes here -->
                            </div>
                        </div>
                        <div class="mt-3">
                            <input type="submit" value="Submit" class="btn btn-primary  mr-4 pl-4 pr-4 submit">
                            <a href="DesignTicketReport">
                                <!-- <button type="button" class="btn btn-primary ml-4 pl-4 pr-4 report" data-toggle="modal" data-target="#hardwareModalCenter">Report</button> -->
                                <button type="button" class="btn btn-primary ml-4 pl-3 pr-3">Report</button>
                            </a>
                        </div>
                    </form>
                    <!--================================= DESIGNER TICKET ENTRY END ============================================-->

                </div>
            </div>

            <!-- OTHER ISSUES -->
            <div class="panels-container">
                <div class="panel left-panel" style="margin-bottom: 100px;">
                    <div class="content" style="margin-right: 50%;">
                        <h3 class="ml-5">Designer Ticket Form</h3>
                        <!-- <p>You are now     in IT Ticket Form .If you want to move Hardware Ticket  </p> -->
                        <!-- <button class="btns transparent clickBtn" id="hardwareBtn">Click To Hardware Ticket</button> -->

                        @if ( $T_No = Session::get('T_No'))
                        <div class="alert alert-success mt-3 alert-dismissible fade show" role="alert">
                            Tno: {{$T_No}} ,Has Been Raised Successfully.
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <div id="error-message" style="color: red;"></div>
                        </div>
                        @endif

                        @if ( $errormsg = Session::get('error'))
                        <div class="alert alert-success mt-3 alert-dismissible fade show" style="color: red;" role="alert">
                            {{$errormsg}}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <div id="error-message" style="color: red;"></div>
                        </div>
                        @endif

                        <!-- @if ($message = Session::get('error'))
                        <div class="alert alert-success mt-3 alert-dismissible fade show" role="alert">
                            {{$message}}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">

                                <span aria-hidden="true">&times;</span>
                                <div id="error-message" style="color: red;"></div>
                            </button>
                        </div>
                        @endif -->
                    </div>
                    <img src="it.svg" alt="" class="image">
                </div>

            </div>

        </div>


        <script>
            // Update hidden input for Division Name
            document.getElementById('division').addEventListener('change', function() {
                const selectedOptionText = this.options[this.selectedIndex].text;
                document.getElementById('selectedDivision').value = selectedOptionText;
            });

            // Update hidden input for Type of Works
            document.getElementById('Type_works').addEventListener('change', function() {
                const selectedOptionText = this.options[this.selectedIndex].text;
                document.getElementById('selectedtypeofworks').value = selectedOptionText;
            });
        </script>

        <!-- RESIZE -->
        <script>
            window.addEventListener('resize', () => {
                const screenWidth = window.innerWidth;
                const inputFields = document.querySelectorAll('.input-field input');

                if (screenWidth < 870) {
                    inputFields.forEach(input => {
                        input.style.pointerEvents = 'auto';
                    });
                } else {
                    inputFields.forEach(input => {
                        input.style.pointerEvents = 'none';
                    });
                }
            });
        </script>


        <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
        @endsection

</body>

</html>