<!DOCTYPE html>
<html lang="en">

<!-- Mirrored from demo.themekita.com/atlantis/livepreview/examples/demo1/index.html by HTTrack Website Copier/3.x [XR&CO'2014], Sat, 26 Feb 2022 04:58:25 GMT -->

<head>
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <title>Ticket Allocation</title>
  <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
  <meta name="csrf-token" content="{{ csrf_token() }}">

  <link rel="icon" href="gplogofinal.png" type="png">


  <!-- Fonts and icons -->
  <script src="{{ asset('frontend/js/plugin/webfont/webfont.min.js')}}"></script>

  <!--<script src="assets/js/plugin/webfont/webfont.min.js"></script>-->
  <script>
    WebFont.load({
      google: {
        "families": ["Lato:300,400,700,900"]
      },
      //custom: {"families":["Flaticon", "Font Awesome 5 Solid", "Font Awesome 5 Regular", "Font Awesome 5 Brands", "simple-line-icons"], urls: ['assets/css/fonts.min.css']},
      active: function() {
        sessionStorage.fonts = true;
      }
    });
  </script>
  <style>
    * {
      font-family: math;
    }

    .save-btn {
      background: radial-gradient(100% 100% at 100% 0, #5adaff 0, #4a8da7 100%);
      color: #fff;
    }

    .add-btn {
      background: radial-gradient(100% 100% at 100% 0, #5adaff 0, #4a8da7 100%);
      color: #fff;
    }

    .delete-btn {
      background: radial-gradient(100% 100% at 100% 0, #5adaff 0, #4a8da7 100%);
      color: #fff;
    }

    .pal-5 {
      padding-left: 60px !important;
    }

    th {
      white-space: nowrap;
    }

    td {
      white-space: nowrap;
    }

    .table-container {

      overflow-y: scroll;
      /* Enable vertical scrolling */
    }

    .sticky-header {

      position: sticky;
      top: 0;
      z-index: 1;
      background-color: #fff;
    }


    .navbar {
      background: #13265C;
    }

    .nav-link:hover {
      color: #9ffb00 !important;
    }

    .dropdown-menu.left {
      left: auto;
      right: 0;
    }

    .active {

      border-radius: 10px;
      color: #fff;
      font-weight: 500;
      border: 2px solid white;

    }
  </style>

  <!-- Custom fonts for this template-->
  <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/startbootstrap-sb-admin-2/4.1.4/js/sb-admin-2.min.js"></script> -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.5.0/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.4.1/jquery.easing.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
  <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">

  <!-- script for spinner -->

  <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
  <script src="{{ asset('frontend/js/spinner.js')}}"></script>

  <!-- script for spinner end -->
  @if(\Route::currentRouteName() == 'TicketAllocationReport' )
  <script>
    $('.button, .closebtn').on('click', function(e) {
      e.preventDefault();
      $('.detail, html, body').toggleClass('open');
    });
  </script>
  @endif
  <link rel="stylesheet" href="{{ asset('frontend/css/fonts.min.css')}}">

  <!-- CSS Files -->
  <!-- Add Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- for icon -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css" rel="stylesheet">
  <link rel="stylesheet" href="{{ asset('frontend/css/ticketAllocation.css')}}">


  <!-- ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| **STYLE** ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| -->


  <!-- STYLE FOR TABLE -->
  <style>
    .table__header {
      width: 100%;
      height: 50px;
      display: flex;
      align-items: center;
      padding: .8rem 1rem;
      background-color: #0C5C9B;
      justify-content: space-between;
    }

    .search_bar {
      width: 100%;
      height: 40px;
      background-color: #d5d1defe;
      padding: .8rem 1rem;
      display: flex;
      justify-content: flex-end;
      align-items: center;
    }

    .entries {
      width: 100%;
      height: 10%;
      padding: .8rem 1rem;
      display: flex;
      justify-content: flex-start;
      align-items: center;
      /* background: green; */

    }

    ::placeholder {
      color: black;
    }

    #searchCount {
      color: black;
      font-weight: bold;
    }

    #entryCount {
      color: black;
      font-weight: bold;
    }

    .search_bar .input-group {
      width: 35%;
      height: 200%;
      background-color: #fff5;
      padding: 0 .8rem;
      border-radius: 2rem;
      display: flex;
      justify-content: center;
      align-items: center;
      transition: .2s;
    }


    .search_bar .input-group input {
      width: 100%;
      padding: 0 .5rem 0 .3rem;
      background-color: transparent;
      border: none;
      outline: none;
    }

    .input-group input {
      color: black;
      font-weight: bold;
    }

    @media (max-width: 1000px) {
      td:not(:first-of-type) {
        min-width: 12.1rem;
      }
    }

    thead th span.icon-arrow {
      display: inline-block;
      /* width: 1.3rem; */
      height: 1.3rem;
      border-radius: 50%;
      border: 1.4px solid transparent;

      text-align: center;
      font-size: 1rem;

      margin-left: .5rem;
      transition: .2s ease-in-out;
    }

    thead th:hover span.icon-arrow {
      border: 1.4px solid #6c00bd;
    }

    thead th:hover {
      color: #6c00bd;
    }

    thead th.active span.icon-arrow {
      background-color: #6c00bd;
      color: #fff;
    }

    thead th.asc span.icon-arrow {
      transform: rotate(180deg);
    }

    thead th.active,
    tbody td.active {
      color: #6c00bd;
    }

    .navbar {
      /* z-index: 1000; */
    }

    .entries select {
      border: none;
      border-radius: 10px;
      padding: 3px 3px;
      background-color: #E3E1E9;
      cursor: pointer;
      font-weight: bold;
    }
  </style>

  <!-- STYLE FOR EXPORT -->
  <style>
    .export__file {
      position: relative;
      margin-left: auto;
    }

    .export__file .export__file-btn {
      display: inline-block;
      width: 2rem;
      height: 2rem;
      background: #fff6 url("{{ asset('frontend/img/Report page/export.png') }}") center / 80% no-repeat;
      border-radius: 50%;
      transition: .2s ease-in-out;
    }

    .export__file .export__file-btn:hover {
      background-color: #fff;
      transform: scale(1.15);
      cursor: pointer;
    }

    .export__file input {
      display: none;
    }

    .export__file .export__file-options {
      position: absolute;
      right: 0;
      width: 12rem;
      border-radius: .5rem;
      overflow: hidden;
      text-align: center;
      opacity: 0;
      transform: scale(.8);
      transform-origin: top right;
      box-shadow: 0 .2rem .5rem #0004;
      transition: .2s;
    }

    .export__file input:checked+.export__file-options {
      opacity: 1;
      transform: scale(1);
      z-index: 100;
    }

    .export__file .export__file-options label {
      display: block;
      width: 100%;
      padding: .6rem 0;
      background-color: #f2f2f2;
      display: flex;
      justify-content: space-around;
      align-items: center;
      transition: .2s ease-in-out;
    }

    .export__file .export__file-options label:first-of-type {
      background-color: #86e49d !important;
    }

    .export__file .export__file-options label:hover {
      transform: scale(1.05);
      background-color: #fff;
      cursor: pointer;
    }

    .export__file .export__file-options img {
      width: 2rem;
      height: auto;
    }

    .form-control option {
      font-weight: bold;
    }
  </style>

  <!-- STYLE FOR PAGINATION -->
  <style>
    .pagination {
      justify-content: space-between;
      margin-left: 10px;
    }

    #pagination {

      margin-right: 15px;
      display: inline-block;
      vertical-align: middle;
      border-radius: 4px;
      padding: 1px 2px 4px 2px;
      border-top: 1px solid #AEAEAE;
      border-bottom: 1px solid #FFFFFF;
      background-color: #DADADA;
      background-image: -webkit-linear-gradient(top, #DBDBDB, #E2E2E2);
      background-image: -moz-linear-gradient(top, #DBDBDB, #E2E2E2);
      background-image: -ms-linear-gradient(top, #DBDBDB, #E2E2E2);
      background-image: -o-linear-gradient(top, #DBDBDB, #E2E2E2);
      background-image: linear-gradient(top, #DBDBDB, #E2E2E2);
    }

    #pagination #pag_a,
    #pagination #pag_i {
      display: inline-block;
      vertical-align: middle;
      width: 22px;
      color: #7D7D7D;
      text-align: center;
      font-size: 10px;
      padding: 3px 0 2px 0;
      -webkit-user-select: none;
      -moz-user-select: none;
      -ms-user-select: none;
      -o-user-select: none;
      user-select: none;
    }

    #pagination #pag_a {
      margin: 0 2px 0 2px;
      border-radius: 4px;
      border: 1px solid #E3E3E3;
      cursor: pointer;
      box-shadow: inset 0 1px 0 0 #FFF, 0 1px 2px #666;
      text-shadow: 0 1px 1px #FFF;
      background-color: #E6E6E6;
      background-image: -webkit-linear-gradient(top, #F3F3F3, #D7D7D7);
      background-image: -moz-linear-gradient(top, #F3F3F3, #D7D7D7);
      background-image: -ms-linear-gradient(top, #F3F3F3, #D7D7D7);
      background-image: -o-linear-gradient(top, #F3F3F3, #D7D7D7);
      background-image: linear-gradient(top, #F3F3F3, #D7D7D7);
    }

    #pagination #pag_i {
      margin: 0 3px 0 3px;
    }

    #pagination #pag_a.current {
      border: 1px solid #E9E9E9;
      box-shadow: 0 1px 1px #999;
      background-color: #DFDFDF;
      background-image: -webkit-linear-gradient(top, #D0D0D0, #EBEBEB);
      background-image: -moz-linear-gradient(top, #D0D0D0, #EBEBEB);
      background-image: -ms-linear-gradient(top, #D0D0D0, #EBEBEB);
      background-image: -o-linear-gradient(top, #D0D0D0, #EBEBEB);
      background-image: linear-gradient(top, #D0D0D0, #EBEBEB);
    }

    #searchtable::-webkit-search-clear-button,
    #searchtable::-webkit-search-decoration,
    #searchtable::-webkit-search-cancel-button,
    #searchtable::-webkit-search-results-button {
      display: none;
    }
  </style>


  <!-- ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||  **END STYLE** ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| -->

</head>

<body id="body">

  <!-- spinner -->


  <div id="container" class="spin_container">
    <div id="spinner_divider" class="" aria-hidden="true"></div>
    <p id="load_text" class="" aria-label="Loading" style="display: none;">
      <span class="" id="l_1" aria-hidden="true">G</span>
      <span class="" id="l_2" aria-hidden="true">a</span>
      <span class="" id="l_3" aria-hidden="true">i</span>
      <span class="" id="l_4" aria-hidden="true">n</span>
      <span class="" id="l_5" aria-hidden="true">u</span>
      <span class="" id="l_6" aria-hidden="true">p</span>
      <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
    </p>
  </div>
  <div id="wrapper" class="">

    <!-- spinner end -->


    @extends('LifeAtGainup.Navbar.Other_Nav')

    @section('content')
    <div class="container-fulid p-1">
      <div class="row">
        <!--############################### EXPORT OPTION ###############################-->
        <section class="table__header">
          <div class="export__file">
            <label for="export-file" class="export__file-btn" title="Export File" onclick="toggleZIndex()"></label>
            <input type="checkbox" id="export-file">
            <div class="export__file-options">
              <label>Export As &nbsp; &#10140;</label>
              <label for="export-file" id="exportbtn">EXCEL <img src="{{ asset('frontend/img/Report page/excel.png') }}" alt="EXCEL"></label>
              <label for="export-file" onclick="printtable.printTable()">PRINT <img src="{{ asset('frontend/img/Report page/print.png') }}" alt="PRINT"></label>
            </div>
          </div>
        </section>

        <!--############################### SEARCH BAR & SHOW ENTRIES ###############################-->
        <div class="search_bar">
          <div class="entries">
            <select name="state" id="maxRows">
              <option value="10">10</option>
              <option value="50">50</option>
              <option value="70">70</option>
              <option value="100" selected>100</option>
              <option value="5000">Show ALL Rows</option>
            </select>
          </div>
          <div class="input-group">
            <input type="search" placeholder="Search Data..." id="searchtable" autocomplete="off">
          </div>
        </div>
      </div>



      @if ( $ticketids = Session::get('tno'))
      <div class="alert alert-success mt-3 w-50   alert-dismissible fade show" role="alert" style=z-index:2;>
        Tno: {{$ticketids}} ,Has Been Allocated Successfully.
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      @endif

      @if ( $ticketidsE = Session::get('tnoError'))
      <div class="alert alert-error mt-3 w-50 alert-dismissible fade show" role="alert" style=z-index:2;>
        Tno: {{$ticketidsE}} ,Does not Allocated .
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      @endif

      @if ( $fcChangeE = Session::get('FCChangeTnoError'))
      <div class="alert alert-success mt-3  w-50 alert-dismissible fade show" role="alert" style=z-index:2;>
        Tno: {{$fcChangeE}} ,FC not Allocated .
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      @endif

      @if ( $fcChange = Session::get('FCChangeTno'))
      <div class="alert alert-success mt-3 w-50 alert-dismissible fade show" role="alert">
        Tno: {{$fcChange}} ,FC Allocated Successfully.
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      @endif
    </div>

    <div class="row">
      <div role="region" aria-labelledby="caption" tabindex="0">
        <table class="table fctable table-striped table-hover table-bordered" id="fctable">
          <thead>
            <tr>
              <th onclick="sortTable(0)" class="sno">
                SNO
              </th>
              <th onclick="sortTable(1)" class="sno">
                TNO

              </th>
              <th onclick="sortTable(2)">
                REQ BY

              </th>
              <th onclick="sortTable(3)">
                REQ DATE/TIME

              </th>
              <th onclick="sortTable(4)">
                MODULE

              </th>
              <th onclick="sortTable(6)">
                APPROVAL

              </th>
              <th onclick="sortTable(5)">
                FC CHANGE

              </th>
              <th onclick="sortTable(6)">
                ISSUE TYPE

              </th>
              <th onclick="sortTable(7)" class="snoD" id="snoD">
                DESCRIPTION

              </th>

            </tr>
          </thead>
          <tbody>
            @if($singleValue != "")
            @foreach($singleValue as $singlevalues)
            <tr>
              <td data-title='SNO'>{{ $singlevalues['SINO'] }}</td>
              <td data-title='TNO'>{{ $singlevalues['Row_id'] }}</td>
              <td data-title='ReportedBy'>
                <abbr data-custom-title="{{ $singlevalues['Issuse_Describ'] }}">{{ $singlevalues['ReportedBy'] }}</abbr>
              </td>
              <td data-title='Reported Date'>{{ $singlevalues['Reported_Date'] }}</td>
              <td data-title='Module'>{{ $singlevalues['Module_Name'] }}</td>
              <td data-title='Allocation' class="selectBtn">

                <a href="" class="selectBtnA" data-user-code="{{$singlevalues['user_code']}}" data-row-id="{{ $singlevalues['Row_id'] }}">
                  <span>Select</span>
                </a>
              </td>

              <!-- FC CHANGE -->
              <td class="selectBtn" data-title='FC CHANGE'>
                <form action="TicketAllocationDevSave" method="post">
                  @csrf
                  <input type="hidden" name="tno" value="{{ $singlevalues['Row_id'] }}" id="hiddenTno">

                  <select name="fcEmplno" id="" class="btn" required>
                    <option value="">--Select--</option>
                    @foreach ($fcname as $fcnames)
                    <option value="{{ $fcnames['id'] }}">{{ $fcnames['Name'] }}</option>
                    @endforeach
                  </select>
                  <button type="submit" class="btn btn-success btn-sm"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check" viewBox="0 0 16 16">
                      <path d="M10.97 4.97a.75.75 0 0 1 1.07 1.05l-3.99 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.267.267 0 0 1 .02-.022z" />
                    </svg></button>
                </form>
              </td>

              <td data-title='Component'>{{ $singlevalues['Components'] }}</td>
              <td data-title='Description' class="snoDD">{{ $singlevalues['Issuse_Describ'] }}</td>

            </tr>
            @endforeach

            @else
            <input type="hidden" name="tno" value="" id="hiddenTno">

            @endif
          </tbody>
        </table>
      </div>
    </div>

    <!-- navbar end -->
    <div class='detail'>
      <div class='detail-container' id="detail-container">

        <form action="TicketAllocationDevSave" method="post" id="survey-form" class="survey" enctype="multipart/form-data">
          @csrf
          <div class="container" style="margin-top:50px !important;">
            <!-- FIRST PAGE -->
            <main class="main">
              <section class="survey__panel survey__panel--current" aria-hidden="false" data-index="1" data-panel="firstPanel" data-requirement="option">

                <div class="row ">
                  <div class="col-md-12 col-xl-6 col-sm-12">
                    <div class="form-group">
                      <label for="tno">Tno</label>
                      <input type="hidden" name="userCode" id="hiddenuserCode">


                      <input type="text" id="tno" name="tno" value="" class="form-control text-color" readonly>
                      <input type="hidden" name="ActualAllocation" value="" id="SbuAllocationHead">
                      <input type="hidden" name="subAllocation" value="" id="subAllocation">
                    </div>
                  </div>
                  <div class="col-md-12 col-xl-6 col-sm-12">
                    <div class="form-group">
                      <label for="reportedby">ReportedBy</label>
                      <input type="text" id="reportedby" name="reportedby" value="" class="form-control text-color" readonly>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-12 col-xl-6 col-sm-12">
                    <div class="form-group">
                      <label for="module">Module</label>
                      <!-- <input type="text" id="module" name="module" value="" class="form-control text-color" readonly> -->
                      <select name="module" id="moduleSelect" class="form-select">
                        <option value="">--Select--</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-12 col-xl-6 col-sm-12">
                    <div class="form-group">
                      <label for="component">Component</label>
                      <input type="hidden" id="component" name="component" value="" class="form-control text-color" readonly>
                      <select name="component" id="componentSelect" class="form-select">
                        <option value="">--Select--</option>
                      </select>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-12 col-xl-6 col-sm-12">
                    <div class="form-group">
                      <label for="reported_date">Reported Date</label>
                      <input type="text" id="reported_date" name="reported_date" value="" class="form-control text-color" readonly>
                    </div>
                  </div>
                  <div class="col-md-12 col-xl-6 col-sm-12">
                    <div class="form-group">
                      <label for="">Attachments</label>
                      <div>
                        <a href="" class="mr-5" id="link1" name="filepath" target="_blank">Link1</a>
                        <!-- <img src="" alt="" srcset="" id="img1"> -->
                        <a href="" class="mr-5" id="link2" name="filepath2" target="_blank">Link2</a>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-12 col-xl-12 col-sm-12">
                    <div class="form-group">
                      <label for="describ">Description</label>
                      <textarea name="userDesrib" id="describ" cols="30" rows="5" class="form-control text-color" readonly></textarea>
                    </div>
                  </div>
                </div>
                <p class="error-message"></p>
              </section>
            </main>

            <!-- SECOND PAGE -->

            <div class="row">
              <div class="row">
                <div class="col-md-12 col-xl-6 col-sm-12">
                  <div class="form-group">
                    <input type="hidden" name="tno" id="hiddenTno1">
                    <label for="allocation">Developer <span class="text-danger">*</span></label>
                    <select name="developer" id="allocation" class="form-control" required>
                      <option value="">--Select--</option>
                      @php
                      $Ticket_Allocation_Rights=Session::get ('Ticket_Allow_rights');
                      @endphp
                      @if ($Ticket_Allocation_Rights !=='Y')
                      <option value="34867">KRISHNA</option>
                      @endif
                    </select>
                  </div>
                </div>
                <div class="col-md-12 col-xl-6 col-sm-12">
                  <div class="form-group">
                    <label for="superVisor">FC Status <span class="text-danger">*</span></label>
                    <select name="fcStatus" id="superVisor" class="form-control" required>
                      <option value="">--Select--</option>
                    </select>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-md-12 col-xl-6 col-sm-12">
                  <div class="form-group">
                    <label for="timeInterval">Time Intervel <span class="text-danger">*</span></label>
                    <select name="timeInterval" id="timeInterval" class="form-control" required>
                      <option value="">--Select--</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-12 col-xl-6 col-sm-12">
                  <div class="form-group">
                    <label for="duration">Duration <span class="text-danger">*</span></label>
                    <input type="text" name="duration" value="1" id="duration" class="form-control" required>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-md-12 col-xl-6 col-sm-12">
                  <div class="form-group">
                    <input type="hidden" name="fcRemarkType" id="remarktypeHidden">
                    <label for="fcRemark">FC Remarks <span class="text-danger">*</span></label>
                    <select name="fcRemark" id="fcRemark" class="form-control" required>
                      <option value="">--Select--</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-12 col-xl-6 col-sm-12">
                  <div class="form-group">
                    <label for="allocation">Tester</label>
                    <!-- <input type="date" name="priority_date" id="priority_date" class="form-control"> -->
                    <select name="tester" id="tester" class="form-control">
                      <option value="">--select--</option>
                    </select>
                  </div>
                </div>
              </div>

              <div class="surya" style="display: none;">
                <div class="row">
                  <div class="col-md-12 col-xl-6 col-sm-12">
                    <div class="form-group">
                      <label for="">Clarity Date</label>
                      <input type="date" name="clarity_date" class="form-control">
                    </div>
                  </div>
                  <div class="col-md-12 col-xl-6 col-sm-12">
                    <div class="form-group">
                      <label for="">Documented Date</label>
                      <input type="date" name="document_date" class="form-control">
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-12 col-xl-6 col-sm-12">
                    <div class="form-group">
                      <label for="">App-IT HOD</label>
                      <input type="date" name="app_it" class="form-control">
                    </div>
                  </div>
                  <div class="col-md-12 col-xl-6 col-sm-12">
                    <div class="form-group">
                      <label for="">App-User HOD</label>
                      <input type="date" name="app_user" class="form-control">
                    </div>
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="col-md-12 col-xl-6 col-sm-12">
                  <div class="form-group">
                    <label for="allocation">Attachments</label>
                    <input type="file" name="files[]" id="attatchment" class="form-control" multiple>
                    <div id="selectedFilesContainer1" class="d-flex selectedFilesContainer " style="width:130%;"></div>
                  </div>
                </div>
                <div class="col-md-12 col-xl-6 col-sm-12">
                  <div class="form-group">
                    <label for="allocation">Remarks</label>
                    <textarea name="fcRemarks" id="" cols="30" rows="2" class="form-control"></textarea>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-md-12 col-xl-6 col-sm-12">
                  <div class="form-group">
                    <label for="pendingHour">Dev pending Hours</label>
                    <input type="text" name="pendingHour" id="pendingHour" class="form-control text-color" required readonly>
                  </div>
                </div>
                <div class="col-md-12 col-xl-6 col-sm-12">
                  <div class="form-group">
                    <label for="expectToStart">Expected To Start</label>
                    <input type="text" name="expectToStart" id="expectToStart" class="form-control text-color" required readonly>
                  </div>
                </div>
              </div>
              <button class="btn button" type="submit" id="submit" aria-hidden="true">Submit</button>
            </div>

          </div>
        </form>
      </div>
      <div class='detail-nav'>
        <button class='closebtn' id="closebtn">
          X
        </button>
        <a href="developerScreen" class="closebtn d-none" id="devBack" style="text-decoration: none;">Go Back</a>
      </div>
    </div>
  </div>

  <!--############################### PAGINATION ###############################-->

  <div class="pagination">
    <div id="entryCount">Total entries: <span id="rowCount"></span></div>
    <div id="searchCount"></div>
    <div id="pagination"></div>
  </div>


  <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ FUNCTION SCRIPTS @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->


  <!-- SEARCH IN TABLE -->
  <script>
    $(document).ready(function() {
      $("#searchtable").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        var matches = $("#fctable tbody tr").filter(function() {
          return $(this).text().toLowerCase().indexOf(value) > -1;
        });

        if (value === "") {
          // If the search bar is empty, clear the search results and count

          $("#searchCount").text("");
          $("#entryCount").show(); // Show the entry count
          $("#fctable tbody tr").toggle(true);
          updateRowsPerPage(); // Call the function to reset displayed rows
        } else {
          $("#entryCount").hide(); // Hide the entry count
          // Show the search count and hide rows that don't match the search criteria
          $("#searchCount").text(matches.length + " result(s) found");
          matches.toggle(true);
          $("#fctable tbody tr").not(matches).toggle(false);
        }
      });
    });
  </script>

  <!-- SHOW ENTRIES TABLE -->
  <script>
    // Function to update the number of displayed rows
    function updateRowsPerPage() {
      var maxRows = parseInt(document.getElementById("maxRows").value);
      var tableBody = document.getElementById("tableBody");
      var fctable = document.getElementById("fctable");
      var rows = fctable.getElementsByTagName("tr");

      for (var i = 1; i < rows.length; i++) {
        if (i <= maxRows) {
          rows[i].style.display = "";
        } else {
          rows[i].style.display = "none";
        }
      }
    }

    // Add an event listener to the maxRows dropdown
    document.getElementById("maxRows").addEventListener("change", updateRowsPerPage);

    // Initial call to set the initial number of displayed rows
    updateRowsPerPage();
  </script>

  <!-- Sorting | Ordering data of HTML table -->
  <script>
    const head_tab = document.querySelectorAll('thead th'); // Replace 'your-header-class' with the actual class name of your table headers
    const row_table = document.querySelectorAll('tbody tr'); // Replace 'your-row-class' with the actual class name of your table rows

    head_tab.forEach((head, i) => {
      let sort_asc = true;
      head.addEventListener('click', () => {
        head_tab.forEach(head => head.classList.remove('active'));
        head.classList.add('active');

        document.querySelectorAll('td').forEach(td => td.classList.remove('active'));
        row_table.forEach(row => {
          row.querySelectorAll('td')[i].classList.add('active');
        })

        head.classList.toggle('asc', sort_asc);
        sort_asc = head.classList.contains('asc') ? false : true;

        sortTable(i, sort_asc);
      });
    });

    function sortTable(column, sort_asc) {
      const tbody = document.querySelector('tbody');
      const rows = Array.from(row_table);

      rows.sort((a, b) => {
        let first_row = parseFloat(a.querySelectorAll('td')[column].textContent.toLowerCase());
        let second_row = parseFloat(b.querySelectorAll('td')[column].textContent.toLowerCase());

        // return sort_asc ? (first_row - second_row) : (second_row - first_row);
        return sort_asc ? (first_row < second_row ? -1 : 1) : (first_row < second_row ? 1 : -1);
      });

      // Clear the existing rows from the table
      while (tbody.firstChild) {
        tbody.removeChild(tbody.firstChild);
      }

      // Append the sorted rows to the table
      rows.forEach(row => {
        tbody.appendChild(row);
      });
    }
  </script>

  <!-- PAGINATION -->
  <script>
    var Pagination = {

      code: '',

      // --------------------
      // Utility
      // --------------------

      // converting initialize data
      Extend: function(data) {
        data = data || {};
        Pagination.size = data.size || 3000;
        Pagination.page = data.page || 5;
        Pagination.step = data.step || 5;
      },

      // add pages by number (from [s] to [f])
      Add: function(s, f) {
        for (var i = s; i < f; i++) {
          Pagination.code += '<a id="pag_a">' + i + '</a>';
        }
      },

      // add last page with separator
      Last: function() {
        Pagination.code += '<i id="pag_i">...</i> <a id="pag_a">' + Pagination.size + '</a>';

      },

      // add first page with separator
      First: function() {
        Pagination.code += '<a id="pag_a">1</a> <i id="pag_i">...</i>';

      },



      // --------------------
      // Handlers
      // --------------------

      // change page
      Click: function() {
        Pagination.page = +this.innerHTML;
        Pagination.Start();
      },

      // previous page
      Prev: function() {
        Pagination.page--;
        if (Pagination.page < 1) {
          Pagination.page = 1;
        }
        Pagination.Start();
      },

      // next page
      Next: function() {
        Pagination.page++;
        if (Pagination.page > Pagination.size) {
          Pagination.page = Pagination.size;
        }
        Pagination.Start();
      },



      // --------------------
      // Script
      // --------------------

      // binding pages
      Bind: function() {
        var a = Pagination.e.getElementsByTagName('a');
        for (var i = 0; i < a.length; i++) {
          if (+a[i].innerHTML === Pagination.page) a[i].className = 'current';
          a[i].addEventListener('click', Pagination.Click, false);
        }

        // Retrieve the maxRows value
        var maxRows = parseInt(document.getElementById("maxRows").value);

        // Add this block to handle table pagination
        var table = document.getElementById('fctable');
        var tbody = table.getElementsByTagName('tbody')[0];
        var rows = tbody.getElementsByTagName('tr');
        for (var i = 0; i < rows.length; i++) {
          rows[i].style.display = 'none';
        }
        var start = (Pagination.page - 1) * maxRows;
        var end = start + maxRows;
        for (var i = start; i < end && i < rows.length; i++) {
          rows[i].style.display = '';
        }
      },

      // write pagination
      Finish: function() {
        Pagination.e.innerHTML = Pagination.code;
        Pagination.code = '';
        Pagination.Bind();
      },

      // find pagination type
      Start: function() {
        var table = document.getElementById('fctable');
        var rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

        // Retrieve the maxRows value
        var maxRows = parseInt(document.getElementById("maxRows").value);

        Pagination.size = Math.ceil(rows.length / maxRows);

        // Reset the code
        Pagination.code = '';

        if (Pagination.size < Pagination.step * 2 + 6) {
          Pagination.Add(1, Pagination.size + 1);
        } else if (Pagination.page < Pagination.step * 2 + 1) {
          Pagination.Add(1, Pagination.step * 2 + 4);
          Pagination.Last();
        } else if (Pagination.page > Pagination.size - Pagination.step * 2) {
          Pagination.First();
          Pagination.Add(Pagination.size - Pagination.step * 2 - 2, Pagination.size + 1);
        } else {
          Pagination.First();
          Pagination.Add(Pagination.page - Pagination.step, Pagination.page + Pagination.step + 1);
          Pagination.Last();
        }
        Pagination.Finish();
        Pagination.Bind();
      },



      // --------------------
      // Initialization
      // --------------------

      // binding buttons
      Buttons: function(e) {
        var nav = e.getElementsByTagName('a');
        nav[0].addEventListener('click', Pagination.Prev, false);
        nav[1].addEventListener('click', Pagination.Next, false);
      },

      // create skeleton
      Create: function(e) {

        var html = [
          '<a id="pag_a">◄</a>', // previous button
          '<span></span>', // pagination container
          '<a id="pag_a">►</a>' // next button
        ];

        e.innerHTML = html.join('');
        Pagination.e = e.getElementsByTagName('span')[0];
        Pagination.Buttons(e);
      },

      // init
      Init: function(e, data) {
        Pagination.Extend(data);
        Pagination.Create(e);
        Pagination.Start();
      }
    };



    /* * * * * * * * * * * * * * * * *
     * Initialization
     * * * * * * * * * * * * * * * * */

    var init = function() {
      // Initialize with data from the table
      Pagination.Init(document.getElementById('pagination'), {
        page: 1, // selected page
        step: '' // pages before and after current
      });
    };

    document.addEventListener('DOMContentLoaded', init, false);
  </script>

  <!-- PRINT -->
  <script>
    let printtable = new function() {
      this.printTable = function() {
        let tab = document.getElementById('fctable');
        let win = window.open('', '', 'height=700,width=700');
        win.document.write(tab.outerHTML);
        win.document.close();
        win.print();
        win.close(); // Add this line to close the window after printing
      }

    }
  </script>

  <!-- SHOWS HOW MANY ENTRIES IN THE TABLE -->
  <script>
    // Add this code to update the entry count:

    function updateEntryCount() {
      var rowCount = $("#fctable tbody tr").length;
      $("#rowCount").text(rowCount);
    }

    // Call the function to update the entry count after the page loads
    $(document).ready(function() {
      updateEntryCount();
    });
  </script>

  <!-- EXPORT -->
  <script>
    function export_table_to_xls(table, filename) {
      var wb = XLSX.utils.table_to_book(table, {
        sheet: "Sheet1"
      });
      XLSX.writeFile(wb, filename);
    }
    document.querySelector("#exportbtn").addEventListener("click", function() {
      var table = document.querySelector("#fctable");
      export_table_to_xls(table, "IT-tickets.xlsx");
    });
  </script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.3/xlsx.full.min.js"></script>


  <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ FUNCTION SCRIPTS @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->





  <!-- EXPECTED TO START -->
  <script>
    let devSelectBtn = document.getElementById("allocation");
    devSelectBtn.addEventListener('click', function(e) {
      e.preventDefault();

      var emplnoDev = devSelectBtn.value;
      // console.log(emplnoDev);
      $.ajax({
        url: 'TicketAllocationDev',
        type: 'POST',
        dataType: 'json',
        data: {
          'emplnoDev': emplnoDev
        },
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(response) {

          // dev pending hour
          // console.log(response);
          document.getElementById("pendingHour").value = response[6][0].id;
          document.getElementById("expectToStart").value = response[6][0].Name;
        }
      });
    });
  </script>

  <!-- DIABLE REQUIRED FIELD IF FC STATUS IS != "ALLOCATE" -->
  <script>
    document.addEventListener("DOMContentLoaded", function() {
      var fcStatusSelect = document.getElementById("superVisor");
      var durationInput = document.getElementById("duration");
      var fcRemarkSelect = document.getElementById("fcRemark");
      var allocation = document.getElementById("allocation");
      var priorityDateInput = document.getElementById("priority_date");
      var timeInterval = document.getElementById("timeInterval");
      var pendingHour = document.getElementById("pendingHour");
      var expectToStart = document.getElementById("expectToStart");

      fcStatusSelect.addEventListener("change", function() {
        var selectedValue = fcStatusSelect.value;

        if (selectedValue === "3" || selectedValue === "4" || selectedValue === "5") {
          durationInput.removeAttribute("required");
          fcRemarkSelect.removeAttribute("required");
          priorityDateInput.removeAttribute("required");
          allocation.removeAttribute("required");
          timeInterval.removeAttribute("required");
          pendingHour.removeAttribute("required");
          expectToStart.removeAttribute("required");
        }
      });
    });
  </script>

  <!-- UPLOAD FILE HANDLE -->
  <script>
    // Get the file input element
    const fileInput = document.getElementById("attatchment");

    // Get the selected files container
    const selectedFilesContainer = document.getElementById("selectedFilesContainer1");

    // Add an event listener to the file input element
    fileInput.addEventListener("change", function() {
      // Limit the selection to two files
      if (fileInput.files.length > 2) {
        alert("You can only select up to two files.");
        clearFileInput();
        return;
      }

      // Clear the selected files container
      selectedFilesContainer.innerHTML = "";

      // Loop through the selected files
      for (let i = 0; i < fileInput.files.length; i++) {
        const file = fileInput.files[i];

        // Create a container for each selected file
        const fileContainer = document.createElement("div");
        fileContainer.classList.add("file-container");

        // Display the file name
        const fileNameElement = document.createElement("span");
        fileNameElement.textContent = file.name;

        // Create a remove button for each file
        const removeButton = document.createElement("button");
        removeButton.textContent = "Remove";
        removeButton.addEventListener("click", function() {
          // Remove the corresponding file from the file input
          removeFile(file);
          // Remove the file container
          fileContainer.remove();
        });

        // Append the file name and remove button to the file container
        fileContainer.appendChild(fileNameElement);
        fileContainer.appendChild(removeButton);

        // Append the file container to the selected files container
        selectedFilesContainer.appendChild(fileContainer);
      }
    });

    function removeFile(file) {
      // Create a new file list without the removed file
      const newFileList = new DataTransfer();
      for (let i = 0; i < fileInput.files.length; i++) {
        if (fileInput.files[i] !== file) {
          newFileList.items.add(fileInput.files[i]);
        }
      }
      // Set the file input's files to the new file list
      fileInput.files = newFileList.files;
    }

    function clearFileInput() {

      fileInput.value = "";
    }
  </script>

  <!-- SHOWING DETAIL FOR FC ALLOCATION -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      var selectButtons = document.querySelectorAll('.selectBtnA');

      selectButtons.forEach(function(button) {
        button.addEventListener('click', function(e) {
          e.preventDefault();

          var selectedRowId = button.getAttribute('data-row-id');

          $.ajax({
            url: 'TicketAllocationDev',
            type: 'POST',
            dataType: 'json',
            data: {
              'row_id': selectedRowId
            },
            headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(datas) {

              var data = datas[0];
              var devChoose = datas[1];
              var supervisor = datas[2];
              var timeInterval = datas[3];
              var tester = datas[4];
              var fcRemark = datas[5];
              var allocationHour = datas[6];
              var moduleNames = datas[8];
              document.getElementById("tno").value = data[0].Row_id;
              document.getElementById("hiddenTno").value = data[0].Row_id;
              document.getElementById("hiddenTno1").value = data[0].Row_id;
              console.log(data[0].Row_id);
              document.getElementById("hiddenuserCode").value = data[0].user_code;
              document.getElementById("reportedby").value = data[0].ReportedBy;

              let selectedModule = data[0].Module_Name;

              const selectModuleElement = document.getElementById("moduleSelect");

              for (let i = 0; i < moduleNames.length; i++) {
                const moduleName = moduleNames[i]["name"];
                const moduleId = moduleNames[i]["id"];
                const option = document.createElement("option");
                option.textContent = moduleName;
                option.value = moduleId;
                // Check if this moduleName matches selectedModule
                if (moduleName === selectedModule) {
                  option.selected = true; // Make this option selected
                }
                selectModuleElement.appendChild(option);
              }


              // ================== component ======================


              let modId = selectModuleElement.value;
              $.ajax({
                url: 'TicketAllocationCompChoose',
                type: 'POST',
                dataType: 'json',
                data: {
                  'modId': modId
                },
                headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {

                  let selectedComponentBtn = document.getElementById("component");
                  let selectedComponentName = selectedComponentBtn.value
                  // dev pending hour


                  const selectModuleElement = document.getElementById("componentSelect");

                  for (let i = 0; i < response.length; i++) {
                    const moduleName = response[i]["name"];
                    const moduleId = response[i]["id"];
                    const option = document.createElement("option");
                    option.textContent = moduleName;
                    option.value = moduleId;
                    // Check if this moduleName matches selectedModule
                    if (moduleName === selectedComponentName) {
                      option.selected = true; // Make this option selected
                    }
                    selectModuleElement.appendChild(option);
                  }
                }
              });

              // =================== componeent end ==============  

              document.getElementById("component").value = data[0].Components;
              document.getElementById("reported_date").value = data[0].Reported_Date;
              document.getElementById("describ").value = data[0].Issuse_Describ;
              // console.log(data[0].Filepath);
              if (data[0].Filepath != "") {

                var img = document.getElementById("link1");
                img.href = data[0].Filepath2;

                var img2 = document.getElementById("link2");
                img2.href = data[0].Filepath;
                // console.log(data[0].Filepath);
              } else {
                var link = document.getElementById("link1");
                link.text = "no Attatchment";
                var link2 = document.getElementById("link2");
                link2.text = "no Attatchment";

              }



              const selectElement = document.getElementById("allocation");

              for (let i = 0; i < devChoose.length; i++) {
                const DevName = devChoose[i]["Name"];
                const id = devChoose[i]["id"];
                const option = document.createElement("option");
                option.textContent = DevName;
                option.value = id;
                selectElement.appendChild(option);

              }

              // ================ allocation End =====================

              const selectedSuperVisor = document.getElementById("superVisor");


              for (let i = 0; i < supervisor.length; i++) {
                const supervisorName = supervisor[i]["Name"];
                const supervisorId = supervisor[i]["id"];
                const option = document.createElement("option");
                option.textContent = supervisorName;
                option.value = supervisorId;
                selectedSuperVisor.appendChild(option);
                selectedSuperVisor.selectedIndex = 2;
              }

              const selectedFcRemark = document.getElementById("fcRemark");

              for (let i = 0; i < fcRemark.length; i++) {
                const fcRemarkName = fcRemark[i]["Name"];
                const fcRemarkId = fcRemark[i]["id"];
                let fcRemarkMode = fcRemark[i]["Mode"];

                const option = document.createElement("option");
                option.textContent = fcRemarkName;
                option.value = fcRemarkId;
                option.setAttribute("data-fc-remark-mode", fcRemarkMode);
                selectedFcRemark.appendChild(option);
              }

              const selectedTimeInterval = document.getElementById("timeInterval");
              for (let i = 0; i < timeInterval.length; i++) {
                const timeIntervalName = timeInterval[i]["Name"];
                const timeIntervalId = timeInterval[i]["id"];
                const option = document.createElement("option");
                option.textContent = timeIntervalName;
                option.value = timeIntervalId;
                selectedTimeInterval.appendChild(option);
                selectedTimeInterval.selectedIndex = 1;
              }

              const selectedTester = document.getElementById("tester");

              for (let i = 0; i < tester.length; i++) {
                const testerName = tester[i]["Name"];
                const testerId = tester[i]["id"];
                const option = document.createElement("option");
                option.textContent = testerName;
                option.value = testerId;
                selectedTester.appendChild(option);

              }
            }
          });
        });
      });
    });


    $('#fcRemark').on('click', function(e) {
      let remarkVal = $('#fcRemark option:selected').data('fcRemarkMode');

      let selectBtn = document.querySelector('#tester');
      let Surya = document.querySelector('.surya');

      document.getElementById("remarktypeHidden").value = remarkVal;

      if (remarkVal === "NRCR" || remarkVal === "TT") {

        selectBtn.style.display = 'block';
        selectBtn.setAttribute('required', 'required');
        Surya.style.display = 'block';


      } else {

        selectBtn.style.display = 'none';
        selectBtn.removeAttribute('required');
        Surya.style.display = 'none';

      }

    });
  </script>

  <!-- SHOWING COMPONENTS BASED ON MODULE -->
  <script>
    let ModChooseBtn = document.getElementById("moduleSelect");
    ModChooseBtn.addEventListener('click', function(e) {
      e.preventDefault();

      var modId = ModChooseBtn.value;
      // console.log(modId);

      $.ajax({
        url: 'TicketAllocationCompChoose',
        type: 'POST',
        dataType: 'json',
        data: {
          'modId': modId
        },
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(response) {

          let selectedComponentBtn = document.getElementById("component");
          let selectedComponentName = selectedComponentBtn.value;

          // dev pending hour

          const selectModuleElement = document.getElementById("componentSelect");

          while (selectModuleElement.options.length > 0) {
            selectModuleElement.remove(0);
          }
          for (let i = 0; i < response.length; i++) {
            const moduleName = response[i]["name"];
            const moduleId = response[i]["id"];
            const option = document.createElement("option");
            option.textContent = moduleName;
            option.value = moduleId;
            // Check if this moduleName matches selectedModule
            if (moduleName === selectedComponentName) {
              option.selected = true; // Make this option selected
            }
            selectModuleElement.appendChild(option);
          }
        }
      });
    });
  </script>

  <!-- SHOWING FC ALLOCATING SCREEN -->
  <script>
    function scrollToDetailContainer() {
      var detailContainer = document.getElementById('detail-container');
      if (detailContainer) {
        detailContainer.scrollIntoView({
          behavior: 'smooth'
        });
      }
    }
  </script>

  @if(\Route::currentRouteName() == 'TicketAllocationReport' )
  <script>
    $('.closebtn').on('click', function(e) {
      // e.preventDefault();
      location.reload();
    });
  </script>
  @endif

  <!-- SUB ALLOCATION  FUNCTIONALITY -->
  <script>
    // Function to toggle class on detail, html, and body elements
    function toggleOpenClass() {
      $('.detail, html, body').toggleClass('open');
      $("#closebtn").addClass('d-none');
      $("#devBack").removeClass('d-none');
    }


    $(document).ready(function() {
      // Get the search parameters from the URL
      var urlParams = new URLSearchParams(window.location.search);

      // Define variables to store parameter values
      var rowid, allocHour, fcRemarks, DeveloperID;

      var rowidParam = urlParams.get('rowid');

      if (rowidParam) {
        var rowidSplit = rowidParam.split('?');
        rowid = rowidSplit[0];
        if (rowidSplit.length > 1) {
          for (var i = 1; i < rowidSplit.length; i++) {
            var keyValue = rowidSplit[i].split('=');
            if (keyValue.length === 2) {
              if (keyValue[0] === 'allocHour') {
                allocHour = keyValue[1];
              } else if (keyValue[0] === 'fcRemarks') {
                fcRemarks = keyValue[1];
              } else if (keyValue[0] === "DeveloperID") {
                DeveloperID = keyValue[1];
                document.getElementById("SbuAllocationHead").value = DeveloperID;
                document.getElementById("subAllocation").value = "subAllocation";

              }
            }
          }
        }
      }

      // Output or further processing



      if (rowid) {


        let timeIntervalArray = allocHour.split(" ");
        // console.log(timeIntervalArray);
        let timeIntervalMins = timeIntervalArray[0];
        let timeIntervalText = timeIntervalArray[1];
        $("#duration").val(timeIntervalMins);
        $.ajax({
          url: 'TicketAllocationDev',
          type: 'POST',
          dataType: 'json',
          data: {
            'row_id': rowid
          },
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          success: function(datas) {

            // console.log(datas);

            var data = datas[0];

            var supervisor = datas[2];
            var timeInterval = datas[3];
            var tester = datas[4];
            var fcRemark = datas[5];
            var allocationHour = datas[6];
            var moduleNames = datas[8];
            var devChoose = datas[9];

            document.getElementById("tno").value = data[0].Row_id;
            document.getElementById("hiddenTno").value = data[0].Row_id;
            document.getElementById("hiddenTno1").value = data[0].Row_id;
            document.getElementById("hiddenuserCode").value = data[0].user_code;
            document.getElementById("reportedby").value = data[0].ReportedBy;

            let selectedModule = data[0].Module_Name;

            const selectModuleElement = document.getElementById("moduleSelect");

            for (let i = 0; i < moduleNames.length; i++) {
              const moduleName = moduleNames[i]["name"];
              const moduleId = moduleNames[i]["id"];
              const option = document.createElement("option");
              option.textContent = moduleName;
              option.value = moduleId;
              // Check if this moduleName matches selectedModule
              if (moduleName === selectedModule) {
                option.selected = true; // Make this option selected
              }
              selectModuleElement.appendChild(option);
            }


            // ================== component ======================


            let modId = selectModuleElement.value;
            $.ajax({
              url: 'TicketAllocationCompChoose',
              type: 'POST',
              dataType: 'json',
              data: {
                'modId': modId
              },
              headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              success: function(response) {

                let selectedComponentBtn = document.getElementById("component");
                let selectedComponentName = selectedComponentBtn.value
                // dev pending hour


                const selectModuleElement = document.getElementById("componentSelect");

                for (let i = 0; i < response.length; i++) {
                  const moduleName = response[i]["name"];
                  const moduleId = response[i]["id"];
                  const option = document.createElement("option");
                  option.textContent = moduleName;
                  option.value = moduleId;
                  // Check if this moduleName matches selectedModule
                  if (moduleName === selectedComponentName) {
                    option.selected = true; // Make this option selected
                  }
                  selectModuleElement.appendChild(option);
                }
              }
            });

            // =================== componeent end ==============  

            document.getElementById("component").value = data[0].Components;
            document.getElementById("reported_date").value = data[0].Reported_Date;
            document.getElementById("describ").value = data[0].Issuse_Describ;
            // console.log(data[0].Filepath);
            if (data[0].Filepath != "") {

              var img = document.getElementById("link1");
              img.href = data[0].Filepath2;

              var img2 = document.getElementById("link2");
              img2.href = data[0].Filepath;
              // console.log(data[0].Filepath);
            } else {
              var link = document.getElementById("link1");
              link.text = "no Attatchment";
              var link2 = document.getElementById("link2");
              link2.text = "no Attatchment";

            }



            const selectElement = document.getElementById("allocation");

            for (let i = 0; i < devChoose.length; i++) {
              const DevName = devChoose[i]["C_Name"];
              const id = devChoose[i]["Emplno"];
              const option = document.createElement("option");
              option.textContent = DevName;
              option.value = id;
              selectElement.appendChild(option);

            }

            // ================ allocation End =====================

            const selectedSuperVisor = document.getElementById("superVisor");


            for (let i = 0; i < supervisor.length; i++) {
              const supervisorName = supervisor[i]["Name"];
              const supervisorId = supervisor[i]["id"];
              const option = document.createElement("option");
              option.textContent = supervisorName;
              option.value = supervisorId;
              selectedSuperVisor.appendChild(option);
              selectedSuperVisor.selectedIndex = 2;
            }

            const selectedFcRemark = document.getElementById("fcRemark");

            for (let i = 0; i < fcRemark.length; i++) {

              const fcRemarkName = fcRemark[i]["Name"];
              const fcRemarkId = fcRemark[i]["id"];
              let fcRemarkMode = fcRemark[i]["Mode"];

              const option = document.createElement("option");
              option.textContent = fcRemarkName;
              option.value = fcRemarkId;
              option.setAttribute("data-fc-remark-mode", fcRemarkMode);
              selectedFcRemark.appendChild(option);

              if (fcRemarks === fcRemarkName) {
                option.selected = true; // Make this option selected
              }
            }

            const selectedTimeInterval = document.getElementById("timeInterval");

            for (let i = 0; i < timeInterval.length; i++) {
              const timeIntervalName = timeInterval[i]["Name"];
              const timeIntervalId = timeInterval[i]["id"];
              const option = document.createElement("option");
              option.textContent = timeIntervalName;
              option.value = timeIntervalId;
              selectedTimeInterval.appendChild(option);

              selectedTimeInterval.selectedIndex = 1;
              if (timeIntervalName == timeIntervalText) {
                option.selected = true;
              }

            }

            const selectedTester = document.getElementById("tester");
            for (let i = 0; i < tester.length; i++) {
              const testerName = tester[i]["Name"];
              const testerId = tester[i]["id"];
              const option = document.createElement("option");
              option.textContent = testerName;
              option.value = testerId;
              selectedTester.appendChild(option);
            }
          }
        });
        toggleOpenClass();
      } else {
        // Click event handler for selectBtnA and closebtn
        $('.selectBtnA, .closebtn').on('click', function(e) {
          e.preventDefault();
          toggleOpenClass();
        });
      }
    });


    function redirectToTicketAllocationReport(rowid) {
      window.location.href = "TicketAllocationReport?rowid=" + rowid;
      toggleOpenClass();
    }
  </script>

  <!-- <script>
    document.addEventListener("DOMContentLoaded", function() {
      const panels = document.querySelectorAll(".survey__panel");
      const progressBar = document.querySelector(".progressbar");
      const prevButton = document.querySelector('button[name="prev"]');
      const nextButton = document.querySelector('button[name="next"]');
      const submitButton = document.querySelector('#submit');
      let selectBtn = document.querySelector('#priority_date');
      let selectLabel = document.querySelector('#priority_date_label');

      let currentPanelIndex = 0;

      function updatePanelVisibility() {
        panels.forEach((panel, index) => {
          panel.style.display = index === currentPanelIndex ? "block" : "none";
          progressBar.children[index].classList.toggle("active", index === currentPanelIndex);
        });

        prevButton.disabled = currentPanelIndex === 0;
        selectBtn.disabled = currentPanelIndex === 0;

        nextButton.disabled = currentPanelIndex === panels.length - 1;
        submitButton.style.display = currentPanelIndex === panels.length - 1 ? "block" : "none";
        selectBtn.style.display = currentPanelIndex === panels.length - 1 ? "block" : "none";
        selectLabel.style.display = currentPanelIndex === panels.length - 1 ? "block" : "none";

      }

      prevButton.addEventListener("click", () => {
        if (currentPanelIndex > 0) {
          currentPanelIndex--;
          updatePanelVisibility();
        }
      });

      nextButton.addEventListener("click", () => {
        if (currentPanelIndex < panels.length - 1) {
          currentPanelIndex++;
          updatePanelVisibility();
        }
      });

      updatePanelVisibility();

    });
  </script> -->

  <!-- DESCRIPTION SHOW WHILE MOUSE HOVER -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      var abbrElements = document.querySelectorAll('abbr[data-custom-title]');

      abbrElements.forEach(function(abbr) {
        abbr.addEventListener('mouseover', function() {
          var tooltip = this.querySelector('::after');
          tooltip.style.opacity = '1';
          tooltip.style.visibility = 'visible';
        });

        abbr.addEventListener('mouseout', function() {
          var tooltip = this.querySelector('::after');
          tooltip.style.opacity = '0';
          tooltip.style.visibility = 'hidden';
        });
      });
    });
  </script>

  <!-- Add Bootstrap JavaScript and jQuery (ensure jQuery is loaded before Bootstrap JS) -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>


  @endsection
</body>

</html>