<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Developer Screen</title>
    <link rel="icon" href="gplogofinal.png" type="png">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">

    <link rel="stylesheet" href="{{ asset('frontend/css/developerScreen.css')}}">
    <!-- for icons (use the correct version of Font Awesome) -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css" rel="stylesheet">
    <!-- Include jQuery (use the same version consistently) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <!-- Include Bootstrap JavaScript (choose one version consistently) -->
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <!-- Include Bootstrap bundle (optional, choose the same version as Bootstrap) -->
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <!-- Include Select2 (choose the correct version) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

    <style>
        * {
            font-size: 12px;
        }
    </style>

</head>

<body>


    @section('userClose')
    <main class="st_viewport">
        <div class="st_wrap_table" data-table_id="0"></div>
        <div class="st_wrap_table " data-table_id="1">
            @extends('LifeAtGainup.Tickets.Ticket_Actions.userClose')
            @extends('LifeAtGainup.Tickets.Ticket_Actions.testingTicket')
            @extends('LifeAtGainup.Tickets.Ticket_Actions.withinDue')
            @extends('LifeAtGainup.Tickets.Ticket_Actions.overDue')
            @extends('LifeAtGainup.Tickets.Ticket_Actions.startingTicket')
            @extends('LifeAtGainup.Navbar.Other_Nav')
        </div>
    </main>

    <!-- ONLY ONE TICKET IS START | CANNOT COMPLETE WITHOUT START -->
    <script>
        $(document).ready(function() {
            // Loop through all select elements with the class 'entry-select'
            $('.entry-select').each(function() {
                // Get the current entry status from the data-entry attribute
                var currentEntryStatus = $(this).data('entry');
                var currentEntryStartid = $(this).data('startid');
                // Enable all options initially
                $(this).find('option').prop('disabled', false);
                if (currentEntryStatus === 'S') {
                    $(this).find('option[value="S"]').prop('disabled', true);
                    $(this).find('option[value="H"]').prop('disabled', false);
                    $(this).find('option[value="C"]').prop('disabled', false);
                } else if ((currentEntryStatus === 'H' && currentEntryStartid == 0) || (currentEntryStatus === "" && currentEntryStartid == 0)) {
                    // If the current status is 'H', disable the 'H' and 'C' options
                    $(this).find('option[value="S"]').prop('disabled', false);
                    $(this).find('option[value="H"]').prop('disabled', true);
                    $(this).find('option[value="C"]').prop('disabled', true);
                } else if (currentEntryStatus != 'S' && currentEntryStartid === 1) {
                    $(this).find('option[value="S"]').prop('disabled', true);
                    $(this).find('option[value="H"]').prop('disabled', true);
                    $(this).find('option[value="C"]').prop('disabled', true);
                }
            });
        });
    </script>


    <!-- STARTED TICKET AT FIRST -->
    <script>
        function manipulateTable(originalTable, newTable, indicate, timeElement, tableIdentifier) {


            for (let i = 1; i < originalTable.rows.length; i++) {
                const cell = originalTable.rows[i].cells[11]; // Use the correct index (0-based) for the 11th column (ENTRY)
                const data = cell.textContent.trim();
                const indicator = document.getElementById('indicator');

                if (data === 'S') {
                    newTable.appendChild(originalTable.rows[i].cloneNode(true));
                    originalTable.deleteRow(i);
                    indicator.innerText = indicate;
                    i--;



                    var remainingTime = localStorage.getItem('remainingTime');
                    // Reset remainingTime in localStorage to 0 when starting the countdown
                    localStorage.setItem('remainingTime', 0);


                    var currentTime2 = new Date();
                    var hours = currentTime2.getHours();
                    var minutes = currentTime2.getMinutes();


                    // Set the initial time in minutes from the current time
                    var totalMinutes = hours * 60 + minutes;

                    if (remainingTime) {
                        totalMinutes += parseInt(remainingTime, 10); // Parse as an integer and add
                    }
                    // console.log(totalMinutes);
                    var x = setInterval(function() {


                        let allocateHour = document.getElementById("allocatedHour").outerText;
                        let workingHour = document.getElementById("workingHour").outerText;

                        var parts = allocateHour.split(" ");
                        var numberPart = parts[0].trim();
                        var wordPart = parts[1].trim();
                        var number = parseFloat(numberPart);


                        if (wordPart === "MINUTE") {
                            var allocateNum = number;
                        } else if (wordPart === "DAY") {
                            var allocateNum = number * 480;
                        } else {

                            var allocateNum = number * 60;
                        }

                        // console.log(workingHour);
                        // let workingHour = "-";
                        if (workingHour === "-") {

                            var workingNum = "0";
                        } else {

                            var parts1 = workingHour.split(':');
                            if (parts1.length === 2) {
                                var hours1 = parseInt(parts1[0], 10);
                                var minutes1 = parseInt(parts1[1], 10);

                                var workingNum = (hours1 * 60) + minutes1;

                            }
                        }

                        let finalHourNum = allocateNum - workingNum;
                        // console.log(finalHourNum);
                        var currentTime1 = new Date();
                        var hours1 = currentTime1.getHours();
                        var minutes1 = currentTime1.getMinutes();
                        var seconds1 = currentTime1.getSeconds();
                        var totalMinutes1 = hours1 * 60 + minutes1;
                        var distance = totalMinutes + finalHourNum - totalMinutes1;
                        var remainingSeconds = distance * 60;
                        var hoursRemaining = Math.floor(Math.abs(remainingSeconds) / 3600);
                        var minutesRemaining = Math.floor(Math.abs(remainingSeconds) / 60) % 60;
                        var formattedHours = hoursRemaining.toString().padStart(2, '0');
                        var formattedMinutes = minutesRemaining.toString().padStart(2, '0');


                        if (remainingSeconds <= 0) {
                            document.getElementById("timerDisplay").innerHTML = "-" + formattedHours + "h " + "-" + formattedMinutes + "m " + seconds1 + "s";
                        } else {
                            document.getElementById("timerDisplay").innerHTML = formattedHours + "h " + formattedMinutes + "m " + seconds1 + "s";
                        }


                    }, 1000);

                } else if (data === 'H') {

                }
            }
        }

        const newTable = document.getElementById('runningTable');
        const overdueTable = document.getElementById('overdue_table');
        const withinDueTable = document.getElementById('withinDue_table');
        const testingTable = document.getElementById('testing_table');
        const OverSymbol = "OverDue Ticket";
        const WithinSymbol = "Within Due Ticket";
        const TestingSymbol = "Testing Ticket";
        const timerElement = document.getElementById('timerDisplay');

        manipulateTable(overdueTable, newTable, OverSymbol, timerElement, 'overdue');
        manipulateTable(withinDueTable, newTable, WithinSymbol, timerElement, 'within_due');
        manipulateTable(testingTable, newTable, TestingSymbol, timerElement, 'testing');
    </script>

    <!-- TICKET HOLD AT 6PM -->
    <script>
        const selectEntry = document.getElementById('select_Entry');
        var currentEntryStartid = $('#select_Entry').data('startid');
        var currentEntryflag = $('#select_Entry').data('entry');
        const currentTime = new Date();
        const targetTime = new Date(currentTime);
        targetTime.setHours(18, 0, 0, 0); // Set the target time to 6:00 PM

        const timeUntilTarget = targetTime - currentTime;

        if (timeUntilTarget > 0) {
            setTimeout(yourFunction, timeUntilTarget);
        }

        function yourFunction() {
            alert("Your Ticket Will Be Closed.");
            if (currentEntryStartid === 1) {
                selectEntry.value = "H";
                document.getElementById('selectForm').submit();
            }
        }
    </script>

    <!-- POPUP FOR COMPLETE FOR NRCR -->
    <script>
        function userclosemodal() {
            $('#userConformModalIT').modal('hide');
        }

        // Hide modal when the close button is clicked
        $('#select_Entry').click(function() {
            var supportmode = $(this).data('supportmode');

            if (this.value === "C" && supportmode === "NRCR") {
                // alert("C")
                $('#userConformModalIT').modal('show');
            }
        });
        //  ======= sub ticket Allocation 
    </script>

    <!-- SKIPS THE ALLOCATION -->
    <script>
        function redirectToAttendance(event) {

            var rowid = $(event.target).closest('tr').find('input[name="rowid"]').val();
            var allocHour = $(event.target).closest('tr').find('input[name="allocHour"]').val();
            var fcRemarks = $(event.target).closest('tr').find('input[name="fcRemarks"]').val();
            var fcRemarks = $(event.target).closest('tr').find('input[name="fcRemarks"]').val();
            var DeveloperID = $(event.target).closest('tr').find('input[name="DeveloperID"]').val();


            console.log(DeveloperID);

            // Perform your logging action here

            var route = "TicketAllocationReport?rowid=" + rowid + "?allocHour=" + allocHour + "?fcRemarks=" + fcRemarks + "?DeveloperID=" + DeveloperID;
            if (rowid) {
                window.location.href = route;
                $('.detail, html, body').toggleClass('open');
            } else {
                window.location.href = route;
            }

            event.preventDefault();
        }
    </script>



    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    @endsection
</body>

</html>