<!-- STYLE FOR EXPORT -->
<style>
    .over_export__file {
        position: relative;
        margin-left: auto;
        color: black !important;
    }

    .over_export__file .over_export__file-btn {
        display: inline-block;
        width: 2rem;
        height: 2rem;
        background: #fff6 url("{{ asset('frontend/img/Report page/export.png') }}") center / 80% no-repeat;
        border-radius: 50%;
        transition: .2s ease-in-out;
    }

    .over_export__file .over_export__file-btn:hover {
        background-color: #fff;
        transform: scale(1.15);
        cursor: pointer;
    }

    .over_export__file input {
        display: none;
    }

    .over_export__file .over_export__file-options {
        position: absolute;
        right: 0;
        width: 12rem;
        border-radius: .5rem;
        overflow: hidden;
        text-align: center;
        opacity: 0;
        transform: scale(.8);
        transform-origin: top right;
        box-shadow: 0 .2rem .5rem #0004;
        transition: .2s;
    }

    .over_export__file input:checked+.over_export__file-options {
        opacity: 1;
        transform: scale(1);
        z-index: 100;
    }

    .over_export__file .over_export__file-options label {
        display: block;
        width: 100%;
        padding: .6rem 0;
        background-color: #f2f2f2;
        display: flex;
        justify-content: space-around;
        align-items: center;
        transition: .2s ease-in-out;
    }

    .over_export__file .over_export__file-options label:first-of-type {
        background-color: #86e49d !important;
    }

    .over_export__file .over_export__file-options label:hover {
        transform: scale(1.05);
        background-color: #fff;
        cursor: pointer;
    }

    .over_export__file .over_export__file-options img {
        width: 2rem;
        height: auto;
    }

    .form-control option {
        font-weight: bold;
    }
</style>

<header class="st_table_header d-md-flex">

    <h2 class="col-xl-3 col-sm-4 h4" style="margin-top: -8px !important;">Over Due Tickets</h2>

    <section class="table__header col-xl-8 mt-1 col-md-7 ">
        <div class="card-title text-white"><b></b></div>
        <div Class="col-sm-3 col-xl-2 col-md-3 col-lg-3">
            <!-- row Count -->
            <div class="empl">
                <div id="entryCountOver">Total Tickets: <span id="rowCountOver"></span></div>
                <div id="searchCountOver"></div>
            </div>
        </div>
        <!-- SEARCH BAR & SHOW ENTRIES -->
        <div class="search_bar">
            <div class="input-group">
                <input type="search" placeholder="Search Data..." id="searchtableOver">
            </div>
        </div>
    </section>

    <!-- EXPORT OPTION -->
    <div class="over_export__file mt-2 ml-3">
        <section class="table__header">
            <div class="over_export__file">
                <label for="export-file-overdue" class="over_export__file-btn" title="Export File" onclick="toggleZIndex()"></label>
                <input type="checkbox" id="export-file-overdue">
                <div class="over_export__file-options">
                    <label>Export As &nbsp; &#10140;</label>
                    <label for="export-file-overdue" class="exportbtn_over">EXCEL <img src="{{ asset('frontend/img/Report page/excel.png') }}" alt="EXCEL"></label>
                    <label for="export-file-overdue" onclick="printOverdueTable()">PRINT <img src="{{ asset('frontend/img/Report page/print.png') }}" alt="PRINT"></label>
                </div>
            </div>
        </section>
    </div>

</header>

<!-- TABLE -->
<section class="table__body">

    <table id="overdue_table" class="table">
        @if(empty ($overDues))
        <h5 class="text-center p-4 text-dark"> {{ $overDuesNoData }}</h5>
        @else
        <thead>
            <tr>
                <th> TNO <span class="icon-arrow">&UpArrow;</span></th>
                <th> REQ BY <span class="icon-arrow">&UpArrow;</span></th>
                <th> Sub-All <span class="icon-arrow">&UpArrow;</span></th>
                <th> REQ DATE <span class="icon-arrow">&UpArrow;</span></th>
                <th> MODULE <span class="icon-arrow">&UpArrow;</span></th>
                <th> FC_NAME <span class="icon-arrow">&UpArrow;</span></th>
                <th> FC REMARKS <span class="icon-arrow">&UpArrow;</span></th>
                <!-- <th> SUPPORT MODE <span class="icon-arrow">&UpArrow;</span></th> -->
                <th> DESCRIPTION <span class="icon-arrow">&UpArrow;</span></th>
                <th> APP DATE <span class="icon-arrow">&UpArrow;</span></th>
                <th> EST DATE <span class="icon-arrow">&UpArrow;</span></th>
                <th> DUE <span class="icon-arrow">&UpArrow;</span></th>
                <th> FLAG <span class="icon-arrow">&UpArrow;</span></th>
                <th> W-HOUR <span class="icon-arrow">&UpArrow;</span></th>
                <th> ENTRY <span class="icon-arrow">&UpArrow;</span></th>
                <th> UN-ALL <span class="icon-arrow">&UpArrow;</span></th>
                <th style="display: none;"> Re-Commit_Date </th>
            </tr>
        </thead>
        <tbody>
            @foreach($overDues as $overDue)
            <tr>
                <td class="font-weight-bold">{{ $overDue['Row_id'] }}</td>
                <td class="">
                    <div class="d-flex align-items-center">
                        <img src="{{ asset('frontend/emplphotos/'.$overDue['User_Emplno'].'.jpeg')}}" style="border-radius: 10px;" alt="" srcset="" width="45" height="50" class="mr-1">
                        {{ $overDue['ReportedBy'] }}
                        <!-- {{ strtok($overDue['ReportedBy'], ' ') }} <br> {{ substr(strstr($overDue['ReportedBy'], ' '), 1) }} -->
                    </div>
                </td>
                <?php
                $subAllocation = Session('ticketAllocationSub');
                ?>
                @if($overDue['Flag'] === "" && $subAllocation === "Y")
                <td class="it_td" data-title="COMPLETION">
                    <input type="hidden" name="rowid" id="rowids" value="{{ $overDue['Row_id'] }}">
                    <input type="hidden" name="allocHour" id="allocHours" value="{{ $overDue['Est_Time_in_hour'] }}">
                    <input type="hidden" name="fcRemarks" id="fcRemarks" value="{{ $overDue['Fc_remark'] }}">
                    <input type="hidden" name="DeveloperID" id="fcRemarks" value="{{ $overDue['Developer'] }}">
                    <!-- Updated Allocate button -->
                    <a onclick="redirectToAttendance(event)" id="" class="Allocate btn btn-success btn-sm ml-1">A</a>
                </td>
                @endif
                <!-- @if($overDue['Flag'] != "" && $subAllocation === "Y")
                <td class="it_td" data-title="COMPLETION">
                    <a class=" ">Allocate</a>
                </td>
                @endif -->

                @if($overDue['Flag'] != "" && $subAllocation === "Y")
                <td class="it_td" data-title="COMPLETION">
                    <p>--</p>
                </td>
                @endif
                @if( $subAllocation === "N" && $overDue['Flag'] != "")
                <td class="it_td" data-title="COMPLETION">
                    <!-- Updated Allocate button -->
                    <p>--</p>
                </td>
                @endif
                @if( $subAllocation === "N" && $overDue['Flag'] === "")
                <td class="it_td" data-title="COMPLETION">
                    <!-- Updated Allocate button -->
                    <p>--</p>
                </td>
                @endif
                <td>{{ $overDue['Reported_Date'] }}</td>
                <td>{{ $overDue['Module_Name'] }}</td>
                <td>{{ $overDue['FC_Name'] }}</td>
                <td>{{ $overDue['Fc_remark'] }}</td>
                <!-- <td>{{ $overDue['Support_Mode'] }}</td> -->
                <td>{{ $overDue['Issuse_Describ'] }}</td>
                <td>{{ date('Y-m-d', strtotime($overDue['Appr_Time'])) }}</td>
                <td>{{ date('Y-m-d', strtotime($overDue['Tar_Comp_Time'])) }} </td>
                <td>{{ $overDue['Due'] }}</td>
                <!-- FLAG -->
                <td data-title='FLAG' class="">
                    @if ($overDue['Flag'] === 'C')
                    <p class="status Approved w-50">
                        <span>{{ $overDue['Flag'] }}</span>
                    </p>

                    @elseif ($overDue['Flag'] === 'S')
                    <p class="status Request w-50">
                        <span>{{ $overDue['Flag'] }}</span>
                    </p>

                    @else ($overDue['Flag'] === 'H')
                    <p class="status Reject w-50">
                        <span>{{ $overDue['Flag'] }}</span>
                    </p>
                    @endif

                </td>
                <td>
                    <div>
                        <p id="">Allocated: <span id="allocatedHour"><br>{{ $overDue['Est_Time_in_hour'] }}</span></p>
                        <p id="">Working: <span id="workingHour"><br>{{ $overDue['Act_Hours'] }}</span></p>

                    </div>
                </td>
                <td class="it_td" data-title="COMPLETION">
                    <form action="/developerScreenEntry" method="POST" class="d-flex" id="selectForm">
                        @csrf
                        <select id="select_Entry" name="selected_entry" class="form-select entry-select" data-entry="{{ $overDue['Flag'] }}" data-startid="{{ $overDue['Mode'] }}" data-supportmode="{{ $overDue['Support_Mode'] }}" required>
                            <option value="">--Select--</option>
                            <option value="S">S</option>
                            <option value="H">H</option>
                            <option value="C">C</option>
                        </select>

                        <input type="hidden" name="rowid" value="{{ $overDue['Row_id'] }}">
                        <input type="hidden" name="Developer_emplno" value="{{ $overDue['Developer'] }}">
                        <input type="hidden" name="Support_Mode" value="{{ $overDue['Support_Mode'] }}">
                        <input type="hidden" name="ReportedBy" value="{{ $overDue['ReportedBy'] }}">
                        <input type="hidden" name="Module_Name" value="{{ $overDue['Module_Name'] }}">
                        <input type="hidden" name="FC_Name" value="{{ $overDue['FC_Name'] }}">
                        <input type="hidden" name="Fc_remark" value="{{ $overDue['Fc_remark'] }}">
                        <input type="hidden" name="User_Emplno" value="{{ $overDue['User_Emplno'] }}">
                        <input type="hidden" name="fc_emplno" value="{{ $overDue['fc_emplno'] }}">
                        <button type="submit" class="btn btn-success btn-sm ml-1" data-bs-toggle="modal" data-bs-target="#exampleModal" data-bs-whatever="@mdo">&#10004;</button>

                        <!-- modal start -->
                        <div class="modal fade" id="userConformModalIT" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLongTitle">User Confirmation Screen</h5>
                                        <button class="close" onclick="userclosemodal()">&times;</button>


                                    </div>
                                    <div class="modal-body">

                                        <!-- =============================================== user Completion form  -->

                                        <div class="form-group">
                                            <label for="">Developer Remark</label>
                                            <textarea name="DeveloperRemark" class="form-control" id="" cols="30" rows="3"></textarea>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" onclick="userclosemodal()">Close</button>
                                        <button type="sunmit" class="btn btn-primary">Save changes</button>
                                        <!-- =============================================== user Completion form  end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- modal end -->
                    </form>
                </td>

                <!-- RECOMMITMENT DATE -->
                <td style="display: none;">
                    <form action="">
                        <input type="date" class="form-control">
                        <input type="text" class="form-control">
                        <button type="submit" class="btn btn-success btn-sm ml-1">Submit</button>
                    </form>
                </td>

                <!-- UNALLOCATE TO FC -->
                <td>
                    <form action="{{route('fc_unallocate')}}" method="POST">
                        @csrf
                        @if($overDue['Flag'] === "")
                        <input type="hidden" name="tno" value="{{ $overDue['Row_id'] }}">
                        <button type="submit" class="btn btn-success btn-sm ml-1">Unallocate</button>
                        @else
                        <button type="" class="btn btn-success btn-sm ml-1" disabled>Unallocate</button>
                        @endif
                    </form>
                </td>

            </tr>
            @endforeach
            @endif


        </tbody>
    </table>

</section>


<!-- Sorting | Ordering data of HTML table -->
<script>
    const head_tab = document.querySelectorAll('#overdue_table thead th');
    const row_table = document.querySelectorAll('#overdue_table tbody tr');
    head_tab.forEach((head, i) => {
        let sort_asc = true;
        head.addEventListener('click', () => {
            head_tab.forEach(head => head.classList.remove('active'));
            head.classList.add('active');

            document.querySelectorAll('#overdue_table td').forEach(td => td.classList.remove('active'));
            row_table.forEach(row => {
                row.querySelectorAll('#overdue_table td')[i].classList.add('active');
            })

            head.classList.toggle('asc', sort_asc);
            sort_asc = head.classList.contains('asc') ? false : true;

            sortTableOver(i, sort_asc);
        });
    });

    function sortTableOver(column, sort_asc) {
        const tbody = document.querySelector('#overdue_table tbody');
        const rows = Array.from(row_table);

        rows.sort((a, b) => {
            let first_row = parseFloat(a.querySelectorAll('#overdue_table td')[column].textContent.toLowerCase());
            let second_row = parseFloat(b.querySelectorAll('#overdue_table td')[column].textContent.toLowerCase());

            // return sort_asc ? (first_row - second_row) : (second_row - first_row);
            return sort_asc ? (first_row < second_row ? -1 : 1) : (first_row < second_row ? 1 : -1);
        });

        // Clear the existing rows from the table
        while (tbody.firstChild) {
            tbody.removeChild(tbody.firstChild);
        }

        // Append the sorted rows to the table
        rows.forEach(row => {
            tbody.appendChild(row);
        });
    }
</script>


<!-- SEARCH IN TABLE -->
<script>
    $(document).ready(function() {
        $("#searchtableOver").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            var matches = $("#overdue_table tbody tr").filter(function() {
                return $(this).text().toLowerCase().indexOf(value) > -1;
            });

            if (value === "") {
                // If the search bar is empty, clear the search results and count

                $("#searchCountOver").text("");
                $("#entryCountOver").show(); // Show the entry count
                $("#overdue_table tbody tr").toggle(true);
                updateRowsPerPage(); // Call the function to reset displayed rows
            } else {
                $("#entryCountOver").hide(); // Hide the entry count
                // Show the search count and hide rows that don't match the search criteria
                $("#searchCountOver").text(matches.length + " result(s) found");
                matches.toggle(true);
                $("#overdue_table tbody tr").not(matches).toggle(false);
            }
        });
    });
</script>


<!-- SHOWS HOW MANY ENTRIES IN THE TABLE -->
<script>
    // Add this code to update the entry count:

    function updateEntryCountOver() {
        var rowCount = $("#overdue_table tbody tr").length;
        $("#rowCountOver").text(rowCount);
    }

    // Call the function to update the entry count after the page loads
    $(document).ready(function() {
        updateEntryCountOver();
    });
</script>


<!-- PRINT -->
<script>
    function printOverdueTable() {
        let tab = document.getElementById('overdue_table');
        let win = window.open('', '', 'height=700,width=700');
        win.document.write(tab.outerHTML);
        win.document.close();
        win.print();
        win.close(); // Add this line to close the window after printing
    }
</script>

<!-- EXPORT -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.3/xlsx.full.min.js"></script>
<script>
    function exportOverdueTableToXls(table, filename) {
        var wb = XLSX.utils.table_to_book(table, {
            sheet: "Sheet1"
        });
        XLSX.writeFile(wb, filename);
    }
    document.querySelector(".exportbtn_over").addEventListener("click", function() {
        var table = document.querySelector("#overdue_table");
        exportOverdueTableToXls(table, "OVER_DUE.xlsx");
    });
</script>


@yield('withinDue')