<!-- STYLE FOR EXPORT -->
<style>
    .testing_export__file {
        position: relative;
        margin-left: auto;
        color: black !important;
    }

    .testing_export__file .testing_export__file-btn {
        display: inline-block;
        width: 2rem;
        height: 2rem;
        background: #fff6 url("{{ asset('frontend/img/Report page/export.png') }}") center / 80% no-repeat;
        border-radius: 50%;
        transition: .2s ease-in-out;
    }

    .testing_export__file .testing_export__file-btn:hover {
        background-color: #fff;
        transform: scale(1.15);
        cursor: pointer;
    }

    .testing_export__file input {
        display: none;
    }

    .testing_export__file .testing_export__file-options {
        position: absolute;
        right: 0;
        width: 12rem;
        border-radius: .5rem;
        overflow: hidden;
        text-align: center;
        opacity: 0;
        transform: scale(.8);
        transform-origin: top right;
        box-shadow: 0 .2rem .5rem #0004;
        transition: .2s;
    }

    .testing_export__file input:checked+.testing_export__file-options {
        opacity: 1;
        transform: scale(1);
        z-index: 100;
    }

    .testing_export__file .testing_export__file-options label {
        display: block;
        width: 100%;
        padding: .6rem 0;
        background-color: #f2f2f2;
        display: flex;
        justify-content: space-around;
        align-items: center;
        transition: .2s ease-in-out;
    }

    .testing_export__file .testing_export__file-options label:first-of-type {
        background-color: #86e49d !important;
    }

    .testing_export__file .testing_export__file-options label:hover {
        transform: scale(1.05);
        background-color: #fff;
        cursor: pointer;
    }

    .testing_export__file .testing_export__file-options img {
        width: 2rem;
        height: auto;
    }

    .form-control option {
        font-weight: bold;
    }
</style>

<header class="st_table_header d-md-flex">
    <h2 class="col-xl-3 col-sm-4 h4" style="margin-top: -9px !important;">Testing Tickets</h2>

    <section class="table__header col-xl-8 mt-1 col-md-7">
        <div class="card-title text-white"><b></b></div>
        <div Class="col-sm-3 col-xl-2 col-md-3 col-lg-3">

            <!-- row Count -->
            <div class="empl">
                <div id="entryCountTest">Total Tickets: <span id="rowCountTest"></span></div>
                <div id="searchCountTest"></div>
            </div>
        </div>


        <!-- SEARCH BAR & SHOW ENTRIES -->
        <div class="search_bar">
            <!-- <div class="entries">
                <select name="state" id="maxRows">
                    <option value="10">10</option>
                    <option value="20">20</option>
                    <option value="50">50</option>
                    <option value="70">70</option>
                    <option value="100">100</option>
                    <option value="5000">Show ALL Rows</option>
                </select>
            </div> -->
            <div class="input-group">
                <input type="search" placeholder="Search Data..." id="searchtableTest">
            </div>
        </div>
        <!-- EXPORT OPTION -->

    </section>

    <!-- EXPORT OPTION -->
    <div class="testing_export__file mt-2 ml-3">
        <section class="table__header">
            <div class="testing_export__file">
                <label for="export-file-testing-due" class="testing_export__file-btn" title="Export File" onclick="toggleZIndex()"></label>
                <input type="checkbox" id="export-file-testing-due">
                <div class="testing_export__file-options">
                    <label>Export As &nbsp; &#10140;</label>
                    <label for="export-file-testing-due" class="exportbtn_testing">EXCEL <img src="{{ asset('frontend/img/Report page/excel.png') }}" alt="EXCEL"></label>
                    <label for="export-file-testing-due" onclick="printWithinDueTable()">PRINT <img src="{{ asset('frontend/img/Report page/print.png') }}" alt="PRINT"></label>
                </div>
            </div>
        </section>
    </div>

</header>
<section class="table__body">
    <table id="testing_table" class="table">
        @if(empty ($testingTicket))
        <h5 class="text-center p-4 text-dark"> {{ $testingNoData }}</h5>

        @else
        <thead>
            <tr>
                <th> TNO <span class="icon-arrow">&UpArrow;</span></th>
                <th> REQ BY <span class="icon-arrow">&UpArrow;</span></th>
                <th> REQ DATE <span class="icon-arrow">&UpArrow;</span></th>
                <th> MODULE <span class="icon-arrow">&UpArrow;</span></th>
                <th> FC_NAME <span class="icon-arrow">&UpArrow;</span></th>
                <th> FC REMARKS <span class="icon-arrow">&UpArrow;</span></th>
                <!-- <th> SUPPORT MODE <span class="icon-arrow">&UpArrow;</span></th> -->
                <th> DESCRIPTION <span class="icon-arrow">&UpArrow;</span></th>
                <th> A DATE <span class="icon-arrow">&UpArrow;</span></th>
                <th> EST DATE <span class="icon-arrow">&UpArrow;</span></th>
                <th> DUE <span class="icon-arrow">&UpArrow;</span></th>
                <th> FLAG <span class="icon-arrow">&UpArrow;</span></th>
                <th> W-HOUR <span class="icon-arrow">&UpArrow;</span></th>
                <th> ENTRY <span class="icon-arrow">&UpArrow;</span></th>
            </tr>
        </thead>
        <tbody>

            @foreach($testingTicket as $testingTickets)
            <tr>
                <td class="font-weight-bold">{{ $testingTickets['Row_id'] }}</td>
                <td class="">

                    <div class="d-flex align-items-center">
                        <img src="{{ asset('frontend/emplphotos/'.$testingTickets['User_Emplno'].'.jpeg')}}" style="border-radius: 10px;" alt="" srcset="" width="45" height="50" class="mr-1">{{ $testingTickets['ReportedBy'] }}
                    </div>

                </td>
                <td>{{ $testingTickets['Reported_Date'] }}</td>
                <td>{{ $testingTickets['Module_Name'] }}</td>
                <td>{{ $testingTickets['FC_Name'] }}</td>
                <td>{{ $testingTickets['Fc_remark'] }}</td>
                <!-- <td>{{ $testingTickets['Support_Mode'] }}</td> -->
                <td>{{ $testingTickets['Issuse_Describ'] }}</td>
                <td>{{ date('Y-m-d', strtotime($testingTickets['Appr_Time'])) }}</td>
                <td>{{ date('Y-m-d', strtotime($testingTickets['Tar_Comp_Time'])) }} </td>
                <td>{{ $testingTickets['Due'] }}</td>
                <td data-title='ATTATCHMENT1' class="">
                    @if ($testingTickets['Flag'] === 'C')
                    <p class="status Approved w-50">
                        <span>{{ $testingTickets['Flag'] }}</span>
                    </p>

                    @elseif ($testingTickets['Flag'] === 'S')
                    <p class="status Request w-50">
                        <span>{{ $testingTickets['Flag'] }}</span>
                    </p>

                    @else ($testingTickets['Flag'] === 'H')
                    <p class="status Reject w-50">
                        <span>{{ $testingTickets['Flag'] }}</span>
                    </p>
                    @endif

                </td>
                <td>
                    <div>
                        <p id="">Allocated: <span id="allocatedHour"><br>{{ $testingTickets['Est_Time_in_hour'] }}</span></p>
                        <p id="">Working: <span id="workingHour"><br>{{ $testingTickets['Act_Hours'] }}</span></p>

                    </div>
                </td>
                <td class="it_td" data-title="COMPLETION">
                    <form action="/developerScreenEntry" method="POST" class="d-flex" id="selectForm">
                        @csrf
                        <select id="select_Entry" name="selected_entry" class="form-select entry-select" data-entry="{{ $testingTickets['Flag'] }}" data-startid="{{ $testingTickets['Mode'] }}" data-supportmode="{{ $testingTickets['Support_Mode'] }}" required>
                            <option value="">--Select--</option>
                            <option value="S">S</option>
                            <option value="H">H</option>
                            <option value="C">C</option>
                        </select>

                        <input type="hidden" name="rowid" value="{{ $testingTickets['Row_id'] }}">
                        <input type="hidden" name="Developer_emplno" value="{{ $testingTickets['Developer'] }}">
                        <input type="hidden" name="Support_Mode" value="{{ $testingTickets['Support_Mode'] }}">
                        <input type="hidden" name="ReportedBy" value="{{ $testingTickets['ReportedBy'] }}">
                        <input type="hidden" name="Module_Name" value="{{ $testingTickets['Module_Name'] }}">
                        <input type="hidden" name="FC_Name" value="{{ $testingTickets['FC_Name'] }}">
                        <input type="hidden" name="Fc_remark" value="{{ $testingTickets['Fc_remark'] }}">
                        <input type="hidden" name="User_Emplno" value="{{ $testingTickets['User_Emplno'] }}">
                        <input type="hidden" name="fc_emplno" value="{{ $testingTickets['fc_emplno'] }}">
                        <button type="submit" class="btn btn-success btn-sm ml-1">&#10004;</button>

                        <!-- modal start -->
                        <div class="modal fade" id="userConformModalIT" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLongTitle">User Confirmation Screen</h5>
                                        <button class="close" onclick="userclosemodal()">&times;</button>


                                    </div>
                                    <div class="modal-body">

                                        <!-- =============================================== user Completion form  -->

                                        <div class="form-group">
                                            <label for="">Developer Remark</label>
                                            <textarea name="DeveloperRemark" class="form-control" id="" cols="30" rows="3"></textarea require>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" onclick="userclosemodal()">Close</button>
                                        <button type="sunmit" class="btn btn-primary">Save changes</button>
                                        <!-- =============================================== user Completion form  end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- modal end -->
                    </form>
                </td>
            </tr>
            @endforeach
            @endif

        </tbody>
    </table>

</section>



<!-- Sorting | Ordering data of HTML table -->
<script>
    const head_test = document.querySelectorAll('#testing_table thead th');
    const row_test = document.querySelectorAll('#testing_table tbody tr');
    head_test.forEach((head, i) => {
        let sort_asc = true;
        head.addEventListener('click', () => {
            head_test.forEach(head => head.classList.remove('active'));
            head.classList.add('active');

            document.querySelectorAll('td').forEach(td => td.classList.remove('active'));
            row_test.forEach(row => {
                row.querySelectorAll('td')[i].classList.add('active');
            })

            head.classList.toggle('asc', sort_asc);
            sort_asc = head.classList.contains('asc') ? false : true;

            sortTableTest(i, sort_asc);
        });
    });

    function sortTableTest(column, sort_asc) {
        const tbody_test = document.querySelector('#testing_table tbody');
        const rows_test = Array.from(row_test);

        rows_test.sort((a, b) => {
            let first_row = parseFloat(a.querySelectorAll('#testing_table td')[column].textContent.toLowerCase());
            let second_row = parseFloat(b.querySelectorAll('#testing_table td')[column].textContent.toLowerCase());

            // return sort_asc ? (first_row - second_row) : (second_row - first_row);
            return sort_asc ? (first_row < second_row ? -1 : 1) : (first_row < second_row ? 1 : -1);
        });

        // Clear the existing rows from the table
        while (tbody_test.firstChild) {
            tbody_test.removeChild(tbody_test.firstChild);
        }

        // Append the sorted rows to the table
        rows_test.forEach(row => {
            tbody_test.appendChild(row);
        });
    }
</script>


<!-- SEARCH IN TABLE -->
<script>
    $(document).ready(function() {
        $("#searchtableTest").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            var matches = $("#testing_table tbody tr").filter(function() {
                return $(this).text().toLowerCase().indexOf(value) > -1;
            });

            if (value === "") {
                // If the search bar is empty, clear the search results and count

                $("#searchCountTest").text("");
                $("#entryCountTest").show(); // Show the entry count
                $("#testing_table tbody tr").toggle(true);
                updateRowsPerPage(); // Call the function to reset displayed rows
            } else {
                $("#entryCountTest").hide(); // Hide the entry count
                // Show the search count and hide rows that don't match the search criteria
                $("#searchCountTest").text(matches.length + " result(s) found");
                matches.toggle(true);
                $("#testing_table tbody tr").not(matches).toggle(false);
            }
        });
    });
</script>

<!-- SHOWS HOW MANY ENTRIES IN THE TABLE -->
<script>
    // Add this code to update the entry count:

    function updateEntryCountTest() {
        var rowCount = $("#testing_table tbody tr").length;
        $("#rowCountTest").text(rowCount);
    }

    // Call the function to update the entry count after the page loads
    $(document).ready(function() {
        updateEntryCountTest();
    });
</script>

<!-- PRINT -->
<script>
    function printWithinDueTable() {
        let tab = document.getElementById('testing_table');
        let win = window.open('', '', 'height=700,width=700');
        win.document.write(tab.outerHTML);
        win.document.close();
        win.print();
        win.close(); // Add this line to close the window after printing
    }
</script>

<!-- EXPORT -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.3/xlsx.full.min.js"></script>
<script>
    function exportWithinDueTableToXls(table, filename) {
        var wb = XLSX.utils.table_to_book(table, {
            sheet: "Sheet1"
        });
        XLSX.writeFile(wb, filename);
    }
    document.querySelector(".exportbtn_testing").addEventListener("click", function() {
        var table = document.querySelector("#testing_table");
        exportWithinDueTableToXls(table, "TESTING.xlsx");
    });
</script>


@yield('userClose')