<!-- STYLE FOR EXPORT -->
<style>
    .userclose_export__file {
        position: relative;
        margin-left: auto;
        color: black !important;
    }

    .userclose_export__file .userclose_export__file-btn {
        display: inline-block;
        width: 2rem;
        height: 2rem;
        background: #fff6 url("{{ asset('frontend/img/Report page/export.png') }}") center / 80% no-repeat;
        border-radius: 50%;
        transition: .2s ease-in-out;
    }

    .userclose_export__file .userclose_export__file-btn:hover {
        background-color: #fff;
        transform: scale(1.15);
        cursor: pointer;
    }

    .userclose_export__file input {
        display: none;
    }

    .userclose_export__file .userclose_export__file-options {
        position: absolute;
        right: 0;
        width: 12rem;
        border-radius: .5rem;
        overflow: hidden;
        text-align: center;
        opacity: 0;
        transform: scale(.8);
        transform-origin: top right;
        box-shadow: 0 .2rem .5rem #0004;
        transition: .2s;
    }

    .userclose_export__file input:checked+.userclose_export__file-options {
        opacity: 1;
        transform: scale(1);
        z-index: 100;
    }

    .userclose_export__file .userclose_export__file-options label {
        display: block;
        width: 100%;
        padding: .6rem 0;
        background-color: #f2f2f2;
        display: flex;
        justify-content: space-around;
        align-items: center;
        transition: .2s ease-in-out;
    }

    .userclose_export__file .userclose_export__file-options label:first-of-type {
        background-color: #86e49d !important;
    }

    .userclose_export__file .userclose_export__file-options label:hover {
        transform: scale(1.05);
        background-color: #fff;
        cursor: pointer;
    }

    .userclose_export__file .userclose_export__file-options img {
        width: 2rem;
        height: auto;
    }

    .form-control option {
        font-weight: bold;
    }
</style>

<header class="st_table_header d-md-flex">
    <h2 class="col-xl-3 col-sm-4 h4" style="margin-top: -9px !important;">Need To Be Closed</h2>

    <section class="table__header col-xl-8 mt-1 col-md-7">
        <div class="card-title text-white"><b></b></div>
        <div Class="col-sm-3 col-xl-2 col-md-3 col-lg-3">

            <!-- row Count -->
            <div class="empl">
                <div id="entryCountUser">Total Tickets: <span id="rowCountUser"></span></div>
                <div id="searchCountUser"></div>
            </div>
        </div>


        <!-- SEARCH BAR  -->
        <div class="search_bar">
            <div class="input-group">
                <input type="search" placeholder="Search Data..." id="searchtableUser">
            </div>
        </div>
        <!-- EXPORT OPTION -->

    </section>

    <!-- EXPORT OPTION -->
    <div class="userclose_export__file mt-2 ml-3">
        <section class="table__header">
            <div class="userclose_export__file">
                <label for="export-file-userclose-due" class="userclose_export__file-btn" title="Export File" onclick="toggleZIndex()"></label>
                <input type="checkbox" id="export-file-userclose-due">
                <div class="userclose_export__file-options">
                    <label>Export As &nbsp; &#10140;</label>
                    <label for="export-file-userclose-due" class="exportbtn_userclose">EXCEL <img src="{{ asset('frontend/img/Report page/excel.png') }}" alt="EXCEL"></label>
                    <label for="export-file-userclose-due" onclick="printWithinDueTable()">PRINT <img src="{{ asset('frontend/img/Report page/print.png') }}" alt="PRINT"></label>
                </div>
            </div>
        </section>
    </div>

</header>
<section class="table__body">
    <table id="userClose_table" class="table">
        @if(empty($userClose))
        <h5 class="text-center p-4 text-dark"> {{ $userCloseNoData }}</h5>

        @else
        <thead>
            <tr>
                <th> TNO <span class="icon-arrow">&UpArrow;</span></th>
                <th> REQ BY <span class="icon-arrow">&UpArrow;</span></th>
                <th> REQ DATE/TIME <span class="icon-arrow">&UpArrow;</span></th>
                <th> MODULE <span class="icon-arrow">&UpArrow;</span></th>
                <th> FC_NAME <span class="icon-arrow">&UpArrow;</span></th>
                <th> FC REMARKS <span class="icon-arrow">&UpArrow;</span></th>
                <!-- <th> SUPPORT MODE <span class="icon-arrow">&UpArrow;</span></th> -->
                <th> DESCRIPTION <span class="icon-arrow">&UpArrow;</span></th>
                <!-- <th> APPROVED DATE <span class="icon-arrow">&UpArrow;</span></th> -->
                <th> EST DATE <span class="icon-arrow">&UpArrow;</span></th>
                <!-- <th> DUE <span class="icon-arrow">&UpArrow;</span></th> -->
                <th> FLAG <span class="icon-arrow">&UpArrow;</span></th>

                <!-- <th> ENTRY <span class="icon-arrow">&UpArrow;</span></th> -->
            </tr>
        </thead>
        <tbody>

            @foreach($userClose as $userCloses)
            <tr>
                <td class="font-weight-bold">{{ $userCloses['Row_id'] }}</td>
                <td>
                    <div class="d-flex align-items-center">
                        <img src="{{ asset('frontend/emplphotos/'.$userCloses['User_Emplno'].'.jpeg')}}" style="border-radius: 10px;" alt="" srcset="" width="45" height="50" class="mr-1">{{ $userCloses['ReportedBy'] }}
                    </div>
                </td>
                <td>{{ $userCloses['Reported_Date'] }}</td>
                <td>{{ $userCloses['Module_Name'] }}</td>
                <td>{{ $userCloses['FC_Name'] }}</td>
                <td>{{ $userCloses['Fc_remark'] }}</td>
                <!-- <td>{{ $userCloses['Support_Mode'] }}</td> -->
                <td>{{ $userCloses['Issuse_Describ'] }}</td>
                <!-- <td>{{ date('Y-m-d', strtotime($userCloses['Appr_Time'])) }}</td> -->
                <td>{{ date('Y-m-d', strtotime($userCloses['Tar_Comp_Time'])) }} </td>
                <!-- <td>{{ $userCloses['Due'] }}</td> -->
                <td data-title='ATTATCHMENT1' class="">
                    @if ($userCloses['Flag'] === 'C')
                    <p class="status Approved w-50">
                        <span>{{ $userCloses['Flag'] }}</span>
                    </p>

                    @elseif ($userCloses['Flag'] === 'S')
                    <p class="status Request w-50">
                        <span>{{ $userCloses['Flag'] }}</span>
                    </p>

                    @else ($userCloses['Flag'] === 'H')
                    <p class="status Reject w-50">
                        <span>{{ $userCloses['Flag'] }}</span>
                    </p>
                    @endif

                </td>
            </tr>
            @endforeach
            @endif

        </tbody>
    </table>
</section>



<script>
    const head_user = document.querySelectorAll('#userClose_table thead th');
    const row_user = document.querySelectorAll('#userClose_table tbody tr');
    head_user.forEach((head, i) => {
        let sort_asc = true;
        head.addEventListener('click', () => {
            head_user.forEach(head => head.classList.remove('active'));
            head.classList.add('active');

            document.querySelectorAll('td').forEach(td => td.classList.remove('active'));
            row_user.forEach(row => {
                row.querySelectorAll('td')[i].classList.add('active');
            })

            head.classList.toggle('asc', sort_asc);
            sort_asc = head.classList.contains('asc') ? false : true;

            sortTableUser(i, sort_asc);
        });
    });

    function sortTableUser(column, sort_asc) {
        const tbody_user = document.querySelector('#userClose_table tbody');
        const rows_user = Array.from(row_user);

        rows_user.sort((a, b) => {
            let first_row = parseFloat(a.querySelectorAll('#userClose_table td')[column].textContent.toLowerCase());
            let second_row = parseFloat(b.querySelectorAll('#userClose_table td')[column].textContent.toLowerCase());

            // return sort_asc ? (first_row - second_row) : (second_row - first_row);
            return sort_asc ? (first_row < second_row ? -1 : 1) : (first_row < second_row ? 1 : -1);
        });

        // Clear the existing rows_user from the table
        while (tbody_user.firstChild) {
            tbody_user.removeChild(tbody_user.firstChild);
        }

        // Append the sorted rows_user to the table
        rows_user.forEach(row => {
            tbody_user.appendChild(row);
        });
    }
</script>


<!-- SEARCH IN TABLE -->
<script>
    $(document).ready(function() {
        $("#searchtableUser").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            var matches = $("#userClose_table tbody tr").filter(function() {
                return $(this).text().toLowerCase().indexOf(value) > -1;
            });

            if (value === "") {
                $("#searchCountUser").text("");
                $("#entryCountUser").show(); // Show the entry count
                $("#userClose_table tbody tr").toggle(true);
                updateRowsPerPage(); // Call the function to reset displayed rows
            } else {
                $("#entryCountUser").hide(); // Hide the entry count
                // Show the search count and hide rows that don't match the search criteria
                $("#searchCountUser").text(matches.length + " result(s) found");
                matches.toggle(true);
                $("#userClose_table tbody tr").not(matches).toggle(false);
            }
        });
    });
</script>


<!-- SHOWS HOW MANY ENTRIES IN THE TABLE -->
<script>
    // Add this code to update the entry count:

    function updateEntryCountUser() {
        var rowCount = $("#userClose_table tbody tr").length;
        $("#rowCountUser").text(rowCount);
    }

    // Call the function to update the entry count after the page loads
    $(document).ready(function() {
        updateEntryCountUser();
    });
</script>

<!-- PRINT -->
<script>
    function printWithinDueTable() {
        let tab = document.getElementById('testing_table');
        let win = window.open('', '', 'height=700,width=700');
        win.document.write(tab.outerHTML);
        win.document.close();
        win.print();
        win.close(); // Add this line to close the window after printing
    }
</script>

<!-- EXPORT -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.3/xlsx.full.min.js"></script>
<script>
    function exportWithinDueTableToXls(table, filename) {
        var wb = XLSX.utils.table_to_book(table, {
            sheet: "Sheet1"
        });
        XLSX.writeFile(wb, filename);
    }
    document.querySelector(".exportbtn_userclose").addEventListener("click", function() {
        var table = document.querySelector("#testing_table");
        exportWithinDueTableToXls(table, "USER_CLOSE.xlsx");
    });
</script>

@yield('userClosed')