<!-- STYLE FOR EXPORT -->
<style>
    .within_export__file {
        position: relative;
        margin-left: auto;
        color: black !important;
    }

    .within_export__file .within_export__file-btn {
        display: inline-block;
        width: 2rem;
        height: 2rem;
        background: #fff6 url("{{ asset('frontend/img/Report page/export.png') }}") center / 80% no-repeat;
        border-radius: 50%;
        transition: .2s ease-in-out;
    }

    .within_export__file .within_export__file-btn:hover {
        background-color: #fff;
        transform: scale(1.15);
        cursor: pointer;
    }

    .within_export__file input {
        display: none;
    }

    .within_export__file .within_export__file-options {
        position: absolute;
        right: 0;
        width: 12rem;
        border-radius: .5rem;
        overflow: hidden;
        text-align: center;
        opacity: 0;
        transform: scale(.8);
        transform-origin: top right;
        box-shadow: 0 .2rem .5rem #0004;
        transition: .2s;
    }

    .within_export__file input:checked+.within_export__file-options {
        opacity: 1;
        transform: scale(1);
        z-index: 100;
    }

    .within_export__file .within_export__file-options label {
        display: block;
        width: 100%;
        padding: .6rem 0;
        background-color: #f2f2f2;
        display: flex;
        justify-content: space-around;
        align-items: center;
        transition: .2s ease-in-out;
    }

    .within_export__file .within_export__file-options label:first-of-type {
        background-color: #86e49d !important;
    }

    .within_export__file .within_export__file-options label:hover {
        transform: scale(1.05);
        background-color: #fff;
        cursor: pointer;
    }

    .within_export__file .within_export__file-options img {
        width: 2rem;
        height: auto;
    }

    .form-control option {
        font-weight: bold;
    }
</style>

<header class="st_table_header d-md-flex">

    <h2 class="col-xl-3 col-sm-4 h4" style="margin-top: -8px !important;">WithinDue Tickets</h2>

    <section class="table__header col-xl-8 mt-1 col-md-7">
        <div class="card-title text-white"><b></b></div>
        <div Class="col-sm-3 col-xl-2 col-md-2 col-lg-2">
            <!-- row count -->
            <div class="empl">
                <div id="entryCountWith">Total Tickets: <span id="rowCountWith"></span></div>
                <div id="searchCountWith"></div>
            </div>
        </div>
        <!-- SEARCH BAR -->
        <div class="search_bar">
            <div class="input-group">
                <input type="search" placeholder="Search Data..." id="searchtableWith">
            </div>
        </div>
    </section>

    <!-- EXPORT OPTION -->
    <div class="within_export__file mt-2 ml-3">
        <section class="table__header">
            <div class="within_export__file">
                <label for="export-file-within-due" class="within_export__file-btn" title="Export File" onclick="toggleZIndex()"></label>
                <input type="checkbox" id="export-file-within-due">
                <div class="within_export__file-options">
                    <label>Export As &nbsp; &#10140;</label>
                    <label for="export-file-within-due" class="exportbtn_within">EXCEL <img src="{{ asset('frontend/img/Report page/excel.png') }}" alt="EXCEL"></label>
                    <label for="export-file-within-due" onclick="printWithinDueTable()">PRINT <img src="{{ asset('frontend/img/Report page/print.png') }}" alt="PRINT"></label>
                </div>
            </div>
        </section>
    </div>

</header>

<section class="table__body">

    <table id="withinDue_table" class="table">
        @if(empty($withinDue))
        <h5 class="text-center p-4 text-dark"> {{ $withinDueNoData }}</h5>
        @else
        <thead>
            <tr>
                <!-- <th> SNO <span class="icon-arrow">&UpArrow;</span></th> -->
                <th> TNO <span class="icon-arrow">&UpArrow;</span></th>
                <th> REQ BY <span class="icon-arrow">&UpArrow;</span></th>
                <th> Sub-All <span class="icon-arrow">&UpArrow;</span></th>
                <th> REQ DATE <span class="icon-arrow">&UpArrow;</span></th>
                <th> MODULE <span class="icon-arrow">&UpArrow;</span></th>
                <th> FC_NAME <span class="icon-arrow">&UpArrow;</span></th>
                <th> FC REMARKS <span class="icon-arrow">&UpArrow;</span></th>
                <!-- <th> SUPPORT MODE <span class="icon-arrow">&UpArrow;</span></th> -->
                <th> DESCRIPTION <span class="icon-arrow">&UpArrow;</span></th>
                <th> APP DATE <span class="icon-arrow">&UpArrow;</span></th>
                <th> EST DATE <span class="icon-arrow">&UpArrow;</span></th>
                <th> DUE <span class="icon-arrow">&UpArrow;</span></th>
                <th> FLAG <span class="icon-arrow">&UpArrow;</span></th>
                <th> W-HOUR <span class="icon-arrow">&UpArrow;</span></th>
                <th> ENTRY <span class="icon-arrow">&UpArrow;</span></th>
                <th> UN-ALL <span class="icon-arrow">&UpArrow;</span></th>
            </tr>
        </thead>
        <tbody>
            @foreach($withinDue as $withinDues)
            <tr>
                <!-- <td data-title='SNO' class="font-weight-bold" >{{ $withinDues['SINO'] }}</td> -->
                <td class="font-weight-bold">{{ $withinDues['Row_id'] }}</td>
                <td>
                    <div class="d-flex align-items-center">
                        <img src="{{ asset('frontend/emplphotos/'.$withinDues['User_Emplno'].'.jpeg')}}" style="border-radius: 10px;" alt="" srcset="" width="45" height="50" class="mr-1">{{ $withinDues['ReportedBy'] }}
                    </div>
                </td>

                <?php
                $subAllocation = Session('ticketAllocationSub');
                ?>

                @if($withinDues['Flag'] === "" && $subAllocation === "Y")
                <td class="it_td" data-title="COMPLETION">
                    <input type="hidden" name="rowid" id="rowids" value="{{ $withinDues['Row_id'] }}">
                    <input type="hidden" name="allocHour" id="allocHours" value="{{ $withinDues['Est_Time_in_hour'] }}">
                    <input type="hidden" name="fcRemarks" id="fcRemarks" value="{{ $withinDues['Fc_remark'] }}">
                    <input type="hidden" name="DeveloperID" id="" value="{{ $withinDues['Developer'] }}">
                    <!-- Updated Allocate button -->
                    <a onclick="redirectToAttendance(event)" id="" class="Allocate btn btn-success btn-sm ml-1">A</a>
                </td>
                @endif

                @if($withinDues['Flag'] != "" && $subAllocation === "Y")
                <td class="it_td" data-title="COMPLETION">
                    <p>--</p>

                </td>
                @endif
                @if( $subAllocation === "N" && $withinDues['Flag'] != "")
                <td class="it_td" data-title="COMPLETION">
                    <p>--</p>
                </td>
                @endif
                @if( $subAllocation === "N" && $withinDues['Flag'] === "")
                <td class="it_td" data-title="COMPLETION">
                    <p>--</p>
                </td>
                @endif
                <td>{{ $withinDues['Reported_Date'] }}</td>
                <td> {{ $withinDues['Module_Name'] }}</td>
                <td>{{ $withinDues['FC_Name'] }}</td>
                <td>{{ $withinDues['Fc_remark'] }}</td>
                <!--OCATE TIME' >{{ $withinDues['Support_Mode'] }}</td>                    -->
                <td style="max-width: 10px; overflow: hidden; text-overflow: ellipsis;">{{ $withinDues['Issuse_Describ'] }}</td>

                <td>{{ date('Y-m-d', strtotime($withinDues['Appr_Time'])) }}</td>
                <td>{{ date('Y-m-d', strtotime($withinDues['Tar_Comp_Time'])) }} </td>
                <td> {{ $withinDues['Due'] }}</td>
                <td class="">
                    @if ($withinDues['Flag'] === 'C')
                    <p class="status Approved w-50">
                        <span>{{ $withinDues['Flag'] }}</span>
                    </p>

                    @elseif ($withinDues['Flag'] === 'S')
                    <p class="status Request w-50">
                        <span>{{ $withinDues['Flag'] }}</span>
                    </p>

                    @else ($withinDues['Flag'] === 'H')
                    <p class="status Reject w-50">
                        <span>{{ $withinDues['Flag'] }}</span>
                    </p>
                    @endif

                </td>
                <td>
                    <div>
                        <p id="">Allocated: <span id="allocatedHour"><br>{{ $withinDues['Est_Time_in_hour'] }}</span></p>
                        <p id="">Working: <span id="workingHour"><br>{{ $withinDues['Act_Hours'] }}</span></p>
                        <p></p>
                    </div>
                </td>

                <td class="it_td" data-title="COMPLETION">
                    <form action="/developerScreenEntry" method="POST" class="d-flex" id="selectForm">
                        @csrf
                        <select id="select_Entry" name="selected_entry" class="form-select entry-select" data-entry="{{ $withinDues['Flag'] }}" data-startid="{{ $withinDues['Mode'] }}" data-supportmode="{{ $withinDues['Support_Mode'] }}" required>
                            <option value="">--Select--</option>
                            <option value="S">S</option>
                            <option value="H">H</option>
                            <option value="C">C</option>
                        </select>
                        <input type="hidden" name="rowid" value="{{ $withinDues['Row_id'] }}">
                        <input type="hidden" name="Developer_emplno" value="{{ $withinDues['Developer'] }}">
                        <input type="hidden" name="Support_Mode" value="{{ $withinDues['Support_Mode'] }}">
                        <input type="hidden" name="ReportedBy" value="{{ $withinDues['ReportedBy'] }}">
                        <input type="hidden" name="Module_Name" value="{{ $withinDues['Module_Name'] }}">
                        <input type="hidden" name="FC_Name" value="{{ $withinDues['FC_Name'] }}">
                        <input type="hidden" name="Fc_remark" value="{{ $withinDues['Fc_remark'] }}">
                        <input type="hidden" name="User_Emplno" value="{{ $withinDues['User_Emplno'] }}">
                        <input type="hidden" name="fc_emplno" value="{{ $withinDues['fc_emplno'] }}">

                        <button type="submit" class="btn btn-success btn-sm ml-1">&#10004;</button>


                        <!-- modal start -->
                        <div class="modal fade" id="userConformModalIT" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLongTitle">User Confirmation Screen</h5>
                                        <button class="close" onclick="userclosemodal()">&times;</button>
                                    </div>
                                    <div class="modal-body">
                                        <!-- =============================================== user Completion form  -->

                                        <div class="form-group">
                                            <label for="">Developer Remark</label>
                                            <textarea name="DeveloperRemark" class="form-control" id="" cols="30" rows="3"></textarea>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" onclick="userclosemodal()">Close</button>
                                        <button type="sunmit" class="btn btn-primary">Save changes</button>
                                        <!-- =============================================== user Completion form  end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- modal end -->
                    </form>
                </td>

                <!-- UNALLOCATE TO FC -->
                <td>
                    <form action="{{route('fc_unallocate')}}" method="POST">
                        @csrf
                        @if($withinDues['Flag'] === "")
                        <input type="hidden" name="tno" value="{{ $withinDues['Row_id'] }}">
                        <button type="submit" class="btn btn-success btn-sm ml-1">Unallocate</button>
                        @else
                        <button type="" class="btn btn-success btn-sm ml-1" disabled>Unallocate</button>
                        @endif
                    </form>
                </td>
            </tr>
            @endforeach
            @endif
        </tbody>
    </table>

</section>

<!-- Sorting | Ordering data of HTML table -->
<script>
    const head_with = document.querySelectorAll('#withinDue_table thead th');
    const row_with = document.querySelectorAll('#withinDue_table tbody tr');
    head_with.forEach((head, i) => {
        let sort_asc = true;
        head.addEventListener('click', () => {
            head_with.forEach(head => head.classList.remove('active'));
            head.classList.add('active');

            document.querySelectorAll('#withinDue_table td').forEach(td => td.classList.remove('active'));
            row_with.forEach(row => {
                row.querySelectorAll('#withinDue_table td')[i].classList.add('active');
            })

            head.classList.toggle('asc', sort_asc);
            sort_asc = head.classList.contains('asc') ? false : true;

            sortTableWith(i, sort_asc);
        });
    });

    function sortTableWith(column, sort_asc) {
        const tbody_with = document.querySelector('#withinDue_table tbody');
        const rows_with = Array.from(row_with);

        rows_with.sort((a, b) => {
            let first_row = parseFloat(a.querySelectorAll('#withinDue_table td')[column].textContent.toLowerCase());
            let second_row = parseFloat(b.querySelectorAll('#withinDue_table td')[column].textContent.toLowerCase());

            // return sort_asc ? (first_row - second_row) : (second_row - first_row);
            return sort_asc ? (first_row < second_row ? -1 : 1) : (first_row < second_row ? 1 : -1);
        });

        // Clear the existing rows from the table
        while (tbody_with.firstChild) {
            tbody_with.removeChild(tbody_with.firstChild);
        }

        // Append the sorted rows to the table
        rows_with.forEach(row => {
            tbody_with.appendChild(row);
        });
    }
</script>

<!-- SEARCH IN TABLE -->
<script>
    $(document).ready(function() {
        $("#searchtableWith").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            var matches = $("#withinDue_table tbody tr").filter(function() {
                return $(this).text().toLowerCase().indexOf(value) > -1;
            });

            if (value === "") {
                // If the search bar is empty, clear the search results and count

                $("#searchCountWith").text("");
                $("#entryCountWith").show(); // Show the entry count
                $("#withinDue_table tbody tr").toggle(true);
                updateRowsPerPage(); // Call the function to reset displayed rows
            } else {
                $("#entryCountWith").hide(); // Hide the entry count
                // Show the search count and hide rows that don't match the search criteria
                $("#searchCountWith").text(matches.length + " result(s) found");
                matches.toggle(true);
                $("#withinDue_table tbody tr").not(matches).toggle(false);
            }
        });
    });
</script>


<!-- SHOWS HOW MANY ENTRIES IN THE TABLE -->
<script>
    // Add this code to update the entry count:

    function updateEntryCountWith() {
        var rowCount = $("#withinDue_table tbody tr").length;
        $("#rowCountWith").text(rowCount);
    }

    // Call the function to update the entry count after the page loads
    $(document).ready(function() {
        updateEntryCountWith();
    });
</script>

<!-- PRINT -->
<script>
    function printWithinDueTable() {
        let tab = document.getElementById('withinDue_table');
        let win = window.open('', '', 'height=700,width=700');
        win.document.write(tab.outerHTML);
        win.document.close();
        win.print();
        win.close(); // Add this line to close the window after printing
    }
</script>

<!-- EXPORT -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.3/xlsx.full.min.js"></script>
<script>
    function exportWithinDueTableToXls(table, filename) {
        var wb = XLSX.utils.table_to_book(table, {
            sheet: "Sheet1"
        });
        XLSX.writeFile(wb, filename);
    }
    document.querySelector(".exportbtn_within").addEventListener("click", function() {
        var table = document.querySelector("#withinDue_table");
        exportWithinDueTableToXls(table, "WITHIN_DUE.xlsx");
    });
</script>


<!-- ALERT MESSAGE -->
@if ($message = Session::get('SuccessMsg'))
<div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
    {{$message}}

</div>
<script>
    // Automatically close the alert after 3 seconds
    setTimeout(function() {
        var successAlert = document.getElementById('successAlert');
        if (successAlert) {
            successAlert.remove();
        }
    }, 3000);
</script>
@endif

@if ($message = Session::get('errorMsg'))
<div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
    {{$message}}

</div>
<script>
    // Automatically close the alert after 3 seconds
    setTimeout(function() {
        var successAlert = document.getElementById('successAlert');
        if (successAlert) {
            successAlert.remove();
        }
    }, 3000);
</script>
@endif


@yield('testingTicket')