<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>TRAVEL ADVANCE ENTRY EDIT</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }

        .sticky-header {
            position: sticky;
            top: 0;
            z-index: 1;
        }

        .sticky-footer {
            position: sticky;
            bottom: 0;
            z-index: 1;
            background-color: whitesmoke;
        }
    </style>
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->

</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->
    @section('tittle') {{"TRAVEL ADVANCE ENTRY EDIT"}}@endsection

    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="live-preview">

                                        <div id="inputContainer"></div>
                                        <marquee behavior="" direction="">
                                            <p style="background-color: lightsalmon; font-weight: bold;">If any functional clarification/policy doubts please contact Accounts Manager/Finance manager.If any technical support required in this system please contact IT Department.</p>
                                        </marquee>
                                        <form method="POST" action="{{ route('travExpenseEdit_Save') }}" enctype="multipart/form-data" class="has-validated" id="validate">
                                            @csrf
                                            <!-- AJAX BUTTON -->
                                            <div class="row">
                                                <div class="col-md-3 d-none">
                                                    <div class="mb-2">
                                                        <button type="button" class="btn btn-warning od_viewButton">
                                                            Click Here For Selecting the OD
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            @php
                                            $Travel_Tiers = session('Travel_Tiers');
                                            @endphp

                                            <!-- FIRST ROW -->
                                            <div class="row">
                                                <!-- ENO -->
                                                <div class="col-md-2">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">ENO</label>
                                                        <input type="text" name="ENo" class="form-control dull" value="{{ $result['ENO'] }}" readonly>
                                                        <input type="hidden" name="MasRowid" class="form-control" value="{{ $result['MasId'] }}" readonly>
                                                    </div>
                                                </div>
                                                <!-- DESITINATION -->
                                                <div class="col-md-3">
                                                    <div class="mb-2">
                                                        <label for="to" class="form-label">DESITINATION<span class="login-danger">*</span></label>
                                                        <select class="form-select select2" id="destinationSelect" name="destinationTo" required>
                                                            <option value="{{ $result['Destination_Code'] }}" data-cat-id="{{ $result['Destination_Code'] }}">{{ $result['Destination'] }}</option>
                                                            @foreach($cityMas as $city)
                                                            <option value="{{ $city['Rowid'] }}"
                                                                data-cat-id="{{ $city['Cat_ID'] }}">{{ $city['Name'] }}</option>
                                                            @endforeach
                                                        </select>
                                                        <input type="hidden" id="desigCatId" name="desigCatId" value="{{ old('desigCatId',$city['Cat_ID']) }}">
                                                    </div>
                                                </div>
                                                <!-- FROM DATE-->
                                                <div class="col-md-2">
                                                    <div class="mb-3">
                                                        <label>FROM DATE<span class="login-danger">*</span></label>
                                                        <input type="date" name="from_date" id="from_date" onkeydown="return false;" value="{{ old('from_date', date('Y-m-d',strtotime($result['FDate']))) }}" class="form-control" required>
                                                    </div>
                                                </div>
                                                <!-- TO DATE -->
                                                <div class="col-md-2">
                                                    <div class="mb-3">
                                                        <label>TO DATE<span class="login-danger">*</span></label>
                                                        <input type="date" name="to_date" id="to_date" onkeydown="return false;" value="{{ old('to_date', date('Y-m-d',strtotime($result['TDate']))) }}" class="form-control" required>
                                                    </div>
                                                </div>
                                                <!-- OD BUTTON -->
                                                <div class="col-md-1">
                                                    <label for="" class="form-label"></label>
                                                    <div class="mb-3 mt-2">
                                                        <a href="javascript:void(0);" id="viewDetails" title="Search OD" class="btn btn-primary"><i class="fa-sharp fa-solid fa-magnifying-glass">OD</i></a>
                                                    </div>
                                                </div>
                                                <!-- TOTAL DAYS -->
                                                <div class="col-md-2">
                                                    <div class="mb-3">
                                                        <label for="total_days" class="form-label">TOTAL DAYS</label>
                                                        <input type="text" name="total_days" id="total_days" class="form-control dull" value="{{ old('total_days', $result['Tot_Day']) }}" readonly>
                                                    </div>
                                                </div>
                                                <!-- ADD EXPENSE LIST -->
                                                <div class="col-md-2 d-none">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">ADD LIST</label>
                                                        <div class="input-group">
                                                            <button type="button" class="btn btn-secondary" onclick="decreaseExpValue()">-</button>
                                                            <input type="number" class="form-control text-center" value="1" id="addExpense" name="N_Per" onchange="validateExpInput()" oninput="validateExpInput()" style="max-width: 60px;">
                                                            <button type="button" class="btn btn-secondary" onclick="increaseExpValue()">+</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- SECOND ROW -->
                                            <div class="row">
                                                <!-- UP -->
                                                <div class="col-md-3">
                                                    <div class="mb-2">
                                                        <label for="to" class="form-label">UPWARDS<span class="login-danger">*</span></label>
                                                        <select class="form-select" name="up_to" id="up_to" required>
                                                            <option value="{{ $result['Vehicle_Mode_Up'] }}">{{ $result['Vehicle_Mode_Up'] }}</option>
                                                        </select>
                                                        <input type="hidden" name="up_to_text" value="{{ $result['Vehicle_Mode_Up'] }}" id="hidden_up_to">
                                                    </div>
                                                </div>
                                                <!-- UP AMOUNT -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="upAmt" class="form-label">AMOUNT<span class="login-danger">*</span></label>
                                                        <input type="number" step="0.01" value="{{ $result['Vehicle_Mode_Up_Amt'] }}" name="up_to_amt" id="upAmt" class="form-control" placeholder="Rs.00" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-1 d-none"></div>
                                                <!-- DOWN -->
                                                <div class="col-md-3">
                                                    <div class="mb-2">
                                                        <label for="to" class="form-label">RETURN<span class="login-danger">*</span></label>
                                                        <select class="form-select" name="down_to" id="down_to" required>
                                                            <option value="{{ $result['Vehicle_Mode_Down'] }}">{{ $result['Vehicle_Mode_Down'] }}</option>
                                                        </select>
                                                        <input type="hidden" name="down_to_text" value="{{ $result['Vehicle_Mode_Down'] }}" id="hidden_down_to">
                                                    </div>
                                                </div>
                                                <!-- DOWN AMOUNT -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="downAmt" class="form-label">AMOUNT<span class="login-danger">*</span></label>
                                                        <input type="number" value="{{ $result['Vehicle_Mode_Down_Amt'] }}" name="down_to_amt" id="downAmt" class="form-control" placeholder="Rs.00" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- EXPENSE TABLE -->
                                            <h6 style="font-weight: bold;">EXPENSES</h6>
                                            <div class="card-body" style="display:block;">
                                                <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                                    <table class="table table-centered align-middle table-nowrap mb-0" id="expenseTable" style="line-height: 10px !important;">
                                                        <thead class="text-muted table-light sticky-header">
                                                            <tr>
                                                                <th data-sort="sno"> SNO <span class="sort-icon"></span></th>
                                                                <th data-sort="description"> Description <span class="login-danger">*</span> <span class="sort-icon"></span></th>
                                                                <th data-sort="hotel"> Hotel <span class="sort-icon"></span></th>
                                                                <th data-sort="food"> Food <span class="sort-icon"></span></th>
                                                                <th data-sort="misc"> Miscellaneous <span class="sort-icon"></span></th>
                                                                <th data-sort="cab"> Auto/Cab <span class="sort-icon"></span></th>
                                                                <th data-sort="toll"> Toll <span class="sort-icon"></span></th>
                                                                <th data-sort="park"> Parking <span class="sort-icon"></span></th>
                                                                <th data-sort="total"> Total <span class="sort-icon"></span></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="tableBodyExp">
                                                            <tr>
                                                                <td>Current Entry</td>
                                                                <td class="d-none">
                                                                    <input type="date" class="form-control" name="expense[0][date]" id="">
                                                                </td>
                                                                <td>
                                                                    <input type="text" class="form-control" value="{{ $result['Reason'] }}" name="expense[0][description]" id="" placeholder="Reason" required>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][hotel]" id="" placeholder="Rs.00">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][food]" id="" placeholder="Rs.00">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][misc]" id="" placeholder="Rs.00">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][cab]" id="" placeholder="Rs.00">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][toll]" id="" placeholder="Rs.00">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][park]" id="" placeholder="Rs.00">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control total-expense dull" name="expense[0][total]" id="" placeholder="Rs.00" readonly>
                                                                </td>
                                                                <td class="d-none">
                                                                    <input type="checkbox" class="col-lg-6" name="expense[0][with_bill]" id="">
                                                                </td>
                                                                <td class="d-none">
                                                                    <button type="button" class="btn btn-danger removeExpRow">X</button>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Previous Entry</td>
                                                                <td>
                                                                    <input type="text" class="form-control dull" value="{{ $result['Reason'] }}" id="" placeholder="Reason" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control dull" value="{{ $result['Hotel'] }}" id="" placeholder="Rs.00" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control dull" value="{{ $result['Food'] }}" id="" placeholder="Rs.00" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control dull" value="{{ $result['Misc'] }}" id="" placeholder="Rs.00" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control dull" value="{{ $result['Auto_Cab'] }}" id="" placeholder="Rs.00" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control dull" value="{{ $result['Toll'] }}" id="" placeholder="Rs.00" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control dull" value="{{ $result['Parking'] }}" id="" placeholder="Rs.00" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control dull" value="{{ $result['Total'] }}" id="" placeholder="Rs.00" readonly>
                                                                </td>
                                                                <td class="d-none">
                                                                    <input type="checkbox" class="col-lg-6" name="expense[0][with_bill]" id="">
                                                                </td>
                                                                <td class="d-none">
                                                                    <button type="button" class="btn btn-danger removeExpRow">X</button>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                        <tfoot class="sticky-footer d-none">
                                                            <tr>
                                                                <td colspan="2" style="text-align: end;"><b>Total</b></td>
                                                                <td><input type="text" id="totalTransport" class="form-control" disabled></td>
                                                                <td><input type="text" id="totalHotel" class="form-control" disabled></td>
                                                                <td><input type="text" id="totalFood" class="form-control" disabled></td>
                                                                <td><input type="text" id="totalMisc" class="form-control" disabled></td>
                                                                <td><input type="text" id="totalCab" class="form-control" disabled></td>
                                                                <td><input type="text" id="totalToll" class="form-control" disabled></td>
                                                                <td><input type="text" id="grandTotal" name="grandTotal" class="form-control dull" readonly></td>
                                                                <td></td>
                                                            </tr>
                                                        </tfoot>
                                                    </table>
                                                </div>
                                            </div>
                                            <!-- GRAND TOTAL -->
                                            <div class="d-flex align-items-center gap-2 mt-1 mb-0">
                                                <label for="grandTotAmt" class="form-label mb-0">GRAND TOTAL<span class="login-danger">*</span></label>
                                                <input type="number" id="grandTotAmt" class="form-control" value="{{ $result['Total_Amount'] }}" placeholder="Rs.00" readonly style="width: 150px;">
                                            </div>
                                            <br>
                                            <!-- TRAVEL PURPOSE (REMARKS) -->
                                            <div class="row">
                                                <div class="col-md-4 mt-0">
                                                    <label for="validationTextarea" class="form-label">TRAVEL PURPOSE :<span class="login-danger"></span></label>
                                                </div>
                                                <div class="col-md-4 mb-2 d-none">
                                                    <input type="file" name="File1" class="form-control">
                                                </div>
                                                <div class="col-md-4 mb-2 d-none">
                                                    <input type="file" name="File2" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <textarea class="form-control" name="Remark" rows="2" placeholder="Enter Remarks...">{{ $result['Remark'] }}</textarea>
                                            </div>
                                            <br>
                                            <!--  SUBMIT BUTTON -->
                                            <div class="d-flex justify-content-around pb-2">
                                                <input type="submit" value="SUBMIT" id="saveButton" class="btn btn-primary">
                                                <button type="button" class="btn btn-info" onclick="window.location.href = '/travExp_Rep'">Report</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal for Details -->
    <div id="odEntryDetailsModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="odEntryDetailsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="odEntryDetailsModalLabel">trvAdvEnty Details</h5>
                    <button type="button" class="close btnok bg-light btn" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table" id="table_det">
                        <thead class="text-muted table-light">
                            <tr>
                                <th data-sort="sno">SNO <span class="sort-icon"></span></th>
                                <th data-sort="entDate">Entry Date <span class="sort-icon"></span></th>
                                <th data-sort="to_date">To Date <span class="sort-icon"></span></th>
                                <th data-sort="daytype">Day Type <span class="sort-icon"></span></th>
                                <th data-sort="remark">Remark <span class="sort-icon"></span></th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-success btnok" data-dismiss="modal">OK</button>
                    <button type="button" class="btn btn-secondary btncancel" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

    <!-- FILL DETAILS USING AJAX & DATE VALIDATION-->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let fromDateInput = document.getElementById("from_date");
            let toDateInput = document.getElementById("to_date");
            let totalDaysInput = document.getElementById("total_days");
            let container = document.getElementById("inputContainer");
            let amounts = {}; // Store expense amounts

            // ✅ Make updateAmounts global
            window.updateAmounts = function() {
                let totalDays = totalDaysInput.value;
                container.innerHTML = ""; // Clear previous inputs
                container.classList.add("d-none");

                if (!amounts || Object.keys(amounts).length === 0) return; // Ensure amounts are loaded

                createInput("totAmtBoard", "totAmtBoard", amounts.Tot_Boadring * totalDays);
                createInput("totAmtFood", "totAmtFood", amounts.Tot_Food * totalDays);
                createInput("amtIncidental", "amtIncidental", amounts.Incidental * totalDays);
                createInput("amtCab", "amtCab", amounts.Cab);
                createInput("amtToll", "amtToll", amounts.Toll);
                createInput("amtPark", "amtPark", amounts.Parking);

                updateExpenseInputs(totalDays);
            };

            totalDaysInput.addEventListener("input", updateAmounts);

            function updateExpenseInputs(totalDays) {
                const Travel_Tiers = @json($Travel_Tiers);
                let DesigCatId = document.getElementById("desigCatId")?.value || 0;

                let hotelInput = document.querySelector("input[name='expense[0][hotel]']");
                let foodInput = document.querySelector("input[name='expense[0][food]']");
                let miscInput = document.querySelector("input[name='expense[0][misc]']");
                let cabInput = document.querySelector("input[name='expense[0][cab]']");
                let tollInput = document.querySelector("input[name='expense[0][toll]']");
                let parkInput = document.querySelector("input[name='expense[0][park]']");

                if (Travel_Tiers != 1 || DesigCatId != 2) {
                    if (hotelInput) hotelInput.value = amounts.Tot_Boadring * totalDays;
                    if (foodInput) foodInput.value = amounts.Tot_Food * totalDays;
                    if (miscInput) miscInput.value = amounts.Incidental * totalDays;
                    if (cabInput) cabInput.value = amounts.Cab;
                    if (tollInput) tollInput.value = amounts.Toll;
                    if (parkInput) parkInput.value = amounts.Parking;
                    updateTotalExpense();
                }
            }

            function updateTotalExpense() {
                let hotel = parseFloat($("input[name='expense[0][hotel]']").val()) || 0;
                let food = parseFloat($("input[name='expense[0][food]']").val()) || 0;
                let misc = parseFloat($("input[name='expense[0][misc]']").val()) || 0;
                let cab = parseFloat($("input[name='expense[0][cab]']").val()) || 0;
                let toll = parseFloat($("input[name='expense[0][toll]']").val()) || 0;
                let park = parseFloat($("input[name='expense[0][park]']").val()) || 0;

                let total = hotel + food + misc + cab + toll + park;
                $("input[name='expense[0][total]']").val(total.toFixed(2));

                updateGrandTotalExpense();
            }

            function updateGrandTotalExpense() {
                let gridTot = parseFloat($("input[name='expense[0][total]']").val()) || 0;
                let upAmt = parseFloat($("#upAmt").val()) || 0;
                let downAmt = parseFloat($("#downAmt").val()) || 0;
                let grandTotal = gridTot + upAmt + downAmt;
                $("#grandTotAmt").val(grandTotal.toFixed(2));
            }

            // Attach event listener to update total when any input changes
            $(".expense-input").on("input", updateTotalExpense);
            $("#upAmt, #downAmt").on("input change", updateGrandTotalExpense);


            function createInput(id, name, value) {
                let input = document.createElement("input");
                input.type = "text";
                input.name = name;
                input.value = value;
                input.classList.add("form-control");
                input.id = id;
                container.appendChild(input);
            }

            fromDateInput.addEventListener("change", function() {
                toDateInput.min = fromDateInput.value;
                // calculateDays();
            });
            // toDateInput.addEventListener("change", calculateDays);

            // AJAX to fetch amounts
            $('#destinationSelect').on('select2:select', function(e) {
                resetInputs();
                var selectedOption = $(this).find(":selected");
                var rowId = selectedOption.data("row-id");
                var catId = selectedOption.data("cat-id");
                document.getElementById("desigCatId").value = catId;

                $.ajax({
                    url: "{{ route('travExpAmtLevel') }}",
                    type: "GET",
                    data: {
                        id: rowId,
                        catid: catId
                    },
                    success: function(response) {
                        if (!response.res || response.res.length === 0) {
                            alert("No data found for this selected Destination. Contact Accounts");
                            $('#destinationSelect').val('').trigger('change'); // if using select2
                            return;
                        }

                        amounts = response.res[0]; // Store amounts

                        let cols = response.columns || {};
                        let up = $('#up_to');
                        let down = $('#down_to');

                        up.empty().append('<option value="" disabled selected>--VEHICLE MODE--</option>');
                        down.empty().append('<option value="" disabled selected>--VEHICLE MODE--</option>');

                        $.each(cols, function(column, value) {
                            if (value > 0) {
                                let option = `<option value="${value}">${column}</option>`;
                                up.append(option);
                                down.append(option);
                            }
                        });

                        // Always append 'Company Car'
                        up.append('<option value="Company Car">Company Car</option>');
                        down.append('<option value="Company Car">Company Car</option>');

                        // calculateDays();
                    },
                    error: function(xhr, status, error) {
                        console.error("AJAX Error: ", status, error);
                        alert("An error occurred while fetching data. Please try again.");
                    }
                });
            });

            function resetInputs() {
                // $("#total_days").val("");
                $("#inputContainer").empty(); // Clear dynamically created inputs
                amounts = {}; // Reset stored amounts
                $('#up_to').empty();
                $('#down_to').empty();

                // Reset the predefined input fields if they exist
                $("input[name='expense[0][hotel]']").val("");
                $("input[name='expense[0][food]']").val("");
                $("input[name='expense[0][misc]']").val("");
                $("input[name='expense[0][cab]']").val("");
                $("input[name='expense[0][toll]']").val("");
                $("input[name='expense[0][park]']").val("");
            }

            // calculateDays(); // Initial calculation
        });
    </script>

    <!-- UP AND DOWN VALIDATION -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            function validateAmount(selectId, inputId, hiddenInputId) {
                const Travel_Tiers = @json($Travel_Tiers);
                let selectElement = document.getElementById(selectId);
                let inputElement = document.getElementById(inputId);
                let hiddenInput = document.getElementById(hiddenInputId);

                if (!selectElement || !inputElement) {
                    console.error(`Element not found: ${selectId} or ${inputId}`);
                    return;
                }

                selectElement.addEventListener("change", function() {
                    let DesigCatId = document.getElementById("desigCatId")?.value || 0;
                    let selectedOption = selectElement.options[selectElement.selectedIndex];
                    let maxValue = parseFloat(selectedOption.value) || 0;
                    let selectedText = selectedOption.text.trim(); // Get text

                    if (Travel_Tiers == 1 || DesigCatId == 2) {
                        inputElement.value = 0;
                    } else {
                        inputElement.value = maxValue;
                    }

                    // CHECK AND DISABLE VEHICLE MODE AND DISABLED AMOUNT INPUT
                    let selectOptionText = selectedOption.text.trim();
                    if (selectOptionText == 'Company Car') {
                        inputElement.setAttribute('disabled', 'disabled');
                    } else {
                        inputElement.removeAttribute('disabled');
                    }

                    hiddenInput.value = selectedText; // Store text separately
                    inputElement.removeAttribute("readonly");
                    checkOwnBikeSelection();
                });

                inputElement.addEventListener("input", function() {
                    let total_days = document.getElementById("total_days")?.value || 0;
                    if (total_days == 0 || total_days == "") {
                        alert("Choose OD Date first");
                        inputElement.value = 0;
                        return;
                    }
                    let DesigCatId = document.getElementById("desigCatId")?.value || 0;
                    if (Travel_Tiers != 1 && DesigCatId != 2) {
                        let maxValue = parseFloat(selectElement.value) || 0;
                        let enteredValue = parseFloat(inputElement.value) || 0;
                        if (enteredValue > maxValue) {
                            alert("Entered amount cannot exceed the allowed amount");
                            inputElement.value = maxValue;
                        }
                    }
                });
            }

            function checkOwnBikeSelection() {
                let upToSelect = document.getElementById("up_to");
                let downToSelect = document.getElementById("down_to");
                let cabInput = document.querySelector("input[name='expense[0][cab]']");
                let tollInput = document.querySelector("input[name='expense[0][toll]']");
                let upAmtInput = document.getElementById("upAmt");
                let downAmtInput = document.getElementById("downAmt");
                let hiddenUpTo = document.getElementById("hidden_up_to");
                let hiddenDownTo = document.getElementById("hidden_down_to");

                // Get selected text, not value
                let upToText = upToSelect.options[upToSelect.selectedIndex].text.trim();
                let downToText = downToSelect.options[downToSelect.selectedIndex].text.trim();

                // Update hidden inputs
                hiddenUpTo.value = upToText;
                hiddenDownTo.value = downToText;

                if (upToText === "OwnBike" || upToText === "OwnCar") {
                    downToSelect.value = upToSelect.value; // Force selection to match
                    downAmtInput.value = upAmtInput.value;
                    downToSelect.setAttribute("disabled", "disabled");
                    downToSelect.style.cursor = "not-allowed";
                    downToSelect.style.backgroundColor = "#f8d7da";
                    downToSelect.style.opacity = "0.6";
                } else {
                    downToSelect.removeAttribute("disabled");
                    downToSelect.style.cursor = "pointer";
                    downToSelect.style.backgroundColor = "";
                    downToSelect.style.opacity = "1";
                }

                if (upToText === "OwnBike") {
                    downToSelect.value = upToSelect.value;
                    downAmtInput.value = upAmtInput.value;
                    tollInput.setAttribute("disabled", "disabled");
                    tollInput.style.cursor = "not-allowed";
                    tollInput.style.backgroundColor = "#f8d7da";
                    tollInput.style.opacity = "0.6";
                } else {
                    tollInput.removeAttribute("disabled");
                    tollInput.style.cursor = "pointer";
                    tollInput.style.backgroundColor = "";
                    tollInput.style.opacity = "1";
                }

                if (upToText === "OwnBike" && downToText === "OwnBike" ||
                    upToText === "OwnCar" && downToText === "OwnCar" ||
                    upToText === "OwnCar" && downToText === "OwnBike" ||
                    upToText === "OwnBike" && downToText === "OwnCar") {
                    cabInput.value = "";
                    cabInput.setAttribute("disabled", "disabled");
                    cabInput.style.cursor = "not-allowed";
                    cabInput.style.backgroundColor = "#f8d7da";
                    cabInput.style.opacity = "0.6";
                } else {
                    cabInput.removeAttribute("disabled");
                    cabInput.style.cursor = "text";
                    cabInput.style.backgroundColor = "";
                    cabInput.style.opacity = "1";
                }
            }

            // Attach event listeners
            document.getElementById("up_to").addEventListener("change", checkOwnBikeSelection);
            document.getElementById("down_to").addEventListener("change", checkOwnBikeSelection);
            // Apply validation
            validateAmount("up_to", "upAmt", "hidden_up_to");
            validateAmount("down_to", "downAmt", "hidden_down_to");
        });
    </script>

    <!-- CONDITIONS FOR ADD EXPENSE INPUT -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const tableBody = document.getElementById("tableBodyExp");

            // Function to calculate total
            function calculateTotal(row) {
                let total = 0;
                row.querySelectorAll(".expense-input").forEach(input => {
                    total += parseFloat(input.value) || 0;
                });
                row.querySelector(".total-expense").value = total.toFixed(2);
            }

            function calculateGrandTotal() {
                let totalTrans = 0,
                    totalHotel = 0,
                    totalFood = 0,
                    totalMisc = 0,
                    totalCab = 0,
                    totalToll = 0,
                    totalGrand = 0;

                document.querySelectorAll("#tableBodyExp tr").forEach(row => {
                    totalTrans += parseFloat(row.children[3].querySelector("input").value) || 0;
                    totalHotel += parseFloat(row.children[4].querySelector("input").value) || 0;
                    totalFood += parseFloat(row.children[5].querySelector("input").value) || 0;
                    totalMisc += parseFloat(row.children[6].querySelector("input").value) || 0;
                    totalCab += parseFloat(row.children[7].querySelector("input").value) || 0;
                    totalToll += parseFloat(row.children[8].querySelector("input").value) || 0;
                    totalGrand += parseFloat(row.children[9].querySelector("input").value) || 0;
                });
                document.getElementById("totalTransport").value = totalTrans.toFixed(2);
                document.getElementById("totalHotel").value = totalHotel.toFixed(2);
                document.getElementById("totalFood").value = totalFood.toFixed(2);
                document.getElementById("totalMisc").value = totalMisc.toFixed(2);
                document.getElementById("totalCab").value = totalCab.toFixed(2);
                document.getElementById("totalToll").value = totalToll.toFixed(2);
                document.getElementById("grandTotal").value = totalGrand.toFixed(2);
            }

            function validateExpenseAmounts() {
                const Travel_Tiers = @json($Travel_Tiers);
                let DesigCatId = document.getElementById("desigCatId")?.value || 0;
                if (Travel_Tiers != 1 && DesigCatId != 2) {

                    alert("Travel_Tiers " + Travel_Tiers + " " + "DesigCatId " + DesigCatId);
                    // let totAmtTrv = parseFloat(document.getElementById("totAmtTrv").value) || 0;
                    // let totAmtFood = parseFloat(document.getElementById("totAmtFood").value) || 0;
                    // let totAmtBoard = parseFloat(document.getElementById("totAmtBoard").value) || 0;
                    // let amtOthers = parseFloat(document.getElementById("amtIncidental").value) || 0;
                    // let amtCab = parseFloat(document.getElementById("amtCab").value) || 0;
                    // let amtToll = parseFloat(document.getElementById("amtToll").value) || 0;
                    // let totalTransport = 0,
                    //     totalHotel = 0,
                    //     totalFood = 0,
                    //     totalMisc = 0,
                    //     totalCab = 0,
                    //     totalToll = 0;
                    // // Loop through all rows and calculate the total expense per category
                    // document.querySelectorAll("#tableBodyExp tr").forEach(row => {
                    //     let inputHotel = row.querySelector("input[name^='expense'][name$='[hotel]']");
                    //     let inputFood = row.querySelector("input[name^='expense'][name$='[food]']");
                    //     let inputMisc = row.querySelector("input[name^='expense'][name$='[misc]']");
                    //     let inputCab = row.querySelector("input[name^='expense'][name$='[cab]']");
                    //     let inputToll = row.querySelector("input[name^='expense'][name$='[toll]']");

                    //     totalHotel += parseFloat(inputHotel.value) || 0;
                    //     totalFood += parseFloat(inputFood.value) || 0;
                    //     totalMisc += parseFloat(inputMisc.value) || 0;
                    //     totalCab += parseFloat(inputCab.value) || 0;
                    //     totalToll += parseFloat(inputToll.value) || 0;
                    // });

                    // Get allowed amounts
                    let alwAmtBoard = parseFloat(document.getElementById("totAmtBoard")?.value) || 0;
                    let alwAmtFood = parseFloat(document.getElementById("totAmtFood")?.value) || 0;
                    let alwAmtMisc = parseFloat(document.getElementById("amtIncidental")?.value) || 0;
                    let alwAmtCab = parseFloat(document.getElementById("amtCab")?.value) || 0;
                    let alwAmtToll = parseFloat(document.getElementById("amtToll")?.value) || 0;
                    let alwAmtPark = parseFloat(document.getElementById("amtPark")?.value) || 0;

                    // Get input values and convert them to numbers
                    let inputHotel = parseFloat(document.querySelector("input[name='expense[0][hotel]']")?.value) || 0;
                    let inputFood = parseFloat(document.querySelector("input[name='expense[0][food]']")?.value) || 0;
                    let inputMisc = parseFloat(document.querySelector("input[name='expense[0][misc]']")?.value) || 0;
                    let inputCab = parseFloat(document.querySelector("input[name='expense[0][cab]']")?.value) || 0;
                    let inputToll = parseFloat(document.querySelector("input[name='expense[0][toll]']")?.value) || 0;
                    let inputPark = parseFloat(document.querySelector("input[name='expense[0][park]']")?.value) || 0;

                    let total_days = document.getElementById("total_days")?.value || 0;
                    if (total_days == 0 || total_days == "") {
                        alert("Choose OD Date first");
                        return;
                    }

                    // Validate each expense
                    if (inputHotel > alwAmtBoard) {
                        alert(`Total boarding expenses exceed the allowed Rs.${alwAmtBoard}!`);
                        document.querySelector("input[name='expense[0][hotel]']").value = alwAmtBoard;
                        return false;
                    }
                    if (inputFood > alwAmtFood) {
                        alert(`Total food expenses exceed the allowed Rs.${alwAmtFood}!`);
                        document.querySelector("input[name='expense[0][food]']").value = alwAmtFood;
                        return false;
                    }
                    if (inputMisc > alwAmtMisc) {
                        alert(`Total miscellaneous expenses exceed the allowed Rs.${alwAmtMisc}!`);
                        document.querySelector("input[name='expense[0][misc]']").value = alwAmtMisc;
                        return false;
                    }
                    if (inputCab > alwAmtCab) {
                        alert(`Total Auto/Cab expenses exceed the allowed Rs.${alwAmtCab}!`);
                        document.querySelector("input[name='expense[0][cab]']").value = alwAmtCab;
                        return false;
                    }
                    if (inputToll > alwAmtToll) {
                        alert(`Total Toll expenses exceed the allowed Rs.${alwAmtToll}!`);
                        document.querySelector("input[name='expense[0][toll]']").value = alwAmtToll;
                        return false;
                    }
                    if (inputPark > alwAmtPark) {
                        alert(`Total Park expenses exceed the allowed Rs.${alwAmtPark}!`);
                        document.querySelector("input[name='expense[0][park]']").value = alwAmtPark;
                        return false;
                    }

                    return true; // Validation successful
                }
            }

            // Event listener for input changes
            tableBody.addEventListener("input", function(event) {
                if (event.target.classList.contains("expense-input")) {
                    const row = event.target.closest("tr");
                    calculateTotal(row);
                    calculateGrandTotal();
                    if (!validateExpenseAmounts()) {
                        // event.target.value = "";
                        calculateTotal(row);
                        calculateGrandTotal();
                    }
                }
            });

            // Remove row event
            tableBody.addEventListener("click", function(event) {
                if (event.target.classList.contains("removeExpRow")) {
                    if (tableBody.getElementsByTagName('tr').length > 1) {
                        event.target.closest("tr").remove();
                        updateRowNumbers(); // Renumber rows after deletion
                        updateAddExpenseInput(); // Update the addExpense input value
                        calculateGrandTotal();
                    } else {
                        alert("You must have at least one row in the table.");
                    }
                }
            });
        });
    </script>

    <!-- SHOWING OD ENTRY DETAIL MODAL -->
    <script>
        $(document).ready(function() {
            function resetFields() {
                $('#from_date, #to_date').val('');
                $('input[type=radio]').prop('checked', false);
                disableSaveButton();
            }

            function enableSaveButton() {
                $('#saveButton').prop('disabled', false);
            }

            function disableSaveButton() {
                $('#saveButton').prop('disabled', true);
            }
            $(document).on('click', '.od_viewButton', function() {
                $('#odEntryDetailsModal').modal('show');

                // Attach click event to table rows
                $('#table_det tbody tr').off('click').on('click', function(event) {
                    // Prevent event propagation if the radio button itself is clicked
                    if (event.target.type === 'radio') return;

                    // Find and check the radio button in the clicked row
                    const $radioButton = $(this).find('input[type=radio]');
                    $radioButton.prop('checked', true).trigger('change');
                });

                // Event for radio buttons when clicked
                $('input[type=radio][name=trvAdvEntyModal_radio]').off('change').on('change', function() {
                    const selectedData = $(this).data();
                    // console.log(selectedData);
                    // Convert "DD-MM-YYYY HH:mm:ss" to "YYYY-MM-DD"
                    const fromDateParts = selectedData.edate.split(" ")[0].split("-");
                    const toDateParts = selectedData.todate.split(" ")[0].split("-");

                    const formattedFromDate = `${fromDateParts[2]}-${fromDateParts[1]}-${fromDateParts[0]}`;
                    const formattedToDate = `${toDateParts[2]}-${toDateParts[1]}-${toDateParts[0]}`;

                    $('#from_date').val(formattedFromDate);
                    $('#to_date').val(formattedToDate);

                    enableSaveButton();
                });

                $('.btncancel').off('click').on('click', function() {
                    resetFields();
                    $('#odEntryDetailsModal').modal('hide');
                });

                $('.btnok').off('click').on('click', function() {
                    $('#odEntryDetailsModal').modal('hide');
                });
            });
        });
    </script>

    <!-- OD DETAIL (DATE) -->
    <script>
        $(document).ready(function() {
            function resetFields() {
                $('#from_date, #to_date, #total_days').val('');
                $('input[type=radio]').prop('checked', false);
                disableSaveButton();
                location.reload();
            }

            function enableSaveButton() {
                $('#saveButton').prop('disabled', false);
            }

            function disableSaveButton() {
                $('#saveButton').prop('disabled', true);
            }

            $('#from_date, #to_date').on('change', function() {
                disableSaveButton();
            });

            $('#viewDetails').click(function() {
                var a = $('#destinationSelect').val();
                if (a == '' || a == null) {
                    alert("Choose Destination First");
                    return;
                }

                var fDate = $('#from_date').val();
                var tDate = $('#to_date').val();

                if (fDate == '') {
                    alert('Choose From Date');
                    return;
                }
                if (tDate == '') {
                    alert('Choose To Date');
                    return;
                }

                console.log(fDate, tDate);

                $.ajax({
                    url: "{{ route('TExpenseOdDtls') }}",
                    type: "GET",
                    data: {
                        fdate1: fDate,
                        tdate1: tDate
                    },
                    success: function(response) {
                        var res = response.odRep;
                        console.table(res);

                        var totalAttDays = 0;
                        var firstHalfDay = false;
                        var encounteredOne = false;

                        for (var i = 0; i < res.length; i++) {
                            var attDay = parseFloat(res[i].Att_days) || 0;

                            if (attDay === 0.5) {
                                if (encounteredOne) {
                                    break; // Ignore 0.5 if we already encountered 1
                                }
                                if (!firstHalfDay) {
                                    firstHalfDay = true;
                                    totalAttDays = 0.5;
                                } else {
                                    totalAttDays = 0.5; // If first two entries are 0.5, result stays 0.5
                                    break;
                                }
                            } else if (attDay === 1) {
                                if (firstHalfDay) {
                                    totalAttDays = 1; // If first was 0.5 and now 1, make it 1
                                } else {
                                    totalAttDays += 1; // Sum all 1s
                                }
                                encounteredOne = true;
                            }
                        }

                        $('#total_days').val(totalAttDays);

                        var showAlert = response.odRep.some(row =>
                            row.To_Date === "No Record" &&
                            row.Day_Type === "No Status" &&
                            row.Remark === "No Record"
                        );

                        // ✅ Call updateAmounts after setting total_days
                        if (typeof updateAmounts === "function") {
                            updateAmounts();
                        }

                        // Show alert if the condition is met
                        if (showAlert) {
                            alert("Given travel dates have No OD entries.Please apply for ON duty immediately.!");
                            disableSaveButton();
                            resetFields();
                        } else {
                            enableSaveButton();
                        }

                        // ✅ Calculate the sum of Att_days
                        // var totalAttDays = res.reduce((sum, row) => sum + (parseFloat(row.Att_days) || 0), 0);

                        // var totalAttDays = 0;
                        // var firstHalfDayTaken = false;
                        // var encounteredOne = false;

                        // for (var i = 0; i < res.length; i++) {
                        //     var attDay = parseFloat(res[i].Att_days) || 0;

                        //     if (attDay === 1) {
                        //         if (totalAttDays === 0.5) {
                        //             totalAttDays = 1.5; // 0.5 + 1 = 1.5
                        //         } else {
                        //             totalAttDays = 1; // Set total to 1 and stop further addition
                        //         }
                        //         encounteredOne = true;
                        //         break;
                        //     } else if (attDay === 0.5) {
                        //         if (!firstHalfDayTaken) {
                        //             totalAttDays = 0.5; // Take the first 0.5
                        //             firstHalfDayTaken = true;
                        //         }
                        //     }
                        // }

                        // var totalAttDays = 0;
                        // var halfDayCount = 0;
                        // var fullDayCount = 0;
                        // for (var i = 0; i < res.length; i++) {
                        //     var attDay = parseFloat(res[i].Att_days) || 0;

                        //     if (attDay === 1) {
                        //         fullDayCount++;
                        //     } else if (attDay === 0.5) {
                        //         halfDayCount++;
                        //     }
                        // }
                        // // **Apply logic based on the required conditions**
                        // if (halfDayCount === 2 && fullDayCount === 1) {
                        //     totalAttDays = 0.5; // ✅ 0.5 + 0.5 + 1 = 0.5
                        // } else if (halfDayCount === 3 && fullDayCount === 1) {
                        //     totalAttDays = 0.5; // ✅ 0.5 + 0.5 + 1 + 0.5 = 0.5
                        // } else if (halfDayCount === 1 && fullDayCount === 1) {
                        //     totalAttDays = 1; // ✅ 0.5 + 1 = 1
                        // } else if (fullDayCount === 1 && halfDayCount === 2) {
                        //     totalAttDays = 1; // ✅ 1 + 0.5 + 0.5 = 1
                        // } else if (fullDayCount === 2) {
                        //     totalAttDays = 2; // ✅ 1 + 1 = 2
                        // } else if (fullDayCount === 1) {
                        //     totalAttDays = 1; // ✅ At least one full day results in 1
                        // } else if (halfDayCount >= 2) {
                        //     totalAttDays = 0.5; // ✅ Two or more half days = 0.5
                        // } else if (halfDayCount === 1) {
                        //     totalAttDays = 0.5; // ✅ A single half day remains 0.5
                        // }
                    }
                })
            });
        });
    </script>

    <!-- SEARCH -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <!-- SUCCESS MESSAGE -->
    @if (session('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{ session('success') }}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('alert'))
    <div id="errorAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        setTimeout(function() {
            var errorAlert = document.getElementById('errorAlert');
            if (errorAlert) {
                errorAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>