<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>TRAVEL POLICY MASTER</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }

        .sticky-header {
            position: sticky;
            top: 0;
            z-index: 1;
        }

        .sticky-footer {
            position: sticky;
            bottom: 0;
            z-index: 1;
            background-color: whitesmoke;
        }
    </style>
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->

    <style>
        h2 {
            text-align: center;
            margin-bottom: 10px;
            color: #333;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 0px;
        }

        th,
        td {
            padding: 10px;
            text-align: left;
            border: 1px solid #ddd;
            font-weight: bold !important;
        }

        th {
            background: #007BFF !important;
            color: white !important;
            text-align: center !important;
            font-weight: bold !important;
            font-size: larger !important;
        }

        input,
        select {
            width: 100%;
            padding: 8px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        input::placeholder {
            color: gray;
        }

        tr:hover {
            background: #f1f1f1;
        }
    </style>

    <style>
        input:disabled {
            background-color: #f8d7da !important;
            color: #721c24 !important;
            border: 1px solid #f5c6cb !important;
            cursor: not-allowed;
        }
    </style>

</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->
    @section('tittle') {{"TRAVEL POLICY MASTER"}}@endsection

    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="live-preview">
                                        <form method="POST" action=" {{ route('TExpenseEntryMasterSave')}} " enctype="multipart/form-data" class="has-validated" id="validate">
                                            @csrf
                                            <div class="row">
                                                <!-- ENO -->
                                                <div class="col-md-1 d-none">
                                                    <div class="mb-2">
                                                        <label for="firstNameinput" class="form-label">ENO</label>
                                                        <input type="text" name="ENo" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- DESITINATION -->
                                                <div class="col-md-3">
                                                    <div class="mb-2">
                                                        <label for="to" class="form-label">DESTINATION</label>
                                                        <select class="form-select select2" id="destinationSelect" name="to" required>
                                                            <option value="" disabled {{ old('to') ? '' : 'selected' }}>--SELECT DESTINATION--</option>
                                                            @foreach($cityMas as $city)
                                                            <option value="{{ $city['Rowid'] }}"
                                                                data-cat-id="{{ $city['Cat_ID'] }}"
                                                                data-cat-name="{{ $city['Cat_Name'] }}"
                                                                {{ old('to') == $city['Rowid'] ? 'selected' : '' }}>
                                                                {{ $city['Name'] }}
                                                            </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <input type="hidden" id="storedCatId" value="{{ old('travelType') }}">
                                                </div>
                                                <!-- INPUTS TO DISPLAY CAT_NAME AND CAT_ID -->
                                                <div class="col-md-3">
                                                    <div class="mb-2">
                                                        <label for="travelTypeName" class="form-label">TRAVEL CATEGORY</label>
                                                        <input type="text" name="travelTypeName" class="form-control" value="{{ old('travelType') }}" id="catName" readonly>
                                                        <input type="hidden" name="travelType" class="form-control" id="catId" value="{{ old('travelType') }}" readonly>
                                                    </div>
                                                </div>
                                                <!-- CITY TIER -->
                                                <div class="col-md-2">
                                                    <div class="mb-2">
                                                        <label for="citytier" class="form-label">CITY TIER</label>
                                                        <select class="form-select" name="citytier" required onchange="disableTiers(this.value)">
                                                            <option value="" disabled {{ old('citytier') ? '' : 'selected' }}>--SELECT CITY--</option>
                                                            @foreach($cityTier as $tier)
                                                            <option value="{{ $tier['Rowid'] }}" {{ old('citytier') == $tier['Rowid'] ? 'selected' : '' }}>{{ $tier['Name'] }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <!-- KM -->
                                                <div class="col-md-2">
                                                    <div class="mb-2">
                                                        <label for="km" class="form-label">KM</label>
                                                        <input type="number" name="km" class="form-control" value="{{ old('km') }}" required>
                                                    </div>
                                                </div>
                                                <!-- EFFECT FROM -->
                                                <div class="col-md-2">
                                                    <div class="mb-2">
                                                        <label for="effectFrom" class="form-label">EFFECT FROM</label>
                                                        <input type="date" name="effectFrom" class="form-control" min="{{ date('Y-m-d') }}" value="{{ old('effectFrom',now()->format('Y-m-d')) }}" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <!-- ENO -->
                                                <div class="col-md-1"></div>
                                                <!-- FROM -->
                                                <!-- <div class="d-none col-md-3">
                                                    <div class="mb-2">
                                                        <label for="from" class="form-label">FROM</label>
                                                        <input type="text" name="from" value="GAINUP" class="form-control dull" readonly required>
                                                    </div>
                                                </div> -->
                                                <!-- KM -->
                                                <!-- <div class="d-none col-md-1">
                                                    <div class="mb-2">
                                                        <label for="km" class="form-label">KM</label>
                                                        <input type="number" name="km" class="form-control" required>
                                                    </div>
                                                </div> -->
                                            </div>
                                            <!-- EXPENSE TABLE -->
                                            <div class="card-body mt-3" style="display:block;">
                                                <div class="table-responsive table-card" style="max-height: 400px; overflow-y: auto;">
                                                    <table class="table table-centered align-middle table-nowrap mb-0" id="expenseTable" style="line-height: 5px !important;">
                                                        <thead class="d-none text-muted table-light sticky-header">
                                                            <tr>
                                                                <th data-sort="sno"> SNO <span class="sort-icon"></span></th>
                                                                <th data-sort="name"> NAME <span class="login-danger">*</span> <span class="sort-icon"></span></th>
                                                                <th data-sort="option"> CHOOSE <span class="sort-icon">*</span> <span class="sort-icon"></span></th>
                                                                <th data-sort="amt"> AMOUNT <span class="sort-icon">*</span> <span class="sort-icon"></span></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="tableBodyExp">
                                                            <tr>
                                                                <th colspan="6">TRAVEL MODE</th>
                                                            </tr>
                                                            <tr>
                                                                <th>LEVEL</th>
                                                                <th>By Flight</th>
                                                                <th>By Train</th>
                                                                <th>By Bus</th>
                                                                <th>By Own Car</th>
                                                                <th>By Own Bike</th>
                                                            </tr>
                                                            @foreach($desig as $index => $des)
                                                            <tr>
                                                                <td>
                                                                    <input type="hidden" name="expenses[{{ $loop->index }}][designation]" value="{{ $des['Rowid'] }}">
                                                                    @if($des['Name']=="ADMIN")
                                                                    HEADS(GM/DGM/AGM)
                                                                    @elseif($des['Name']=="MANAGER")
                                                                    MANAGERS(AM/DM/SM)
                                                                    @elseif($des['Name']=="EXECUTIVE")
                                                                    STAFF/EXECUTIVE(Other than the Above)
                                                                    @endif
                                                                </td>
                                                                <td><input type="number" name="expenses[{{ $loop->index }}][byFlight]" placeholder="&#8377" value="{{ old('expenses.' . $index . '.byFlight') }}"></td>
                                                                <td><input type="number" name="expenses[{{ $loop->index }}][byTrain]" placeholder="&#8377" value="{{ old('expenses.' . $index . '.byTrain') }}"></td>
                                                                <td><input type="number" name="expenses[{{ $loop->index }}][byBus]" placeholder="&#8377" value="{{ old('expenses.' . $index . '.byBus') }}"></td>
                                                                <td><input type="number" name="expenses[{{ $loop->index }}][byOCar]" placeholder="&#8377" value="{{ old('expenses.' . $index . '.byOCar') }}"></td>
                                                                <td><input type="number" name="expenses[{{ $loop->index }}][byOBike]" placeholder="&#8377" value="{{ old('expenses.' . $index . '.byOBike') }}"></td>
                                                            </tr>
                                                            @endforeach

                                                            <tr>
                                                                <th colspan="6">FOOD</th>
                                                            </tr>
                                                            <tr>
                                                                <th>LEVEL</th>
                                                                <th>Breakfast</th>
                                                                <th>Lunch</th>
                                                                <th>Dinner</th>
                                                            </tr>
                                                            @foreach($desig as $index => $des)
                                                            <tr>
                                                                <td>
                                                                    <input type="hidden" name="expenses[{{ $loop->index }}][designation]" value="{{ $des['Rowid'] }}">
                                                                    @if($des['Name']=="ADMIN")
                                                                    HEADS(GM/DGM/AGM)
                                                                    @elseif($des['Name']=="MANAGER")
                                                                    MANAGERS(AM/DM/SM)
                                                                    @elseif($des['Name']=="EXECUTIVE")
                                                                    STAFF/EXECUTIVE(Other than the Above)
                                                                    @endif
                                                                </td>
                                                                <td><input type="number" name="expenses[{{ $loop->index }}][breakfast]" placeholder="&#8377" value="{{ old('expenses.' . $index . '.breakfast') }}"></td>
                                                                <td><input type="number" name="expenses[{{ $loop->index }}][lunch]" placeholder="&#8377" value="{{ old('expenses.' . $index . '.lunch') }}"></td>
                                                                <td><input type="number" name="expenses[{{ $loop->index }}][dinner]" placeholder="&#8377" value="{{ old('expenses.' . $index . '.dinner') }}"></td>
                                                            </tr>
                                                            @endforeach

                                                            <tr>
                                                                <th colspan="6">BOARDING</th>
                                                            </tr>
                                                            <tr>
                                                                <th>LEVEL</th>
                                                                <th class="tierI">Boarding</th>
                                                            </tr>
                                                            @foreach($desig as $index => $des)
                                                            <tr>
                                                                <td>
                                                                    <input type="hidden" name="expenses[{{ $loop->index }}][designation]" value="{{ $des['Rowid'] }}">
                                                                    @if($des['Name']=="ADMIN")
                                                                    HEADS(GM/DGM/AGM)
                                                                    @elseif($des['Name']=="MANAGER")
                                                                    MANAGERS(AM/DM/SM)
                                                                    @elseif($des['Name']=="EXECUTIVE")
                                                                    STAFF/EXECUTIVE(Other than the Above)
                                                                    @endif
                                                                </td>
                                                                <td class="tierI"><input type="number" name="expenses[{{ $loop->index }}][boarding]" placeholder="&#8377" value="{{ old('expenses.' . $index . '.boarding') }}"></td>
                                                            </tr>
                                                            @endforeach

                                                            <tr>
                                                                <th colspan="6">OTHERS</th>
                                                            </tr>
                                                            <tr>
                                                                <th>LEVEL</th>
                                                                <th>Auto/Cab</th>
                                                                <th>Toll</th>
                                                                <th>Parking</th>
                                                                <th>Incidentals</th>
                                                            </tr>
                                                            @foreach($desig as $index => $des)
                                                            <tr>
                                                                <td>
                                                                    <input type="hidden" name="expenses[{{ $loop->index }}][designation]" value="{{ $des['Rowid'] }}">
                                                                    @if($des['Name']=="ADMIN")
                                                                    HEADS(GM/DGM/AGM)
                                                                    @elseif($des['Name']=="MANAGER")
                                                                    MANAGERS(AM/DM/SM)
                                                                    @elseif($des['Name']=="EXECUTIVE")
                                                                    STAFF/EXECUTIVE(Other than the Above)
                                                                    @endif
                                                                </td>
                                                                <td><input type="number" name="expenses[{{ $loop->index }}][auto_cab]" placeholder="&#8377" value="{{ old('expenses.' . $index . '.auto_cab') }}"></td>
                                                                <td><input type="number" name="expenses[{{ $loop->index }}][toll]" placeholder="&#8377" value="{{ old('expenses.' . $index . '.toll') }}"></td>
                                                                <td><input type="number" name="expenses[{{ $loop->index }}][park]" placeholder="&#8377" value="{{ old('expenses.' . $index . '.park') }}"></td>
                                                                <td><input type="number" name="expenses[{{ $loop->index }}][incidental]" placeholder="&#8377" value="{{ old('expenses.' . $index . '.incidental') }}"></td>
                                                            </tr>
                                                            @endforeach

                                                        </tbody>
                                                        <tfoot class="d-none sticky-footer">
                                                            <tr>
                                                                <td colspan="3" style="text-align: end;"><b>Total</b></td>
                                                                <td><input type="text" id="totalTransport" class="form-control" disabled></td>
                                                            </tr>
                                                        </tfoot>
                                                    </table>
                                                </div>
                                            </div>
                                            <br>
                                            <!--  SUBMIT BUTTON -->
                                            <div class="text-center justify">
                                                <button type="submit" value="SUBMIT" class="btn btn-primary" id="saveButton">Submit</button>
                                                <a href="/travExp_PolView" class="btn btn-warning">REPORT</a>
                                            </div>
                                            <div class="d-flex justify-content-around pb-2 d-none">
                                                <input type="submit" value="SUBMIT" class="btn btn-success">
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

    <!-- GET DESTINATION CATERGORY ID AND NAME -->
    <script>
        $(document).ready(function() {
            $('#destinationSelect').select2();

            function toggleFields(catId) {
                let fields = ['byFlight', 'byTrain', 'boarding'];
                fields.forEach(field => {
                    let inputField = $(`input[name^="expenses"][name*="[${field}]"]`);
                    if (catId == 1) {
                        inputField.prop('readonly', true).val(0).css({
                            'cursor': 'not-allowed',
                            'background-color': '#f8d7da',
                            'opacity': '0.6'
                        });
                    } else {
                        inputField.prop('readonly', false).css({
                            'cursor': 'auto',
                            'background-color': '',
                            'opacity': '1'
                        });
                    }
                });
            }

            // Reapply settings on page reload
            let storedCatId = $('#storedCatId').val();
            if (storedCatId) {
                toggleFields(storedCatId);
            }

            $('#destinationSelect').on('select2:select', function(e) {
                var selectedOption = $(this).find(":selected");
                var catId = selectedOption.data("cat-id");

                $('#catName').val(selectedOption.data("cat-name") || '');
                $('#catId').val(catId || '');
                $('#storedCatId').val(catId); // Update hidden input for persistence

                toggleFields(catId);
            });
        });
    </script>

    <!-- SEARCH -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <!-- CHECK FIRST ROW IS ALWAYS GREATER -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            function enforceExpenseRules() {
                let categories = new Set();

                // Collect unique expense categories
                document.querySelectorAll('#tableBodyExp input[name^="expenses"]').forEach(input => {
                    let match = input.name.match(/\[([a-zA-Z0-9_]+)\]$/);
                    if (match) categories.add(match[1]);
                });

                // Travel-related categories
                const travelCategories = ['byFlight', 'byTrain', 'byBus', 'byOCar', 'byOBike'];

                categories.forEach(category => {
                    // keep DOM order (top -> bottom)
                    let inputs = Array.from(document.querySelectorAll(`#tableBodyExp input[name^="expenses"][name$="[${category}]"]`));

                    inputs.forEach((input, index) => {
                        input.addEventListener("input", function() {
                            let currentValue = parseFloat(input.value);
                            if (isNaN(currentValue)) currentValue = 0;

                            // ---------- TRAVEL: <= immediate previous row (equal allowed) ----------
                            if (travelCategories.includes(category)) {
                                if (index > 0) {
                                    let prevInput = inputs[index - 1];
                                    let prevValue = parseFloat(prevInput.value);
                                    if (isNaN(prevValue)) prevValue = 0;

                                    // current cannot exceed previous
                                    if (currentValue > prevValue) {
                                        input.value = prevValue;
                                        currentValue = prevValue;
                                        input.title = "Value cannot exceed previous level's amount.";
                                        input.style.borderColor = "red";
                                        setTimeout(() => input.style.borderColor = "", 1200);
                                    }
                                }

                                // If current decreased, ensure all lower rows are <= current
                                for (let i = index + 1; i < inputs.length; i++) {
                                    let nextInput = inputs[i];
                                    let nextValue = parseFloat(nextInput.value);
                                    if (isNaN(nextValue)) nextValue = 0;

                                    if (nextValue > currentValue) {
                                        nextInput.value = currentValue;
                                    } else {
                                        // if a lower row already respects the <= rule, keep checking further rows
                                        // but do not break — we want to ensure all rows are <= currentValue
                                        // (kept intentionally)
                                    }
                                }
                            }

                            // ---------- NON-TRAVEL: strictly decreasing (each < previous) ----------
                            else {
                                if (index > 0) {
                                    let prevInput = inputs[index - 1];
                                    let prevValue = parseFloat(prevInput.value);
                                    if (isNaN(prevValue)) prevValue = 0;

                                    if (currentValue >= prevValue) {
                                        input.value = prevValue > 1 ? prevValue - 1 : 0;
                                        currentValue = parseFloat(input.value);
                                        input.title = "Must be less than previous level.";
                                        input.style.borderColor = "red";
                                        setTimeout(() => input.style.borderColor = "", 1200);
                                    }
                                }

                                // Adjust lower rows automatically to maintain strict decreasing
                                for (let i = index + 1; i < inputs.length; i++) {
                                    let nextInput = inputs[i];
                                    let nextValue = parseFloat(nextInput.value);
                                    if (isNaN(nextValue)) nextValue = 0;

                                    if (nextValue >= currentValue) {
                                        nextInput.value = currentValue > 1 ? currentValue - 1 : 0;
                                        currentValue = parseFloat(nextInput.value);
                                    } else {
                                        break;
                                    }
                                }
                            }
                        });
                    });
                });
            }

            enforceExpenseRules();
        });
    </script>


    <!-- SUCCESS MESSAGE -->
    @if (session('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{ session('success') }}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('alert'))
    <div id="errorAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        setTimeout(function() {
            var errorAlert = document.getElementById('errorAlert');
            if (errorAlert) {
                errorAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    <!-- <script>
        function disableTiers(selectedTier) {
            // Enable all inputs first
            let allTiers = document.querySelectorAll('.tierI input, .tierII input, .tierIII input');
            allTiers.forEach(input => {
                input.disabled = false;
                input.setAttribute("required", "true");
            });

            // Disable inputs based on the selected tier
            if (selectedTier == "1") {
                document.querySelectorAll('.tierII input, .tierIII input').forEach(input => {
                    input.disabled = true;
                    input.removeAttribute("required");
                });
            } else if (selectedTier == "2") {
                document.querySelectorAll('.tierI input, .tierIII input').forEach(input => {
                    input.disabled = true;
                    input.removeAttribute("required");
                });
            } else if (selectedTier == "3") {
                document.querySelectorAll('.tierI input, .tierII input').forEach(input => {
                    input.disabled = true;
                    input.removeAttribute("required");
                });
            }
        }
    </script> -->


    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>