<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>TRAVEL RETURN EDIT</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <!-- ALERT -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }

        .sticky-header {
            position: sticky;
            top: 0;
            z-index: 1;
        }

        .sticky-footer {
            position: sticky;
            bottom: 0;
            z-index: 1;
            background-color: whitesmoke;
        }
    </style>
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->

</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->
    @section('tittle') {{"TRAVEL EXPENSE ENTRY EDIT"}}@endsection

    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="live-preview">
                                        <form method="POST" action="{{ route('TExpenseReturnEdit_Save') }}" enctype="multipart/form-data" class="has-validated" id="validate">
                                            @csrf
                                            <div class="row">
                                                <!-- ENO -->
                                                <div class="col-md-2">
                                                    <div class="mb-2">
                                                        <label for="to" class="form-label">ENO</label>
                                                        <input type="text" name="eno" id="Eno" class="form-control dull" value="{{ old('eno',$result[0]['ENO']) }}" readonly required>
                                                        <input type="hidden" name="Rowid" id="Rowid" class="form-control dull" value="{{ old('Rowid',$result[0]['Rowid']) }}" readonly required>
                                                    </div>
                                                </div>
                                                <!-- DESITINATION -->
                                                <div class="col-md-2">
                                                    <div class="mb-2">
                                                        <label for="to" class="form-label">DESITINATION</label>
                                                        <input type="text" name="destinationTo" id="destinationTo" class="form-control dull" value="{{ old('destinationTo',$result[0]['Destination']) }}" readonly required>
                                                    </div>
                                                </div>
                                                <!-- FROM DATE-->
                                                <div class="col-md-3">
                                                    <div class="mb-2">
                                                        <label>FROM DATE</label>
                                                        <input type="text" name="from_date" id="from_date" class="form-control dull" value="{{ old('from_date',$result[0]['FDate']) }}" readonly required>
                                                    </div>
                                                </div>
                                                <!-- TO DATE -->
                                                <div class="col-md-3">
                                                    <div class="mb-2">
                                                        <label>TO DATE</label>
                                                        <input type="text" name="to_date" id="to_date" class="form-control dull" value="{{ old('to_date',$result[0]['TDate']) }}" readonly required>
                                                    </div>
                                                </div>
                                                <!-- TOTAL DAYS -->
                                                <div class="col-md-2">
                                                    <div class="mb-2">
                                                        <label for="total_days" class="form-label">TOTAL DAYS</label>
                                                        <input type="text" name="total_days" id="total_days" class="form-control dull" value="{{ old('total_days',$result[0]['Tot_Day']) }}" readonly required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <!-- UP -->
                                                <div class="col-md-2">
                                                    <div class="mb-2">
                                                        <label for="to" class="form-label">TOWARDS</label>
                                                        <input type="text" name="up_to_text" class="form-control dull" id="hidden_up_to" value="{{ old('up_to_text',$result[0]['Vehicle_Mode_Up']) }}" readonly required>
                                                    </div>
                                                </div>
                                                <!-- UP AMOUNT -->
                                                <div class="col-md-1">
                                                    <div class="mb-2">
                                                        <label for="upAmt" class="form-label">AMOUNT</label>
                                                        <input type="text" name="upAmt" class="form-control dull" id="upAmt" value="{{ old('upAmt',$result[0]['Vehicle_Mode_Up_Amt']) }}" readonly required>
                                                    </div>
                                                </div>
                                                <!-- UP AMOUNT - ACTUAL -->
                                                <div class="col-md-1">
                                                    <div class="mb-2">
                                                        <label for="upAmt" class="form-label">ACTUAL <span class="login-danger">*</span></label>
                                                        <input type="number" name="upAmtAct" class="form-control" value="{{ old('upAmtAct',$result[0]['Actual_Up_Amt']) }}" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-1"></div>
                                                <!-- DOWN -->
                                                <div class="col-md-2">
                                                    <div class="mb-2">
                                                        <label for="to" class="form-label">RETURN</label>
                                                        <input type="text" name="down_to_text" class="form-control dull" id="hidden_down_to" value="{{ old('down_to_text',$result[0]['Vehicle_Mode_Down']) }}" readonly required>
                                                    </div>
                                                </div>
                                                <!-- DOWN AMOUNT -->
                                                <div class="col-md-1">
                                                    <div class="mb-2">
                                                        <label for="downAmt" class="form-label">AMOUNT</label>
                                                        <input type="text" name="downAmt" class="form-control dull" id="downAmt" value="{{ old('downAmt',$result[0]['Vehicle_Mode_Down_Amt']) }}" readonly required>
                                                    </div>
                                                </div>
                                                <!-- DOWN AMOUNT - ACTUAL -->
                                                <div class="col-md-1">
                                                    <div class="mb-2">
                                                        <label for="downAmt" class="form-label">ACTUAL <span class="login-danger">*</span></label>
                                                        <input type="number" name="downAmtAct" class="form-control" value="{{ old('downAmtAct',$result[0]['Actual_Down_Amt']) }}" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- EXPENSE TABLE -->
                                            <h6 style="font-weight: bold;">EXPENSES</h6>
                                            <div class="card-body" style="display:block;">
                                                <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                                    <table class="table table-centered align-middle table-nowrap mb-0" id="expenseTable" style="line-height: 10px !important;">
                                                        <thead class="text-muted table-light sticky-header">
                                                            <tr>
                                                                <th data-sort="sno"> SNO <span class="sort-icon"></span></th>
                                                                <th></th>
                                                                <th data-sort="description"> Description <span class="sort-icon"></span></th>
                                                                <th data-sort="hotel"> Hotel <span class="sort-icon"></span></th>
                                                                <th data-sort="food"> Food <span class="sort-icon"></span></th>
                                                                <th data-sort="misc"> Miscellaneous <span class="sort-icon"></span></th>
                                                                <th data-sort="cab"> Auto/Cab <span class="sort-icon"></span></th>
                                                                <th data-sort="toll"> Toll <span class="sort-icon"></span></th>
                                                                <th data-sort="park"> Parking <span class="sort-icon"></span></th>
                                                                <th data-sort="total"> Total <span class="sort-icon"></span></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="tableBodyExp">
                                                            <!-- PLANNED -->
                                                            <tr>
                                                                <td>1</td>
                                                                <td>PLANNED</td>
                                                                <td>
                                                                    <input type="text" class="form-control dull" name="reason" id="reason" placeholder="Reason" value="{{ old('reason',$result[0]['Plan_Reason']) }}" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control dull" name="hotel" id="hotel" placeholder="Rs.00" value="{{ old('hotel',$result[0]['Plan_Hotel']) }}" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control dull" name="food" id="food" placeholder="Rs.00" value="{{ old('food',$result[0]['Plan_Food']) }}" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control dull" name="misc" id="misc" placeholder="Rs.00" value="{{ old('misc',$result[0]['Plan_Misc']) }}" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control dull" name="auto_cab" id="auto_cab" placeholder="Rs.00" value="{{ old('auto_cab',$result[0]['Plan_Auto']) }}" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control dull" name="toll" id="toll" placeholder="Rs.00" value="{{ old('toll',$result[0]['Plan_Toll']) }}" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control dull" name="parking" id="parking" placeholder="Rs.00" value="{{ old('parking',$result[0]['Plan_Parking']) }}" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control dull total-expense dull" name="total" id="total" placeholder="Rs.00" value="{{ old('total',$result[0]['Plan_Row_Total']) }}" readonly>
                                                                </td>
                                                            </tr>
                                                            <!-- ACTUAL -->
                                                            <tr>
                                                                <td>2</td>
                                                                <td>ACTUAL <span class="login-danger">*</span></td>
                                                                <td>
                                                                    <input type="text" class="form-control" name="expense[0][reasonAct]" placeholder="Reason" value="{{ old('reasonAct',$result[0]['Act_Reason']) }}">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][hotelAct]" placeholder="Rs.00" value="{{ old('hotelAct',$result[0]['Act_Hotel']) }}">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][foodAct]" placeholder="Rs.00" value="{{ old('foodAct',$result[0]['Act_Food']) }}">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][miscAct]" placeholder="Rs.00" value="{{ old('miscAct',$result[0]['Act_Misc']) }}">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][auto_cabAct]" placeholder="Rs.00" value="{{ old('auto_cabAct',$result[0]['Act_Auto']) }}">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][tollAct]" placeholder="Rs.00" value="{{ old('tollAct',$result[0]['Act_Toll']) }}">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][parkingAct]" placeholder="Rs.00" value="{{ old('parkingAct',$result[0]['Act_Parking']) }}">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control total-expense" name="expense[0][totalAct]" placeholder="Rs.00" value="{{ old('totalAct',$result[0]['Act_Row_Total']) }}" readonly>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                            <!-- TRAVEL PURPOSE (REMARKS) -->
                                            <div class="col-md-12 mb-2">
                                                <textarea class="form-control dull" name="Remark" id="remark" rows="1" readonly>{{ old('Remark',$result[0]['Plan_Reason']) }}</textarea>
                                            </div>
                                            <div class="row">
                                                <div class="d-flex align-items-center gap-2 mt-1 mb-0">
                                                    <!-- PLANNED TOTAL -->
                                                    <label for="planTotAmt" class="form-label mb-0">PLANNED TOTAL<span class="login-danger">*</span></label>
                                                    <input type="text" id="planTotAmt" class="form-control" name="planTotAmt" value="{{ old('planTotAmt',$result[0]['Planned_Total']) }}" placeholder="Rs.00" style="width: 150px;" readonly>
                                                    <!-- ACTUAL TOTAL -->
                                                    <label for="actualTotAmt" class="form-label mb-0">ACTUAL TOTAL<span class="login-danger">*</span></label>
                                                    <input type="text" id="actualTotAmt" class="form-control" name="actualTotAmt" value="{{ old('actualTotAmt',$result[0]['Actual_Total']) }}" placeholder="Rs.00" readonly style="width: 150px;">
                                                </div>
                                            </div>
                                            <br>
                                            <!-- ATTACHMENT -->
                                            <div class="row">
                                                <div class="col-md-4 mb-2">
                                                    <label for="file1" class="form-label">Attachment 1 <span class="login-danger">*</span> </label>
                                                    <!-- Hidden old filename -->
                                                    <input type="hidden" name="OldFile1" value="{{ $result[0]['Rtn_Att1'] }}">
                                                    <!-- NEW FILE -->
                                                    <input type="file" name="File1" class="form-control" @if ($result[0]['Rtn_Att1']=="" ) required @endif>
                                                    @if ($result[0]['Rtn_Att1'] == "")
                                                    --
                                                    @else
                                                    <a href="{{ asset('/TravelExpReturnEntry/' . $result[0]['Rtn_Att1']) }}" target="_blank">
                                                        {{ $result[0]['Rtn_Att1'] }}
                                                    </a>
                                                    @endif
                                                </div>
                                                <div class="col-md-4 mb-2">
                                                    <label for="file2" class="form-label">Attachment 2</label>
                                                    <!-- Hidden old filename -->
                                                    <input type="hidden" name="OldFile2" value="{{ $result[0]['Rtn_Att2'] }}">
                                                    <!-- NEW FILE -->
                                                    <input type="file" name="File2" class="form-control">
                                                    @if ($result[0]['Rtn_Att2'] == "")
                                                    --
                                                    @else
                                                    <a href="{{ asset('/TravelExpReturnEntry/' . $result[0]['Rtn_Att2']) }}" target="_blank">
                                                        {{ $result[0]['Rtn_Att2'] }}
                                                    </a>
                                                    @endif
                                                </div>
                                            </div>

                                            <!-- BILL ATTACHMENT -->
                                            <div class="row">
                                                <div class="col-md-2 mb-2">
                                                    <label for="BillFile1" class="form-label">Bill Attachment 1</label>
                                                    <!-- Hidden old filename -->
                                                    <input type="hidden" name="OldBill1" value="{{ $result[0]['Bill_Att1'] }}">
                                                    <input type="file" name="BillFile1" class="form-control">
                                                    @if ($result[0]['Bill_Att1'] == "")
                                                    --
                                                    @else
                                                    <a href="{{ asset('/TravelExpReturnEntry/' . $result[0]['Bill_Att1']) }}" target="_blank">
                                                        {{ $result[0]['Bill_Att1'] }}
                                                    </a>
                                                    @endif
                                                </div>
                                                <div class="col-md-2 mb-2">
                                                    <label for="BillFile2" class="form-label">Bill Attachment 2</label>
                                                    <!-- Hidden old filename -->
                                                    <input type="hidden" name="OldBill2" value="{{ $result[0]['Bill_Att2'] }}">
                                                    <input type="file" name="BillFile2" class="form-control">
                                                    @if ($result[0]['Bill_Att2'] == "")
                                                    --
                                                    @else
                                                    <a href="{{ asset('/TravelExpReturnEntry/' . $result[0]['Bill_Att2']) }}" target="_blank">
                                                        {{ $result[0]['Bill_Att2'] }}
                                                    </a>
                                                    @endif
                                                </div>
                                                <div class="col-md-2 mb-2">
                                                    <label for="BillFile3" class="form-label">Bill Attachment 3</label>
                                                    <!-- Hidden old filename -->
                                                    <input type="hidden" name="OldBill3" value="{{ $result[0]['Bill_Att3'] }}">
                                                    <input type="file" name="BillFile3" class="form-control">
                                                    @if ($result[0]['Bill_Att3'] == "")
                                                    --
                                                    @else
                                                    <a href="{{ asset('/TravelExpReturnEntry/' . $result[0]['Bill_Att3']) }}" target="_blank">
                                                        {{ $result[0]['Bill_Att3'] }}
                                                    </a>
                                                    @endif
                                                </div>
                                                <div class="col-md-2 mb-2">
                                                    <label for="BillFile4" class="form-label">Bill Attachment 4</label>
                                                    <!-- Hidden old filename -->
                                                    <input type="hidden" name="OldBill4" value="{{ $result[0]['Bill_Att4'] }}">
                                                    <input type="file" name="BillFile4" class="form-control">
                                                    @if ($result[0]['Bill_Att4'] == "")
                                                    --
                                                    @else
                                                    <a href="{{ asset('/TravelExpReturnEntry/' . $result[0]['Bill_Att4']) }}" target="_blank">
                                                        {{ $result[0]['Bill_Att4'] }}
                                                    </a>
                                                    @endif
                                                </div>
                                                <div class="col-md-2 mb-2">
                                                    <label for="BillFile5" class="form-label">Bill Attachment 5</label>
                                                    <!-- Hidden old filename -->
                                                    <input type="hidden" name="OldBill5" value="{{ $result[0]['Bill_Att5'] }}">
                                                    <input type="file" name="BillFile5" class="form-control">
                                                    @if ($result[0]['Bill_Att5'] == "")
                                                    --
                                                    @else
                                                    <a href="{{ asset('/TravelExpReturnEntry/' . $result[0]['Bill_Att5']) }}" target="_blank">
                                                        {{ $result[0]['Bill_Att5'] }}
                                                    </a>
                                                    @endif
                                                </div>
                                            </div>

                                            <!-- PURPOSE REMARK -->
                                            <div class="row">
                                                <div class="col-md-12 mt-2">
                                                    <label for="validationTextarea" class="form-label">TRAVEL PURPOSE <span class="login-danger">*</span></label>
                                                    <textarea class="form-control" name="feedback" rows="2" placeholder="Purpose of this Travel..." required>{{old('feedback',$result[0]['Actual_Remarks'])}}</textarea>
                                                    <small id="error-msg" style="color: red; display: none;">Minimum 30 characters required</small>
                                                </div>
                                            </div>
                                            <br>
                                            <!--  SUBMIT BUTTON -->
                                            <div class="d-flex justify-content-around pb-2">
                                                <!-- <input type="submit" value="SUBMIT" id="saveButton" class="btn btn-primary" disabled> -->
                                                <input type="submit" value="SUBMIT" id="saveButton" class="btn btn-primary" {{ old('Eno') ? '' : 'disabled' }}>
                                                <button type="button" class="btn btn-info" onclick="window.location.href = '/travExp_returnView'">Report</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

    <!-- PREVENT FORM SUBMIT FROM ENTER -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.querySelector('#validate'); // or use a more specific selector

            form.addEventListener('keydown', function(event) {
                if (event.key === 'Enter') {
                    event.preventDefault(); // stop the form submission
                }
            });
        });
    </script>

    <!-- FILL DETAILS USING AJAX & DATE VALIDATION-->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- ENABLED SUBMIT BUTTON IF SAVE ERROR OCCURS -->
    <script>
        $(document).ready(function() {
            setTimeout(function() { // Delay execution slightly to ensure inputs are loaded
                var rid = $('#Rowid').val().trim(); // Use jQuery for consistency
                if (rid !== "") {
                    $('#saveButton').prop('disabled', false);
                }
            }, 100);
        });
    </script>

    <!-- ACTUAL GRAND TOTAL CALCULATION -->
    <script>
        $(document).on('input', '.expense-input, input[name="upAmtAct"], input[name="downAmtAct"]', function() {
            let total = 0;

            // Sum all table expense inputs
            $('.expense-input').each(function() {
                total += Number($(this).val()) || 0;
            });

            // Add upAmtAct and downAmtAct
            total += Number($('input[name="upAmtAct"]').val()) || 0;
            total += Number($('input[name="downAmtAct"]').val()) || 0;

            // Display formatted total in Rs.
            $('#actualTotAmt').val(total.toFixed(2));
        });
    </script>

    <!-- ALERT FOR ACTUAL EXCEED PLANNED -->
    <script>
        $('#validate').on('submit', function(e) {
            e.preventDefault(); // Stop normal submission temporarily

            let planTotAmt = Number($('#planTotAmt').val()) || 0;
            let actualTotAmt = Number($('#actualTotAmt').val()) || 0;

            // If actual > planned → show alert with confirmation
            if (actualTotAmt > planTotAmt) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Actual exceeds Planned!',
                    text: 'The actual total is higher than the planned total, Need to get APPROVAL. Are you sure you want to proceed?',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, proceed',
                    cancelButtonText: 'Cancel',
                }).then((result) => {
                    if (result.isConfirmed) {
                        $('#AutoApp').val('N');
                        e.target.submit(); // Submit only if user confirmed
                    }
                });
            } else {
                // No alert — proceed silently
                $('#AutoApp').val('Y');
                this.submit(); // Only here it submits directly
            }
        });
    </script>

    <!--  ADVANCE ENTRY DETAILS  -->
    <script>
        $(document).ready(function() {
            function resetFields() {
                $('#Eno, #Rowid, #destinationTo, #from_date, #to_date, #total_days,#hidden_up_to,#upAmt,#hidden_down_to,#downAmt,#reason,#hotel,#food,#misc,#auto_cab,#toll,#parking,#total,#remark').val('');
                $('input[type=radio]').prop('checked', false);
                disableSaveButton();
            }

            function enableSaveButton() {
                $('#saveButton').prop('disabled', false);
            }

            function disableSaveButton() {
                $('#saveButton').prop('disabled', true);
            }

            $(document).on('click', '.entry_viewButton', function() {
                $('#trvAdvEntyModal').modal('show');

                // Attach click event to table rows
                $('#table_det tbody tr').off('click').on('click', function(event) {
                    // Prevent event propagation if the radio button itself is clicked
                    if (event.target.type === 'radio') return;

                    // Find and check the radio button in the clicked row
                    const $radioButton = $(this).find('input[type=radio]');
                    $radioButton.prop('checked', true).trigger('change');
                });

                // Event for radio buttons when clicked
                $('input[type=radio][name=trvAdvEnty_radio]').off('change').on('change', function() {
                    const selectedData = $(this).data();

                    $('#Rowid').val(selectedData.rowid);
                    $('#Eno').val(selectedData.eno);
                    $('#destinationTo').val(selectedData.destin);
                    $('#from_date').val(selectedData.fdate);
                    $('#to_date').val(selectedData.tdate);
                    $('#total_days').val(selectedData.totday);
                    $('#hidden_up_to').val(selectedData.up);
                    $('#upAmt').val(selectedData.upamt);
                    $('#hidden_down_to').val(selectedData.down);
                    $('#downAmt').val(selectedData.downamt);
                    $('#reason').val(selectedData.reason);
                    $('#hotel').val(selectedData.hotel);
                    $('#food').val(selectedData.food);
                    $('#misc').val(selectedData.misc);
                    $('#auto_cab').val(selectedData.auto);
                    $('#toll').val(selectedData.toll);
                    $('#parking').val(selectedData.park);
                    $('#total').val(selectedData.total);
                    $('#remark').val(selectedData.remark);

                    $('#planTotAmt').val(
                        (Number(selectedData.upamt) || 0) +
                        (Number(selectedData.downamt) || 0) +
                        (Number(selectedData.hotel) || 0) +
                        (Number(selectedData.food) || 0) +
                        (Number(selectedData.misc) || 0) +
                        (Number(selectedData.auto) || 0) +
                        (Number(selectedData.toll) || 0) +
                        (Number(selectedData.park) || 0)
                    );


                    enableSaveButton();
                });

                $('.btncancel').off('click').on('click', function() {
                    resetFields();
                    $('#trvAdvEntyModal').modal('hide');
                });

                $('.btnok').off('click').on('click', function() {
                    $('#trvAdvEntyModal').modal('hide');
                });
            });
        });
    </script>

    <!-- VAIDATE FEEDBACK TEXT BOX MIN 30 -->
    <script>
        document.getElementById("validate").addEventListener("submit", function(event) {
            let textarea = document.querySelector("textarea[name='feedback']");
            let errorMsg = document.getElementById("error-msg");
            let text = textarea.value.trim(); // Remove leading and trailing spaces
            let charCount = text.replace(/\s+/g, "").length; // Count only non-space characters

            if (charCount < 30) {
                errorMsg.style.display = "inline";
                event.preventDefault(); // Prevent form submission
            } else {
                errorMsg.style.display = "none";
            }
        });
    </script>

    <script>
        function updateTotalExpense() {
            let hotel = parseFloat($("input[name='expense[0][hotelAct]']").val()) || 0;
            let food = parseFloat($("input[name='expense[0][foodAct]']").val()) || 0;
            let misc = parseFloat($("input[name='expense[0][miscAct]']").val()) || 0;
            let cab = parseFloat($("input[name='expense[0][auto_cabAct]']").val()) || 0;
            let toll = parseFloat($("input[name='expense[0][tollAct]']").val()) || 0;
            let park = parseFloat($("input[name='expense[0][parkingAct]']").val()) || 0;

            let total = hotel + food + misc + cab + toll + park;
            $("input[name='expense[0][totalAct]']").val(total.toFixed(2));
        }

        // Attach event listener to update total when any input changes
        $(".expense-input").on("input", updateTotalExpense);
    </script>

    <!-- SEARCH -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <!-- SUCCESS MESSAGE -->
    @if (session('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{ session('success') }}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 8000);
    </script>
    @endif
    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('alert'))
    <div id="errorAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        setTimeout(function() {
            var errorAlert = document.getElementById('errorAlert');
            if (errorAlert) {
                errorAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>