<style>
    #reimbFormCard.pdf-compact {
        font-size: 11px;
        width: 780px;
        margin: 0 auto;
        background: #fff;
    }
    #reimbFormCard.pdf-compact h4 { font-size: 15px; margin-bottom: 6px; }
    #reimbFormCard.pdf-compact .table { font-size: 10px; }
    #reimbFormCard.pdf-compact .table td,
    #reimbFormCard.pdf-compact .table th { padding: .22rem .35rem; }
</style>
<style>
    .signature-line { border-bottom: 1px solid #000; height: 32px; min-width: 160px; }
    .date-label { white-space: nowrap; }
</style>
<div class="hidediv" style="display: none;">
    <div class="card mt-3" id="reimbFormCard" style="font-size: 12px;">
        <div class="card-body px-5">
            <h4 class="text-center mb-4">Travel Expenses Reimbursement Form</h4>
            <form id="travelReimbForm" class="needs-validation" novalidate>
                <div class="row g-3 mb-3">
                    <div class="col-md-6">
                        <label class="form-label">Employee Name</label>
                        <div id="empName" class="form-control-plaintext px-2 py-1"></div>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Employee ID</label>
                        <div id="empId" class="form-control-plaintext px-2 py-1"></div>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Employee Position</label>
                        <div id="empPosition" class="form-control-plaintext px-2 py-1"></div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Division</label>
                        <div id="division" class="form-control-plaintext px-2 py-1"></div>
                    </div>
                    <div class="col-md-6">
                        <div class="d-flex gap-2">
                            <div class="flex-fill">
                                <label class="form-label mb-1">Expense From date</label>
                                <div id="periodFrom" class="form-control-plaintext px-2 py-1"></div>
                            </div>
                            <div class="flex-fill">
                                <label class="form-label mb-1">Expense To date</label>
                                <div id="periodTo" class="form-control-plaintext px-2 py-1"></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <label class="form-label">Travel purpose</label>
                        <div id="travelPurpose" class="form-control-plaintext px-2 py-1"></div>
                    </div>
                    <div class="col-md-3">
                      <label class="form-label">ENo</label>
                      <div id="ENo" class="form-control-plaintext px-2 py-1"></div>
                    </div>
                    <div class="col-md-3">
                      <label class="form-label">Destination</label>
                      <div id="Destination" class="form-control-plaintext px-2 py-1"></div>
                    </div>
                </div>

                <div class="table-responsive mb-3">
                    <table class="table table-bordered align-middle mb-0" id="reimbLinesTable">
                        <thead class="table-light">
                            <tr class="py-2">
                                <th style="width: 8rem;">Date</th>
                                <th>Description</th>
                                <th style="width: 8rem;">Transport</th>
                                <th style="width: 8rem;">Hotel</th>
                                <th style="width: 8rem;">Meals</th>
                                <th style="width: 8rem;">Misc.</th>
                                <th style="width: 8rem;">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- rows will be injected from JS populateReimbForm -->
                        </tbody>
                    </table>
                </div>

                <div class="row g-3 mt-3">
                    <div class="col-md-8">
                        <div class="border rounded p-2">
                            <small>
                                I certify that these expenses were incurred in accordance with Gainup group travel expenses policy guidelines and that they represent prudent, reasonable and necessary expenses.
                            </small>
                            
                        </div>
                        <div class="mt-1">
                            <small>* Don't forget to attach bills/receipts</small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="d-flex flex-column gap-2">
                            <div class="d-flex align-items-center justify-content-between flex-nowrap">
                                <label class="mb-0 me-2 text-nowrap">Subtotal:</label>
                                <div class="form-control-plaintext px-6 py-2  ms-4 text-center" id="subtotal"></div>
                            </div>
                            <div class="d-flex align-items-center justify-content-between flex-nowrap">
                                <label class="mb-0 me-2 text-nowrap">Advance Payment:</label>
                                <div class="form-control-plaintext px-6 py-2  text-center" id="advancePayment"></div>
                            </div>
                            <div class="d-flex align-items-center justify-content-between flex-nowrap">
                                <label class="mb-0 me-2 text-nowrap">Total Reimbursement:</label>
                                <div class="form-control-plaintext px-6 py-2  me-5 text-center" id="totalReimb"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row g-4 mt-3">
                    <div class="col-md-12">
                        <div class="d-flex align-items-center gap-3">
                            <label class="mb-0 me-2 text-nowrap">Employee Signature</label>
                            <div class="form-control-plaintext px-2 py-2 flex-fill signature-line" id="empSignature"></div>
                            <label class="mb-0 ms-2 me-2 date-label">Date</label>
                            <div class="form-control-plaintext px-2 py-2 flex-fill signature-line" id="empSignDate"></div>
                        </div>
                    </div>
                
                    <div class="col-md-12">
                        <div class="d-flex align-items-center gap-3">
                            <label class="mb-0 me-2 text-nowrap">Approval Signature</label>
                            <div class="form-control-plaintext px-2 py-2 flex-fill signature-line" id="apprSignature"></div>
                            <label class="mb-0 ms-2 me-2 date-label">Date</label>
                            <div class="form-control-plaintext px-2 py-2 flex-fill signature-line" id="apprSignDate"></div>
                        </div>
                    </div>
                    <div class="row g-2">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center justify-content-between flex-nowrap">
                                <label class="mb-0 me-2 text-nowrap">Approval Name</label>
                                <div class="form-control-plaintext px-2 py-6" id="apprName"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex align-items-center justify-content-between flex-nowrap">
                                <label class="mb-0 me-2 text-nowrap">Designation</label>
                                <div class="form-control-plaintext  px-2 py-6" id="apprDesignation"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-3">
                    <p class="mb-1"><strong>Note:</strong></p>
                    <ol class="mb-0 ps-3">
                        <li>Public Transport: Ticket should be affixed.</li>
                        <li>On duty approved sheet is must and to be submitted along with claim bill.</li>
                    </ol>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    (function(){
        if (window.TravelForm && window.TravelForm.inited) return;
        window.TravelForm = {
            inited: true,
            formatDateCk: function(dateString) {
                if (!dateString || typeof dateString !== 'string') return '';
                var datePart = dateString.split(' ')[0];
                var parts = datePart.split('-');
                if (parts.length !== 3) return '';
                var day, month, year;
                if (parts[0].length === 4) { year = parts[0]; month = parts[1]; day = parts[2]; }
                else { day = parts[0]; month = parts[1]; year = parts[2]; }
                if ((year||'').length === 4) return day + '-' + month + '-' + year.substring(2);
                return '';
            },
            fetchTravelPolicy: function(empid, rowid){
                return $.ajax({
                    url: "{{ route('travelpolicy') }}",
                    type: "GET",
                    data: { empid: empid, rowid: rowid },
                    dataType: "json"
                });
            },
            populateReimbForm: function(list){
                if(!Array.isArray(list) || list.length===0) return;
                var first = list[0] || {};
                $('#empName').text(first.Emp_Name || '');
                $('#empId').text(first.Emp_TNo || '');
                $('#Destination').text(first.Destination || '');
                $('#ENo').text(first.ENO || '');
                $('#empPosition').text(first.Emp_Designation || '');
                $('#division').text(first.Emp_Division || '');
                $('#periodFrom').text(this.formatDateCk(first.FDate) || '');
                $('#periodTo').text(this.formatDateCk(first.TDate) || '');
                $('#travelPurpose').text(first.Remark || '');
                $('#apprName').text(first.App_2_Name || '');
                $('#apprDesignation').text(first.App_2_DesigName || '');
                var $tbody = $('#reimbLinesTable tbody');
                $tbody.empty();
                var subtotal = 0;
                list.forEach(function(item){
                    var t = parseFloat((item.Total||'0').toString().replace(/,/g,'')) || 0;
                    subtotal += t;
                    var tr = '<tr>'+
                        '<td class="py-3">'+ (window.TravelForm.formatDateCk(item.FDate || '') || '') +'</td>'+
                        '<td class="py-3">'+ ((item.Description || '')+'') +'</td>'+
                        '<td class="text-end py-3">'+ ((item.Transport_Amt || '0')) +'</td>'+
                        '<td class="text-end py-3">'+ ((item.Hotel || '0')) +'</td>'+
                        '<td class="text-end py-3">'+ ((item.Food || '0')) +'</td>'+
                        '<td class="text-end py-3">'+ ((item.Misc || '0')) +'</td>'+
                        '<td class="text-end py-3">'+ ((item.Total || '0')) +'</td>'+
                    '</tr>';
                    $tbody.append(tr);
                });
                var adv = parseFloat((($('#advancePayment').text()||'0')).toString().replace(/,/g,'')) || 0;
                $('#subtotal').text(subtotal.toFixed(3));
                $('#totalReimb').text((subtotal - adv).toFixed(3));
            },
            bindPdf: function(){
                $(document).off('click.travelpdf', '#downloadPdfBtn').on('click.travelpdf', '#downloadPdfBtn', function(){
                    var el = document.getElementById('reimbFormCard');
                    if (!el) return;
                    // If the form is inside a display:none container, temporarily show it
                    var wrapper = el.closest('.hidediv');
                    var prevDisplay;
                    if (wrapper) { prevDisplay = wrapper.style.display; wrapper.style.display = 'block'; }
                    el.classList.add('pdf-compact');
                    const opt = { margin: [16,16,16,16], filename: 'Travel_Expenses_Reimbursement_Form.pdf', image: { type: 'jpeg', quality: 0.98 }, html2canvas: { scale: 2, useCORS: true, logging: false }, jsPDF: { unit: 'pt', format: 'a4', orientation: 'portrait' }, pagebreak: { mode: ['avoid-all', 'css', 'legacy'] } };
                    html2pdf().set(opt).from(el).save().then(function(){
                        el.classList.remove('pdf-compact');
                        if (wrapper) { wrapper.style.display = (prevDisplay !== undefined ? prevDisplay : 'none'); }
                        $('#downloadPdfBtn').hide();
                    }).catch(function(){
                        el.classList.remove('pdf-compact');
                        if (wrapper) { wrapper.style.display = (prevDisplay !== undefined ? prevDisplay : 'none'); }
                        $('#downloadPdfBtn').hide();
                    });
                });
            },
            init: function(){
                this.bindPdf();
            }
        };
        window.fetchTravelPolicy = function(empid, rowid){
            return window.TravelForm.fetchTravelPolicy(empid, rowid).done(function(res){
                var list = (res && res.data) ? res.data : [];
                window.TravelForm.populateReimbForm(list);
                $('#downloadPdfBtn').trigger('click');
                //$('#downloadPdfBtn').show();
            });
        };
        $(document).ready(function(){ window.TravelForm.init(); });
    })();
</script>
