<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>ADVANCE REQUEST ENTRY</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }

        .sticky-header {
            position: sticky;
            top: 0;
            z-index: 1;
        }

        .sticky-footer {
            position: sticky;
            bottom: 0;
            z-index: 1;
            background-color: whitesmoke;
        }
    </style>
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->

</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->
    @section('tittle') {{"EXPENSE REQUEST ENTRY"}}@endsection

    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="live-preview">
                                        <form method="POST" action="{{ route('travExpenseSave') }}" enctype="multipart/form-data" class="has-validated" id="validate">
                                            @csrf
                                            <div class="row">
                                                <!-- ENO -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">ENO</label>
                                                        <input type="text" name="ENo" class="form-control dull" value="{{ $result }}" readonly>
                                                    </div>
                                                </div>
                                                <!-- FROM -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label>FROM<span class="login-danger">*</span></label>
                                                        <input type="date" name="from_date" id="from_date" onkeydown="return false;" min="{{ date('Y-m-d') }}" value="{{ old('from_date', now()->format('Y-m-d')) }}" class="form-control">
                                                    </div>
                                                </div>
                                                <!-- TO -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label>TO<span class="login-danger">*</span></label>
                                                        <input type="date" name="to_date" id="to_date" onkeydown="return false;" min="{{ date('Y-m-d') }}" value="{{ old('to_date', now()->format('Y-m-d')) }}" class="form-control">
                                                    </div>
                                                </div>
                                                <!-- ADD EXPENSE LIST -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">ADD LIST</label>
                                                        <div class="input-group">
                                                            <button type="button" class="btn btn-secondary" onclick="decreaseExpValue()">-</button>
                                                            <input type="number" class="form-control text-center" value="1" id="addExpense" name="N_Per" onchange="validateExpInput()" oninput="validateExpInput()" style="max-width: 60px;">
                                                            <button type="button" class="btn btn-secondary" onclick="increaseExpValue()">+</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- EXPENSE TABLE -->
                                            <h6 style="font-weight: bold;">EXPENSES</h6>
                                            <div class="card-body" style="display:block;">
                                                <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                                    <table class="table table-centered align-middle table-nowrap mb-0" id="expenseTable" style="line-height: 10px !important;">
                                                        <thead class="text-muted table-light sticky-header">
                                                            <tr>
                                                                <th data-sort="sno"> SNO <span class="sort-icon"></span></th>
                                                                <th class="d-none" data-sort="date"> Date <span class="sort-icon"></span></th>
                                                                <th data-sort="description"> Description <span class="login-danger">*</span> <span class="sort-icon"></span></th>
                                                                <th data-sort="transport"> Transport <span class="sort-icon"></span></th>
                                                                <th data-sort="hotel"> Hotel <span class="sort-icon"></span></th>
                                                                <th data-sort="food"> Food <span class="sort-icon"></span></th>
                                                                <th data-sort="misc"> Miscellaneous <span class="sort-icon"></span></th>
                                                                <th data-sort="total"> Total <span class="sort-icon"></span></th>
                                                                <th class="d-none" data-sort="with-bill"> With Bill <span class="sort-icon"></span></th>
                                                                <th data-sort="remove"> Remove <span class="sort-icon"></span></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="tableBodyExp">
                                                            <tr>
                                                                <td>1</td>
                                                                <td class="d-none">
                                                                    <input type="date" class="form-control" name="expense[0][date]" id="">
                                                                </td>
                                                                <td>
                                                                    <input type="text" class="form-control" name="expense[0][description]" id="" placeholder="Reason" required>
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][transport]" id="" min="1" placeholder="Rs.00">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][hotel]" id="" placeholder="Rs.00">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][food]" id="" placeholder="Rs.00">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control expense-input" name="expense[0][misc]" id="" placeholder="Rs.00">
                                                                </td>
                                                                <td>
                                                                    <input type="number" class="form-control total-expense dull" name="expense[0][total]" id="" placeholder="Rs.00" readonly>
                                                                </td>
                                                                <td class="d-none">
                                                                    <input type="checkbox" class="col-lg-6" name="expense[0][with_bill]" id="">
                                                                </td>
                                                                <td>
                                                                    <button type="button" class="btn btn-danger removeExpRow">X</button>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                        <tfoot class="sticky-footer">
                                                            <tr>
                                                                <td colspan="2" style="text-align: end;"><b>Total</b></td>
                                                                <td><input type="text" id="totalTransport" class="form-control" disabled></td>
                                                                <td><input type="text" id="totalHotel" class="form-control" disabled></td>
                                                                <td><input type="text" id="totalFood" class="form-control" disabled></td>
                                                                <td><input type="text" id="totalMisc" class="form-control" disabled></td>
                                                                <td><input type="text" id="grandTotal" name="grandTotal" class="form-control dull" readonly></td>
                                                                <td></td>
                                                            </tr>
                                                        </tfoot>
                                                    </table>
                                                </div>
                                            </div>
                                            <br>
                                            <!-- ADD PERSON -->
                                            <div class="row">
                                                <div class="col-md-2">
                                                    <div class="mb-2">
                                                        <label for="firstNameinput" class="form-label">ADD PERSON</label>
                                                        <div class="input-group">
                                                            <span class="input-group-btn">
                                                                <button type="button" class="btn btn-secondary" onclick="decreaseValue()">-</button>
                                                            </span>
                                                            <input type="number" class="form-control" value="1" placeholder="0" id="numberOfPerson" name="totPer" onchange="validateInput()" oninput="validateInput()" style="text-align: center;">
                                                            <span class="input-group-btn">
                                                                <button type="button" class="btn btn-secondary" onclick="increaseValue()">+</button>
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php $user_name = session('emp_name') ?>
                                            <?php $user_tkno = session('user_data') ?>
                                            <?php $user_posit = session('des_data') ?>
                                            <!-- EMP TABLE -->
                                            <div class="card-body" style="display:block;">
                                                <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                                    <table class="table table-centered align-middle table-nowrap mb-0" id="personTable" style="line-height: 30px !important;">
                                                        <thead class="text-muted table-light sticky-header">
                                                            <tr>
                                                                <th data-sort="sno"> SNO <span class="sort-icon"></span></th>
                                                                <th data-sort="name"> Name <span class="sort-icon"></span></th>
                                                                <th data-sort="tkno"> TK No <span class="sort-icon"></span></th>
                                                                <th data-sort="designation"> Designation <span class="sort-icon"></span></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="tableBody">
                                                            <tr>
                                                                <td>1</td>
                                                                <td>{{$user_name}}</td>
                                                                <td>{{$user_tkno}}</td>
                                                                <td>{{$user_posit}}</td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                            <br>
                                            <!-- TRAVEL PURPOSE (REMARKS) -->
                                            <div class="row">
                                                <div class="col-md-4 mt-3">
                                                    <label for="validationTextarea" class="form-label">TRAVEL PURPOSE :<span class="login-danger"></span></label>
                                                </div>
                                                <div class="col-md-4 mb-2">
                                                    <input type="file" name="File1" class="form-control">
                                                </div>
                                                <div class="col-md-4 mb-2">
                                                    <input type="file" name="File2" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <textarea class="form-control" name="Remark" rows="2" placeholder="Enter Remarks..."></textarea>
                                            </div>
                                            <br>
                                            <!--  SUBMIT BUTTON -->
                                            <div class="d-flex justify-content-around pb-2">
                                                <input type="submit" value="SUBMIT" class="btn btn-primary">
                                                <button type="button" class="btn btn-info" onclick="window.location.href = '/travExp_Rep'">Report</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>



    <!-- INCREASE TABLE ROWS BASED ON NO OF EMP -->
    <script>
        // FILLING EMPLOYEE TNO & DESIGNATION IN THE TABLE
        function populateTnoAndDesignation(selectElement) {
            var selectedValue = selectElement.value;
            var tnoAndDesgn = selectedValue.split('|');
            var tno = tnoAndDesgn[0];
            var desgn = tnoAndDesgn[1];

            var row = selectElement.parentElement.parentElement; // Get the parent row
            var tnoCell = row.querySelector("#tno_" + row.cells[0].innerText);
            var desgnCell = row.querySelector("#desgn_" + row.cells[0].innerText);

            tnoCell.innerText = tno;
            desgnCell.innerText = desgn;
        }

        // ADDIND ROWS
        function addRows() {
            var numberOfRows = document.getElementById('numberOfPerson').value;
            var tableBody = document.getElementById('tableBody');
            var currentRows = tableBody.getElementsByTagName('tr').length;

            // Remove excess rows if necessary
            while (currentRows > numberOfRows) {
                tableBody.removeChild(tableBody.lastChild);
                currentRows--;
            }

            // Add new rows if necessary
            for (var i = currentRows + 1; i <= numberOfRows; i++) {
                var newRow = document.createElement('tr');
                newRow.innerHTML = `
                <td>${i}</td>
                <td style="width:200px;">
                    <select name="selectName[]" class="select" onchange="populateTnoAndDesignation(this)" required>
                        <option value="" disabled selected>--SELECT--</option>
                        @foreach ($Name as $pasng)
                            <option value="{{ $pasng['tno'] }}|{{ $pasng['desgn'] }}|{{ $pasng['Emplno'] }}">{{ $pasng['name'] }}</option>
                        @endforeach
                    </select>
                </td>
                <td><span id="tno_${i}"></span></td>
                <td><span id="desgn_${i}"></span></td>`;
                tableBody.appendChild(newRow);
            }

            // Show/hide table based on the value of numberOfPerson
            var table = document.getElementById('personTable');
            table.style.display = numberOfRows > 0 ? 'table' : 'none';

            // Initialize Select2 for the new select element
            $('.select').select2();
        }
    </script>

    <!-- CONDITIONS FOR ADD PERSON INPUT -->
    <script>
        function decreaseValue() {
            var inputElement = document.getElementById('numberOfPerson');
            var value = parseInt(inputElement.value);
            if (value > 1) {
                inputElement.value = value - 1;
                addRows(); // Call addRows() to update the table rows
            }
        }

        function increaseValue() {
            var inputElement = document.getElementById('numberOfPerson');
            var value = parseInt(inputElement.value);
            inputElement.value = value + 1;
            addRows(); // Call addRows() to update the table rows
        }

        function validateInput() {
            var input = document.getElementById("numberOfPerson");
            var value = parseInt(input.value);

            if (isNaN(value) || value < 1) {
                input.value = 1; // Set the value to 1 if it's less than 1 or not a number
            }
            // Call the addRows() function here if needed
            addRows();
        }
    </script>

    <!-- CONDITIONS FOR ADD EXPENSE INPUT -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const tableBody = document.getElementById("tableBodyExp");

            // Function to calculate total
            function calculateTotal(row) {
                let total = 0;
                row.querySelectorAll(".expense-input").forEach(input => {
                    total += parseFloat(input.value) || 0;
                });
                row.querySelector(".total-expense").value = total.toFixed(2);
            }

            function calculateGrandTotal() {
                let totalTrans = 0,
                    totalHotel = 0,
                    totalFood = 0,
                    totalMisc = 0,
                    totalGrand = 0;

                document.querySelectorAll("#tableBodyExp tr").forEach(row => {
                    totalTrans += parseFloat(row.children[3].querySelector("input").value) || 0;
                    totalHotel += parseFloat(row.children[4].querySelector("input").value) || 0;
                    totalFood += parseFloat(row.children[5].querySelector("input").value) || 0;
                    totalMisc += parseFloat(row.children[6].querySelector("input").value) || 0;
                    totalGrand += parseFloat(row.children[7].querySelector("input").value) || 0;
                });
                document.getElementById("totalTransport").value = totalTrans.toFixed(2);
                document.getElementById("totalHotel").value = totalHotel.toFixed(2);
                document.getElementById("totalFood").value = totalFood.toFixed(2);
                document.getElementById("totalMisc").value = totalMisc.toFixed(2);
                document.getElementById("grandTotal").value = totalGrand.toFixed(2);
            }

            // Event listener for input changes
            tableBody.addEventListener("input", function(event) {
                if (event.target.classList.contains("expense-input")) {
                    const row = event.target.closest("tr");
                    calculateTotal(row);
                    calculateGrandTotal();
                }
            });

            // Remove row event
            tableBody.addEventListener("click", function(event) {
                if (event.target.classList.contains("removeExpRow")) {
                    if (tableBody.getElementsByTagName('tr').length > 1) {
                        event.target.closest("tr").remove();
                        updateRowNumbers(); // Renumber rows after deletion
                        updateAddExpenseInput(); // Update the addExpense input value
                        calculateGrandTotal();
                    } else {
                        alert("You must have at least one row in the table.");
                    }
                }
            });
        });

        // Function to update row numbering
        function updateRowNumbers() {
            const rows = document.querySelectorAll("#tableBodyExp tr");
            rows.forEach((row, index) => {
                row.querySelector("td:first-child").textContent = index + 1;
            });
        }

        // Function to update the addExpense input value
        function updateAddExpenseInput() {
            var tableBody = document.getElementById('tableBodyExp');
            var numberOfRows = tableBody.getElementsByTagName('tr').length;
            document.getElementById('addExpense').value = numberOfRows; // Set the value to the current number of rows
        }

        // Add/Remove rows based on input value
        function addExpRows() {
            var numberOfRows = document.getElementById('addExpense').value;
            var tableBody = document.getElementById('tableBodyExp');
            var currentRows = tableBody.getElementsByTagName('tr').length;

            while (currentRows > numberOfRows) {
                tableBody.removeChild(tableBody.lastElementChild);
                currentRows--;
            }

            for (var i = currentRows; i < numberOfRows; i++) { // Start from current count
                var newRow = document.createElement('tr');
                newRow.innerHTML = `
                    <td>${i + 1}</td>
                    <td class="d-none"><input type="date" class="form-control" name="expense[${i}][date]"></td>
                    <td><input type="text" class="form-control" name="expense[${i}][description]" placeholder="Reason" required></td>
                    <td><input type="number" class="form-control expense-input" name="expense[${i}][transport]" min="1" placeholder="Rs.00"></td>
                    <td><input type="number" class="form-control expense-input" name="expense[${i}][hotel]" placeholder="Rs.00"></td>
                    <td><input type="number" class="form-control expense-input" name="expense[${i}][food]" placeholder="Rs.00"></td>    
                    <td><input type="number" class="form-control expense-input" name="expense[${i}][misc]" placeholder="Rs.00"></td>
                    <td><input type="number" class="form-control total-expense dull" name="expense[${i}][total]" placeholder="Rs.00" readonly></td>
                    <td class="d-none"><input type="checkbox" class="col-lg-6" name="expense[${i}][with_bill]"></td>
                    <td><button type="button" class="btn btn-danger removeExpRow">X</button></td>
                `;
                tableBody.appendChild(newRow);
            }
            updateRowNumbers();
            document.getElementById('addExpense').value = numberOfRows;
            document.getElementById('expenseTable').style.display = numberOfRows > 0 ? 'table' : 'none';
        }


        // Increase and decrease buttons
        function decreaseExpValue() {
            var inputElement = document.getElementById('addExpense');
            var value = parseInt(inputElement.value);
            if (value > 1) {
                inputElement.value = value - 1;
                addExpRows();
            }
        }

        function increaseExpValue() {
            var inputElement = document.getElementById('addExpense');
            var value = parseInt(inputElement.value);
            inputElement.value = value + 1;
            addExpRows();
        }

        // Validate input value
        function validateExpInput() {
            var input = document.getElementById("addExpense");
            var value = parseInt(input.value);

            if (isNaN(value) || value < 1) {
                input.value = 1;
            }
            addExpRows();
        }
    </script>

    <!-- SEARCH -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('alert'))
    <div id="errorAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var errorAlert = document.getElementById('errorAlert');
            if (errorAlert) {
                errorAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>