<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>ADVANCE EXPENSE APPROVE</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <!-- EXCEL -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.3/xlsx.full.min.js"></script>

    <!-- STYLE FOR PAGINATION -->
    <style>
        .pagination {
            justify-content: space-between;
            margin-left: 10px;
        }

        #pagination {
            margin-right: 15px;
            display: inline-block;
            vertical-align: middle;
            border-radius: 4px;
            padding: 1px 2px 4px 2px;
            border-top: 1px solid #AEAEAE;
            border-bottom: 1px solid #FFFFFF;
            background-color: #DADADA;
            background-image: -webkit-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -moz-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -ms-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -o-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: linear-gradient(top, #DBDBDB, #E2E2E2);
        }

        #pagination #pag_a,
        #pagination #pag_i {
            display: inline-block;
            vertical-align: middle;
            width: 22px;
            color: #7D7D7D;
            text-align: center;
            font-size: 10px;
            padding: 3px 0 2px 0;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            -o-user-select: none;
            user-select: none;
        }

        #pagination #pag_a {
            margin: 0 2px 0 2px;
            border-radius: 4px;
            border: 1px solid #E3E3E3;
            cursor: pointer;
            box-shadow: inset 0 1px 0 0 #FFF, 0 1px 2px #666;
            text-shadow: 0 1px 1px #FFF;
            background-color: #E6E6E6;
            background-image: -webkit-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -moz-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -ms-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -o-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: linear-gradient(top, #F3F3F3, #D7D7D7);
        }

        #pagination #pag_i {
            margin: 0 3px 0 3px;
        }

        #pagination #pag_a.current {
            border: 1px solid #E9E9E9;
            box-shadow: 0 1px 1px #999;
            background-color: #DFDFDF;
            background-image: -webkit-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -moz-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -ms-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -o-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: linear-gradient(top, #D0D0D0, #EBEBEB);
        }
    </style>

    <!-- FONT -->
    <!-- <style>
        .row label,
        .card-title {
            font-weight: bold;
            font-size: medium;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .form-heading h4 {
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .card-body .table-responsive table thead th {
            color: black;
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .card-body .table-responsive table tbody td {
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }
    </style> -->

    <!-- STATUS -->
    <style>
        .status {
            padding: .1rem 0;
            border-radius: 2rem;
            text-align: center;
            margin-top: 10px;
        }

        .status.Approved {
            /* background-color: #86e49d; */
            /* color: #006b21; */
            color: green;
            font-weight: bold;
            border: 1px solid pink;
            outline: 2px dashed greenyellow;
            /* -webkit-text-stroke: 0.5px black; */

        }

        .status.Reject {
            /* background-color: #d893a3; */
            color: #b30021;
            font-weight: bold;
            border: 2px solid pink;
            outline: 2px dashed #d893a3;

        }

        .status.Request {
            /* background-color: #ebc474; */
            color: #FABA5F;
            font-weight: bold;
            border: 2px solid #FF9F00;
            outline: 2px dashed #FF9944;
            width: 100px;

        }

        .status.shipped {
            background-color: #6fcaea;
        }
    </style>

    <!-- TABLE DESIGN -->
    <style>
        .card-body .table-responsive .table tbody tr td {
            padding: 0 25px !important;
            height: 3px;
            vertical-align: middle !important;
        }

        .card-header {
            height: 60px;
        }

        .card-header .col-md-3 select {
            margin-top: 10px;
        }

        .table-responsive {
            position: relative;
            overflow: auto;
        }

        .table thead th {
            position: sticky;
            top: 0;
            z-index: 1;
        }
    </style>

    <!-- EXAMPLE TABLE -->
    <style>
        .card-body #table-fixed-header .gridjs .gridjs-wrapper .gridjs-table .gridjs-tbody .gridjs-tr .gridjs-td {
            padding: 0 25px !important;
            height: 3px !important;
            vertical-align: middle !important;
        }

        .card-header {
            height: 60px;
        }

        .card-header .col-md-3 select {
            margin-top: 10px;
        }
    </style>

    <style>
        .hidden_data {
            display: none;
        }

        .centered {
            display: flex;
            align-items: center;
            justify-content: center;
        }
    </style>
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->
    <!-- DETAILS MODAL STYLE -->

    <style>
        /* MODAL BACKDROP */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            /* Dark overlay */
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* MODAL CONTENT */
        .modal-content {
            background: #fff;
            padding: 20px;
            width: 60%;
            max-width: 800px;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            animation: fadeIn 0.3s ease-in-out;
            position: relative;
            max-height: 80vh;
            /* Avoid overflow */
            overflow-y: auto;
            /* Scroll if needed */
        }

        /* CLOSE BUTTON */
        .close {
            position: absolute;
            top: 10px;
            right: 15px;
            font-size: 24px;
            cursor: pointer;
            color: #555;
        }

        .close:hover {
            color: #000;
        }

        /* HEADINGS */
        .modal-content h3 {
            margin-top: 0;
            font-size: 22px;
            text-align: center;
            color: #333;
        }

        /* TABLE STYLING */
        #detailsModel table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        #detailsModel th,
        #detailsModel td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        #detailsModel th {
            background-color: #007bff;
            color: white;
        }

        #detailsModel tbody tr:nth-child(even) {
            background-color: #f2f2f2;
        }
    </style>

</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->
    @section('tittle') {{"TRAVEL EXPENSE APPROVE"}}@endsection

    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">

                                <!-- ALERT MESSAGE -->
                                @if ($message = Session::get('success'))
                                <div id="successAlert" class="alert alert-success alert-dismissible fade show mt-2 " role="alert">
                                    {{$message}}
                                </div>
                                <script>
                                    // Automatically close the alert after 3 seconds
                                    setTimeout(function() {
                                        var successAlert = document.getElementById('successAlert');
                                        if (successAlert) {
                                            successAlert.remove();
                                        }
                                    }, 15000);
                                </script>
                                @endif

                                @if ($errors->any())
                                <div id="ErrorAlert" class="alert alert-danger alert-dismissible fade show mt-2 " role="alert">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                                @endif

                                <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ SEARCH AND SHOW ENTRIES @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="page-table-header mb-2">
                                            <div class="row align-items-center">
                                                <div class="doctor-table-blk">
                                                    <div class="doctor-search-blk">
                                                        <div class="top-nav-search table-search-blk">
                                                            <form action="javascript:;">
                                                                <div class="d-flex justify-content-between align-items-center">
                                                                    <div class="search-container" style="margin-left: 10px;">
                                                                        <input type="text" id="search-input" class="form-control" placeholder="Search here">
                                                                    </div>
                                                                    <div class="ml-2 col-md-1" style="margin-right: 10px;">
                                                                        <select name="state" id="maxRows" class="form-select">
                                                                            <option value="10">10</option>
                                                                            <option value="50">50</option>
                                                                            <option value="70">70</option>
                                                                            <option value="100">100</option>
                                                                            <option value="5000">Show ALL Rows</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ TABLE @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->

                                <form action="{{ route('travExp_App1') }}" method="POST">
                                    @csrf
                                    <div class="card-body">
                                        <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                            <table class="table table-centered align-middle table-nowrap mb-0" id="dataTable" style="line-height: 30px !important;">
                                                <thead class="text-muted table-light">
                                                    <tr>
                                                        <th>
                                                            <input type="checkbox" class="check" id="checkAll">
                                                        </th>
                                                        <th data-sort="sno">SNO <span class="sort-icon"></span></th>
                                                        <th data-sort="eno">ENO <span class="sort-icon"></span></th>
                                                        <th data-sort="entDate">Entry Date <span class="sort-icon"></span></th>
                                                        <th data-sort="from_date">From Date <span class="sort-icon"></span></th>
                                                        <th data-sort="to_date">To Date <span class="sort-icon"></span></th>
                                                        <th data-sort="entBy">Entry By <span class="sort-icon"></span></th>
                                                        <th data-sort="totPerson">No. Person <span class="sort-icon"></span></th>
                                                        <th data-sort="totAmt">Total Amt <span class="sort-icon"></span></th>
                                                        <th data-sort="remark">Remark <span class="sort-icon"></span></th>
                                                        <th data-sort="att1">Attachment 1 <span class="sort-icon"></span></th>
                                                        <th data-sort="att2">Attachment 2 <span class="sort-icon"></span></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($result1 as $index => $row)
                                                    <tr>
                                                        <td>
                                                            <div class="row">
                                                                <div class="row-item">
                                                                    <div class="checkbox">
                                                                        <input class="check" type="checkbox" name="ch[]" value="{{ $row['Rowid'] }} | {{ $row['Total_Amount'] }}
                                                                        | {{ $row['Entry_Name'] }}| {{ $row['Entry_TNo'] }}| {{ $row['Ent_Mail'] }}
                                                                        | {{ $row['App_Name'] }}| {{ $row['App_TNo'] }}| {{ $row['App_Mail1'] }}" />
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>{{$index + 1}}</td>
                                                        <td>
                                                            <a href=" javascript:void(0);" class="viewDetails" data-rowid="{{ $row['Rowid'] }}" style="color:blue; font-weight: bold;">
                                                                {{$row['ENO']}}
                                                            </a>
                                                        </td>
                                                        <td>{{ date('Y-m-d',strtotime($row['Entry_Date'])) }}</td>
                                                        <td>{{ date('Y-m-d',strtotime($row['FDate'])) }}</td>
                                                        <td>{{ date('Y-m-d',strtotime($row['TDate'])) }}</td>
                                                        <td>{{ $row['Entry_Name'] }}</td>
                                                        <td>{{ $row['NoOfPerson'] }}</td>
                                                        <td>{{ $row['Total_Amount'] }}</td>
                                                        <td>{{ $row['Remark'] }}</td>
                                                        <td>
                                                            @if ($row['Attachment1'] == "")
                                                            --
                                                            @else
                                                            <a href="{{ asset('/TravelExpReqEntry/' . $row['Attachment1']) }}" target="_blank">
                                                                {{ $row['Attachment1'] }}
                                                            </a>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            @if ($row['Attachment2'] == "")
                                                            --
                                                            @else
                                                            <a href="{{ asset('/TravelExpReqEntry/' . $row['Attachment2']) }}" target="_blank">
                                                                {{ $row['Attachment2'] }}
                                                            </a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <!--############################### PAGINATION ###############################-->
                                    <div class="pagination">
                                        <div id="entryCount">Total entries: <span id="rowCount"></span></div>
                                        <div id="searchCount"></div>
                                        <div id="pagination"></div>
                                    </div>
                                    <div class="d-flex justify-content-around pb-2">
                                        <input type="submit" name="submit" value="APPROVED" id="approve" class="btn btn-success">
                                        <input type="submit" name="submit" value="REJECTED" id="reject" class="btn btn-danger">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- DETAILS MODEL -->
    <div id="detailsModel" class="modal" style="display: none;">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h3>Travel Expense Details</h3>
            <!-- EMP DETAILS -->
            <table id="empDetails">
                <thead>
                    <tr>
                        <th>SNO</th>
                        <th>Name</th>
                        <th>TNO</th>
                        <th>DESIGNATION</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- DATA WILL APPEAR HERE -->
                </tbody>
            </table>
            <!-- EXPENSE DETAILS -->
            <table id="expDetails">
                <thead>
                    <tr>
                        <th>SNO</th>
                        <th>REASON</th>
                        <th>TRANSPORT</th>
                        <th>HOTEL</th>
                        <th>FOOD</th>
                        <th>MISCELLANEOUS</th>
                        <th>TOTAL Rs.</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- DATA WILL APPEAR HERE -->
                </tbody>
            </table>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>

    <!-- DETAILS MODEL -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $(".viewDetails").click(function() {
                var rowid = $(this).data("rowid");

                $.ajax({
                    url: "{{ route('travExp_RepDet') }}",
                    type: "GET",
                    data: {
                        id: rowid
                    },
                    success: function(response) {
                        debugger;
                        var resultEmp = response.resultEmpDt;
                        var resultDts = response.resultDt;

                        // CLEAR EXISTING TABLE
                        $("#empDetails tbody").empty();
                        $("#expDetails tbody").empty();

                        // CHECK IF NO DATA EXISTS
                        if (resultEmp.length === 0) {
                            $("#empDetails tbody").append(
                                `<tr>
                                    <td colspan="4" style="text-align: center; font-weight: bold; color: red;">NO EXTRA PERSON</td>
                                </tr>`
                            );
                        }

                        $.each(resultEmp, function(index, item) {
                            $("#empDetails tbody").append(
                                `<tr>
                                    <td>${index + 1}</td>
                                    <td>${item.Name}</td>
                                    <td>${item.tno}</td>
                                    <td>${item.DesignationName}</td>
                                </tr>`
                            );
                        });

                        $.each(resultDts, function(index, item) {
                            $("#expDetails tbody").append(
                                `<tr>
                                    <td>${index + 1}</td>
                                    <td>${item.Reason}</td>
                                    <td>${item.Transport}</td>
                                    <td>${item.Hotel}</td>
                                    <td>${item.Food}</td>
                                    <td>${item.Misc}</td>
                                    <td>${item.Total}</td>
                                </tr>`
                            );
                        });
                        $("#detailsModel").show();
                    }
                });
            });
            $(".close").click(function() {
                $("#detailsModel").hide();
            });

            // Close Modal on Clicking Outside the Modal
            $(window).click(function(event) {
                if (event.target.id === "detailsModel") {
                    $("#detailsModel").hide();
                }
            });
        });
    </script>

    <!-- SELECT ALL -->
    <script>
        $(document).ready(function() {
            // Select all checkboxes
            $("#checkAll").on("click", function() {
                $(".check").prop("checked", this.checked);
            });

            // Uncheck 'Select All' if any checkbox is unchecked
            $(".check").on("click", function() {
                if ($(".check:checked").length == $(".check").length) {
                    $("#checkAll").prop("checked", true);
                } else {
                    $("#checkAll").prop("checked", false);
                }
            });
        });
    </script>

    <!-- POPUP FOR APPROVE -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Get a reference to the "REJECT" button by its ID
            var approveButton = document.getElementById("approve");

            // Add a click event listener to the button
            approveButton.addEventListener("click", function(event) {
                // Get all checkboxes
                var checkboxes = document.querySelectorAll(".check");
                var isChecked = Array.from(checkboxes).some(checkbox => checkbox.checked);

                if (!isChecked) {
                    alert("Please select at least one row before approving.");
                    event.preventDefault(); // Prevent form submission
                    return;
                }

                // Display confirmation dialog
                var confirmation = confirm("Are you sure you want to Approve?");
                if (!confirmation) {
                    event.preventDefault();
                }
            });
        });
    </script>

    <!-- POPUP FOR REJECT -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Get a reference to the "REJECT" button by its ID
            var rejectButton = document.getElementById("reject");

            rejectButton.addEventListener("click", function(event) {
                // Get all checkboxes
                var checkboxes = document.querySelectorAll(".check");
                var isChecked = Array.from(checkboxes).some(checkbox => checkbox.checked);

                if (!isChecked) {
                    alert("Please select at least one row before Reject.");
                    event.preventDefault(); // Prevent form submission
                    return;
                }

                // Display confirmation dialog
                var confirmation = confirm("Are you sure you want to Reject?");
                if (!confirmation) {
                    event.preventDefault();
                }
            });
        });
    </script>

    <!-- SORTING -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.sort-icon').html('<i class="fas fa-sort"></i>'); // Display the sort icon by default

            $('th[data-sort]').click(function() {
                const column = $(this).data('sort');
                const sortOrder = $(this).hasClass('asc') ? 'desc' : 'asc';

                // Reset sorting indicators
                $('th[data-sort]').removeClass('asc desc');
                $('.sort-icon').html('<i class="fas fa-sort"></i>');

                // Apply sorting indicator to the clicked column
                $(this).addClass(sortOrder);
                $(this).find('.sort-icon i').removeClass().addClass(sortOrder === 'asc' ? 'fas fa-sort-up' : 'fas fa-sort-down');

                // Perform sorting logic based on the column and sortOrder
                sortTable(column, sortOrder);
            });

            function sortTable(column, sortOrder) {
                const rows = $('tbody tr').get();

                rows.sort(function(a, b) {
                    let keyA = $(a).find(`td:eq(${getColumnIndex(column)})`).text();
                    let keyB = $(b).find(`td:eq(${getColumnIndex(column)})`).text();

                    if (!isNaN(parseFloat(keyA)) && !isNaN(parseFloat(keyB))) {
                        keyA = parseFloat(keyA);
                        keyB = parseFloat(keyB);
                    }

                    if (sortOrder === 'asc') {
                        if (isNaN(keyA) || isNaN(keyB)) {
                            return keyA.localeCompare(keyB);
                        } else {
                            return keyA - keyB;
                        }
                    } else {
                        if (isNaN(keyA) || isNaN(keyB)) {
                            return keyB.localeCompare(keyA);
                        } else {
                            return keyB - keyA;
                        }
                    }
                });

                $.each(rows, function(index, row) {
                    $('tbody').append(row);
                });
            }

            function getColumnIndex(column) {
                return $('thead th[data-sort="' + column + '"]').index();
            }
        });
    </script>

    <!-- PRINT -->
    <script>
        let printtable = new function() {
            this.printTable = function() {
                let tab = document.getElementById('dataTable');
                let win = window.open('', '', 'height=700,width=700');
                win.document.write(tab.outerHTML);
                win.document.close();
                win.print();
                win.close(); // Add this line to close the window after printing
            }

        }
    </script>

    <!-- EXPORT AS EXCEL -->
    <script>
        function export_table_to_xlsx(table, filename) {
            var wb = XLSX.utils.table_to_book(table, {
                sheet: "Sheet1"
            });
            var ws = wb.Sheets["Sheet1"];

            // Calculate column widths based on content
            var range = XLSX.utils.decode_range(ws['!ref']);
            for (var C = range.s.c; C <= range.e.c; ++C) {
                var max_len = 0;
                for (var R = range.s.r; R <= range.e.r; ++R) {
                    var cell = ws[XLSX.utils.encode_cell({
                        r: R,
                        c: C
                    })];
                    if (cell && cell.v) {
                        var len = String(cell.v).length;
                        if (len > max_len) {
                            max_len = len;
                        }
                    }
                }
                if (max_len > 0) {
                    ws['!cols'] = ws['!cols'] || [];
                    ws['!cols'][C] = {
                        wch: max_len + 2
                    };
                }
            }

            XLSX.writeFile(wb, filename);
        }

        document.querySelector("#exportExcelBtn").addEventListener("click", function(event) {
            event.preventDefault(); // Prevent default action of anchor tag
            var table = document.querySelector("table");
            if (table) {
                export_table_to_xlsx(table, "Trav_Expense_Req_Entry.xlsx");
            } else {
                console.error("Table not found!");
            }
        });
    </script>

    <!-- SEARCH -->
    <script>
        $(document).ready(function() {
            // Define a variable to store the search value
            var searchValue = "";

            // Search function
            function performSearch() {
                var matches = $("#dataTable tbody tr").filter(function() {
                    return $(this).text().toLowerCase().indexOf(searchValue) > -1;
                });

                if (searchValue === "") {
                    // If the search bar is empty, clear the search results and count
                    $("#searchCount").text("");
                    $("#entryCount").show(); // Show the entry count
                    $("#dataTable tbody tr").toggle(true);
                    updateRowsPerPage(); // Call the function to reset displayed rows
                } else {
                    $("#entryCount").hide(); // Hide the entry count
                    // Show the search count and hide rows that don't match the search criteria
                    $("#searchCount").text(matches.length + " result(s) found");

                    // Get the selected rows per page value
                    var maxRows = parseInt($("#maxRows").val());

                    // Limit the matches to the selected rows per page
                    matches.slice(maxRows).toggle(false);
                    matches.slice(0, maxRows).toggle(true);
                    $("#dataTable tbody tr").not(matches).toggle(false);
                }
            }

            // Search input keyup event
            $("#search-input").on("keyup", function() {
                searchValue = $(this).val().toLowerCase();
                performSearch();
            });

            // maxRows dropdown change event
            $("#maxRows").on("change", function() {
                // Update rows per page and reapply search
                updateRowsPerPage();
                performSearch();
            });

            // Initialize search and rows per page
            performSearch();
            updateRowsPerPage();
        });
    </script>

    <!-- SHOW ENTRIES TABLE -->
    <script>
        // Function to update the number of displayed rows
        function updateRowsPerPage() {
            var maxRows = parseInt(document.getElementById("maxRows").value);
            var tableBody = document.getElementById("tableBody");
            var dataTable = document.getElementById("dataTable");
            var rows = dataTable.getElementsByTagName("tr");

            for (var i = 1; i < rows.length; i++) {
                if (i <= maxRows) {
                    rows[i].style.display = "";
                } else {
                    rows[i].style.display = "none";
                }
            }
        }

        // Add an event listener to the maxRows dropdown
        document.getElementById("maxRows").addEventListener("change", updateRowsPerPage);

        // Initial call to set the initial number of displayed rows
        updateRowsPerPage();
    </script>

    <!-- PAGINATION -->
    <script>
        var Pagination = {

            code: '',

            // --------------------
            // Utility
            // --------------------

            // converting initialize data
            Extend: function(data) {
                data = data || {};
                Pagination.size = data.size || 3000;
                Pagination.page = data.page || 5;
                Pagination.step = data.step || 5;
            },

            // add pages by number (from [s] to [f])
            Add: function(s, f) {
                for (var i = s; i < f; i++) {
                    Pagination.code += '<a id="pag_a">' + i + '</a>';
                }
            },

            // add last page with separator
            Last: function() {
                Pagination.code += '<i id="pag_i">...</i> <a id="pag_a">' + Pagination.size + '</a>';

            },

            // add first page with separator
            First: function() {
                Pagination.code += '<a id="pag_a">1</a> <i id="pag_i">...</i>';

            },



            // --------------------
            // Handlers
            // --------------------

            // change page
            Click: function() {
                Pagination.page = +this.innerHTML;
                Pagination.Start();
            },

            // previous page
            Prev: function() {
                Pagination.page--;
                if (Pagination.page < 1) {
                    Pagination.page = 1;
                }
                Pagination.Start();
            },

            // next page
            Next: function() {
                Pagination.page++;
                if (Pagination.page > Pagination.size) {
                    Pagination.page = Pagination.size;
                }
                Pagination.Start();
            },



            // --------------------
            // Script
            // --------------------

            // binding pages
            Bind: function() {
                var a = Pagination.e.getElementsByTagName('a');
                for (var i = 0; i < a.length; i++) {
                    if (+a[i].innerHTML === Pagination.page) a[i].className = 'current';
                    a[i].addEventListener('click', Pagination.Click, false);
                }

                // Retrieve the maxRows value
                var maxRows = parseInt(document.getElementById("maxRows").value);

                // Add this block to handle table pagination
                var table = document.getElementById('dataTable');
                var tbody = table.getElementsByTagName('tbody')[0];
                var rows = tbody.getElementsByTagName('tr');
                for (var i = 0; i < rows.length; i++) {
                    rows[i].style.display = 'none';
                }
                var start = (Pagination.page - 1) * maxRows;
                var end = start + maxRows;
                for (var i = start; i < end && i < rows.length; i++) {
                    rows[i].style.display = '';
                }
            },

            // write pagination
            Finish: function() {
                Pagination.e.innerHTML = Pagination.code;
                Pagination.code = '';
                Pagination.Bind();
            },

            // find pagination type
            Start: function() {
                var table = document.getElementById('dataTable');
                var rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

                // Retrieve the maxRows value
                var maxRows = parseInt(document.getElementById("maxRows").value);

                Pagination.size = Math.ceil(rows.length / maxRows);

                // Reset the code
                Pagination.code = '';

                if (Pagination.size < Pagination.step * 2 + 6) {
                    Pagination.Add(1, Pagination.size + 1);
                } else if (Pagination.page < Pagination.step * 2 + 1) {
                    Pagination.Add(1, Pagination.step * 2 + 4);
                    Pagination.Last();
                } else if (Pagination.page > Pagination.size - Pagination.step * 2) {
                    Pagination.First();
                    Pagination.Add(Pagination.size - Pagination.step * 2 - 2, Pagination.size + 1);
                } else {
                    Pagination.First();
                    Pagination.Add(Pagination.page - Pagination.step, Pagination.page + Pagination.step + 1);
                    Pagination.Last();
                }
                Pagination.Finish();
                Pagination.Bind();
            },



            // --------------------
            // Initialization
            // --------------------

            // binding buttons
            Buttons: function(e) {
                var nav = e.getElementsByTagName('a');
                nav[0].addEventListener('click', Pagination.Prev, false);
                nav[1].addEventListener('click', Pagination.Next, false);
            },

            // create skeleton
            Create: function(e) {

                var html = [
                    '<a id="pag_a">◄</a>', // previous button
                    '<span></span>', // pagination container
                    '<a id="pag_a">►</a>' // next button
                ];

                e.innerHTML = html.join('');
                Pagination.e = e.getElementsByTagName('span')[0];
                Pagination.Buttons(e);
            },

            // init
            Init: function(e, data) {
                Pagination.Extend(data);
                Pagination.Create(e);
                Pagination.Start();
            }
        };



        /* * * * * * * * * * * * * * * * *
         * Initialization
         * * * * * * * * * * * * * * * * */

        var init = function() {
            // Initialize with data from the table
            Pagination.Init(document.getElementById('pagination'), {
                page: 1, // selected page
                step: '' // pages before and after current
            });
        };

        document.addEventListener('DOMContentLoaded', init, false);
    </script>

    <!-- SHOWS HOW MANY ENTRIES IN THE TABLE -->
    <script>
        // Add this code to update the entry count:

        function updateEntryCount() {
            var rowCount = $("#dataTable tbody tr").length;
            $("#rowCount").text(rowCount);
        }

        // Call the function to update the entry count after the page loads
        $(document).ready(function() {
            updateEntryCount();
        });
    </script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('alert'))
    <div id="errorAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var errorAlert = document.getElementById('errorAlert');
            if (errorAlert) {
                errorAlert.remove();
            }
        }, 5000);
    </script>
    @endif

</body>
@endsection

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>