<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>CAR BOOKING</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="Life-logo/logo.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="LifeAtGainup_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="LifeAtGainup_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="LifeAtGainup_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="LifeAtGainup_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="LifeAtGainup_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <style>
        .login-danger {
            color: red;
        }

        .dull {
            background-color: #F0F0F0;
        }
    </style>
    <!-- start spinner script -->
    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>
    <!-- end spinner script -->

</head>

<body id="body" class="">
    <!-- spinner -->
    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>
    <!-- spinner end -->
    @section('tittle') {{"CAR BOOKING"}}@endsection

    <div id="wrapper">
        @extends('LifeAtGainup.Navbar.nav')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="live-preview">
                                        <form method="POST" action="{{ route('car_book_save') }}" enctype="multipart/form-data" class="has-validated" id="validate">
                                            @csrf
                                            <div class="row">
                                                <!-- ENO -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">ENO</label>
                                                        <input type="text" name="ENo" class="form-control dull" value="{{ $ENO }}" readonly>
                                                    </div>
                                                </div>
                                                <!-- E-DATE -->
                                                <div class="col-md-3 d-none">
                                                    <div class="mb-3">
                                                        <label class="form-label">E-DATE<span class="login-danger"></span></label>
                                                        <input type="date" value="{{now()->format('Y-m-d')}}" class="form-control dull" readonly>
                                                    </div>
                                                </div>
                                                <!-- TYPE -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label>TYPE<span class="login-danger">*</span></label>
                                                        <select name="Type" class="form-select select2" required>
                                                            <option value="" disabled selected>--Select--</option>
                                                            @foreach ( $type as $key => $option )
                                                            @php
                                                            $Ty_Rowidd = $Ty_Rowid[$key];
                                                            @endphp
                                                            <option value="{{ $Ty_Rowidd }}"> {{ $option }} </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <!-- FROM -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label>FROM<span class="login-danger">*</span></label>
                                                        <select name="L_From" id="Fselect" class="form-select select2" required>
                                                            <option value="" disabled selected>Location</option>
                                                            @foreach ( $route as $key => $f_route)
                                                            @php
                                                            $R_Rowidd = $R_Rowid[$key];
                                                            @endphp
                                                            <option value="{{$R_Rowidd}}" data-name="{{ $f_route }}"> {{ $f_route }} </option>
                                                            @endforeach
                                                        </select>
                                                        <input type="hidden" id="selected_FRouteName" name="selected_FRouteName" class="form-control" readonly>
                                                    </div>
                                                </div>
                                                <!-- TO -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label>TO<span class="login-danger">*</span></label>
                                                        <select name="L_To" id="Tselect" class="form-select select2" required>
                                                            <option value="" disabled selected>Location</option>
                                                            @foreach ( $route as $key => $f_route)
                                                            @php
                                                            $R_Rowidd = $R_Rowid[$key];
                                                            @endphp
                                                            <option value="{{$R_Rowidd}}" data-name="{{ $f_route }}"> {{ $f_route }} </option>
                                                            @endforeach
                                                        </select>
                                                        <input type="hidden" id="selected_TRouteName" name="selected_TRouteName" class="form-control" readonly>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <div class="row">
                                                <!-- DATE -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label class="form-label">DATE<span class="login-danger">*</span></label>
                                                        <input type="date" name="B_date" min="{{ date('Y-m-d') }}" class="form-control" required>
                                                    </div>
                                                </div>
                                                <!-- TIME -->
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label>TIME<span class="login-danger">*</span></label>
                                                        <select name="B_Time" id="B_Time" class="form-select select2" required>
                                                            <option value="" disabled selected>--Select--</option>
                                                            @foreach ($time as $key => $timing )
                                                            @php
                                                            $Ti_Rowidd = $Ti_Rowid[$key];
                                                            @endphp
                                                            <option value="{{$Ti_Rowidd}}" data-name="{{ $timing }}"> {{$timing}} </option>
                                                            @endforeach
                                                        </select>
                                                        <input type="hidden" id="selected_Time" name="selected_Time" class="form-control" readonly>
                                                    </div>
                                                </div>
                                                <!-- REMARK -->
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label for="validationTextarea" class="form-label">REASON<span class="login-danger"></span></label>
                                                        <textarea class="form-control" name="Reason" rows="1"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                            <!-- ADD PERSON -->
                                            <div class="col-md-2">
                                                <div class="mb-3">
                                                    <label for="firstNameinput" class="form-label">ADD PERSON</label>
                                                    <div class="input-group">
                                                        <span class="input-group-btn">
                                                            <button type="button" class="btn btn-secondary" onclick="decreaseValue()">-</button>
                                                        </span>
                                                        <input type="number" class="form-control" value="1" placeholder="0" id="numberOfPerson" name="N_Per" onchange="validateInput()" oninput="validateInput()" readonly style="text-align: center;">
                                                        <span class="input-group-btn">
                                                            <button type="button" class="btn btn-secondary" onclick="increaseValue()">+</button>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>

                                            <input type="hidden" class="form-control" name="Book_no" value="{{ $bookno }}" readonly>
                                            <input type="hidden" class="form-control" value="{{ $Divison }}" name="Division" readonly>
                                            <input type="hidden" class="form-control" name="Buyer" value="0">
                                            <br>

                                            <?php $user_name = session('emp_name') ?>
                                            <?php $user_tkno = session('user_data') ?>
                                            <?php $user_posit = session('des_data') ?>

                                            <!-- TABLE -->
                                            <div class="card-body" style="display:block;">
                                                <div class="table-responsive table-card" style="max-height: 365px; overflow-y: auto;">
                                                    <table class="table table-centered align-middle table-nowrap mb-0" id="personTable" style="line-height: 30px !important;">
                                                        <thead class="text-muted table-light sticky-header">
                                                            <tr>
                                                                <th data-sort="sno"> SNO <span class="sort-icon"></th>
                                                                <th data-sort="name"> Name <span class="sort-icon"></th>
                                                                <th data-sort="tkno"> TK No <span class="sort-icon"></th>
                                                                <th data-sort="Design"> Designation <span class="sort-icon"></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="tableBody">
                                                            <tr>
                                                                <td>1</td>
                                                                <td>{{$user_name}}</td>
                                                                <td>{{$user_tkno}}</td>
                                                                <td>{{$user_posit}}</td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                            <br>

                                            <!--  SUBMIT BUTTON -->
                                            <div class=" d-flex justify-content-around pb-2">
                                                <input type="submit" value="SUBMIT" class="btn btn-primary">
                                                <button type="button" class="btn btn-info" onclick="window.location.href = '/car_booking_report'">Report</button>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <!-- JAVASCRIPT -->
    <script src="LifeAtGainup_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="LifeAtGainup_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <!-- prismjs plugin -->
    <script src="LifeAtGainup_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="LifeAtGainup_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="LifeAtGainup_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="LifeAtGainup_Assets/assets/js/app.js"></script>


    <!-- SAME FROM AND TO NOT SHOW -->
    <script>
        $(document).ready(function() {
            // Disable "Location" option in both dropdowns initially
            $('#Fselect option[value=""]').prop('disabled', true);
            $('#Tselect option[value=""]').prop('disabled', true);

            $('#Fselect').change(function() {

                // Get the selected option's data-name attribute
                var selectedOption = this.options[this.selectedIndex];
                var selectedRouteName = selectedOption.getAttribute('data-name');

                // Set the value of the input field with the selected route name
                document.getElementById('selected_FRouteName').value = selectedRouteName;

                var selectedFrom = $(this).val();
                $('#Tselect option').prop('disabled', false); // Enable all options in "TO"
                $('#Tselect option[value="' + selectedFrom + '"]').prop('disabled', true);
                $('#Tselect option[value=""]').prop('disabled', true); // Disable "Location" option again
            });

            $('#Tselect').change(function() {

                // Get the selected option's data-name attribute
                var selectedOption = this.options[this.selectedIndex];
                var selectedRouteName = selectedOption.getAttribute('data-name');

                // Set the value of the input field with the selected route name
                document.getElementById('selected_TRouteName').value = selectedRouteName;


                var selectedTo = $(this).val();
                $('#Fselect option').prop('disabled', false); // Enable all options in "FROM"
                $('#Fselect option[value="' + selectedTo + '"]').prop('disabled', true);
                $('#Fselect option[value=""]').prop('disabled', true); // Disable "Location" option again
            });


            $('#B_Time').change(function() {

                // Get the selected option's data-name attribute
                var selectedOption = this.options[this.selectedIndex];
                var selectedRouteName = selectedOption.getAttribute('data-name');

                // Set the value of the input field with the selected route name
                document.getElementById('selected_Time').value = selectedRouteName;

            });

        });
    </script>

    <!-- INCREASE TABLE ROWS BASED ON NO OF EMP -->
    <script>
        // FILLING EMPLOYEE TNO & DESIGNATION IN THE TABLE
        function populateTnoAndDesignation(selectElement) {
            var selectedValue = selectElement.value;
            var tnoAndDesgn = selectedValue.split('|');
            var tno = tnoAndDesgn[0];
            var desgn = tnoAndDesgn[1];

            var row = selectElement.parentElement.parentElement; // Get the parent row
            var tnoCell = row.querySelector("#tno_" + row.cells[0].innerText);
            var desgnCell = row.querySelector("#desgn_" + row.cells[0].innerText);

            tnoCell.innerText = tno;
            desgnCell.innerText = desgn;
        }

        // ADDIND ROWS
        function addRows() {
            var numberOfRows = document.getElementById('numberOfPerson').value;
            var tableBody = document.getElementById('tableBody');
            var currentRows = tableBody.getElementsByTagName('tr').length;

            // Remove excess rows if necessary
            while (currentRows > numberOfRows) {
                tableBody.removeChild(tableBody.lastChild);
                currentRows--;
            }

            // Add new rows if necessary
            for (var i = currentRows + 1; i <= numberOfRows; i++) {
                var newRow = document.createElement('tr');
                newRow.innerHTML = `
                <td>${i}</td>
                <td style="width:200px;">
                    <select name="selectName[]" class="select" onchange="populateTnoAndDesignation(this)" required>
                        <option value="" disabled selected>--SELECT--</option>
                        @foreach ($Name as $pasng)
                            <option value="{{ $pasng['C_TNO'] }}|{{ $pasng['C_Designation'] }}|{{ $pasng['Emplno'] }}">{{ $pasng['C_Name'] }}/{{ $pasng['C_TNO'] }}</option>
                        @endforeach
                    </select>
                </td>
                <td><span id="tno_${i}"></span></td>
                <td><span id="desgn_${i}"></span></td>`;
                tableBody.appendChild(newRow);
            }

            // Show/hide table based on the value of numberOfPerson
            var table = document.getElementById('personTable');
            table.style.display = numberOfRows > 0 ? 'table' : 'none';

            // Initialize Select2 for the new select element
            $('.select').select2();
        }
    </script>

    <!-- CONDITIONS FOR ADD PERSON INPUT -->
    <script>
        function checkMinimumValue() {
            var inputElement = document.getElementById('numberOfPerson');
            if (inputElement.value < 1) {
                inputElement.value = 1;
            }
        }

        function decreaseValue() {
            var inputElement = document.getElementById('numberOfPerson');
            var value = parseInt(inputElement.value);
            if (value > 1) {
                inputElement.value = value - 1;
                addRows(); // Call addRows() to update the table rows
            }
        }

        function increaseValue() {
            var inputElement = document.getElementById('numberOfPerson');
            var value = parseInt(inputElement.value);
            inputElement.value = value + 1;
            addRows(); // Call addRows() to update the table rows
        }

        function validateInput() {
            var input = document.getElementById("numberOfPerson");
            var value = parseInt(input.value);

            if (isNaN(value) || value < 1) {
                input.value = 1; // Set the value to 1 if it's less than 1 or not a number
            }

            // Call the addRows() function here if needed
            addRows();
        }
    </script>


    <!-- SEARCH -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>


    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('success'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($message = Session::get('alert'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

    @endsection
</body>

<!--!@#$%^&*())(*&^%$#@! ==[ THEME CHANGED BY SURYA 25-03-2024 ONWARDS ]== !@#$%^&*())(*&^%$#@!-->

</html>