<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <title>Login</title>
  <link rel="icon" href="gplogofinal.png" type="png">

  <style>
    @import url("https://fonts.googleapis.com/css?family=Montserrat:400,500,600,700,800,900");
    @import url("https://cdn.linearicons.com/free/1.0.0/icon-font.min.css");

    body {
      font-family: 'Montserrat', sans-serif;
      background: url("../assets/assets/Background.jpg");
      background-position: center;
      background-repeat: no-repeat;
      background-size: cover;
    }

    .weather-card {
      margin: 60px auto;
      height: 540px;
      width: 450px;
      background: #fff;
      box-shadow: 0 1px 38px rgba(0, 0, 0, 0.15), 0 5px 12px rgba(0, 0, 0, 0.25);
      overflow: hidden;
    }

    .weather-card .top {
      position: relative;
      height: 450px;
      width: 100%;
      overflow: hidden;
      background: url("../assets/assets/hw1.png") no-repeat;
      background-size: cover;
      background-position: center center;
      text-align: center;
    }

    .weather-card .top .wrapper {
      padding: 30px;
      position: relative;
      z-index: 1;
    }

    .weather-card .top .wrapper .mynav {
      height: 20px;
    }

    .weather-card .top .wrapper .mynav .lnr {
      color: #fff;
      font-size: 20px;
    }

    .weather-card .top .wrapper .mynav .lnr-chevron-left {
      display: inline-block;
      float: left;
    }

    .weather-card .top .wrapper .mynav .lnr-cog {
      display: inline-block;
      float: right;
    }

    .weather-card .top .wrapper .heading {
      margin-top: 20px;
      font-size: 35px;
      font-weight: 400;
      color: yellow;
    }

    .weather-card .top .wrapper .location {
      margin-top: 20px;
      font-size: 21px;
      font-weight: 400;
      color: #fff;
    }

    .weather-card .top .wrapper .temp {
      margin-top: 20px;
    }

    .weather-card .top .wrapper .temp a {
      text-decoration: none;
      color: #fff;
    }

    .weather-card .top .wrapper .temp a .temp-type {
      font-size: 45px;
    }

    .weather-card .top .wrapper .temp .temp-value {
      display: inline-block;
      font-size: 45px;
      font-weight: 600;
      color: #fff;
    }

    .weather-card .top .wrapper .temp .deg {
      display: inline-block;
      font-size: 35px;
      font-weight: 600;
      color: #fff;
      vertical-align: top;
      margin-top: 10px;
    }

    .weather-card .top:after {
      content: "";
      height: 100%;
      width: 100%;
      display: block;
      position: absolute;
      top: 0;
      left: 0;
      background: rgba(0, 0, 0, 0.5);
    }

    .weather-card .bottom {
      padding: 0 30px;
      background: #fff;
    }

    .weather-card .bottom .wrapper .forecast {
      overflow: hidden;
      margin: 0;
      font-size: 0;
      padding: 0;
      padding-top: 20px;
      max-height: 155px;
    }

    .weather-card .bottom .wrapper .forecast a {
      text-decoration: none;
      color: #000;
    }

    .weather-card .bottom .wrapper .forecast .go-up {
      text-align: center;
      display: block;
      font-size: 25px;
      margin-bottom: 10px;
    }

    .weather-card .bottom .wrapper .forecast li {
      display: block;
      font-size: 25px;
      font-weight: 400;
      color: rgba(0, 0, 0, 0.25);
      line-height: 1em;
      margin-bottom: 30px;
    }

    .weather-card .bottom .wrapper .forecast li .date {
      display: inline-block;
    }

    .weather-card .bottom .wrapper .forecast li .condition {
      display: inline-block;
      vertical-align: middle;
      float: right;
      font-size: 25px;
    }

    .weather-card .bottom .wrapper .forecast li .condition .temp {
      display: inline-block;
      vertical-align: top;
      font-family: 'Montserrat', sans-serif;
      font-size: 20px;
      font-weight: 400;
      padding-top: 2px;
    }

    .weather-card .bottom .wrapper .forecast li .condition .temp .deg {
      display: inline-block;
      font-size: 10px;
      font-weight: 600;
      margin-left: 3px;
      vertical-align: top;
    }

    .weather-card .bottom .wrapper .forecast li .condition .temp .temp-type {
      font-size: 20px;
    }

    .weather-card .bottom .wrapper .forecast li.active {
      color: rgba(0, 0, 0, 0.8);
    }

    .weather-card.rain .top {
      background: url("../assets/assets/life.jpg") no-repeat;
      background-size: cover;
      background-position: center center;
    }

    .col a:hover {
      text-decoration: none;
    }
  </style>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
  <link href="//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" rel="stylesheet" id="bootstrap-css">
  <script src="//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
  <script src="//code.jquery.com/jquery-1.11.1.min.js"></script>

</head>

<body>
    @php     
        $empl_no = Session::get('empl_id');
        $empl_name = Session::get('emp_name');
    @endphp

<div class="container">
    <div class="row">

      <!-- L@G -->
      <div class="col">
        <a href="dashboard">
          <div class="weather-card rain">
            <div class="top">
              <div class="wrapper">
                <div class="mynav">
                </div>
                <h1 class="heading">Life@Gainup</h1>
              </div>
            </div>
            <div class="bottom">
              <div class="wrapper">
                <ul class="forecast">
                  <li class="active">
                    <span class="date"><a href="dashboard">Life@Gainup</a></span>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </a>
      </div>

      <!-- HARDWARE ASSET -->
      <div class="col">
        <a href="hw_dashboard">
          <div class="weather-card">
            <div class="top">
              <div class="wrapper">
                <div class="mynav">
                </div>
                <h1 class="heading">Hardware Asset</h1>
              </div>
            </div>
            <div class="bottom">
              <div class="wrapper">
                <ul class="forecast">
                  <li class="active">
                    <span class="date"><a href="hw_dashboard">Hardware Asset</a></span>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </a>
      </div>



      <!-- CDC PORTALS -->
      <div class="col">
        <div class="weather-card clickable-card" id="cdc-portals">
          <div class="top">
            <div class="wrapper">
              <div class="mynav"></div>
              <h1 class="heading">CDC Portals</h1>
            </div>
          </div>
          <div class="bottom">
            <div class="wrapper">
              <ul class="forecast">
                <li class="active">
                  <span class="date">CDC Portals</span>
                </li>
              </ul>
            </div>
          </div>
        </div>
      </div>


    </div>
</div>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

  <script>
    sessionStorage.setItem('emp_id', "{{ Session::get('empl_id') }}");
    sessionStorage.setItem('emp_name', "{{ urlencode(Session::get('emp_name')) }}");

  // $(document).ready(function () {
  //   $('#cdc-portals').on('click', function () {
  //     const empId = sessionStorage.getItem('emp_id') || '';
  //     const empName = sessionStorage.getItem('emp_name') || '';
  //     const token = document.querySelector('meta[name="csrf-token"]').content;

  //     const $form = $('<form>', {
  //       method: 'POST',
  //       action: '/merchandiserdashboard',
  //       target: '_blank'
  //     });

  //     $form.append($('<input>', { type: 'hidden', name: '_token', value: token }));
  //     $form.append($('<input>', { type: 'hidden', name: 'emp_id', value: empId }));
  //     $form.append($('<input>', { type: 'hidden', name: 'emp_name', value: empName }));

  //     $('body').append($form);
  //     $form.trigger('submit');
  //   });
  // });

  $(document).ready(function () {
    $('#cdc-portals').on('click', function () {
      $.get('/generate-encrypted-url', function (url) {
        if (url) {
          window.open(url, '_blank');
        } else {
          alert('Could not generate secure link.');
        }
      }).fail(function(){
        alert('Failed to generate secure link.');
      });
    });
  });

  </script>
</body>

