<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Production Socks Overview</title>
   
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'background': 'rgb(245, 246, 247)',
                        'foreground': 'rgb(31, 41, 55)',
                        'card': 'rgb(255, 255, 255)',
                        'card-foreground': 'rgb(31, 41, 55)',
                        'primary': 'rgb(15, 61, 126)',
                        'primary-foreground': 'rgb(248, 250, 252)',
                        'primary-100': 'rgb(219, 234, 254)',
                        'primary-50': 'rgb(239, 246, 255)',
                        'primary-25': 'rgb(248, 250, 252)',
                        'secondary': 'rgb(241, 245, 249)',
                        'muted': 'rgb(241, 245, 249)',
                        'muted-foreground': 'rgb(100, 116, 139)',
                        'border': 'rgb(226, 232, 240)',
                        'input': 'rgb(226, 232, 240)',
                        'ring': 'rgb(15, 61, 126)',
                    }
                }
            }
        }
    </script>

    <style>
        body { font-family: 'Inter', system-ui, sans-serif; }
        .sparkline-container { width: 80px; height: 40px; }
        #tooltip { position: absolute; z-index: 9999; background: #fff; color: #333; font-size: 12px; padding: 4px 8px; border-radius: 4px; white-space: nowrap; display: none; box-shadow: 0 4px 12px rgba(0,0,0,0.15); border: 1px solid #e2e8f0; }
        #tooltip.show { display: block; }
        .highlight-row { background-color: rgb(219, 234, 254) !important; transition: background-color 0.5s ease; }
        .active-card { background-color: #e6f3ff !important; border: 2px solid #2e66beff !important; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1) !important; }
		.spinner {
			width: 24px;
			height: 24px;
			border: 3px solid rgba(255, 255, 255, 0.3);
			border-radius: 50%;
			border-top-color: #fff;
			animation: spin 1s ease-in-out infinite;
			margin-right: 10px;
		}

		@keyframes spin {
			to { transform: rotate(360deg); }
		}
    </style>
</head>
<body class="h-full bg-background text-foreground antialiased">
    @php
        $empl_no = Session::get('empl_id');
        $empl_name = Session::get('emp_name');
    @endphp

    <div id="tooltip" class="tooltip"></div>

    <div class="flex min-h-screen w-full flex-col">
        @include('LifeAtGainup.socksproduction.header')

        <main class="flex flex-1 flex-col gap-4 p-4 md:gap-8 md:p-8">
            <!-- KPI Header -->
            <div class="grid gap-4 md:grid-cols-2 lg:grid-cols-4 xl:grid-cols-6 mb-4" id="kpiGrid"></div>

            <!-- Drilldown Table -->
            <div class="grid gap-4 md:gap-8 grid-cols-1">
                <div class="bg-card border border-border rounded-lg shadow-sm">
                    <div class="flex flex-row items-start justify-between p-6 border-b border-border">
                        <div class="flex flex-row items-center gap-2">
                            <h3 class="text-2xl font-semibold bg-gradient-to-r from-blue-500 to-indigo-500 bg-clip-text text-transparent">Daily snapshot</h3>
                            <p class="text-sm text-muted-foreground mt-1.5">Aggregated production data. Click on a unit or zone to expand.</p>
                        </div>
                    </div>

                    <div class="p-6">
                        <div class="relative w-full overflow-auto">
                            <table class="w-full caption-bottom text-sm">
                                <thead class="bg-gray-50 border-b-2 border-gray-300">
                                    <tr class="border-b border-border">
                                        <th class="px-6 py-4 text-left align-middle font-medium text-muted-foreground w-[300px]">Unit / Date / Shift</th>
                                        <th class="px-4 py-3 text-left align-middle font-medium text-muted-foreground">M/C</th>
                                        <th class="px-4 py-3 text-right align-middle font-medium text-muted-foreground">Opr</th>
                                        <th class="px-4 py-3 text-right align-middle font-medium text-muted-foreground">Act Tgt</th>
                                        <th class="px-4 py-3 text-right align-middle font-medium text-muted-foreground">Util Tgt</th>
                                        <th class="px-4 py-3 text-right align-middle font-medium text-muted-foreground ">Knit Qty</th>
                                        <th class="px-4 py-3 text-right align-middle font-medium text-muted-foreground">Rej</th>
                                        <th class="px-4 py-3 text-right align-middle font-medium text-muted-foreground">Util %</th>
                                        <th class="px-4 py-3 text-center align-middle font-medium text-muted-foreground">Perf %</th>
                                        <th class="px-4 py-3 text-right align-middle font-medium text-muted-foreground">Rej %</th>
                                        <th class="px-4 py-3 text-right align-middle font-medium text-muted-foreground">WIP</th>
                                        <th class="px-4 py-3 text-right align-middle font-medium text-muted-foreground">OEE %</th>
                                        <th class="px-4 py-3 text-center align-middle font-medium text-muted-foreground text-xs">Socks Waste</th>
                                        <th class="px-4 py-3 text-center align-middle font-medium text-muted-foreground text-xs">Yarn Waste</th>
                                        <th class="px-4 py-3 text-center align-middle font-medium text-muted-foreground">Stop Min</th>
                                    </tr>
                                </thead>
                                <tbody id="drilldownTableBody"></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

<script>
    // YOUR ORIGINAL MOCK KPI DATA (exactly as you had)
    const mockKpiData = {
        backFeedAvail: { label: "Grey Store", value: 87, yesterday: 4, target: 100, unit: "", description: "Available back feed stock", trendData: [{value:80},{value:82},{value:83},{value:84},{value:85},{value:86},{value:87}] },
        capacityUtilization: { label: "Cap Utilization", value: 85, yesterday: 4, target: 95.0, unit: "%", description: "Current capacity utilization percentage", trendData: [{value:87.5},{value:88.1},{value:88.8},{value:89.2},{value:90.1},{value:90.8},{value:91.4}] },
        cuttingOutput: { label: "Cutting Output", value: 100, yesterday: 5, target: 14000, unit: "", description: "Total pieces cut today", trendData: [{value:12200},{value:12400},{value:12650},{value:12834},{value:13000},{value:13120},{value:13247}] },
        directLabourStrength: { label: "Direct", value: 455, yesterday: 5, target: 1250, unit: "", description: "Number of direct labour workers present", trendData: [{value:1235},{value:1240},{value:1242},{value:1238},{value:1245},{value:1246},{value:1247}] },
        efficiency: { label: "Efficiency", value: 80, yesterday: 4, target: 90.0, unit: "%", description: "Overall production efficiency", trendData: [{value:83.2},{value:84.1},{value:84.8},{value:85.1},{value:86.2},{value:86.9},{value:87.3}] },
        output: { label: "Knitting", value: 0, yesterday: 8, target: 13000, unit: "", description: "Total pieces produced today", trendData: [{value:11200},{value:11400},{value:11600},{value:11823},{value:12100},{value:12300},{value:12547}] },
        lineStopMins: { label: "Line Stop Minutes", value: 200, yesterday: 4, target: 150, unit: "", description: "Total minutes lost due to line stops", trendData: [{value:245},{value:230},{value:218},{value:203},{value:195},{value:189},{value:184}] },
        ordersOnTrack: { label: "Orders On Track", value: 92, yesterday: 13, target: 98.0, unit: "%", description: "Percentage of orders on schedule", trendData: [{value:91.2},{value:91.8},{value:92.1},{value:92.8},{value:93.4},{value:93.8},{value:94.2}] },
        packingOutput: { label: "Pack Output", value: 215, yesterday: 3, target: 12500, unit: "", description: "Total pieces packed today", trendData: [{value:10800},{value:11000},{value:11150},{value:11234},{value:11450},{value:11650},{value:11847}] },
        wip: { label: "WIP", value: 9000, yesterday: 4, target: 2500, unit: "", description: "Work in progress on production lines", trendData: [{value:3200},{value:3150},{value:3080},{value:3012},{value:2950},{value:2890},{value:2847}] },
        merchandiser: { label: "Merchandiser", value: 95, yesterday: 5, target: 100, unit: "%", description: "Merchandiser performance metric", trendData: [{value:88},{value:90},{value:91},{value:92},{value:93},{value:94},{value:95}] },
        quality: { label: "Quality", value: 98, yesterday: 2, target: 99.5, unit: "%", description: "Quality assurance percentage", trendData: [{value:96.5},{value:97.0},{value:97.2},{value:97.5},{value:97.8},{value:98.0},{value:98.2}] }
    };

    let originalData = [], filteredData = [], expandedRows = {};

    function createSparkline(containerId, data, color = '#3b82f6') {
        const canvas = document.getElementById(containerId);
        if (!canvas) return;
        const ctx = canvas.getContext('2d');
        new Chart(ctx, {
            type: 'line',
            data: { labels: data.map((_, i) => i), datasets: [{ data: data.map(d => d.value), borderColor: color, backgroundColor: color + '20', borderWidth: 2, fill: true, tension: 0.4, pointRadius: 0, pointHoverRadius: 0 }] },
            options: { responsive: true, maintainAspectRatio: false, scales: { x: { display: false }, y: { display: false } }, plugins: { legend: { display: false }, tooltip: { enabled: false } } }
        });
    }

    function initializeKpiCards() {
        const kpiGrid = $('#kpiGrid');
        kpiGrid.empty();

        const kpiOrder = ['cuttingOutput','backFeedAvail','output','lineStopMins','wip','efficiency','directLabourStrength','packingOutput','ordersOnTrack','capacityUtilization','merchandiser','quality'];

        kpiOrder.forEach(key => {
            const kpi = mockKpiData[key];
            if (!kpi) return;

            const diff = kpi.yesterday;
            const comparisonColor = diff >= 0 ? 'text-green-500' : 'text-red-500';
            const arrowIcon = diff >= 0 ? 'arrow-up' : 'arrow-down';
            const comparisonText = 'vs yesterday';

            const formatValue = value => {
                if (key === 'lineStopMins') return Math.round(value).toLocaleString();
                if (kpi.unit === '%') return `${value.toFixed(1)}${kpi.unit}`;
                return value.toLocaleString();
            };

            const trend = kpi.trendData;
            const isIncreasing = trend[trend.length - 1].value > trend[0].value;
            const chartColor = isIncreasing ? '#22c55e' : (trend[trend.length - 1].value < trend[0].value ? '#ef4444' : '#3b82f6');

            let segmentedControl = '';
            if (key === 'output') {
                segmentedControl = `<div class="flex bg-gray-50 rounded-md border border-gray-200 px-2 py-1 gap-3 absolute top-10 left-3">
                    <div class="text-xs text-primary font-medium">Boxes</div>
                    <div class="text-xs font-bold" id="output-sum">0</div>
                    <span class="text-xs text-gray-600 font-medium">|</span>
                    <div class="text-xs text-primary font-medium">Clock</div>
                    <div class="text-xs font-bold" id="earned-minutes-sum">0</div>
                </div>`;
            } else if (key === 'directLabourStrength') {
                segmentedControl = `<div class="flex bg-gray-50 rounded-md px-2 py-1 gap-3 absolute top-10 left-3 ">
                    <div class="flex items-center gap-1 text-xs text-primary" title="Tailors">Users</div>
                    <div class="text-xs font-bold" id="labour-tailor-sum">0</div>
                    <span class="text-xs text-gray-600 font-medium">|</span>
                    <div class="flex items-center gap-1 text-xs text-primary" title="Direct Labour">User</div>
                    <div class="text-xs font-bold" id="labour-direct-sum">0</div>
                    <span class="text-xs text-gray-600 font-medium">|</span>
                    <div class="flex items-center gap-1 text-xs text-primary" title="Unallocated">Circle</div>
                    <div class="text-xs font-bold" id="labour-unalloc-sum">00</div>
                </div>`;
            }

            const isClickable = ['output', 'lineStopMins', 'directLabourStrength','backFeedAvail'].includes(key);
            const nonClickableStyle = 'pointer-events: auto; transition: none; box-shadow: none !important; background-color: #ddd8d8ff !important;';
            const cardHtml = `
            <div class="bg-card border border-border rounded-lg shadow-sm flex-1 relative ${isClickable ? 'cursor-pointer hover:bg-muted transition-colors' : ''} ${key === 'output' ? 'active-card' : ''}" data-type="${key}" ${isClickable ? '' : `style="${nonClickableStyle}"`}>
                ${segmentedControl}
                <div class="p-4">
                    <div class="flex flex-col md:flex-row md:items-stretch h-full">
                        <div class="flex-1 flex flex-col">
                            <div>
                                <div class="flex items-center gap-1.5">
                                    <p class="text-sm font-medium text-muted-foreground">${kpi.label}</p>
                                    <i class="fa-solid fa-circle-info h-3 w-3 text-muted-foreground" data-tooltip="${kpi.description}"></i>
                                </div>
                                <p class="text-2xl font-bold">${formatValue(kpi.value)}</p>
                            </div>
                            <div>
                                <div class="flex items-center text-xs text-muted-foreground">
                                    <i class="fa-solid fa-${arrowIcon} h-4 w-4 ${comparisonColor}"></i>
                                    <span class="ml-1 ${comparisonColor}">${Math.abs(diff)}</span>
                                    <span class="ml-1">${comparisonText}</span>
                                </div>
                                <p class="text-xs text-purple-300 mt-1">Target: ${formatValue(kpi.target)}</p>
                            </div>
                        </div>
                        <div class="w-full h-12 md:w-24 md:h-auto mt-2 md:mt-0 md:ml-4">
                            <canvas id="chart-${key}" class="sparkline-container w-full h-full"></canvas>
                        </div>
                    </div>
                </div>
            </div>`;

            kpiGrid.append(cardHtml);
            setTimeout(() => createSparkline(`chart-${key}`, kpi.trendData, chartColor), 100);
            // Wire up clicks for specific KPI cards
            if (key === 'lineStopMins') {
                $(`[data-type="lineStopMins"]`).off('click').on('click', function(){
                    const picker = $('#dateRangePicker').data('daterangepicker');
                    const from = picker ? picker.startDate.format('YYYY-MM-DD') : moment().format('YYYY-MM-DD');
                    const to = picker ? picker.endDate.format('YYYY-MM-DD') : moment().format('YYYY-MM-DD');
                    const url = `/socks_linestop_analysis?fromdate=${encodeURIComponent(from)}&enddate=${encodeURIComponent(to)}`;
                    window.location.href = url;
                });
            } else if (key === 'directLabourStrength') {
                $(`[data-type="directLabourStrength"]`).off('click').on('click', function(){
                    const picker = $('#dateRangePicker').data('daterangepicker');
                    const from = picker ? picker.startDate.format('YYYY-MM-DD') : moment().format('YYYY-MM-DD');
                    const to = picker ? picker.endDate.format('YYYY-MM-DD') : moment().format('YYYY-MM-DD');
                    const url = `/socksdirectlabour?fromdate=${encodeURIComponent(from)}&enddate=${encodeURIComponent(to)}`;
                    window.location.href = url;
                });
            } else if (key === 'output') {
                $(`[data-type="output"]`).off('click').on('click', function(){
                    const $table = $('table');
                    if ($table.length) {
                        $('html, body').animate({ scrollTop: $table.offset().top - 80 }, 500);
                        $table.closest('.bg-card').addClass('highlight-row');
                        setTimeout(() => $table.closest('.bg-card').removeClass('highlight-row'), 2000);
                    }
                });
            }else if (key === 'backFeedAvail') {
                $(`[data-type="backFeedAvail"]`).off('click').on('click', function(){
                    const picker = $('#dateRangePicker').data('daterangepicker');
                    const from = picker ? picker.startDate.format('YYYY-MM-DD') : moment().format('YYYY-MM-DD');
                    const to = picker ? picker.endDate.format('YYYY-MM-DD') : moment().format('YYYY-MM-DD');
                    const url = `/socksmstock?fromdate=${encodeURIComponent(from)}&enddate=${encodeURIComponent(to)}`;
                    window.location.href = url;
                });
            }
        });
    }

    // Table functions
    function transformApiData(units) {
        return (units || []).map(unit => ({
            unitId: unit.Unit,
            Unit: unit.Unit,
            level: 'unit',
            Running_Machines: unit.Running_Machines || "0/0",
            No_Of_Opr: unit.No_Of_Opr || 0,
            Actual_Target: unit.Actual_Target || 0,
            Utilization_Target: unit.Utilization_Target || 0,
            Knit_Qty: unit.Knit_Qty || 0,
            Rej_Qty: unit.Rej_Qty || 0,
            Utilization_Percentage: unit.Utilization_Percentage || 0,
            Performance_Percentage: unit.Performance_Percentage || 0,
            Rej_Percentage: unit.Rej_Percentage || 0,
            Line_WIP: unit.Line_WIP || 0,
            OEE_Percentage: unit.OEE_Percentage || 0,
            Socks_Wastage: unit.Socks_Wastage || 0,
            Yarn_Wastage: unit.Yarn_Wastage || 0,
            Stoppage_Min: unit.Stoppage_Min || 0,

            dates: (unit.dates || []).map(date => ({
                dateId: `${unit.Unit}-${date.EntryDate}`,
                Unit: `${date.EntryDate}`,
                level: 'date',
                ...date,
                shifts: (date.shifts || []).map(shift => ({
                    shiftId: `${unit.Unit}-${date.EntryDate}-${shift.Shift}`,
                    Unit: `Shift ${shift.Shift}`,
                    level: 'shift',
                    ...shift
                }))
            }))
        }));
    }

    function buildTableRows() {
        const rows = [];
        function addRows(items, level = 0) {
            items.forEach(item => {
                const id = item.unitId || item.dateId || item.shiftId;
                rows.push({ item, level, id });
                if (expandedRows[id] && (item.dates || item.shifts)) {
                    addRows(item.dates || item.shifts, level + 1);
                }
            });
        }
        addRows(filteredData);
        return rows;
    }

    function renderTable() {
        const tbody = $('#drilldownTableBody');
        tbody.empty();
        const rows = buildTableRows();

        if (rows.length === 0) {
            tbody.append(`<tr><td colspan="15" class="h-24 text-center text-muted-foreground">No data available</td></tr>`);
            return;
        }

        rows.forEach(({ item, level, id }) => {
            const hasChildren = !!(item.dates?.length) || !!(item.shifts?.length);
            const isExpanded = expandedRows[id];

            tbody.append(`
            <tr class="hover:bg-blue-50 transition-all duration-200 border-b border-border">
                <td class="py-4 px-6 font-medium" style="padding-left: ${level * 50 + 30}px;">
                    <div class="flex items-center gap-3">
                        ${hasChildren ? `<button class="w-10 h-10 rounded-full hover:bg-blue-100 expand-btn transition-colors" data-id="${id}">
                            <i class="fa-solid ${isExpanded ? 'fa-chevron-down' : 'fa-chevron-right'} text-blue-600"></i>
                        </button>` : '<span class="w-10"></span>'}
                        <span class="${level === 0 ? 'font-bold  text-lg' : 'text-foreground'}">${item.Unit}</span>
                    </div>
                </td>
                <td class="py-4 px-4 ">${item.Running_Machines || '-'}</td>
                <td class="py-4 px-4 text-right">${(item.No_Of_Opr || 0).toLocaleString()}</td>
                <td class="py-4 px-4 text-right">${(item.Actual_Target || 0).toLocaleString()}</td>
                <td class="py-4 px-4 text-right">${(item.Utilization_Target || 0).toLocaleString()}</td>
                <td class="py-4 px-4 text-right ">${(item.Knit_Qty || 0).toLocaleString()}</td>
                <td class="py-4 px-4 text-right ">${(item.Rej_Qty || 0).toLocaleString()}</td>
                <td class="py-4 px-4 text-right">${(item.Utilization_Percentage || 0).toFixed(1)}%</td>
                <td class="py-4 px-4 text-center ">${(item.Performance_Percentage || 0).toFixed(1)}%</td>
                <td class="py-4 px-4 text-right">${(item.Rej_Percentage || 0).toFixed(1)}%</td>
                <td class="py-4 px-4 text-right">${item.level === 'unit' ? (item.Line_WIP || 0).toLocaleString() : '-'}</td>
                <td class="py-4 px-4 text-right ">${(item.OEE_Percentage || 0).toFixed(1)}%</td>
                <td class="py-4 px-4 text-center ">${(item.Socks_Wastage || 0).toFixed(3)}</td>
                <td class="py-4 px-4 text-center ">${(item.Yarn_Wastage || 0).toFixed(3)}</td>
                <td class="py-4 px-4 text-center ">${item.Stoppage_Min || 0}</td>
            </tr>`);
        });
    }

	function fetchDailySnapshot() {
        $("#loadSpinner").show();

        const picker = $('#dateRangePicker').data('daterangepicker');
        const from = picker ? picker.startDate.format('YYYY-MM-DD') : moment().format('YYYY-MM-DD');
        const to = picker ? picker.endDate.format('YYYY-MM-DD') : moment().format('YYYY-MM-DD');

        $.get('/socksdailysnapshot', { fromdate: from, enddate: to, empid: "{{ Session('empl_id') }}"  })
            .done(function(res) {
                if (res.success) {
                    // First update the KPI data
                    (res.overall_totals || []).forEach(item => {
                        const map = {
                            "Back Feed Avail":"backFeedAvail",
                            "Capacity Utilization":"capacityUtilization",
                            "Cutting Output":"cuttingOutput",
                            "Direct Labour":"directLabourStrength",
                            "Efficiency":"efficiency",
                            "Knitting prod":"output",
                            "Line Stop Mins":"lineStopMins",
                            "Orders on Track":"ordersOnTrack",
                            "Packing Output":"packingOutput",
                            "WIP":"wip"
                        };
                        const key = map[item.Type];
                        if (key && mockKpiData[key]) {
                            mockKpiData[key].value = parseFloat(item.Cutting) || 0;
                            mockKpiData[key].yesterday = parseFloat(item.Prv_Cut) || 0;
                        }
                    });

                    // Initialize KPI cards first
                    initializeKpiCards();

                    // Now calculate and update the knitting card values
                    let totalKnitQty = 0;
                    let totalStopMins = 0;
                    
                    if (res.units && res.units.length > 0) {
                        res.units.forEach(unit => {
                            totalKnitQty += parseFloat(unit.Knit_Qty) || 0;
                            totalStopMins += parseFloat(unit.Stoppage_Min) || 0;
                            
                        });
                    }

                    // Update the values in the UI
                    const outputSumEl = document.getElementById('output-sum');
                    const earnedMinsEl = document.getElementById('earned-minutes-sum');
                    
                    if (outputSumEl) outputSumEl.textContent = Math.round(totalKnitQty).toLocaleString();
                    if (earnedMinsEl) earnedMinsEl.textContent = Math.round(totalStopMins).toLocaleString();

                    // Update the table data
                    originalData = transformApiData(res.units || []);
                    filteredData = JSON.parse(JSON.stringify(originalData));
                    renderTable();
                }
            })
            .fail(function(err) {
                console.error("API failed:", err);
            })
            .always(function() {
                $("#loadSpinner").hide();
            });
    }


    $(document).on('click', '.expand-btn', function() {
        const id = $(this).data('id');
        expandedRows[id] = !expandedRows[id];
        renderTable();
    });

     $(document).ready(function () {
        initializeKpiCards();
        renderTable();
        //initializeEventHandlers();
        // Icons now use Font Awesome; no initialization required

        // Initialize date range picker
        $('#dateRangePicker').daterangepicker({
            opens: 'left',
            startDate: moment(),
            endDate: moment(),
            maxDate: moment(), // Restrict dates beyond today
            ranges: {
                'Today': [moment(), moment()],
                'Last Week': [moment().subtract(6, 'days'), moment()], // Changed from This Week
                'This Month': [moment().startOf('month'), moment().endOf('month')]
            }
        }, function(start, end, label) {
            // Format dates as dd-mm-yy
            const startFormatted = start.format('DD-MM-YY');
            const endFormatted = end.format('DD-MM-YY');
            // Store the selected range label
            selectedRangeLabel = label;
            // Check if start and end are the same day
            const isSameDay = start.isSame(end, 'day');
            const titleText = `
             Production_dashboard_Overview- 
            <span style="color: #000; font-weight: bold; background-color: #FFFF00; padding: 2px 6px; border-radius: 10px;">
                SOCKS
            </span>
            <span class="ml-4" style="color: #fff; font-weight: 500;">
                ${startFormatted} - ${endFormatted}
            </span>
            `;

            $('.dashboard_title').html(titleText); // ✅ Use .html() instead of .text()
            
            // Update input value
            $('#dateRangePicker').val(`${startFormatted} - ${endFormatted}`);
            
            // Fetch data
            fetchDailySnapshot();
        });

        $(`#HistoricalButton`).on('click', function () {
            window.location.href = '/history_socks_dashboard/Production';
        });

        // Initial title setup
        const initialStart = moment();
        const initialEnd = moment();
        const initialStartFormatted = initialStart.format('DD-MM-YY');
        const initialEndFormatted = initialEnd.format('DD-MM-YY');
        const isSameDay = initialStart.isSame(initialEnd, 'day');
        $('.dashboard_title').html(`
        Production Overview dashboard -   
        <span style="color: #000; font-weight: bold;  background-color: #FFFF00; padding: 2px 4px; border-radius: 10px;">SOCKS</span>
        <span class="ml-4">
            ${initialStartFormatted} - ${initialEndFormatted}
        </span>
        `);
        
        // Initial fetch
        $('#dateRangePicker').val(`${initialStartFormatted} - ${initialEndFormatted}`);
        fetchDailySnapshot();
    });
</script>
</body>
</html>