<!DOCTYPE html>
<html lang="en">

<head>
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <title>SELF APPRAISAL REPORT</title>
  <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
  <link rel="icon" href="gplogofinal.png" type="png">


  <!-- ************************************************************************ || NAV SCRIPT || ******************************************************************************* -->

  <!-- NAV -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
  <script src="{{ asset('frontend/js/plugin/webfont/webfont.min.js')}}"></script>

  <!-- LOGOUT -->
  <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
  <script src="{{ asset('frontend/js/core/bootstrap.min.js')}}"></script>

  <!-- FOR SPINNER -->
  <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
  <script src="{{ asset('frontend/js/spinner.js')}}"></script>

  <!-- NAV FONT -->
  <script>
    WebFont.load({
      google: {
        "families": ["Lato:300,400,700,900"]
      },
      //custom: {"families":["Flaticon", "Font Awesome 5 Solid", "Font Awesome 5 Regular", "Font Awesome 5 Brands", "simple-line-icons"], urls: ['assets/css/fonts.min.css']},
      active: function() {
        sessionStorage.fonts = true;
      }
    });
  </script>

  <!-- NAV IMAGES -->
  <link rel="stylesheet" href="{{ asset('frontend/css/fonts.min.css')}}">

  <!-- NAV ALIGN -->
  <link rel="stylesheet" href="{{ asset('frontend/css/atlantis.css')}}">

  <!--  NAV OPTION -->
  <script src="{{ asset('frontend/js/plugin/jquery-ui-1.12.1.custom/jquery-ui.min.js')}}"></script>

  <!-- NAV  Scrollbar -->
  <script src="{{ asset('frontend/js/plugin/jquery-scrollbar/jquery.scrollbar.min.js')}}"></script>
  <script src="{{ asset('frontend/js/atlantis.min.js')}}"></script>

  <!-- FOR EXPORT -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>

  <!-- ****************************************************************  || END NAV SCRIPT || ******************************************************************************* -->



  <!-- ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| **STYLE** ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| -->

  <!-- STYLE FOR TABLE -->
  <style>
    main.table {
      width: 79vw;
      height: 85vh;
      background-color: #fff5;
      backdrop-filter: blur(7px);
      box-shadow: 0 .4rem .8rem #0005;
      border-radius: .8rem;
      overflow: hidden;
      float: right;
      margin-top: 10px;
      margin-right: 10px;

    }

    .table__header {
      width: 100%;
      height: 50px;
      display: flex;
      align-items: center;
      padding: .8rem 1rem;
      background-color: #0C5C9B;
      justify-content: space-between;
    }


    .table__header h1 {
      margin-right: 10px;
      /* Add margin to the right to separate h1 and select */
    }

    .empl {
      display: flex;
      align-items: center;
    }

    .empl select {
      margin-right: 10px;
      /* Add margin to the right to separate select from the text */
    }

    .search_bar {
      width: 100%;
      height: 40px;
      background-color: #d5d1defe;
      padding: .8rem 1rem;
      display: flex;
      justify-content: flex-end;
      align-items: center;
    }

    .entries {
      width: 100%;
      height: 10%;
      padding: .8rem 1rem;
      display: flex;
      justify-content: flex-start;
      align-items: center;
      /* background: green; */

    }

    ::placeholder {
      color: black;
    }

    #searchCount {
      color: black;
      font-weight: bold;
    }

    #entryCount {
      color: black;
      font-weight: bold;
    }

    .search_bar .input-group {
      width: 35%;
      height: 200%;
      background-color: #fff5;
      padding: 0 .8rem;
      border-radius: 2rem;
      display: flex;
      justify-content: center;
      align-items: center;
      transition: .2s;
    }


    .search_bar .input-group input {
      width: 100%;
      padding: 0 .5rem 0 .3rem;
      background-color: transparent;
      border: none;
      outline: none;
    }

    .input-group input {
      color: black;
      font-weight: bold;
    }

    .table__body {
      width: 98%;
      max-height: calc(75% - 1.6rem);
      background-color: #fffb;
      margin: .8rem auto;
      border-radius: .6rem;
      overflow: auto;
      overflow: overlay;
    }

    .table__body::-webkit-scrollbar {
      width: 0.5rem;
      height: 0.5rem;
    }

    .table__body::-webkit-scrollbar-thumb {
      border-radius: .5rem;
      background-color: #0004;
      /* visibility: hidden; */
    }

    .table__body:hover::-webkit-scrollbar-thumb {
      visibility: visible;
    }

    table {
      width: 100%;
    }

    table,
    th,
    td {
      border-collapse: collapse;
      padding: 1rem;
      text-align: center;
    }

    td {
      white-space: nowrap;
    }

    thead th {
      position: sticky;
      top: 0;
      left: 0;
      background-color: #d5d1def0;
      cursor: pointer;
      text-transform: capitalize;
      white-space: nowrap;
    }

    .table th {
      font-weight: 500;
      height: 40px;
    }

    tbody tr:nth-child(even) {
      background-color: #0000000b;
    }

    tbody tr {
      --delay: .1s;
      transition: .5s ease-in-out var(--delay), background-color 0s;
    }

    tbody tr.hide {
      opacity: 0;
      transform: translateX(100%);
    }

    tbody tr:hover {
      background-color: #fff6 !important;
    }

    tbody tr td,
    tbody tr td p,
    tbody tr td img {
      transition: .2s ease-in-out;
    }

    tbody tr.hide td,
    tbody tr.hide td p {
      padding: 0;
      font: 0 / 0 sans-serif;
      transition: .2s ease-in-out .5s;
    }

    table td {
      overflow: hidden;
      text-overflow: ellipsis;
      word-wrap: break-word;
      white-space: normal;
    }

    .table td {
      padding: 0 25px !important;
      height: 27px;
      vertical-align: middle !important;
    }


    .status {
      padding: .1rem 0;
      border-radius: 2rem;
      text-align: center;
      margin-top: 10px;
    }

    .status.Approved {
      /* background-color: #86e49d; */
      /* color: #006b21; */
      color: green;
      font-weight: bold;
      border: 1px solid pink;
      outline: 2px dashed greenyellow;
      /* -webkit-text-stroke: 0.5px black; */

    }

    .status.Reject {
      /* background-color: #d893a3; */
      color: #b30021;
      font-weight: bold;
      border: 2px solid pink;
      outline: 2px dashed #d893a3;

    }

    .status.Request {
      /* background-color: #ebc474; */
      color: #FABA5F;
      font-weight: bold;
      border: 2px solid #FF9F00;
      outline: 2px dashed #FF9944;
      width: 100px;

    }

    .status.shipped {
      background-color: #6fcaea;
    }


    @media (max-width: 1000px) {
      td:not(:first-of-type) {
        min-width: 12.1rem;
      }
    }

    thead th span.icon-arrow {
      display: inline-block;
      /* width: 1.3rem; */
      height: 1.3rem;
      border-radius: 50%;
      border: 1.4px solid transparent;

      text-align: center;
      font-size: 1rem;

      margin-left: .5rem;
      transition: .2s ease-in-out;
    }

    thead th:hover span.icon-arrow {
      border: 1.4px solid #6c00bd;
    }

    thead th:hover {
      color: #6c00bd;
    }

    thead th.active span.icon-arrow {
      background-color: #6c00bd;
      color: #fff;
    }

    thead th.asc span.icon-arrow {
      transform: rotate(180deg);
    }

    thead th.active,
    tbody td.active {
      color: #6c00bd;
    }

    .navbar {
      z-index: 1000;
    }

    .entries select {
      border: none;
      border-radius: 10px;
      padding: 3px 3px;
      background-color: #E3E1E9;
      cursor: pointer;
      font-weight: bold;
    }

    .empl select {
      color: black;
      font-weight: bold;
    }
  </style>

  <!-- STYLE FOR EXPORT -->
  <style>
    .export__file {
      position: relative;
    }

    .export__file .export__file-btn {
      display: inline-block;
      width: 2rem;
      height: 2rem;
      background: #fff6 url("{{ asset('frontend/img/Report page/export.png') }}") center / 80% no-repeat;
      border-radius: 50%;
      transition: .2s ease-in-out;
    }

    .export__file .export__file-btn:hover {
      background-color: #fff;
      transform: scale(1.15);
      cursor: pointer;
    }

    .export__file input {
      display: none;
    }

    .export__file .export__file-options {
      position: absolute;
      right: 0;
      width: 12rem;
      border-radius: .5rem;
      overflow: hidden;
      text-align: center;
      opacity: 0;
      transform: scale(.8);
      transform-origin: top right;
      box-shadow: 0 .2rem .5rem #0004;
      transition: .2s;
    }

    .export__file input:checked+.export__file-options {
      opacity: 1;
      transform: scale(1);
      z-index: 100;
    }

    .export__file .export__file-options label {
      display: block;
      width: 100%;
      padding: .6rem 0;
      background-color: #f2f2f2;

      display: flex;
      justify-content: space-around;
      align-items: center;

      transition: .2s ease-in-out;
    }

    .export__file .export__file-options label:first-of-type {
      /* padding: 1rem 0; */
      background-color: #86e49d !important;
    }

    .export__file .export__file-options label:hover {
      transform: scale(1.05);
      background-color: #fff;
      cursor: pointer;
    }

    .export__file .export__file-options img {
      width: 2rem;
      height: auto;
    }

    .form-control option {
      font-weight: bold;
    }
  </style>

  <!-- STYLE FOR PAGINATION -->
  <style>
    .pagination {
      justify-content: space-between;
      margin-left: 10px;
    }

    #pagination {

      margin-right: 15px;
      display: inline-block;
      vertical-align: middle;
      border-radius: 4px;
      padding: 1px 2px 4px 2px;
      border-top: 1px solid #AEAEAE;
      border-bottom: 1px solid #FFFFFF;
      background-color: #DADADA;
      background-image: -webkit-linear-gradient(top, #DBDBDB, #E2E2E2);
      background-image: -moz-linear-gradient(top, #DBDBDB, #E2E2E2);
      background-image: -ms-linear-gradient(top, #DBDBDB, #E2E2E2);
      background-image: -o-linear-gradient(top, #DBDBDB, #E2E2E2);
      background-image: linear-gradient(top, #DBDBDB, #E2E2E2);
    }

    #pagination #pag_a,
    #pagination #pag_i {
      display: inline-block;
      vertical-align: middle;
      width: 22px;
      color: #7D7D7D;
      text-align: center;
      font-size: 10px;
      padding: 3px 0 2px 0;
      -webkit-user-select: none;
      -moz-user-select: none;
      -ms-user-select: none;
      -o-user-select: none;
      user-select: none;
    }

    #pagination #pag_a {
      margin: 0 2px 0 2px;
      border-radius: 4px;
      border: 1px solid #E3E3E3;
      cursor: pointer;
      box-shadow: inset 0 1px 0 0 #FFF, 0 1px 2px #666;
      text-shadow: 0 1px 1px #FFF;
      background-color: #E6E6E6;
      background-image: -webkit-linear-gradient(top, #F3F3F3, #D7D7D7);
      background-image: -moz-linear-gradient(top, #F3F3F3, #D7D7D7);
      background-image: -ms-linear-gradient(top, #F3F3F3, #D7D7D7);
      background-image: -o-linear-gradient(top, #F3F3F3, #D7D7D7);
      background-image: linear-gradient(top, #F3F3F3, #D7D7D7);
    }

    #pagination #pag_i {
      margin: 0 3px 0 3px;
    }

    #pagination #pag_a.current {
      border: 1px solid #E9E9E9;
      box-shadow: 0 1px 1px #999;
      background-color: #DFDFDF;
      background-image: -webkit-linear-gradient(top, #D0D0D0, #EBEBEB);
      background-image: -moz-linear-gradient(top, #D0D0D0, #EBEBEB);
      background-image: -ms-linear-gradient(top, #D0D0D0, #EBEBEB);
      background-image: -o-linear-gradient(top, #D0D0D0, #EBEBEB);
      background-image: linear-gradient(top, #D0D0D0, #EBEBEB);
    }
  </style>

  <!-- ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||  **END STYLE** ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| -->

</head>

<body id="body" class="">
  <!--############################### FOR SPINNER ###############################-->

  <div id="container" class="spin_container">
    <div id="spinner_divider" class="" aria-hidden="true"></div>
    <p id="load_text" class="" aria-label="Loading" style="display: none;">
      <span class="" id="l_1" aria-hidden="true">G</span>
      <span class="" id="l_2" aria-hidden="true">a</span>
      <span class="" id="l_3" aria-hidden="true">i</span>
      <span class="" id="l_4" aria-hidden="true">n</span>
      <span class="" id="l_5" aria-hidden="true">u</span>
      <span class="" id="l_6" aria-hidden="true">p</span>
    </p>
  </div>
  <div id="wrapper" class="">

    <!--############################### Navbar Header ###############################-->

    @section('tittle') {{"SELF APPRAISAL REPORT"}}@endsection
    @extends('nav')
    @section('content')


    <main class="table">
      <form method="GET" action="{{ route('kpi_table') }}">
        <section class="table__header">
          @csrf
          <div class="card-title text-white"><b>{{$name}}</b></div>
          <div Class="col-sm-3 col-md-3 col-lg-3">

            <!--############################### EMPLOYEE NAME ###############################-->

            <div class="empl">
              <select class="form-control" name="employee" id="employee" onchange="submitForm()">
                <option value="">--Select Employee--</option>
                @php
                $loginID = Session::get('empl_id');
                $loginNAME = Session::get('emp_name')
                @endphp
                <option value="{{$loginID}}">{{$loginNAME}}</option>
                @foreach ($res as $row)
                <option value="{{$row['Emplno']}}">{{$row['C_Name']}}</option>
                @endforeach
              </select>
            </div>
          </div>

          <!--############################### EXPORT OPTION ###############################-->

          <div class="export__file">
            <label for="export-file" class="export__file-btn" title="Export File"></label>
            <input type="checkbox" id="export-file">
            <div class="export__file-options">
              <label>Export As &nbsp; &#10140;</label>
              <label for="export-file" id="toEXCEL">EXCEL <img src="{{ asset('frontend/img/Report page/excel.png') }}" alt="EXCEL"></label>
              <label for="export-file" onclick="printtable.printTable()">PRINT <img src="{{ asset('frontend/img/Report page/print.png') }}" alt="PRINT"></label>
            </div>
          </div>
        </section>
      </form>

      <!--############################### SEARCH BAR & SHOW ENTRIES ###############################-->

      <div class="search_bar">
        <div class="entries">
          <select name="state" id="maxRows">
            <option value="10">10</option>
            <option value="50">50</option>
            <option value="70">70</option>
            <option value="100">100</option>
            <option value="5000">Show ALL Rows</option>
          </select>
        </div>
        <div class="input-group">
          <input type="search" placeholder="Search Data..." id="searchtable">
        </div>
      </div>

      <!--############################### TABLE ###############################-->

      <section class="table__body">
        <table id="dataTable" class="table">
          <thead>
            <tr>
              <th> SNO <span class="icon-arrow">&UpArrow;</span></th>
              <th> EFFECT FROM <span class="icon-arrow">&UpArrow;</span></th>
              <th> KPI POINT <span class="icon-arrow">&UpArrow;</span></th>
              <th> TARGET <span class="icon-arrow">&UpArrow;</span></th>
              <th> ACTUAL <span class="icon-arrow">&UpArrow;</span></th>
              <th> INCHARGE POINT <span class="icon-arrow">&UpArrow;</span></th>
              <th> INCHARGE REMARK <span class="icon-arrow">&UpArrow;</span></th>
              <th> KPI REMARK <span class="icon-arrow">&UpArrow;</span></th>
              <th> APPROVAL <span class="icon-arrow">&UpArrow;</span></th>
              <th> TARGET APPROVAL <span class="icon-arrow">&UpArrow;</span></th>
              <th> UOM <span class="icon-arrow">&UpArrow;</span></th>

            </tr>
          </thead>
          <tbody>
            @foreach($results as $index => $row)
            <tr>
              <td>{{ $index + 1}}</td>
              <td>{{ $row['Effect_From'] }}</td>
              <td>{{ $row['KPI_POINT'] }}</td>
              <td>{{ $row['Target'] }}</td>
              <td>{{ $row['ACTUAL'] }}</td>
              <td>{{ $row['Incharge_Point'] }}</td>
              <td>{{ $row['Remarks'] }}</td>
              <td>{{ $row['Kpi_Remarks'] }}</td>
              <td>{{ $row['Approval'] }}</td>
              <td>{{ $row['Target_approval'] }}</td>
              <td>{{ $row['Uom'] }}</td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </section>


      <!--############################### PAGINATION ###############################-->

      <div class="pagination">
        <div id="entryCount">Total entries: <span id="rowCount"></span></div>
        <div id="searchCount"></div>
        <div id="pagination"></div>
      </div>
    </main>

  </div>



  <!--@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ FUNCTION SCRIPTS @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-->


  <!-- SEARCH IN TABLE -->
  <script>
    $(document).ready(function() {
      $("#searchtable").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        var matches = $("#dataTable tbody tr").filter(function() {
          return $(this).text().toLowerCase().indexOf(value) > -1;
        });

        if (value === "") {
          // If the search bar is empty, clear the search results and count

          $("#searchCount").text("");
          $("#entryCount").show(); // Show the entry count
          $("#dataTable tbody tr").toggle(true);
          updateRowsPerPage(); // Call the function to reset displayed rows
        } else {
          $("#entryCount").hide(); // Hide the entry count
          // Show the search count and hide rows that don't match the search criteria
          $("#searchCount").text(matches.length + " result(s) found");
          matches.toggle(true);
          $("#dataTable tbody tr").not(matches).toggle(false);
        }
      });
    });
  </script>

  <!-- SHOW ENTRIES TABLE -->
  <script>
    // Function to update the number of displayed rows
    function updateRowsPerPage() {
      var maxRows = parseInt(document.getElementById("maxRows").value);
      var tableBody = document.getElementById("tableBody");
      var dataTable = document.getElementById("dataTable");
      var rows = dataTable.getElementsByTagName("tr");

      for (var i = 1; i < rows.length; i++) {
        if (i <= maxRows) {
          rows[i].style.display = "";
        } else {
          rows[i].style.display = "none";
        }
      }
      // Update pagination
      Pagination.Start();
    }

    // Add an event listener to the maxRows dropdown
    document.getElementById("maxRows").addEventListener("change", updateRowsPerPage);

    // Initial call to set the initial number of displayed rows
    updateRowsPerPage();
  </script>

  <!-- AUTOMATICALLY SELECT EMPLOYEE -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      var selectEmployee = document.getElementById('employee');
      selectEmployee.addEventListener('change', function() {
        this.form.submit();
      });
    });

    document.addEventListener('DomcontentLoaded', function() {
      var a = document.getElementById
    })
  </script>

  <!-- Sorting | Ordering data of HTML table -->
  <script>
    const head_tab = document.querySelectorAll('thead th'); // Replace 'your-header-class' with the actual class name of your table headers
    const row_table = document.querySelectorAll('tbody tr'); // Replace 'your-row-class' with the actual class name of your table rows

    head_tab.forEach((head, i) => {
      let sort_asc = true;
      head.addEventListener('click', () => {
        head_tab.forEach(head => head.classList.remove('active'));
        head.classList.add('active');

        document.querySelectorAll('td').forEach(td => td.classList.remove('active'));
        row_table.forEach(row => {
          row.querySelectorAll('td')[i].classList.add('active');
        })

        head.classList.toggle('asc', sort_asc);
        sort_asc = head.classList.contains('asc') ? false : true;

        sortTable(i, sort_asc);
      });
    });

    function sortTable(column, sort_asc) {
      const tbody = document.querySelector('tbody');
      const rows = Array.from(row_table);

      rows.sort((a, b) => {
        let first_row = parseFloat(a.querySelectorAll('td')[column].textContent.toLowerCase());
        let second_row = parseFloat(b.querySelectorAll('td')[column].textContent.toLowerCase());

        // return sort_asc ? (first_row - second_row) : (second_row - first_row);
        return sort_asc ? (first_row < second_row ? -1 : 1) : (first_row < second_row ? 1 : -1);
      });

      // Clear the existing rows from the table
      while (tbody.firstChild) {
        tbody.removeChild(tbody.firstChild);
      }

      // Append the sorted rows to the table
      rows.forEach(row => {
        tbody.appendChild(row);
      });
    }
  </script>

  <!-- PAGINATION -->
  <script>
    var Pagination = {

      code: '',

      // --------------------
      // Utility
      // --------------------

      // converting initialize data
      Extend: function(data) {
        data = data || {};
        Pagination.size = data.size || 3000;
        Pagination.page = data.page || 5;
        Pagination.step = data.step || 5;
      },

      // add pages by number (from [s] to [f])
      Add: function(s, f) {
        for (var i = s; i < f; i++) {
          Pagination.code += '<a id="pag_a">' + i + '</a>';
        }
      },

      // add last page with separator
      Last: function() {
        Pagination.code += '<i id="pag_i">...</i> <a id="pag_a">' + Pagination.size + '</a>';

      },

      // add first page with separator
      First: function() {
        Pagination.code += '<a id="pag_a">1</a> <i id="pag_i">...</i>';

      },



      // --------------------
      // Handlers
      // --------------------

      // change page
      Click: function() {
        Pagination.page = +this.innerHTML;
        Pagination.Start();
      },

      // previous page
      Prev: function() {
        Pagination.page--;
        if (Pagination.page < 1) {
          Pagination.page = 1;
        }
        Pagination.Start();
      },

      // next page
      Next: function() {
        Pagination.page++;
        if (Pagination.page > Pagination.size) {
          Pagination.page = Pagination.size;
        }
        Pagination.Start();
      },



      // --------------------
      // Script
      // --------------------

      // binding pages
      Bind: function() {
        var a = Pagination.e.getElementsByTagName('a');
        for (var i = 0; i < a.length; i++) {
          if (+a[i].innerHTML === Pagination.page) a[i].className = 'current';
          a[i].addEventListener('click', Pagination.Click, false);
        }

        // Retrieve the maxRows value
        var maxRows = parseInt(document.getElementById("maxRows").value);

        // Add this block to handle table pagination
        var table = document.getElementById('dataTable');
        var tbody = table.getElementsByTagName('tbody')[0];
        var rows = tbody.getElementsByTagName('tr');
        for (var i = 0; i < rows.length; i++) {
          rows[i].style.display = 'none';
        }
        var start = (Pagination.page - 1) * maxRows;
        var end = start + maxRows;
        for (var i = start; i < end && i < rows.length; i++) {
          rows[i].style.display = '';
        }
      },

      // write pagination
      Finish: function() {
        Pagination.e.innerHTML = Pagination.code;
        Pagination.code = '';
        Pagination.Bind();
      },

      // find pagination type
      Start: function() {
        var table = document.getElementById('dataTable');
        var rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

        // Retrieve the maxRows value
        var maxRows = parseInt(document.getElementById("maxRows").value);

        Pagination.size = Math.ceil(rows.length / maxRows);

        // Reset the code
        Pagination.code = '';

        if (Pagination.size < Pagination.step * 2 + 6) {
          Pagination.Add(1, Pagination.size + 1);
        } else if (Pagination.page < Pagination.step * 2 + 1) {
          Pagination.Add(1, Pagination.step * 2 + 4);
          Pagination.Last();
        } else if (Pagination.page > Pagination.size - Pagination.step * 2) {
          Pagination.First();
          Pagination.Add(Pagination.size - Pagination.step * 2 - 2, Pagination.size + 1);
        } else {
          Pagination.First();
          Pagination.Add(Pagination.page - Pagination.step, Pagination.page + Pagination.step + 1);
          Pagination.Last();
        }
        Pagination.Finish();
        Pagination.Bind();
      },



      // --------------------
      // Initialization
      // --------------------

      // binding buttons
      Buttons: function(e) {
        var nav = e.getElementsByTagName('a');
        nav[0].addEventListener('click', Pagination.Prev, false);
        nav[1].addEventListener('click', Pagination.Next, false);
      },

      // create skeleton
      Create: function(e) {

        var html = [
          '<a id="pag_a">◄</a>', // previous button
          '<span></span>', // pagination container
          '<a id="pag_a">►</a>' // next button
        ];

        e.innerHTML = html.join('');
        Pagination.e = e.getElementsByTagName('span')[0];
        Pagination.Buttons(e);
      },

      // init
      Init: function(e, data) {
        Pagination.Extend(data);
        Pagination.Create(e);
        Pagination.Start();
      }
    };



    /* * * * * * * * * * * * * * * * *
     * Initialization
     * * * * * * * * * * * * * * * * */

    var init = function() {
      // Initialize with data from the table
      Pagination.Init(document.getElementById('pagination'), {
        page: 1, // selected page
        step: '' // pages before and after current
      });
    };

    document.addEventListener('DOMContentLoaded', init, false);
  </script>

  <!-- PRINT -->
  <script>
    let printtable = new function() {
      this.printTable = function() {
        let tab = document.getElementById('dataTable');
        let win = window.open('', '', 'height=700,width=700');
        win.document.write(tab.outerHTML);
        win.document.close();
        win.print();
        win.close(); // Add this line to close the window after printing
      }

    }
  </script>

  <!-- EXPORT AS EXCEL -->
  <script>
    function export_table_to_xlsx(table, filename) {
      var wb = XLSX.utils.table_to_book(table, {
        sheet: "Sheet1"
      });

      var ws = wb.Sheets["Sheet1"];

      // Calculate column widths based on content
      var range = XLSX.utils.decode_range(ws['!ref']);
      for (var C = range.s.c; C <= range.e.c; ++C) {
        var max_len = 0;
        for (var R = range.s.r; R <= range.e.r; ++R) {
          var cell = ws[XLSX.utils.encode_cell({
            r: R,
            c: C
          })];
          if (cell && cell.v) {
            var len = String(cell.v).length;
            if (len > max_len) {
              max_len = len;
            }
          }
        }
        if (max_len > 0) {
          ws['!cols'] = ws['!cols'] || [];
          ws['!cols'][C] = {
            wch: max_len + 2
          };
        }
      }

      XLSX.writeFile(wb, filename);

    }

    document.querySelector("#toEXCEL").addEventListener("click", function() {
      var table = document.querySelector("table");
      export_table_to_xlsx(table, "SELF_APPRAISAL_REPORT.xlsx");
    });
  </script>

  <!-- SHOWS HOW MANY ENTRIES IN THE TABLE -->
  <script>
    // Add this code to update the entry count:

    function updateEntryCount() {
      var rowCount = $("#dataTable tbody tr").length;
      $("#rowCount").text(rowCount);
    }

    // Call the function to update the entry count after the page loads
    $(document).ready(function() {
      updateEntryCount();
    });
  </script>


  @endsection
</body>

</html>