<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>Task Allocation</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="TMS_Assets/assets/images/tms-logo-light.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="TMS_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="TMS_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="TMS_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="TMS_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="TMS_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="TMS_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />

    <!-- Layout config Js -->
    <script src="TMS_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="TMS_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="TMS_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="TMS_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="TMS_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />

    <!-- Include Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>

</head>

<body>

    <div id="layout-wrapper">
        @extends('TMS.Navbar.tmsnavbar')
        @section('content')

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="container">
                                        <div class="row">
                                            <div class="col-12 col-md-2">
                                                <p style="font-size: 20px;font-weight: 900;">MAIN TASK</p>
                                            </div>

                                            <div class="col-12 col-md-6 col-xl-2">
                                                <form action=""> <!-- Add method="post" to your form -->
                                                    <div class="form-group local-forms">
                                                        <select class="form-control select2" name="employee" id="employee">
                                                            <option value="">--Select Employee--</option>
                                                            @php
                                                            $loginID = Session::get('empl_id');
                                                            $loginNAME = Session::get('emp_name')
                                                            @endphp
                                                            <option value="{{$loginID}}" @if(request('employee')==$loginID) selected @endif>{{$loginNAME}}</option>
                                                            @foreach ($Staff_Name as $row)
                                                            <option value="{{$row['Emplno']}}" @if(request('employee')==$row['Emplno']) selected @endif>{{$row['C_Name']}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="container-fluid">
                                        <div class="tasks-board mb-3" id="kanbanboard">
                                            <!--================================= NEW TASK =================================-->

                                            <div class="tasks-list">
                                                <div class="d-flex mb-3">
                                                    <div class="flex-grow-1">
                                                        <h6 class="fs-14 text-uppercase mb-0" style="font-weight: 600;">New Tasks</h6>
                                                    </div>
                                                </div>

                                                <div data-simplebar class="tasks-wrapper px-3 mx-n3">
                                                    <div id="unassigned-task" class="tasks">
                                                        <div class="card tasks-box" style="background-color: #c6d4f6;">
                                                            <a href="task_action">
                                                                <div class="card-body">
                                                                    <div class="col-md-12">
                                                                        @if(empty($MresultZ))
                                                                        <div class="card-body">
                                                                            <p>No data available.</p>
                                                                        </div>
                                                                        @else
                                                                        @foreach($MresultZ as $Mnew)
                                                                        <div class="d-flex mb-2">
                                                                            <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                Task No : {{ $Mnew['Task_id'] }}
                                                                            </h6>
                                                                        </div>
                                                                        <div class="d-flex mb-2">
                                                                            <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                Task Name : {{ $Mnew['Task_Name'] }}
                                                                            </h6>
                                                                        </div>
                                                                        <div class="d-flex mb-2">
                                                                            <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                Description : {{ $Mnew['Description'] }}
                                                                            </h6>
                                                                        </div>
                                                                        <div class="d-flex mb-2">
                                                                            <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                Alloted Hours : {{ (int)$Mnew['Alloted_Hrs'] }} {{$Mnew['Ti_Interval']}}
                                                                            </h6>
                                                                        </div>
                                                                        @endforeach
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!--================================= ON GOING =================================-->
                                            <div class="tasks-list">
                                                <div class="d-flex mb-3">
                                                    <div class="flex-grow-1">
                                                        <h6 class="fs-14 text-uppercase mb-0" style="font-weight: 600;">Start / Hold</h6>
                                                    </div>
                                                </div>

                                                <div data-simplebar class="tasks-wrapper px-3 mx-n3">
                                                    <div id="unassigned-task" class="tasks">
                                                        <!-- START -->
                                                        <div class="card tasks-box" style="background-color:  #ACE1AF;">
                                                            <a href="task_action">
                                                                <div class="card-body">
                                                                    <div class="col-md-12">
                                                                        @if(empty($MresultS))
                                                                        <div class="card-body">
                                                                            <p>No data available.</p>
                                                                        </div>
                                                                        @else

                                                                        @foreach($MresultS as $Mstart)
                                                                        <div class="weight-blk" style="padding-bottom: 1px; margin-bottom: 5px;background-color: #bbf3be;">
                                                                            <div class="card-body">
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Task No : {{ $Mstart['Task_id'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Task Name : {{ $Mstart['Task_Name'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Description : {{ $Mstart['Description'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Alloted Hours : {{ $Mstart['Alloted_Hrs'] }}
                                                                                    </h6>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        @endforeach
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </a>
                                                        </div>
                                                        <!-- HOLD -->
                                                        <div class="card tasks-box" style="background-color: #ffff9b;">
                                                            <a href="task_action">
                                                                <div class="card-body">
                                                                    <div class="col-md-12">
                                                                        @if(empty($MresultH))
                                                                        <div class="card-body">
                                                                            <p>No data available.</p>
                                                                        </div>
                                                                        @else
                                                                        @foreach($MresultH as $Mhold)
                                                                        <div class="weight-blk" style="padding-bottom: 1px; margin-bottom: 5px;background-color: #ffffab;">
                                                                            <div class="card-body">
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Task No : {{ $Mhold['Task_id'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Task Name : {{ $Mhold['Task_Name'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Description : {{ $Mhold['Description'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Alloted Hours : {{ $Mhold['Alloted_Hrs'] }}
                                                                                    </h6>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        @endforeach
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!--================================= COMPLETED =================================-->
                                            <div class="tasks-list">
                                                <div class="d-flex mb-3">
                                                    <div class="flex-grow-1">
                                                        <h6 class="fs-14 text-uppercase mb-0" style="font-weight: 600;">Completed</h6>
                                                    </div>
                                                </div>

                                                <div data-simplebar class="tasks-wrapper px-3 mx-n3">
                                                    <div id="unassigned-task" class="tasks">
                                                        <div class="card tasks-box" style="background-color: #8ad7f5;">
                                                            <a href="task_comp_report">
                                                                <div class="card-body">
                                                                    <div class="col-md-12">
                                                                        @if(empty($MresultC))
                                                                        <div class="card-body">
                                                                            <p>No data available.</p>
                                                                        </div>
                                                                        @else

                                                                        @foreach($MresultC as $Mcomp)
                                                                        <div class="weight-blk" style="padding-bottom: 1px; margin-bottom: 5px;background-color: #bae0f8;">
                                                                            <div class="card-body">
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Task No : {{ $Mcomp['Task_id'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Task Name : {{ $Mcomp['Task_Name'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Description : {{ $Mcomp['Description'] }}
                                                                                    </h6>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        @endforeach
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-body">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-12 col-md-2">
                                                <p style="font-size: 20px;font-weight: 900;">SUB TASK</p>
                                            </div>
                                        </div>
                                        <div class="tasks-board mb-3" id="kanbanboard">

                                            <!--================================= NEW TASK =================================-->
                                            <div class="tasks-list">
                                                <div class="d-flex mb-3">
                                                    <div class="flex-grow-1">
                                                        <h6 class="fs-14 text-uppercase mb-0" style="font-weight: 600;">New Tasks</h6>
                                                    </div>
                                                </div>

                                                <div data-simplebar class="tasks-wrapper px-3 mx-n3">
                                                    <div id="unassigned-task" class="tasks">
                                                        <div class="card tasks-box" style="background-color: #c6d4f6;">
                                                            <a href="sub_task_report">
                                                                <div class="card-body">
                                                                    <div class="col-md-12">
                                                                        @if(empty($SresultZ))
                                                                        <div class="card-body">
                                                                            <p>No data available.</p>
                                                                        </div>
                                                                        @else
                                                                        @foreach($SresultZ as $Snew)
                                                                        <div class="weight-blk" style="padding-bottom: 1px; margin-bottom: 5px;background-color: #d1daf6;">
                                                                            <div class="card-body">
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Task No : {{ $Snew['Task_id'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Task Name : {{ $Snew['Task_Name'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Description : {{ $Snew['Description'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Alloted Hours : {{ (int)$Snew['Alloted_Hrs'] }} {{$Snew['Ti_Interval']}}
                                                                                    </h6>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        @endforeach
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!--================================= ON GOING =================================-->
                                            <div class="tasks-list">
                                                <div class="d-flex mb-3">
                                                    <div class="flex-grow-1">
                                                        <h6 class="fs-14 text-uppercase mb-0" style="font-weight: 600;">Start / Hold</h6>
                                                    </div>
                                                </div>

                                                <div data-simplebar class="tasks-wrapper px-3 mx-n3">
                                                    <div id="unassigned-task" class="tasks">
                                                        <!-- START -->
                                                        <div class="card tasks-box" style="background-color:  #ACE1AF;">
                                                            <a href="sub_task_report">
                                                                <div class="card-body">
                                                                    <div class="col-md-12">
                                                                        @if(empty($SresultS))
                                                                        <div class="card-body">
                                                                            <p>No data available.</p>
                                                                        </div>
                                                                        @else

                                                                        @foreach($SresultS as $Sstart)
                                                                        <div class="weight-blk" style="padding-bottom: 1px; margin-bottom: 5px;background-color: #bbf3be;">
                                                                            <div class="card-body">
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Task No : {{ $Sstart['Task_id'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Task Name : {{ $Sstart['Task_Name'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Description : {{ $Sstart['Description'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Alloted Hours : {{ $Sstart['Alloted_Hrs'] }}
                                                                                    </h6>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        @endforeach
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </a>
                                                        </div>
                                                        <!-- HOLD -->
                                                        <div class="card tasks-box" style="background-color: #ffff9b;">
                                                            <a href="sub_task_report">
                                                                <div class="card-body">
                                                                    <div class="col-md-12">
                                                                        @if(empty($SresultH))
                                                                        <div class="card-body">
                                                                            <p>No data available.</p>
                                                                        </div>
                                                                        @else
                                                                        @foreach($SresultH as $Shold)
                                                                        <div class="weight-blk" style="padding-bottom: 1px; margin-bottom: 5px;background-color: #ffffab;">
                                                                            <div class="card-body">
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Task No : {{ $Shold['Task_id'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Task Name : {{ $Shold['Task_Name'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Description : {{ $Shold['Description'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Alloted Hours : {{ $Shold['Alloted_Hrs'] }}
                                                                                    </h6>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        @endforeach
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!--================================= COMPLETED =================================-->
                                            <div class="tasks-list">
                                                <div class="d-flex mb-3">
                                                    <div class="flex-grow-1">
                                                        <h6 class="fs-14 text-uppercase mb-0" style="font-weight: 600;">Completed</h6>
                                                    </div>
                                                </div>

                                                <div data-simplebar class="tasks-wrapper px-3 mx-n3">
                                                    <div id="unassigned-task" class="tasks">
                                                        <div class="card tasks-box" style="background-color: #8ad7f5;">
                                                            <a href="sub_comp_report">
                                                                <div class="card-body">
                                                                    <div class="col-md-12">
                                                                        @if(empty($SresultC))
                                                                        <div class="card-body">
                                                                            <p>No data available.</p>
                                                                        </div>
                                                                        @else

                                                                        @foreach($MresultC as $Scomp)
                                                                        <div class="weight-blk" style="padding-bottom: 1px; margin-bottom: 5px;background-color: #bae0f8;">
                                                                            <div class="card-body">
                                                                                <div class="d-flex mb-2" style="margin-top: -30px;">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Task No : {{ $Scomp['Task_id'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Task Name : {{ $Scomp['Task_Name'] }}
                                                                                    </h6>
                                                                                </div>
                                                                                <div class="d-flex mb-2">
                                                                                    <h6 class="fs-15 mb-0 flex-grow-1 text-truncate task-title">
                                                                                        Description : {{ $Scomp['Description'] }}
                                                                                    </h6>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        @endforeach
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="pie_chart">
                                    <div class="page-wrapper">
                                        <div class="content container-fluid">
                                            <div class="row">

                                                <div class="col-md-6">
                                                    <div class="card">
                                                        <div class="col-12 col-md-6">
                                                            <p style="font-size: 20px;font-weight: 900;">MAIN PIE CHART</p>
                                                        </div>
                                                        <div class="card-body">
                                                            <canvas id="myPieChart1" width="300" height="300"></canvas>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-6">
                                                    <div class="card">
                                                        <div class="col-12 col-md-6">
                                                            <p style="font-size: 20px;font-weight: 900;">SUB PIE CHART</p>
                                                        </div>
                                                        <div class="card-body">
                                                            <canvas id="myPieChart2" width="300" height="300"></canvas>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>


    <!-- PIE CHART -->

    <!-- MAIN TASK PIE -->
    <script>
        // Assuming $Pichart contains the API response with flags and counts
        var apiData = <?php echo json_encode($MainPichart); ?>;

        var fullform = {
            'S': 'Start',
            'H': 'Hold',
            'C': 'Complete',
            'Z': 'New Task',
            'Over': 'Over Due',
        }
        // Extract flags and counts from the API response
        var flags = apiData.map(function(item) {
            return fullform[item.Flag] || item.Flag;
        });

        var counts = apiData.map(function(item) {
            return item.cnt;
        });

        // Data for the pie chart
        var data = {
            labels: flags,
            datasets: [{
                data: counts,
                backgroundColor: [
                    'purple',
                    'blue',
                    'yellow',
                    'green',
                    'red',
                    'orange'
                ],
                borderColor: 'rgba(255, 255, 255, 0.7)',
                borderWidth: 1
            }]
        };

        // Configuration options
        var options = {
            responsive: true,
            maintainAspectRatio: false,
            title: {
                display: true,
                text: 'My Pie Chart'
            },
            plugins: {
                datalabels: {
                    formatter: (value) => {
                        return value;
                    },
                    color: '#fff',
                    font: {
                        weight: 'bold'
                    }
                }
            }
        };



        // Get the context of the canvas element we want to select
        var ctx = document.getElementById("myPieChart1").getContext('2d');

        // Create the pie chart
        var myPieChart = new Chart(ctx, {
            type: 'pie',
            data: data,
            options: options,
            plugins: [ChartDataLabels]
        });
    </script>

    <!-- SUB TASK PIE -->
    <script>
        // Assuming $Pichart contains the API response with flags and counts
        var apiData = <?php echo json_encode($SubPichart); ?>;

        var fullform = {
            'S': 'Start',
            'H': 'Hold',
            'C': 'Complete',
            'Z': 'New Task',
            'Over': 'Over Due',
        }
        // Extract flags and counts from the API response
        var flags = apiData.map(function(item) {
            return fullform[item.Flag] || item.Flag;
        });

        var counts = apiData.map(function(item) {
            return item.cnt;
        });

        // Data for the pie chart
        var data = {
            labels: flags,
            datasets: [{
                data: counts,
                backgroundColor: [
                    'purple',
                    'blue',
                    'yellow',
                    'green',
                    'red',
                    'orange'
                ],
                borderColor: 'rgba(255, 255, 255, 0.7)',
                borderWidth: 1
            }]
        };

        // Configuration options
        var options = {
            responsive: true,
            maintainAspectRatio: false,
            title: {
                display: true,
                text: 'My Pie Chart'
            },
            plugins: {
                datalabels: {
                    formatter: (value) => {
                        return value;
                    },
                    color: '#fff',
                    font: {
                        weight: 'bold'
                    }
                }
            }
        };

        // Get the context of the canvas element we want to select
        var ctx = document.getElementById("myPieChart2").getContext('2d');

        // Create the pie chart
        var myPieChart = new Chart(ctx, {
            type: 'pie',
            data: data,
            options: options,
            plugins: [ChartDataLabels]
        });
    </script>


    <!-- SUBMIT THE EMPLOYEE NAME -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var selectEmployee = document.getElementById('employee');
            selectEmployee.addEventListener('change', function() {
                this.form.submit();
            });
        });
    </script>

    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->

    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>

    <div class="customizer-setting d-none d-md-block">
        <div class="btn-info rounded-pill shadow-lg btn btn-icon btn-lg p-2" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
            <i class='mdi mdi-spin mdi-cog-outline fs-22'></i>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="TMS_Assets/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="TMS_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="TMS_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="TMS_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="TMS_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="TMS_Assets/assets/js/plugins.js"></script>
    <!-- prismjs plugin -->
    <script src="TMS_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="TMS_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="TMS_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="TMS_Assets/assets/js/app.js"></script>

    <!-- calendar min js -->
    <script src="TMS_Assets/assets/libs/fullcalendar/index.global.min.js"></script>

    <!-- Calendar init -->
    <script src="TMS_Assets/assets/js/pages/calendar.init.js"></script>
    <script src="TMS_Assets/assets/js/pages/flatpickr.min.js"></script>
    <script src="TMS_Assets/assets/js/pages/choice.min.js"></script>

</body>
@endsection

</html>