<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>Task Report</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="TMS_Assets/assets/images/tms-logo-light.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="TMS_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="TMS_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="TMS_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="TMS_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="TMS_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="TMS_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <!-- IMAGE POPUP CLOSE -->
    <style>
        .modal .close {
            background-color: red;
            padding-left: 10px;
            padding-right: 10px;
            padding-top: 10px;
            padding-bottom: 1px;
            font-size: 30px;
            margin-left: 10px;
            cursor: pointer;
        }
    </style>

    <!-- STYLE FOR PAGINATION -->
    <style>
        .pagination {
            justify-content: space-between;
            margin-left: 10px;
        }

        #pagination {
            margin-right: 15px;
            display: inline-block;
            vertical-align: middle;
            border-radius: 4px;
            padding: 1px 2px 4px 2px;
            border-top: 1px solid #AEAEAE;
            border-bottom: 1px solid #FFFFFF;
            background-color: #DADADA;
            background-image: -webkit-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -moz-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -ms-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: -o-linear-gradient(top, #DBDBDB, #E2E2E2);
            background-image: linear-gradient(top, #DBDBDB, #E2E2E2);
        }

        #pagination #pag_a,
        #pagination #pag_i {
            display: inline-block;
            vertical-align: middle;
            width: 22px;
            color: #7D7D7D;
            text-align: center;
            font-size: 10px;
            padding: 3px 0 2px 0;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            -o-user-select: none;
            user-select: none;
        }

        #pagination #pag_a {
            margin: 0 2px 0 2px;
            border-radius: 4px;
            border: 1px solid #E3E3E3;
            cursor: pointer;
            box-shadow: inset 0 1px 0 0 #FFF, 0 1px 2px #666;
            text-shadow: 0 1px 1px #FFF;
            background-color: #E6E6E6;
            background-image: -webkit-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -moz-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -ms-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: -o-linear-gradient(top, #F3F3F3, #D7D7D7);
            background-image: linear-gradient(top, #F3F3F3, #D7D7D7);
        }

        #pagination #pag_i {
            margin: 0 3px 0 3px;
        }

        #pagination #pag_a.current {
            border: 1px solid #E9E9E9;
            box-shadow: 0 1px 1px #999;
            background-color: #DFDFDF;
            background-image: -webkit-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -moz-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -ms-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: -o-linear-gradient(top, #D0D0D0, #EBEBEB);
            background-image: linear-gradient(top, #D0D0D0, #EBEBEB);
        }
    </style>

    <!-- FONT -->
    <style>
        .row label,
        .card-title {
            font-weight: bold;
            font-size: medium;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .form-heading h4 {
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .card-body .table-responsive table thead th {
            color: black;
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .card-body .table-responsive table tbody td {
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }
    </style>

    <!-- Add CSS for modal display -->
    <style>
        /* Modal styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            /* Enable scrolling if needed */
            background-color: rgb(0, 0, 0);
            background-color: rgba(0, 0, 0, 0.4);
        }

        /* Modal content styles */
        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 50%;
        }

        /* Close button styles */
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
    </style>

</head>

<body>

    <div id="layout-wrapper">
        @extends('TMS.Navbar.tmsnavbar')
        @section('content')
        <div class="main-content">
            <div class="page-content">

                <!-- MAIN TASK -->
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0 flex-grow-1">TASK REPORT</h4>
                                </div>


                                <div id="taskDetailsModal" class="modal">
                                    <div class="modal-content" id="taskDetailsContent">
                                        <table id="taskDetailsTable" class="task-details-table">
                                            <thead>
                                                <tr>
                                                    <th>SNO</th>
                                                    <th>Flag</th>
                                                    <th>Timing</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <!-- Task details will be loaded here -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>



                                <!-- SEARCH AND SHOW ENTRIES -->
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="page-table-header mb-2">
                                            <div class="row align-items-center">
                                                <div class="doctor-table-blk">
                                                    <div class="doctor-search-blk">
                                                        <div class="top-nav-search table-search-blk">
                                                            <form action="javascript:;">
                                                                <div class="d-flex justify-content-between align-items-center">
                                                                    <div class="search-container" style="margin-left: 10px;">
                                                                        <input type="text" id="search-input" class="form-control" placeholder="Search here">
                                                                    </div>
                                                                    <div class="ml-2 col-md-1" style="margin-right: 10px;">
                                                                        <select name="state" id="maxRows" class="form-select">
                                                                            <option value="10">10</option>
                                                                            <option value="50">50</option>
                                                                            <option value="70">70</option>
                                                                            <option value="100">100</option>
                                                                            <option value="5000">Show ALL Rows</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="card-body">
                                    <div class="table-responsive table-card">
                                        <table class="table table-borderless table-centered align-middle table-nowrap mb-0" id="dataTable">
                                            <thead class="text-muted table-light">
                                                <tr>
                                                    <th style="display: none;">Rowid</th>
                                                    <th>SNO</th>
                                                    <th>Status</th>
                                                    <th style="display: block;">View History</th>
                                                    <th>Sub-Task No</th>
                                                    <th>Task Name</th>
                                                    <th>Reported To</th>
                                                    <th>Time/Duration</th>
                                                    <th>Hours Worked</th>
                                                    <th>Entry Date</th>
                                                    <th>Due Date</th>
                                                    <th>Decription</th>
                                                    <th>Attachment</th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                                <?php
                                                $counter = 0;
                                                foreach ($result as $index => $res) {
                                                    $counter++;
                                                ?>
                                                    <tr>
                                                        <td style="display: none;">{{ $res['Rowid'] }}</td>
                                                        <td>{{ $counter }}</td>

                                                        @if ( $res['Status'] == 'C')
                                                        <td>Completed</td>
                                                        @elseif($res['Status'] === 'S')
                                                        <td>Start</td>
                                                        @elseif($res['Status'] === 'H')
                                                        <td>Hold</td>
                                                        @elseif($res['Status'] === '')
                                                        <td></td>
                                                        @endif
                                                        <td style="display: block;">
                                                            <a href="#" onclick="showTaskDetails('{{ route('task_history', ['Rowid' => $res['Rowid'], 'emplno' => $res['Reported_To_id']]) }}')">View</a>
                                                        </td>
                                                        <td>{{ $res['Task_id'] }}</td>
                                                        <td>{{ $res['Task_Name'] }}</td>
                                                        <td>{{ $res['Reported_To'] }}</td>
                                                        <td>{{ $res['Time'] }}/{{ $res['Duration'] }}</td>
                                                        <td>{{ $res['Worked_Hours'] }}</td>
                                                        <td>{{ date('d-m-Y', strtotime($res['Entry_Date'])) }}</td>
                                                        <td>{{ date('d-m-Y', strtotime($res['Due_date'])) }}</td>
                                                        <td>{{ $res['Description'] }}</td>
                                                        <td>
                                                            @if($res['Attachment'] != "No Image")

                                                            <?php
                                                            $attachmentPath = $res['Attachment'];
                                                            $filename = basename($attachmentPath);
                                                            ?>

                                                            <a href="javascript:void(0);" onclick="showImagePopup('{{ asset('TMS_img/SUB/SUB/' . $filename) }}')">{{ $res['Attachment'] }}</a>

                                                            @else
                                                            No Image
                                                            @endif

                                                            <div id="imageModal" class="modal">
                                                                <span class="close" onclick="closeImagePopup()">&times;</span>
                                                                <img class="modal-content" id="modalImg" style="max-width: 70%; max-height: 70%; margin: auto;">
                                                            </div>

                                                        </td>
                                                    </tr>
                                                <?php
                                                }
                                                $subcounter = 0;
                                                foreach ($resultsub as $index => $res) {
                                                    $subcounter++;
                                                    $combine = $counter + $subcounter;
                                                ?>
                                                    <tr style="background-color: #f0f7f2;">
                                                        <td style="display: none;">{{ $res['Rowid'] }}</td>
                                                        <td>{{ $combine }}</td>

                                                        @if ( $res['Status'] == 'C')
                                                        <td>Completed</td>
                                                        @elseif($res['Status'] === 'S')
                                                        <td>Start</td>
                                                        @elseif($res['Status'] === 'H')
                                                        <td>Hold</td>
                                                        @elseif($res['Status'] === '')
                                                        <td></td>
                                                        @endif
                                                        <td style="display: block;">
                                                            <a href="#" onclick="showTaskDetails('{{ route('task_history', ['Subid' => $res['Rowid'], 'emplno' => $res['Reported_To_id']]) }}')">View</a>
                                                        </td>
                                                        <td>{{ $res['Sub_Task_id'] }}</td>
                                                        <td>{{ $res['Task_Name'] }}</td>
                                                        <td>{{ $res['Reported_To'] }}</td>
                                                        <td>{{ $res['Time'] }}/{{ $res['Duration'] }}</td>
                                                        <td>{{ $res['Worked_Hours'] }}</td>
                                                        <td>{{ date('d-m-Y', strtotime($res['Entry_Date'])) }}</td>
                                                        <td>{{ date('d-m-Y', strtotime($res['Due_date'])) }}</td>
                                                        <td>{{ $res['Description'] }}</td>
                                                        <td>
                                                            @if($res['Attachment'] != "No Image")

                                                            <?php
                                                            $attachmentPath = $res['Attachment'];
                                                            $filename = basename($attachmentPath);
                                                            ?>

                                                            <a href="javascript:void(0);" onclick="showImagePopup('{{ asset('TMS_img/SUB/SUB/' . $filename) }}')">{{ $res['Attachment'] }}</a>

                                                            @else
                                                            No Image
                                                            @endif

                                                            <div id="imageModal" class="modal">
                                                                <span class="close" onclick="closeImagePopup()">&times;</span>
                                                                <img class="modal-content" id="modalImg" style="max-width: 70%; max-height: 70%; margin: auto;">
                                                            </div>

                                                        </td>
                                                    </tr>
                                                <?php
                                                }
                                                ?>

                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <!--############################### PAGINATION ###############################-->
                                <div class="pagination">
                                    <div id="entryCount">Total entries: <span id="rowCount"></span></div>
                                    <div id="searchCount"></div>
                                    <div id="pagination"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function showTaskDetails(url) {
            // Make an AJAX request to fetch task details
            fetch(url)
                .then(response => response.json())
                .then(data => {
                    console.log('Received data:', data); // Log received data for debugging

                    // Clear previous content
                    const tableBody = document.querySelector('#taskDetailsTable tbody');
                    tableBody.innerHTML = '';

                    let serialno = 1;

                    // Function to get the display value for mainItem.Flag
                    const getFlagDisplayMain = flag => {
                        switch (flag) {
                            case 'S':
                                return 'Start';
                            case 'H':
                                return 'Hold';
                            case 'C':
                                return 'Completed';
                            default:
                                return flag;
                        }
                    };

                    // Populate the table with main task details
                    if (Array.isArray(data.main)) {
                        data.main.forEach(mainItem => {
                            const row = tableBody.insertRow();
                            row.innerHTML = `
                            <td>${serialno}</td>
                            <td>${getFlagDisplayMain(mainItem.Flag)}</td>
                            <td>${mainItem.Timing}</td>
                    `;
                            serialno++;
                        });
                    }

                    // Function to get the display value for mainItem.Flag
                    const getFlagDisplaySub = flag => {
                        switch (flag) {
                            case 'S':
                                return 'Start';
                            case 'H':
                                return 'Hold';
                            case 'C':
                                return 'Completed';
                            default:
                                return flag;
                        }
                    };
                    // Populate the table with sub task details if available
                    if (Array.isArray(data.sub) && data.sub.length > 0) {
                        data.sub.forEach(subItem => {
                            const row = tableBody.insertRow();
                            row.innerHTML = `
                            <td>${serialno}</td>
                            <td>${getFlagDisplaySub(subItem.Flag)}</td>
                            <td>${subItem.Timing}</td>
                    `;
                            serialno++;
                        });
                    }

                    // Show the modal
                    document.getElementById('taskDetailsModal').style.display = 'block';
                })
                .catch(error => {
                    console.error('Error fetching task details:', error);
                });
        }


        // Function to close the modal
        function closeTaskDetailsModal() {
            document.getElementById('taskDetailsModal').style.display = 'none';
        }

        // Close the modal when clicking on the close button
        document.getElementsByClassName('close')[0].onclick = function() {
            closeTaskDetailsModal();
        };

        // Close the modal when clicking outside the modal content
        window.onclick = function(event) {
            const modal = document.getElementById('taskDetailsModal');
            if (event.target === modal) {
                closeTaskDetailsModal();
            }
        };
    </script>




    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->

    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>

    <div class="customizer-setting d-none d-md-block">
        <div class="btn-info rounded-pill shadow-lg btn btn-icon btn-lg p-2" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
            <i class='mdi mdi-spin mdi-cog-outline fs-22'></i>
        </div>
    </div>

    <!-- SEARCH -->
    <script>
        $(document).ready(function() {
            // Attach an event handler to the input field
            $('#search-input').on('input', function() {
                // Get the value entered by the user
                var searchTerm = $(this).val().toLowerCase();

                // Filter the table rows based on the search term
                $('tbody tr').each(function() {
                    var rowText = $(this).text().toLowerCase();
                    $(this).toggle(rowText.includes(searchTerm));
                });
            });
        });
    </script>

    <!-- COLOR AND FLAG GROUP -->
    <script>
        // JavaScript for custom select functionality
        document.addEventListener("click", function(e) {
            closeAllCustomSelects(e.target);
        });

        // Function to close all custom selects except the one passed as argument
        function closeAllCustomSelects(exceptThis) {
            var customSelects = document.querySelectorAll(".custom-select");
            customSelects.forEach(function(customSelect) {
                if (exceptThis !== customSelect && !customSelect.contains(exceptThis)) {
                    var content = customSelect.querySelector(".custom-select-content");
                    content.style.display = "none";
                }
            });
        }

        // Handling color select
        var colorSelectBtns = document.querySelectorAll(".color-select .select-btn");
        var colorOptions = document.querySelectorAll(".color-select .custom-option");

        colorSelectBtns.forEach(function(colorSelectBtn, index) {
            colorSelectBtn.addEventListener("click", function(e) {
                closeAllCustomSelects();
                var selectContent = this.parentNode.querySelector(".custom-select-content");
                selectContent.style.display = "block";
                selectedRowId.value = index; // Store the index of the clicked row
                e.stopPropagation();
            });
        });

        colorOptions.forEach(function(option) {
            option.addEventListener("click", function() {
                var value = option.getAttribute("data-value");
                var colorIndicator = document.createElement("div");
                colorIndicator.classList.add("color-indicator");
                colorIndicator.style.backgroundColor = value;
                var colorSelectBtn = option.parentNode.parentNode.querySelector(".select-btn");
                colorSelectBtn.textContent = ""; // Clear text
                colorSelectBtn.appendChild(colorIndicator);
                closeAllCustomSelects();

                // Get the index of the clicked row
                var rowIndex = selectedRowId.value;

                // Update the input field associated with the clicked row
                var rowInput = document.querySelector('tr:nth-child(' + (parseInt(rowIndex) + 1) + ') input[name="color"]');
                if (rowInput) {
                    rowInput.value = value;
                }
            });
        });

        // Handling flag select
        var flagSelects = document.querySelectorAll(".flag-select");
        flagSelects.forEach(function(flagSelect, index) {
            var flagSelectBtn = flagSelect.querySelector(".select-btn");
            var flagOptions = flagSelect.querySelectorAll(".custom-option");

            flagSelectBtn.addEventListener("click", function(e) {
                closeAllCustomSelects();
                flagSelect.querySelector(".custom-select-content").style.display = "block";
                selectedRowId.value = index; // Store the index of the clicked row
                e.stopPropagation();
            });

            flagOptions.forEach(function(option) {
                option.addEventListener("click", function() {
                    var flagIcon = option.querySelector("i").cloneNode(true); // Clone the flag icon
                    flagSelectBtn.textContent = ""; // Clear text
                    flagSelectBtn.appendChild(flagIcon); // Add the flag icon to the select button
                    closeAllCustomSelects(); // Close the dropdown
                    var value = option.getAttribute("data-value");
                    selectedFlagInput.value = value; // Update flag input value

                    // Update the input field associated with the clicked row
                    var rowIndex = selectedRowId.value;
                    var rowInput = document.querySelector('tr:nth-child(' + (parseInt(rowIndex) + 1) + ') input[name="flag"]');
                    if (rowInput) {
                        rowInput.value = value;
                    }
                });
            });
        });
    </script>

    <!-- DROPDOWNS RESET TO  ORIGINAL STATE-->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let dropdownStates = {};

            // Add event listeners to all select dropdowns
            document.querySelectorAll("select").forEach(function(select) {
                // Store initial selectedIndex when the dropdown is clicked
                select.addEventListener("focus", function(event) {
                    dropdownStates[select.id] = select.selectedIndex;
                });

                // Restore initial selectedIndex if the dropdown loses focus without selecting a new option
                select.addEventListener("blur", function(event) {
                    if (!event.relatedTarget || event.relatedTarget.tagName !== "OPTION" && event.relatedTarget.tagName !== "BUTTON") {
                        select.selectedIndex = dropdownStates[select.id] || 0;
                    }
                });
            });
        });
    </script>

    <!-- CAN'T 'START' ANOTHER TASK IF ALREADY TASK IS IN START -->
    <script>
        // Function to show popup message
        function showStartPopup() {
            alert("Another task is already started.");
            event.target.value = '--Select--';
        }

        // Function to disable "Start" option in status dropdowns and show popup
        function handleStartOption(event) {
            var currentDropdown = event.target;
            var statusDropdowns = document.querySelectorAll('select[name="status"]');

            // Check if the current dropdown is trying to change to "Start"
            if (currentDropdown.value === 'S') {
                var startFound = false;

                // Loop through each dropdown to see if any other dropdown already has status "Start"
                statusDropdowns.forEach(function(dropdown) {
                    if (dropdown !== currentDropdown && dropdown.value === 'S') {
                        startFound = true;
                    }
                });

                // If another task is already started, prevent changing the current dropdown to "Start"
                if (startFound) {
                    event.preventDefault();
                    showStartPopup();
                }
            }
        }

        // Call the function whenever a status dropdown changes
        document.addEventListener('DOMContentLoaded', function() {
            // Listen for change events on status dropdowns
            document.querySelectorAll('select[name="status"]').forEach(function(dropdown) {
                dropdown.addEventListener('change', handleStartOption);
            });
        });
    </script>

    <!-- SHOW THE STARTED ROW AT THE TOP -->
    <script>
        // Function to reorder rows based on status
        function reorderRows() {
            var tableBody = document.querySelector('tbody');
            var rows = Array.from(tableBody.querySelectorAll('tr'));

            // Separate rows with status "Start"
            var startRows = rows.filter(function(row) {
                return row.querySelector('td:nth-child(5)').innerText.trim() === 'Start';
            });

            // Remove startRows from rows array
            rows = rows.filter(function(row) {
                return !startRows.includes(row);
            });

            // Reorder rows by appending startRows at the top
            startRows.forEach(function(row) {
                tableBody.appendChild(row);
            });

            // Append remaining rows after startRows
            rows.forEach(function(row) {
                tableBody.appendChild(row);
            });
        }

        // Call the function initially to reorder rows
        document.addEventListener('DOMContentLoaded', function() {
            reorderRows();
        });
    </script>

    <!-- IMAGE CLOSE -->
    <script>
        function showImagePopup(imageUrl) {
            var modal = document.getElementById("imageModal");
            var modalImg = document.getElementById("modalImg");
            modal.style.display = "block";
            modalImg.src = imageUrl;
        }

        function closeImagePopup() {
            var modal = document.getElementById("imageModal");
            modal.style.display = "none";
        }
    </script>

    <!-- GETTING THE ROWID FOR STATUS -->
    <script>
        document.querySelectorAll('.rowid').forEach(function(select) {
            select.addEventListener('change', function() {
                var selectedValue = this.value;
                var rowid = this.closest('tr').querySelector('.rid').innerText;
                this.closest('tr').querySelector('.Mrid').value = rowid;
            });
        });
    </script>

    <!-- GETTING THE ROWID FOR GROUPING -->
    <script>
        // JavaScript to handle row selection
        document.addEventListener("DOMContentLoaded", function() {
            // Get all custom-option elements
            var customOptions = document.querySelectorAll(".custom-option");

            // Add click event listener to each custom-option
            // Add click event listener to each custom-option
            customOptions.forEach(function(option) {
                option.addEventListener("click", function() {
                    // Get the value of the selected rowid
                    var rowid = this.closest('tr').querySelector('.rid').textContent;

                    // Update the value of the hidden input field associated with the clicked row
                    var rowInput = this.closest('tr').querySelector('input[name="rowid"]');
                    if (rowInput) {
                        rowInput.value = rowid;
                    }
                });
            });
        });
    </script>

    <!-- SHOW ENTRIES TABLE -->
    <script>
        // Function to update the number of displayed rows
        function updateRowsPerPage() {
            var maxRows = parseInt(document.getElementById("maxRows").value);
            var tableBody = document.getElementById("tableBody");
            var dataTable = document.getElementById("dataTable");
            var rows = dataTable.getElementsByTagName("tr");

            for (var i = 1; i < rows.length; i++) {
                if (i <= maxRows) {
                    rows[i].style.display = "";
                } else {
                    rows[i].style.display = "none";
                }
            }
            // Update pagination
            Pagination.Start();
        }

        // Add an event listener to the maxRows dropdown
        document.getElementById("maxRows").addEventListener("change", updateRowsPerPage);

        // Initial call to set the initial number of displayed rows
        updateRowsPerPage();
    </script>

    <!-- PAGINATION -->
    <script>
        var Pagination = {

            code: '',

            // --------------------
            // Utility
            // --------------------

            // converting initialize data
            Extend: function(data) {
                data = data || {};
                Pagination.size = data.size || 3000;
                Pagination.page = data.page || 5;
                Pagination.step = data.step || 5;
            },

            // add pages by number (from [s] to [f])
            Add: function(s, f) {
                for (var i = s; i < f; i++) {
                    Pagination.code += '<a id="pag_a">' + i + '</a>';
                }
            },

            // add last page with separator
            Last: function() {
                Pagination.code += '<i id="pag_i">...</i> <a id="pag_a">' + Pagination.size + '</a>';

            },

            // add first page with separator
            First: function() {
                Pagination.code += '<a id="pag_a">1</a> <i id="pag_i">...</i>';

            },



            // --------------------
            // Handlers
            // --------------------

            // change page
            Click: function() {
                Pagination.page = +this.innerHTML;
                Pagination.Start();
            },

            // previous page
            Prev: function() {
                Pagination.page--;
                if (Pagination.page < 1) {
                    Pagination.page = 1;
                }
                Pagination.Start();
            },

            // next page
            Next: function() {
                Pagination.page++;
                if (Pagination.page > Pagination.size) {
                    Pagination.page = Pagination.size;
                }
                Pagination.Start();
            },



            // --------------------
            // Script
            // --------------------

            // binding pages
            Bind: function() {
                var a = Pagination.e.getElementsByTagName('a');
                for (var i = 0; i < a.length; i++) {
                    if (+a[i].innerHTML === Pagination.page) a[i].className = 'current';
                    a[i].addEventListener('click', Pagination.Click, false);
                }

                // Retrieve the maxRows value
                var maxRows = parseInt(document.getElementById("maxRows").value);

                // Add this block to handle table pagination
                var table = document.getElementById('dataTable');
                var tbody = table.getElementsByTagName('tbody')[0];
                var rows = tbody.getElementsByTagName('tr');
                for (var i = 0; i < rows.length; i++) {
                    rows[i].style.display = 'none';
                }
                var start = (Pagination.page - 1) * maxRows;
                var end = start + maxRows;
                for (var i = start; i < end && i < rows.length; i++) {
                    rows[i].style.display = '';
                }
            },

            // write pagination
            Finish: function() {
                Pagination.e.innerHTML = Pagination.code;
                Pagination.code = '';
                Pagination.Bind();
            },

            // find pagination type
            Start: function() {
                var table = document.getElementById('dataTable');
                var rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

                // Retrieve the maxRows value
                var maxRows = parseInt(document.getElementById("maxRows").value);

                Pagination.size = Math.ceil(rows.length / maxRows);

                // Reset the code
                Pagination.code = '';

                if (Pagination.size < Pagination.step * 2 + 6) {
                    Pagination.Add(1, Pagination.size + 1);
                } else if (Pagination.page < Pagination.step * 2 + 1) {
                    Pagination.Add(1, Pagination.step * 2 + 4);
                    Pagination.Last();
                } else if (Pagination.page > Pagination.size - Pagination.step * 2) {
                    Pagination.First();
                    Pagination.Add(Pagination.size - Pagination.step * 2 - 2, Pagination.size + 1);
                } else {
                    Pagination.First();
                    Pagination.Add(Pagination.page - Pagination.step, Pagination.page + Pagination.step + 1);
                    Pagination.Last();
                }
                Pagination.Finish();
                Pagination.Bind();
            },



            // --------------------
            // Initialization
            // --------------------

            // binding buttons
            Buttons: function(e) {
                var nav = e.getElementsByTagName('a');
                nav[0].addEventListener('click', Pagination.Prev, false);
                nav[1].addEventListener('click', Pagination.Next, false);
            },

            // create skeleton
            Create: function(e) {

                var html = [
                    '<a id="pag_a">◄</a>', // previous button
                    '<span></span>', // pagination container
                    '<a id="pag_a">►</a>' // next button
                ];

                e.innerHTML = html.join('');
                Pagination.e = e.getElementsByTagName('span')[0];
                Pagination.Buttons(e);
            },

            // init
            Init: function(e, data) {
                Pagination.Extend(data);
                Pagination.Create(e);
                Pagination.Start();
            }
        };



        /* * * * * * * * * * * * * * * * *
         * Initialization
         * * * * * * * * * * * * * * * * */

        var init = function() {
            // Initialize with data from the table
            Pagination.Init(document.getElementById('pagination'), {
                page: 1, // selected page
                step: '' // pages before and after current
            });
        };

        document.addEventListener('DOMContentLoaded', init, false);
    </script>

    <!-- SHOWS HOW MANY ENTRIES IN THE TABLE -->
    <script>
        // Add this code to update the entry count:

        function updateEntryCount() {
            var rowCount = $("#dataTable tbody tr").length;
            $("#rowCount").text(rowCount);
        }

        // Call the function to update the entry count after the page loads
        $(document).ready(function() {
            updateEntryCount();
        });
    </script>

    <!-- JAVASCRIPT -->
    <script src="TMS_Assets/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="TMS_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="TMS_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="TMS_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="TMS_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="TMS_Assets/assets/js/plugins.js"></script>

    <!-- prismjs plugin -->
    <script src="TMS_Assets/assets/libs/prismjs/prism.js"></script>

    <!-- gridjs js -->
    <script src="TMS_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="TMS_Assets/assets/js/pages/gridjs.init.js"></script>

    <!-- App js -->
    <script src="TMS_Assets/assets/js/app.js"></script>

</body>
@endsection

</html>