<!DOCTYPE html>
<html lang="en">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <link rel="shortcut icon" type="image/x-icon" href="TMS_ass/task.png">
    <title>Task Allocation</title>

    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/css/bootstrap.min.css">
    <!-- Fontawesome CSS -->
    <link rel="stylesheet" href="hwassets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="hwassets/plugins/fontawesome/css/all.min.css">
    <!-- Feathericon CSS -->
    <link rel="stylesheet" href="hwassets/plugins/feather/feather.css">
    <!-- Select2 CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/css/select2.min.css">
    <!-- Datatables CSS -->
    <link rel="stylesheet" href="hwassets/plugins/datatables/datatables.min.css">
    <!-- Calendar CSS -->
    <link rel="stylesheet" href="hwassets/plugins/simple-calendar/simple-calendar.css">
    <!-- Datepicker CSS -->
    <link rel="stylesheet" href="hwassets/css/bootstrap-datetimepicker.min.css">
    <!-- Slick CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/plugins/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="hwassets/plugins/slick/slick-theme.css">
    <link rel="stylesheet" type="text/css" href="hwassets/plugins/light-gallery/css/lightgallery.min.css">
    <!-- Summernote CSS -->
    <link rel="stylesheet" href="hwassets/plugins/summernote/summernote-bs5.min.css">
    <link rel="stylesheet" type="text/css" href="hwassets/css/fullcalendar.min.css">
    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="TMS_ass/style.css">

    <!-- FONT -->
    <style>
        .row label {
            font-weight: bold;
            font-size: medium;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .form-heading h4 {
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .card-body .local-top {
            font-weight: bold;
            font-size: medium;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }
    </style>

</head>


<body>

    <div class="main-wrapper">
        @extends('TMS.Navbar.tmsnavbar')
        @section('content')

        <div class="page-wrapper">
            <div class="content">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>TASK ALLOCATION</h4>
                                    </div>
                                </div>
                                <form method="post" action="task_allocate1" enctype="multipart/form-data" class="has-validated" onsubmit="return validateForm()">
                                    @csrf
                                    <div class="row">
                                        <!-- TASK ID -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Task No</label>
                                                <input type="text" name="eno" value="{{$Taskno}}" class="form-control" readonly>
                                            </div>
                                        </div>
                                        <!-- STAFF NAME -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Employee Name<span class="login-danger">*</span></label>
                                                <select name="emplno" id="emplno" class="form-control select2" onchange="getemplno(this.value); clearSelecterror('emplno')">
                                                    <option value="" selected disabled>Select Type</option>
                                                    @foreach ($Staff_Name as $Staffs)
                                                    <option value="{{ $Staffs['Emplno'] }}">{{ $Staffs['C_Name'] }} / {{ $Staffs['C_TNO'] }}</option>
                                                    @endforeach
                                                </select>
                                                <div id="emplno-error" style="color: red; display: none;">Please select an Employee.</div>
                                            </div>
                                        </div>
                                        <!-- TASK NAME -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Task Name<span class="login-danger">*</span></label>
                                                <input name="task_name" id="task_name" class="form-control" type="text" oninput="clearTaskNameErrorMessage()" autocomplete="off">
                                                <div id="task-name-error" style="color: red; display: none;">Please enter Task Name.</div>
                                            </div>
                                        </div>
                                        <!-- Task Type -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Task Type<span class="login-danger">*</span></label>
                                                <select name="task_type" id="type" class="form-control select2" onchange="updateSelectedTaskType(); clearSelecterror('task_type')">
                                                    <option value="" disabled selected>Select Type</option>
                                                    @foreach ($resultType as $Type)
                                                    <option value="{{ $Type['Rowid'] }}">{{ $Type['Name'] }}</option>
                                                    @endforeach
                                                </select>
                                                <div id="task_type-error" style="color: red; display: none;">Please select Task Type.</div>
                                            </div>
                                        </div>

                                        <!-- PERIOD -->
                                        <div class="col-6 col-md-6 col-xl-4 period" style="display: none;" id="Period">
                                            <div class="row">

                                                <div class="col-lg-6 col-md-6">
                                                    <div class="form-group local-forms">
                                                        <label>Periodic Type<span class="login-danger">*</span></label>
                                                        <select name="period_type" id="Sch_Period" class="form-control select2" onchange="showweek(); clearSelecterror('Sch_Period')">
                                                            <option value="" disabled selected>Select Type</option>
                                                            @foreach ($resultPeriod as $Period)
                                                            <option value="{{ $Period['Rowid'] }}">{{ $Period['Name'] }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div id="Sch_Period-error" style="color: red; display: none;">Please select Period Type.</div>
                                                </div>

                                                <!-- DAILY TIME -->
                                                <div class="col-lg-6 col-md-6" id="dailysch" style="display: none;">
                                                    <div class="form-group local-forms">
                                                        <div class="input-group">
                                                            <input type="time" name="scheTimeDaily" class="form-control" id="Sch_Time_Daily" oninput="clearError('Sch_Time_Daily-error')">
                                                            <!-- <div class="input-group-append">
                                                                <span class="input-group-text"><i class="far fa-clock"></i></span>
                                                            </div> -->
                                                        </div>
                                                    </div>
                                                    <div id="Sch_Time_Daily-error" style="color: red; display: none;">Please select Time.</div>
                                                </div>

                                                <!-- WEEKLY DAYS -->
                                                <!-- <div class="col-lg-6 col-md-6" id="weeksch" style="display: none;">
                                                    <div class="form-group local-forms">
                                                        <input type="date" id="datePicker" class="form-control" oninput="updateDay()">
                                                        <input type="hidden" name="perd_W_day" id="dayInput">
                                                    </div>
                                                    <div class="form-group local-forms">
                                                        <div class="input-group">
                                                            <input type="time" name="perd_W_time" class="form-control">
                                                        </div>
                                                    </div>
                                                </div> -->

                                                <div class="col-12 col-md-6" id="weeksch" style="display: none;">
                                                    <div class="form-group local-forms">
                                                        <!-- <label>Day<span class="login-danger">*</span></label> -->
                                                        <select name="Sch_Day" class="form-control select2" id="Sch_Week_Day" onchange="clearError('Sch_Week_Day-error')">
                                                            <option value="" disabled selected>Select Type</option>
                                                            <option value="Mon">Monday</option>
                                                            <option value="Tue">Tuesday</option>
                                                            <option value="Wed">Wednesday</option>
                                                            <option value="Thr">Thrusday</option>
                                                            <option value="Fri">Friday</option>
                                                            <option value="Sat">Saturday</option>
                                                            <option value="Sun">Sunday</option>
                                                        </select>
                                                    </div>
                                                    <div id="Sch_Week_Day-error" style="color: red; display: none;">Please select a Day.</div>
                                                    <div class="form-group local-forms">
                                                        <div class="input-group">
                                                            <input type="time" name="scheTimeWeek" class="form-control" id="Sch_Time_Week" oninput="clearError('Sch_Time_Week-error')">
                                                        </div>
                                                    </div>
                                                    <div id="Sch_Time_Week-error" style="color: red; display: none;">Please select Task Type.</div>
                                                </div>

                                                <!-- DAY/MONTH -->
                                                <div class="col-6 col-md-6" id="monthsch" style="display: none;">
                                                    <div class="form-group local-forms">
                                                        <input type="date" name="Month_Day" class="form-control" id="Sch_Month_Date" oninput="clearError('Sch_Month_Date-error')">
                                                        <div id="Sch_Month_Date-error" style="color: red; display: none;">Please select Month Date.</div>
                                                    </div>
                                                    <div class="form-group local-forms">
                                                        <div class="input-group">
                                                            <input type="time" name="scheTimeMonth" class="form-control" id="Sch_Time_Month" oninput="clearError('Sch_Time_Month-error')">
                                                        </div>
                                                    </div>
                                                    <div id="Sch_Time_Month-error" style="color: red; display: none;">Please select Task Type.</div>
                                                </div>

                                            </div>
                                        </div>

                                        <!-- REPEATED TASK -->
                                        <div class="col-12 col-md-6 col-xl-4 repeat" style="display: none;">
                                            <div class="form-group local-forms">
                                                <label>Repeated Task<span class="login-danger"></span></label>
                                                <select name="repeat" class="form-control select2">
                                                    <option disabled selected>Select Type</option>
                                                    <option>YES</option>
                                                    <option>NO</option>
                                                </select>
                                            </div>
                                        </div>

                                        <!-- DUE -->
                                        <div class="col-12 col-md-6 col-xl-4" id="due_date">
                                            <div class="form-group local-forms">
                                                <label>DUE Date<span class="login-danger">*</span></label>
                                                <input type="date" name="due_date" min="{{ date('Y-m-d') }}" class="form-control" oninput="clearError('due-error')">
                                                <div id="due-error" style="color: red; display: none;">Please Choose the Due Date.</div>
                                            </div>
                                        </div>
                                        <!-- TIME -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Time Intervel<span class="login-danger">*</span></label>
                                                <select name="time_intervel" id="time_int" class="form-control select2" onchange="clearSelecterror('time_intervel')">
                                                    <option value="" disabled selected>Select Type</option>
                                                    @foreach ($resultTime as $Time)
                                                    @if ($Time['Name'] != 'Day')
                                                    <option value="{{ $Time['Rowid'] }}">{{ $Time['Name'] }}</option>
                                                    @endif
                                                    @endforeach
                                                </select>
                                                <div id="time_intervel-error" style="color: red; display: none;">Please select Time Intervel.</div>
                                            </div>
                                        </div>
                                        <!-- DURATION -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Duration<span class="login-danger">*</span></label>
                                                <input name="duration" id="durationInput" class="form-control" type="text" autocomplete="off" oninput="clearError('duration-error')">
                                                <div id="duration-error" style="color: red; display: none;">Please Enter Duration.</div>
                                            </div>
                                        </div>
                                        <!-- BEN DEP -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Beneficiary Dep<span class="login-danger"></span></label>
                                                <select name="ben_dep" class="form-control select2">
                                                    <option disabled selected>Select Type</option>
                                                    @foreach ($dept as $dep)
                                                    <option value="{{ $dep['code'] }}">{{ $dep['name'] }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <!-- BEN STAFF -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Beneficiary Staff<span class="login-danger"></span></label>
                                                <select name="ben_staff" class="form-control select2">
                                                    <option selected disabled>Select Type</option>
                                                    @foreach ($Ben_Staff as $Staffs)
                                                    <option value="{{ $Staffs['Emplno'] }}">{{ $Staffs['name'] }} / {{ $Staffs['tno'] }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <!-- ATTACHMENT -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-top-form">
                                                <label class="local-top">Attachment<span class="login-danger"></span></label>
                                                <div class="settings-btn upload-files-avator">
                                                    <input type="file" accept="image/*" name="image1" id="prodImgInput" class="hide-input" onchange="previewImage1()">
                                                    <label for="file" class="upload">Choose File</label>
                                                </div>
                                            </div>
                                            <div id="imagePreview" style="display:none; text-align: center;">
                                                <img id="preview" alt="Selected Image" style="max-width: 50%; height: 100px;">
                                                <br><br>
                                            </div>
                                        </div>
                                        <!-- PENDING HOURS -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Task Pending Hours<span class="login-danger"></span></label>
                                                <input name="pend_hrs" id="task_pending_hours" class="form-control" type="text" readonly>
                                            </div>
                                        </div>
                                        <!-- EXPECTED TO START -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Expected to Start<span class="login-danger"></span></label>
                                                <input name="ex_start" id="Ex_to_start" class="form-control" type="text" readonly>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- DESC -->
                                    <div class="col-12 col-sm-12">
                                        <div class="form-group local-forms">
                                            <label>Description <span class="login-danger"></span></label>
                                            <textarea name="desc" class="form-control" rows="1" cols="30"></textarea>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <div class="doctor-submit text-end">
                                            <button type="submit" class="btn btn-primary submit-form me-2">Submit</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- <script>
        function updateDay() {
            const datePicker = document.getElementById('datePicker');
            const selectedDate = new Date(datePicker.value);
            const dayIndex = selectedDate.getDay();
            const daysOfWeek = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
            const dayAbbreviation = daysOfWeek[dayIndex];

            const dayInput = document.getElementById('dayInput');
            dayInput.value = dayAbbreviation;
        }
    </script> -->


    <div class="sidebar-overlay" data-reff=""></div>
    <!-- jQuery -->
    <script src="hwassets/js/jquery-3.7.0.min.js"></script>
    <!-- Bootstrap Core JS -->
    <script src="hwassets/js/bootstrap.bundle.min.js"></script>
    <!-- Feather Js -->
    <script src="hwassets/js/feather.min.js"></script>
    <!-- Slimscroll -->
    <script src="hwassets/js/jquery.slimscroll.js"></script>
    <!-- Select2 Js -->
    <script src="hwassets/js/select2.min.js"></script>
    <!-- Datatables JS -->
    <script src="hwassets/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="hwassets/plugins/datatables/datatables.min.js"></script>
    <!-- counterup JS -->
    <script src="hwassets/js/jquery.waypoints.js"></script>
    <script src="hwassets/js/jquery.counterup.min.js"></script>
    <!-- Apexchart JS -->
    <script src="hwassets/plugins/apexchart/apexcharts.min.js"></script>
    <script src="hwassets/plugins/apexchart/chart-data.js"></script>
    <!-- Calendar Js -->
    <script src="hwassets/plugins/simple-calendar/jquery.simple-calendar.js"></script>
    <script src="hwassets/js/calander.js"></script>
    <!-- Circle Progress JS -->
    <script src="hwassets/js/circle-progress.min.js"></script>
    <!-- Slick JS -->
    <script src="hwassets/plugins/slick/slick.js"></script>
    <!-- Datepicker Core JS -->
    <script src="hwassets/plugins/moment/moment.min.js"></script>
    <script src="hwassets/js/bootstrap-datetimepicker.min.js"></script>
    <script src="hwassets/plugins/light-gallery/js/lightgallery-all.min.js"></script>
    <!-- Summernote JS -->
    <script src="hwassets/plugins/summernote/summernote-bs5.min.js"></script>
    <!-- Ck Editor JS -->
    <script src="hwassets/js/ckeditor.js"></script>
    <!-- Full Calendar -->
    <script src="hwassets/js/jquery-ui.min.js"></script>
    <script src="hwassets/js/fullcalendar.min.js"></script>
    <script src="hwassets/js/jquery.fullcalendar.js"></script>

    <!-- REQUIRED FOR FIELD -->
    <script>
        function validateForm() {
            var selectedEmpl = document.getElementById("emplno").value;
            var selectedTType = document.getElementById("type").value;
            var selectedTime = document.getElementById("time_int").value;
            var selectedTaskName = document.getElementById("task_name").value.trim();
            var selectedDuration = document.getElementById("durationInput").value.trim();
            var selectedPeriod = document.getElementById("Sch_Period").value;

            var errorEmpl = document.getElementById("emplno-error");
            var errorTType = document.getElementById("task_type-error");
            var errorTime = document.getElementById("time_intervel-error");
            var errorTaskName = document.getElementById("task-name-error");
            var errorDuration = document.getElementById("duration-error");
            var errorPeriod = document.getElementById("Sch_Period-error");

            var hasErrors = false;

            // CHECK STAFF 
            if (selectedEmpl == "") {
                errorEmpl.style.display = "block";
                hasErrors = true;
            } else {
                errorEmpl.style.display = "none";
            }

            // CHECK TASK NAME 
            if (selectedTaskName === "") {
                errorTaskName.style.display = "block";
                hasErrors = true;
            } else {
                errorTaskName.style.display = "none";
            }

            // CHECK TYPE
            if (selectedTType == "") {
                errorTType.style.display = "block";
                hasErrors = true;
            } else {
                errorTType.style.display = "none";
            }

            // CHECK TIME INTERVAL
            if (selectedTime == "") {
                errorTime.style.display = "block";
                hasErrors = true;
            } else {
                errorTime.style.display = "none";
            }

            // CHECK DURATION
            if (selectedDuration === "") {
                errorDuration.style.display = "block";
                hasErrors = true;
            } else {
                errorDuration.style.display = "none";
            }

            // CHECK IF PERIOD FIELD IS VISIBLE
            var Period = document.getElementById("Period");
            if (Period.style.display !== 'none') {
                if (selectedPeriod === "") {
                    errorPeriod.style.display = "block";
                    hasErrors = true;
                } else {
                    errorPeriod.style.display = "none";
                }
            }

            // CHECK IF DUE DATE FIELD IS VISIBLE
            var duedate = document.getElementById("due_date");
            if (duedate.style.display !== 'none') {
                var selectedDue = document.querySelector('input[name="due_date"]').value;
                var errorDue = document.getElementById("due-error");

                if (selectedDue == "") {
                    errorDue.style.display = "block";
                    hasErrors = true;
                } else {
                    errorDue.style.display = "none";
                }
            }

            // CHECK IF DAILY SCHEDULE FIELD IS VISIBLE
            var DailySch = document.getElementById("dailysch");
            if (DailySch.style.display !== 'none') {
                var SchTimeDaily = document.getElementById('Sch_Time_Daily').value;
                var SchTimeDailyError = document.getElementById('Sch_Time_Daily-error');

                if (SchTimeDaily == "") {
                    SchTimeDailyError.style.display = "block";
                    hasErrors = true;
                } else {
                    SchTimeDailyError.style.display = "none";
                }
            }

            // CHECK IF WEEKLY SCHEDULE FIELD IS VISIBLE
            var WeekSch = document.getElementById("weeksch");
            if (WeekSch.style.display !== 'none') {
                var SchWeekDay = document.getElementById("Sch_Week_Day").value;
                var SchWeekDayError = document.getElementById("Sch_Week_Day-error");
                var SchWeekTime = document.getElementById("Sch_Time_Week").value;
                var SchWeekTimeError = document.getElementById("Sch_Time_Week-error");

                if (SchWeekDay == "") {
                    SchWeekDayError.style.display = "block";
                    hasErrors = true;
                } else {
                    SchWeekDayError.style.display = "none";
                }

                if (SchWeekTime == "") {
                    SchWeekTimeError.style.display = "block";
                    hasErrors = true;
                } else {
                    SchWeekTimeError.style.display = "none";
                }
            }

            // CHECK IF MONTHLY SCHEDULE FIELD IS VISIBLE
            var MonthSch = document.getElementById('monthsch');
            if (MonthSch.style.display !== 'none') {
                var SchMonthDate = document.getElementById('Sch_Month_Date').value;
                var SchMonthDateError = document.getElementById('Sch_Month_Date-error');
                var SchMonthTime = document.getElementById('Sch_Time_Month').value;
                var SchMonthTimeError = document.getElementById('Sch_Time_Month-error');

                if (SchMonthDate == "") {
                    SchMonthDateError.style.display = "block";
                    hasErrors = true;
                } else {
                    SchMonthDateError.style.display = "none";
                }
                if (SchMonthTime == "") {
                    SchMonthTimeError.style.display = "block";
                    hasErrors = true;
                } else {
                    SchMonthTimeError.style.display = "none";
                }
            }

            if (hasErrors) {
                return false; // Return false to prevent form submission
            }

            return true; // Return true if no errors, allow form submission
        }

        // Function to clear the error message for the selected option
        function clearSelecterror(elementId) {
            var errorDiv = document.getElementById(elementId + "-error");
            errorDiv.style.display = "none";
        }


        // Function to clear the error message for the task name
        function clearTaskNameErrorMessage() {
            var taskNameErrorDiv = document.getElementById("task-name-error");
            taskNameErrorDiv.style.display = "none";
        }
    </script>
    <script>
        function clearError(errorId) {
            var errorDiv = document.getElementById(errorId);
            errorDiv.style.display = "none";
        }
    </script>

    <!-- HIDE PERIODIC AND REPEAT DROPDOWN -->
    <script>
        function updateSelectedTaskType() {
            // Get the selected value from the dropdown
            var selectedValue = document.getElementById("type").value;

            // Get the Periodic Type dropdown element
            var periodicTypeDropdown = document.querySelector('.period');
            var repeatDropdown = document.querySelector('.repeat');
            var select = document.querySelector('.select2');
            var duedate = document.querySelector('#due_date');

            // Check if the selected value is 2
            if (selectedValue === '2') {
                // Show the Periodic Type dropdown
                periodicTypeDropdown.style.display = 'block';
                repeatDropdown.style.display = 'block';
                duedate.style.display = 'none';
            } else {
                // Hide the Periodic Type dropdown
                periodicTypeDropdown.style.display = 'none';
                repeatDropdown.style.display = 'none';
                duedate.style.display = 'block';
            }
        }

        function showweek() {
            var sch = document.querySelector("#Sch_Period").value;
            var dailysch = document.querySelector("#dailysch");
            var weeksch = document.querySelector("#weeksch");
            var monthsch = document.querySelector("#monthsch");

            if (sch === '1') {
                dailysch.style.display = "block";
            } else {
                dailysch.style.display = "none";
            }

            if (sch === '2') {
                weeksch.style.display = 'block';
            } else {
                weeksch.style.display = 'none';
            }

            if (sch === '3') {
                monthsch.style.display = "block";
            } else {
                monthsch.style.display = "none";
            }
        }
    </script>

    <!-- NOT ALLOW " . " IN DURATION -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var durationInput = document.getElementById('durationInput');

            durationInput.addEventListener('input', function() {
                var inputValue = this.value.trim();
                var regex = /^[1-9]\d*$/; // Regular expression to match only whole numbers

                if (!regex.test(inputValue)) {
                    alert('Please enter a valid number without decimals " . "');
                    this.value = ''; // Clear the input field if input is invalid
                }
            });
        });
    </script>

    <!-- GETTING EXPECTED TIME TO START AND HOUR -->
    <script>
        function getemplno(emplno) {
            $.ajax({
                url: "{{ route('getApiResultMain') }}",
                type: "GET",
                data: {
                    emplno: emplno,
                },
                dataType: 'json',

                success: function(response) {
                    console.log(response);
                    if (response.length > 0) {
                        document.getElementById("task_pending_hours").value = response[0].Hours;
                        document.getElementById("Ex_to_start").value = response[0].Date;
                    } else {
                        document.getElementById("task_pending_hours").value = "";
                        document.getElementById("Ex_to_start").value = "";
                    }
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });


            // Now make the second API request
            $.ajax({
                url: "{{ route('getApiResultSub') }}",
                type: "GET",
                data: {
                    emplno: emplno,
                },
                dataType: 'json',

                success: function(responseSub) {
                    console.log(responseSub);
                    document.getElementById("task_pending_hours").value = responseSub[0].Hours;
                    document.getElementById("Ex_to_start").value = responseSub[0].Date;
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });
        }
    </script>

    <!-- DURATION TIME TO DECIMEL-->
    <script>
        // Get the input element
        var durationInput = document.getElementById('durationInput');

        // Add event listener for the input losing focus
        durationInput.addEventListener('blur', function() {
            // Get the entered value
            var enteredValue = parseFloat(this.value);

            // Check if the entered value is a number
            if (!isNaN(enteredValue)) {
                // Format the value as a decimal number with two decimal places
                this.value = enteredValue.toFixed(2);
            }
        });
    </script>

    <!-- SEARCH -->
    <script>
        // Initialize Select2
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <!-- IMAGE -->
    <script>
        function previewImage1() {
            var input = document.getElementById('prodImgInput');
            var preview = document.getElementById('preview');
            var previewContainer = document.getElementById('imagePreview');

            var file = input.files[0];

            if (file) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    preview.src = e.target.result;
                    previewContainer.style.display = 'block';
                };

                reader.readAsDataURL(file);
            } else {
                preview.src = '';
                previewContainer.style.display = null;
            }
        }
    </script>

    <script data-navigate-once="true">
        window.livewireScriptConfig = {
            "csrf": "hU0lkwotxPRtX77i9lZ9z8EOooahpVoehQm3a7EO",
            "uri": "\/livewire\/update",
            "progressBar": ""
        };
    </script>

    <!-- Custom JS -->
    <script src="hwassets/js/app.js"></script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('SuccessMsg'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($message = Session::get('errorMsg'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

</body>
@endsection

</html>