<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>Sub Task Allocation</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="TMS_Assets/assets/images/tms-logo-light.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="TMS_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="TMS_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="TMS_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="TMS_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="TMS_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="TMS_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

    <style>
        .login-danger {
            color: red;
        }
    </style>

    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

    <!-- DROPDOWN -->
    <style>
        .select2-container .select2-selection--single {
            height: 38px;
            padding: 8px 12px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        .select2-container .select2-selection--single .select2-selection__arrow {
            height: 36px;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 20px;
            top: 50%;
            font-size: 15px;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow b {
            top: 50%;
            transform: translateY(-50%);
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            top: 50%;
            transform: translateY(-50%);
        }

        .select2-container .select2-selection--single .select2-selection__placeholder {
            line-height: normal;
            /* Reset line-height */
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            font-size: 15px;
        }

        .select2-container .select2-selection--single .select2-selection__clear {
            display: block;
        }
    </style>
    
    <!-- FONT -->
    <style>
        .row label,
        .card-title {
            font-weight: bold;
            font-size: medium;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }
    </style>

</head>

<body>

    <div id="layout-wrapper">
        @extends('TMS.Navbar.tmsnavbar')
        @section('content')
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-6">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">SUB TASK ENTRY</h4>
                                </div>

                                <div class="card-body">
                                    <div class="live-preview">
                                        <!-- <form action="" class="needs-validation"> -->
                                        <!-- <form class="row g-3 needs-validation" novalidate> -->
                                        <form method="post" action="sub_task_entry" enctype="multipart/form-data" class="has-validated" onsubmit="return validateForm()">
                                            @csrf
                                            <div class="row">
                                                <input type="hidden" name="MRid" value="{{ request('Rowid') }}">
                                                <!-- TASK ID -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">Task No</label>
                                                        <input type="text" name="maineno" value="{{ request('Task_id') }}" class="form-control" readonly>
                                                    </div>
                                                </div>
                                                <!-- OVERALL DUE DATE -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">Overall Due Date</label>
                                                        <input type="text" value="{{ date('d-m-Y', strtotime(request('Due_date') )) }}" class="form-control" readonly>
                                                    </div>
                                                </div>
                                                <!-- SUB TASK ID -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">Sub Task No</label>
                                                        <input type="text" name="subeno" value="{{ $SubTaskno }}" class="form-control" readonly>
                                                    </div>
                                                </div>
                                                <!-- SUB TASK NAME -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">Sub Task No</label>
                                                        <input name="task_name" value="{{ request('Task_Name') }}" class="form-control" type="text" autocomplete="off">
                                                    </div>
                                                </div>
                                                <!-- STAFF NAME -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="ForminputState" class="form-label">Employee Name<span class="login-danger">*</span></label>
                                                        <select name="emplno" id="emplno" class="form-select select2" onchange="getemplno(this.value); clearSelecterror('emplno')">
                                                            <option value="" selected disabled>Select Type</option>
                                                            @foreach ($Staff_Name as $Staffs)
                                                            <option value="{{ $Staffs['Emplno'] }}">{{ $Staffs['C_Name'] }} / {{ $Staffs['C_TNO'] }}</option>
                                                            @endforeach
                                                        </select>
                                                        <div id="emplno-error" style="color: red; display: none;">Please select an Employee.</div>
                                                    </div>
                                                </div>
                                                <!-- TASK TYPE -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label>Task Type<span class="login-danger">*</span></label>
                                                        <select name="task_type" id="type" class="form-select select2" onchange="updateSelectedTaskType(); clearSelecterror('task_type')">
                                                            <option value="" disabled selected>Select Type</option>
                                                            @foreach ($resultType as $Type)
                                                            <option value="{{ $Type['Rowid'] }}">{{ $Type['Name'] }}</option>
                                                            @endforeach
                                                        </select>
                                                        <div id="task_type-error" style="color: red; display: none;">Please select Task Type.</div>
                                                    </div>
                                                </div>
                                                <!-- PERIOD -->
                                                <div class="col-md-4 period" style="display: none;" id="Period">
                                                    <div class="mb-3 row">

                                                        <div class="col-lg-6 col-md-6">
                                                            <div class="form-group local-forms">
                                                                <label>Periodic Type<span class="login-danger">*</span></label>
                                                                <select name="period_type" id="Sch_Period" class="form-select select2" onchange="showweek(); clearSelecterror('Sch_Period')">
                                                                    <option value="" disabled selected>Select Type</option>
                                                                    @foreach ($resultPeriod as $Period)
                                                                    <option value="{{ $Period['Rowid'] }}">{{ $Period['Name'] }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            <div id="Sch_Period-error" style="color: red; display: none;">Please select Period Type.</div>
                                                        </div>
                                                        <!-- DAILY TIME -->
                                                        <div class="col-lg-6 col-md-6" id="dailysch" style="display: none;">
                                                            <div class="form-group local-forms">
                                                                <div class="input-group">
                                                                    <input type="time" name="scheTimeDaily" class="form-control" id="Sch_Time_Daily" oninput="clearError('Sch_Time_Daily-error')">
                                                                </div>
                                                            </div>
                                                            <div id="Sch_Time_Daily-error" style="color: red; display: none;">Please select Time.</div>
                                                        </div>
                                                        <!-- WEEKLY DAYS -->
                                                        <div class="col-12 col-md-6" id="weeksch" style="display: none;">
                                                            <div class="form-group local-forms">
                                                                <select name="Week_Day" class="form-select select2" id="Sch_Week_Day" onchange="clearError('Sch_Week_Day-error')">
                                                                    <option value="" disabled selected>Select Type</option>
                                                                    <option value="Mon">Monday</option>
                                                                    <option value="Tue">Tuesday</option>
                                                                    <option value="Wed">Wednesday</option>
                                                                    <option value="Thr">Thrusday</option>
                                                                    <option value="Fri">Friday</option>
                                                                    <option value="Sat">Saturday</option>
                                                                    <option value="Sun">Sunday</option>
                                                                </select>
                                                            </div>
                                                            <div id="Sch_Week_Day-error" style="color: red; display: none;">Please select a Day.</div>
                                                            <div class="form-group local-forms">
                                                                <div class="input-group">
                                                                    <input type="time" name="scheTimeWeek" class="form-control" id="Sch_Time_Week" oninput="clearError('Sch_Time_Week-error')">
                                                                </div>
                                                            </div>
                                                            <div id="Sch_Time_Week-error" style="color: red; display: none;">Please select Task Type.</div>
                                                        </div>
                                                        <!-- DAY/MONTH -->
                                                        <div class="col-6 col-md-6" id="monthsch" style="display: none;">
                                                            <div class="form-group local-forms">
                                                                <input type="date" name="Month_Day" class="form-control" id="Sch_Month_Date" oninput="clearError('Sch_Month_Date-error')">
                                                                <div id="Sch_Month_Date-error" style="color: red; display: none;">Please select Month Date.</div>
                                                            </div>
                                                            <div class="form-group local-forms">
                                                                <div class="input-group">
                                                                    <input type="time" name="scheTimeMonth" class="form-control" id="Sch_Time_Month" oninput="clearError('Sch_Time_Month-error')">
                                                                </div>
                                                            </div>
                                                            <div id="Sch_Time_Month-error" style="color: red; display: none;">Please select Task Type.</div>
                                                        </div>

                                                    </div>
                                                </div>
                                                <!-- REPEATED TASK -->
                                                <div class="col-md-4 repeat" style="display: none;">
                                                    <div class="mb-3">
                                                        <label>Repeated Task<span class="login-danger"></span></label>
                                                        <select name="repeat" class="form-select select2">
                                                            <option disabled selected>Select Type</option>
                                                            <option>YES</option>
                                                            <option>NO</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <!-- DUE DATE -->
                                                <div class="col-md-4" id="due_date">
                                                    <div class="mb-3">
                                                        <label class="form-label">DUE Date<span class="login-danger">*</span></label>
                                                        <input type="date" name="due_date" min="{{ date('Y-m-d') }}" class="form-control" oninput="clearError('due-error')">
                                                        <div id="due-error" style="color: red; display: none;">Please choose the Due Date.</div>
                                                    </div>
                                                </div>
                                                <!-- TIME INTERVAL -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label>Time Intervel<span class="login-danger">*</span></label>
                                                        <select name="time_intervel" id="time" class="form-select select2" onchange="clearSelecterror('time_intervel')">
                                                            <option value="" disabled selected>Select Type</option>
                                                            @foreach ($resultTime as $Time)
                                                            @if ($Time['Name'] != 'Day')
                                                            <option value="{{ $Time['Rowid'] }}">{{ $Time['Name'] }}</option>
                                                            @endif
                                                            @endforeach
                                                        </select>
                                                        <div id="time_intervel-error" style="color: red; display: none;">Please select Time Intervel.</div>
                                                    </div>
                                                </div>
                                                <!-- DURATION -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label>Duration<span class="login-danger">*</span></label>
                                                        <input name="duration" id="durationInput" class="form-control" type="text" autocomplete="off" oninput="clearError('duration-error')">
                                                        <div id="duration-error" style="color: red; display: none;">Please enter Duration.</div>
                                                    </div>
                                                    <input type="hidden" value="{{request('Time')}}">
                                                    <input type="hidden" id="remainDuration" value="{{request('RemainingDuration')}}">
                                                </div>
                                                <!-- BEN DEP -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label>Beneficiary Dep<span class="login-danger"></span></label>
                                                        <select name="ben_dep" class="form-select select2">
                                                            <option value="" disabled selected>Select Type</option>
                                                            @foreach ($dept as $dep)
                                                            <option value="{{ $dep['code'] }}">{{ $dep['name'] }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <!-- BEN STAFF -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label>Beneficiary Staff<span class="login-danger"></span></label>
                                                        <select name="ben_staff" class="form-select select2">
                                                            <option value="" disabled selected>Select Type</option>
                                                            @foreach ($Ben_Staff as $Staffs)
                                                            <option value="{{ $Staffs['Emplno'] }}">{{ $Staffs['name'] }} / {{ $Staffs['tno'] }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <!-- ATTACHMENT -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <div>
                                                            <label for="formFile" class="form-label">Attachment</label>
                                                            <input type="file" class="form-control" name="image1" id="prodImgInput" onchange="previewImage1()">
                                                        </div>
                                                    </div>
                                                    <div id="imagePreview" style="display:none; text-align: center;">
                                                        <img id="preview" alt="Selected Image" style="max-width: 50%; height: 100px;">
                                                        <br><br>
                                                    </div>
                                                </div>
                                                <!-- PENDING HOURS -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">Task Pending Hours</label>
                                                        <input type="text" id="task_pending_hours" name="pend_hrs" class="form-control" readonly>
                                                    </div>
                                                </div>
                                                <!-- EXPECTED TO START -->
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label for="firstNameinput" class="form-label">Expected to Start</label>
                                                        <input type="text" name="ex_start" id="Ex_to_start" class="form-control" readonly>
                                                    </div>
                                                </div>
                                                <!-- DESCRIPTION -->
                                                <div class="mb-3">
                                                    <label for="validationTextarea" class="form-label">Description</label>
                                                    <textarea class="form-control" name="desc"></textarea>
                                                </div>
                                                <!--  SUBMIT BUTTON -->
                                                <div class="col-sm-auto">
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->

    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>

    <div class="customizer-setting d-none d-md-block">
        <div class="btn-info rounded-pill shadow-lg btn btn-icon btn-lg p-2" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
            <i class='mdi mdi-spin mdi-cog-outline fs-22'></i>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="TMS_Assets/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="TMS_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="TMS_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="TMS_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="TMS_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="TMS_Assets/assets/js/plugins.js"></script>
    <!-- prismjs plugin -->
    <script src="TMS_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="TMS_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="TMS_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="TMS_Assets/assets/js/app.js"></script>

    <!-- REQUIRED FOR FIELD -->
    <script>
        function validateForm() {
            var selectedEmpl = document.getElementById("emplno").value;
            var selectedTType = document.getElementById("type").value;
            var selectedTime = document.getElementById("time").value;
            // var selectedTaskName = document.getElementById("task_name").value.trim();
            var selectedDuration = document.getElementById("durationInput").value.trim();
            var selectedPeriod = document.getElementById("Sch_Period").value;

            var errorEmpl = document.getElementById("emplno-error");
            var errorTType = document.getElementById("task_type-error");
            var errorTime = document.getElementById("time_intervel-error");
            // var errorTaskName = document.getElementById("task-name-error");
            var errorDuration = document.getElementById("duration-error");
            var errorPeriod = document.getElementById("Sch_Period-error");

            var hasErrors = false;

            // CHECK STAFF 
            if (selectedEmpl == "") {
                errorEmpl.style.display = "block";
                hasErrors = true;
            } else {
                errorEmpl.style.display = "none";
            }

            // CHECK TASK NAME 
            // if (selectedTaskName === "") {
            //     errorTaskName.style.display = "block";
            //     hasErrors = true;
            // } else {
            //     errorTaskName.style.display = "none";
            // }

            // CHECK TYPE
            if (selectedTType == "") {
                errorTType.style.display = "block";
                hasErrors = true;
            } else {
                errorTType.style.display = "none";
            }

            // CHECK TIME INTERVAL
            if (selectedTime == "") {
                errorTime.style.display = "block";
                hasErrors = true;
            } else {
                errorTime.style.display = "none";
            }

            // CHECK DURATION
            if (selectedDuration === "") {
                errorDuration.style.display = "block";
                hasErrors = true;
            } else {
                errorDuration.style.display = "none";
            }

            // CHECK IF PERIOD FIELD IS VISIBLE
            var Period = document.getElementById("Period");
            if (Period.style.display !== 'none') {
                if (selectedPeriod === "") {
                    errorPeriod.style.display = "block";
                    hasErrors = true;
                } else {
                    errorPeriod.style.display = "none";
                }
            }

            // CHECK IF DUE DATE FIELD IS VISIBLE
            var duedate = document.getElementById("due_date");
            if (duedate.style.display !== 'none') {
                var selectedDue = document.querySelector('input[name="due_date"]').value;
                var errorDue = document.getElementById("due-error");

                if (selectedDue == "") {
                    errorDue.style.display = "block";
                    hasErrors = true;
                } else {
                    errorDue.style.display = "none";
                }
            }

            // CHECK IF DAILY SCHEDULE FIELD IS VISIBLE
            var DailySch = document.getElementById("dailysch");
            if (DailySch.style.display !== 'none') {
                var SchTimeDaily = document.getElementById('Sch_Time_Daily').value;
                var SchTimeDailyError = document.getElementById('Sch_Time_Daily-error');

                if (SchTimeDaily == "") {
                    SchTimeDailyError.style.display = "block";
                    hasErrors = true;
                } else {
                    SchTimeDailyError.style.display = "none";
                }
            }

            // CHECK IF WEEKLY SCHEDULE FIELD IS VISIBLE
            var WeekSch = document.getElementById("weeksch");
            if (WeekSch.style.display !== 'none') {
                var SchWeekDay = document.getElementById("Sch_Week_Day").value;
                var SchWeekDayError = document.getElementById("Sch_Week_Day-error");
                var SchWeekTime = document.getElementById("Sch_Time_Week").value;
                var SchWeekTimeError = document.getElementById("Sch_Time_Week-error");

                if (SchWeekDay == "") {
                    SchWeekDayError.style.display = "block";
                    hasErrors = true;
                } else {
                    SchWeekDayError.style.display = "none";
                }

                if (SchWeekTime == "") {
                    SchWeekTimeError.style.display = "block";
                    hasErrors = true;
                } else {
                    SchWeekTimeError.style.display = "none";
                }
            }

            // CHECK IF MONTHLY SCHEDULE FIELD IS VISIBLE
            var MonthSch = document.getElementById('monthsch');
            if (MonthSch.style.display !== 'none') {
                var SchMonthDate = document.getElementById('Sch_Month_Date').value;
                var SchMonthDateError = document.getElementById('Sch_Month_Date-error');
                var SchMonthTime = document.getElementById('Sch_Time_Month').value;
                var SchMonthTimeError = document.getElementById('Sch_Time_Month-error');

                if (SchMonthDate == "") {
                    SchMonthDateError.style.display = "block";
                    hasErrors = true;
                } else {
                    SchMonthDateError.style.display = "none";
                }
                if (SchMonthTime == "") {
                    SchMonthTimeError.style.display = "block";
                    hasErrors = true;
                } else {
                    SchMonthTimeError.style.display = "none";
                }
            }

            if (hasErrors) {
                return false; // Return false to prevent form submission
            }

            return true; // Return true if no errors, allow form submission
        }

        // Function to clear the error message for the selected option
        function clearSelecterror(elementId) {
            var errorDiv = document.getElementById(elementId + "-error");
            errorDiv.style.display = "none";
        }


        // Function to clear the error message for the task name
        function clearTaskNameErrorMessage() {
            var taskNameErrorDiv = document.getElementById("task-name-error");
            taskNameErrorDiv.style.display = "none";
        }
    </script>
    <script>
        function clearError(errorId) {
            var errorDiv = document.getElementById(errorId);
            errorDiv.style.display = "none";
        }
    </script>

    <!-- HIDE PERIODIC AND REPEAT DROPDOWN -->
    <script>
        function updateSelectedTaskType() {
            // Get the selected value from the dropdown
            var selectedValue = document.getElementById("type").value;

            // Get the Periodic Type dropdown element
            var periodicTypeDropdown = document.querySelector('.period');
            var repeatDropdown = document.querySelector('.repeat');
            var select = document.querySelector('.select2');
            var duedate = document.querySelector('#due_date');

            // Check if the selected value is 2
            if (selectedValue === '2') {
                // Show the Periodic Type dropdown
                periodicTypeDropdown.style.display = 'block';
                repeatDropdown.style.display = 'block';
                duedate.style.display = 'none';
            } else {
                // Hide the Periodic Type dropdown
                periodicTypeDropdown.style.display = 'none';
                repeatDropdown.style.display = 'none';
                duedate.style.display = 'block';
            }
        }

        function showweek() {
            var sch = document.querySelector("#Sch_Period").value;
            var dailysch = document.querySelector("#dailysch");
            var weeksch = document.querySelector("#weeksch");
            var monthsch = document.querySelector("#monthsch");

            if (sch === '1') {
                dailysch.style.display = "block";
            } else {
                dailysch.style.display = "none";
            }

            if (sch === '2') {
                weeksch.style.display = 'block';
            } else {
                weeksch.style.display = 'none';
            }

            if (sch === '3') {
                monthsch.style.display = "block";
            } else {
                monthsch.style.display = "none";
            }
        }
    </script>

    <!-- DURATION CANNOT EXCEED TO REMAINING DURATION -->
    <script>
        var durationInput = document.getElementById("durationInput");
        var remainDuration = document.getElementById("remainDuration").value;

        durationInput.addEventListener("input", function() {
            var durationValue = parseFloat(this.value);
            var selectedOption = document.getElementById("time");
            var selectedTime = selectedOption.options[selectedOption.selectedIndex].text;

            // Function to convert remaining duration based on the selected time interval
            function adjustRemainingDuration(selectedTime, remainDuration) {
                if (selectedTime === "Minute") {
                    return remainDuration * 60; // Convert to seconds
                }
                return remainDuration;
            }

            var adjustedDuration = adjustRemainingDuration(selectedTime, remainDuration);

            if (!isNaN(durationValue) && durationValue > parseFloat(adjustedDuration)) {
                var unit = selectedTime === "Minute" ? "min" : "hr";
                alert("Duration cannot exceed Remaining duration: " + adjustedDuration + " " + unit);
                this.value = "";
            }
        });
    </script>

    <!-- NOT ALLOW " . " IN DURATION -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var durationInput = document.getElementById('durationInput');

            durationInput.addEventListener('input', function() {
                var inputValue = this.value.trim();
                var regex = /^[1-9]\d*$/; // Regular expression to match only whole numbers

                if (!regex.test(inputValue)) {
                    alert('Please enter a valid number without decimals " . "');
                    this.value = ''; // Clear the input field if input is invalid
                }
            });
        });
    </script>

    <!-- GETTING EXPECTED TIME TO START AND HOUR -->
    <script>
        function getemplno(emplno) {
            $.ajax({
                url: "{{ route('getApiResultMain') }}",
                type: "GET",
                data: {
                    emplno: emplno,
                },
                dataType: 'json',

                success: function(response) {
                    console.log(response);
                    if (response.length > 0) {
                        document.getElementById("task_pending_hours").value = response[0].Hours;
                        document.getElementById("Ex_to_start").value = response[0].Date;
                    } else {
                        document.getElementById("task_pending_hours").value = "";
                        document.getElementById("Ex_to_start").value = "";
                    }
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });


            // Now make the second API request
            $.ajax({
                url: "{{ route('getApiResultSub') }}",
                type: "GET",
                data: {
                    emplno: emplno,
                },
                dataType: 'json',

                success: function(responseSub) {
                    console.log(responseSub);
                    document.getElementById("task_pending_hours").value = responseSub[0].Hours;
                    document.getElementById("Ex_to_start").value = responseSub[0].Date;
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });
        }
    </script>

    <!-- DURATION TIME TO DECIMEL-->
    <script>
        // Get the input element
        var durationInput = document.getElementById('durationInput');

        // Add event listener for the input losing focus
        durationInput.addEventListener('blur', function() {
            // Get the entered value
            var enteredValue = parseFloat(this.value);

            // Check if the entered value is a number
            if (!isNaN(enteredValue)) {
                // Format the value as a decimal number with two decimal places
                this.value = enteredValue.toFixed(2);
            }
        });
    </script>

    <!-- SEARCH -->
    <script>
        $(document).ready(function() {
            $('.select2').select2({
                placeholder: '--Select--',
                allowClear: true, // Optional: Adds a clear button to the dropdown
                width: '100%', // Optional: Adjust the width as needed
            });
        });
    </script>

    <!-- IMAGE -->
    <script>
        function previewImage1() {
            var input = document.getElementById('prodImgInput');
            var preview = document.getElementById('preview');
            var previewContainer = document.getElementById('imagePreview');

            var file = input.files[0];

            if (file) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    preview.src = e.target.result;
                    previewContainer.style.display = 'block';
                };

                reader.readAsDataURL(file);
            } else {
                preview.src = '';
                previewContainer.style.display = null;
            }
        }
    </script>


    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('SuccessMsg'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($message = Session::get('errorMsg'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

</body>
@endsection

</html>