<!DOCTYPE html>
<html lang="en">
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <link rel="shortcut icon" type="image/x-icon" href="TMS_ass/task.png">
    <title>Time Sheet</title>

    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/css/bootstrap.min.css">
    <!-- Fontawesome CSS -->
    <link rel="stylesheet" href="hwassets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="hwassets/plugins/fontawesome/css/all.min.css">
    <!-- Feathericon CSS -->
    <link rel="stylesheet" href="hwassets/plugins/feather/feather.css">
    <!-- Select2 CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/css/select2.min.css">
    <!-- Datatables CSS -->
    <link rel="stylesheet" href="hwassets/plugins/datatables/datatables.min.css">
    <!-- Calendar CSS -->
    <link rel="stylesheet" href="hwassets/plugins/simple-calendar/simple-calendar.css">
    <!-- Datepicker CSS -->
    <link rel="stylesheet" href="hwassets/css/bootstrap-datetimepicker.min.css">
    <!-- Slick CSS -->
    <link rel="stylesheet" type="text/css" href="hwassets/plugins/slick/slick.css">
    <link rel="stylesheet" type="text/css" href="hwassets/plugins/slick/slick-theme.css">
    <link rel="stylesheet" type="text/css" href="hwassets/plugins/light-gallery/css/lightgallery.min.css">
    <!-- Summernote CSS -->
    <link rel="stylesheet" href="hwassets/plugins/summernote/summernote-bs5.min.css">
    <link rel="stylesheet" type="text/css" href="hwassets/css/fullcalendar.min.css">
    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="TMS_ass/style.css">
    <style>
        .row label {
            font-weight: bold;
            font-size: medium;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .form-heading h4 {
            font-weight: bold;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }

        .card-body .local-top {
            font-weight: bold;
            font-size: medium;
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
        }
    </style>

</head>


<body>

    <div class="main-wrapper">
        @extends('TMS.Navbar.tmsnavbar')
        @section('content')

        <div class="page-wrapper">
            <div class="content">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>TIME SHEET</h4>
                                    </div>
                                </div>
                                <form method="post" action="task_allocate1" enctype="multipart/form-data" class="has-validated" onsubmit="return validateForm()">
                                    @csrf
                                    <div class="row">
                                        <!-- TASK ID -->
                                        <div class="col-12 col-md-6 col-xl-4 d-none">
                                            <div class="form-group local-forms">
                                                <label>Task No</label>
                                                <input type="text" name="eno" value="" class="form-control" readonly>
                                            </div>
                                        </div>
                                        <!-- TASK NAME -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Task Name<span class="login-danger">*</span></label>
                                                <input name="task_name" id="task_name" class="form-control" type="text" oninput="clearTaskNameErrorMessage()" autocomplete="off">
                                                <div id="task-name-error" style="color: red; display: none;">Please enter Task Name.</div>
                                            </div>
                                        </div>
                                        <!-- FROM DATE -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>From Date<span class="login-danger">*</span></label>
                                                <input type="date" name="due_date" min="{{ date('Y-m-d') }}" class="form-control" oninput="clearError('due-error')">
                                                <div id="due-error" style="color: red; display: none;">Please Choose the From Date.</div>
                                            </div>
                                        </div>
                                        <!-- TO DATE -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>To Date<span class="login-danger">*</span></label>
                                                <input type="date" name="due_date" min="{{ date('Y-m-d') }}" class="form-control" oninput="clearError('due-error')">
                                                <div id="due-error" style="color: red; display: none;">Please Choose the To Date.</div>
                                            </div>
                                        </div>
                                        <!-- BEN DEP -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Beneficiary Dep<span class="login-danger"></span></label>
                                                <select name="ben_dep" class="form-control select2">
                                                    <option disabled selected>Select Type</option>

                                                </select>
                                            </div>
                                        </div>
                                        <!-- BEN STAFF -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-forms">
                                                <label>Beneficiary Staff<span class="login-danger"></span></label>
                                                <select name="ben_staff" class="form-control select2">
                                                    <option selected disabled>Select Type</option>

                                                </select>
                                            </div>
                                        </div>
                                        <!-- ATTACHMENT -->
                                        <div class="col-12 col-md-6 col-xl-4">
                                            <div class="form-group local-top-form">
                                                <label class="local-top">Attachment<span class="login-danger"></span></label>
                                                <div class="settings-btn upload-files-avator">
                                                    <input type="file" accept="image/*" name="image1" id="prodImgInput" class="hide-input" onchange="previewImage1()">
                                                    <label for="file" class="upload">Choose File</label>
                                                </div>
                                            </div>
                                            <div id="imagePreview" style="display:none; text-align: center;">
                                                <img id="preview" alt="Selected Image" style="max-width: 50%; height: 100px;">
                                                <br><br>
                                            </div>
                                        </div>
                                        <!-- DESC -->
                                        <div class="col-12 col-sm-12">
                                            <div class="form-group local-forms">
                                                <label>Description <span class="login-danger"></span></label>
                                                <textarea name="desc" class="form-control" rows="1" cols="30"></textarea>
                                            </div>
                                        </div>

                                        <div class="col-12">
                                            <div class="doctor-submit text-end">
                                                <button type="submit" class="btn btn-primary submit-form me-2">Submit</button>
                                            </div>
                                        </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="sidebar-overlay" data-reff=""></div>
    <!-- jQuery -->
    <script src="hwassets/js/jquery-3.7.0.min.js"></script>
    <!-- Bootstrap Core JS -->
    <script src="hwassets/js/bootstrap.bundle.min.js"></script>
    <!-- Feather Js -->
    <script src="hwassets/js/feather.min.js"></script>
    <!-- Slimscroll -->
    <script src="hwassets/js/jquery.slimscroll.js"></script>
    <!-- Select2 Js -->
    <script src="hwassets/js/select2.min.js"></script>
    <!-- Datatables JS -->
    <script src="hwassets/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="hwassets/plugins/datatables/datatables.min.js"></script>
    <!-- counterup JS -->
    <script src="hwassets/js/jquery.waypoints.js"></script>
    <script src="hwassets/js/jquery.counterup.min.js"></script>
    <!-- Apexchart JS -->
    <script src="hwassets/plugins/apexchart/apexcharts.min.js"></script>
    <script src="hwassets/plugins/apexchart/chart-data.js"></script>
    <!-- Calendar Js -->
    <script src="hwassets/plugins/simple-calendar/jquery.simple-calendar.js"></script>
    <script src="hwassets/js/calander.js"></script>
    <!-- Circle Progress JS -->
    <script src="hwassets/js/circle-progress.min.js"></script>
    <!-- Slick JS -->
    <script src="hwassets/plugins/slick/slick.js"></script>
    <!-- Datepicker Core JS -->
    <script src="hwassets/plugins/moment/moment.min.js"></script>
    <script src="hwassets/js/bootstrap-datetimepicker.min.js"></script>
    <script src="hwassets/plugins/light-gallery/js/lightgallery-all.min.js"></script>
    <!-- Summernote JS -->
    <script src="hwassets/plugins/summernote/summernote-bs5.min.js"></script>
    <!-- Ck Editor JS -->
    <script src="hwassets/js/ckeditor.js"></script>
    <!-- Full Calendar -->
    <script src="hwassets/js/jquery-ui.min.js"></script>
    <script src="hwassets/js/fullcalendar.min.js"></script>
    <script src="hwassets/js/jquery.fullcalendar.js"></script>

    <!-- REQUIRED FOR FIELD -->
    <script>
        function validateForm() {
            var selectedEmpl = document.getElementById("emplno").value;
            var selectedTType = document.getElementById("type").value;
            var selectedDue = document.getElementById("Due").value;
            var selectedTime = document.getElementById("time_int").value;
            var selectedTaskName = document.getElementById("task_name").value.trim();
            var selectedDuration = document.getElementById("durationInput").value.trim();

            var errorEmpl = document.getElementById("emplno-error");
            var errorTType = document.getElementById("task_type-error");
            var errorDue = document.getElementById("due-error");
            var errorTime = document.getElementById("time_intervel-error");
            var errorTaskName = document.getElementById("task-name-error");
            var errorDuration = document.getElementById("duration-error");

            var hasErrors = false;

            // Check if any required field is empty
            if (selectedEmpl == "") {
                errorEmpl.style.display = "block";
                hasErrors = true;
            } else {
                errorEmpl.style.display = "none";
            }

            if (selectedTType == "") {
                errorTType.style.display = "block";
                hasErrors = true;
            } else {
                errorTType.style.display = "none";
            }

            if (selectedDue == "") {
                errorDue.style.display = "block";
                hasErrors = true;
            } else {
                errorDue.style.display = "none";
            }

            if (selectedTime == "") {
                errorTime.style.display = "block";
                hasErrors = true;
            } else {
                errorTime.style.display = "none";
            }

            if (selectedTaskName === "") {
                errorTaskName.style.display = "block";
                hasErrors = true;
            } else {
                errorTaskName.style.display = "none";
            }

            if (selectedDuration === "") {
                errorDuration.style.display = "block";
                hasErrors = true;
            } else {
                errorDuration.style.display = "none";
            }

            return !hasErrors; // Return true if no errors, false if there are errors
        }


        // Function to clear the error message for the selected option
        function clearSelecterror(elementId) {
            var errorDiv = document.getElementById(elementId + "-error");
            errorDiv.style.display = "none";
        }


        // Function to clear the error message for the task name
        function clearTaskNameErrorMessage() {
            var taskNameErrorDiv = document.getElementById("task-name-error");
            taskNameErrorDiv.style.display = "none";
        }
    </script>
    <script>
        function clearError(errorId) {
            var errorDiv = document.getElementById(errorId);
            errorDiv.style.display = "none";
        }
    </script>

    <!-- SEARCH -->
    <script>
        // Initialize Select2
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <!-- IMAGE -->
    <script>
        function previewImage1() {
            var input = document.getElementById('prodImgInput');
            var preview = document.getElementById('preview');
            var previewContainer = document.getElementById('imagePreview');

            var file = input.files[0];

            if (file) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    preview.src = e.target.result;
                    previewContainer.style.display = 'block';
                };

                reader.readAsDataURL(file);
            } else {
                preview.src = '';
                previewContainer.style.display = null;
            }
        }
    </script>

    <script data-navigate-once="true">
        window.livewireScriptConfig = {
            "csrf": "hU0lkwotxPRtX77i9lZ9z8EOooahpVoehQm3a7EO",
            "uri": "\/livewire\/update",
            "progressBar": ""
        };
    </script>

    <!-- Custom JS -->
    <script src="hwassets/js/app.js"></script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('SuccessMsg'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif
    @if ($message = Session::get('errorMsg'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 5000);
    </script>
    @endif

</body>
@endsection

</html>