<!DOCTYPE html>

<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>
    <meta charset="utf-8" />
    <link rel="shortcut icon" type="image/x-icon" href="TMS_ass/task.png">
    <title>TMS Calendar</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="TMS_Assets/assets/images/tms-logo-light.png" sizes="128x128">
    <!-- gridjs css -->
    <link rel="stylesheet" href="TMS_Assets/assets/libs/gridjs/theme/mermaid.min.css">
    <!-- Layout config Js -->
    <script src="TMS_Assets/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="TMS_Assets/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="TMS_Assets/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="TMS_Assets/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="TMS_Assets/assets/css/custom.min.css" rel="stylesheet" type="text/css" />


    <style>
        .event-color-0 {
            background-color: green;
            border-color: green;
        }

        .event-color-1 {
            background-color: violet;
            border-color: violet;
        }

        .event-color-2 {
            background-color: red;
            border-color: red;
        }

        .event-color-3 {
            background-color: yellow;
            border-color: yellow;
        }

        .event-color-4 {
            background-color: pink;
            border-color: pink;
        }

        .event-color-5 {
            background-color: blue;
            border-color: blue;
        }

        .fc-event {
            cursor: default !important;
        }

        .fc-button-group .fc-dayGridMonth-button {
            display: none;
        }

        .fc-button-group .fc-timeGridWeek-button {
            display: none;
        }

        .fc-button-group .fc-timeGridDay-button {
            display: none;
        }

        .fc-button-group .fc-listMonth-button {
            display: none;
        }

        .fc-daygrid-day-top {
            pointer-events: none;
        }

        .fc-header-toolbar .fc-toolbar-chunk .fc-toolbar-title {
            padding-left: 340px;
            margin-left: 340px;
        }



        .card-body .form-group .form-control {
            /* margin-left: 250px;
            margin-bottom: -70px; */
        }
    </style>

</head>

<body>
    @extends('TMS.Navbar.tmsnavbar')
    @section('content')

    <!-- Begin page -->
    <div id="layout-wrapper">
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">

                    <div class="row">
                        <div class="col-12">
                            <div class="row">
                                <div class="col-xl-3 d-none">
                                    <div class="card-body">
                                        <div id="external-events"></div>
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="card card-h-100">
                                        <div class="card-body">

                                            <div class="col-10 col-md-10 col-xl-2" style="margin-bottom: 5px;">
                                                <form action="">
                                                    <div class="form-group local-forms">
                                                        <select class="form-control select2" name="employee" id="employee">
                                                            <option value="">--Select Employee--</option>
                                                            @php
                                                            $loginID = Session::get('empl_id');
                                                            $loginNAME = Session::get('emp_name')
                                                            @endphp
                                                            <option value="{{$loginID}}" @if(request('employee')==$loginID) selected @endif>{{$loginNAME}}</option>
                                                            @foreach ($Staff_Name as $row)
                                                            <option value="{{$row['Emplno']}}" @if(request('employee')==$row['Emplno']) selected @endif>{{$row['C_Name']}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </form>
                                            </div>

                                            <div id="calendar"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div style="clear: both"></div>

                            <!-- Add New Event MODAL -->
                            <div clas s="modal fade d-none" id="event-modal" tabindex="-1">
                                <div class="modal-dialog modal-dialog-centered">
                                    <div class="modal-content border-0">

                                        <div class="modal-body p-4">
                                            <form class="needs-validation" name="event-form" id="form-event" novalidate>

                                                <div class="event-details">
                                                    <div class="d-flex mb-2">
                                                        <div class="flex-grow-1 d-flex align-items-center">
                                                            <div class="flex-shrink-0 me-3">
                                                                <i class="ri-calendar-event-line text-muted fs-16"></i>
                                                            </div>
                                                            <div class="flex-grow-1">
                                                                <h6 class="d-block fw-semibold mb-0" id="event-start-date-tag"></h6>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-2">
                                                        <div class="flex-shrink-0 me-3">
                                                            <i class="ri-time-line text-muted fs-16"></i>
                                                        </div>
                                                        <div class="flex-grow-1">
                                                            <h6 class="d-block fw-semibold mb-0">
                                                                <span id="event-timepicker1-tag"></span> -
                                                                <span id="event-timepicker2-tag"></span>
                                                            </h6>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-2">
                                                        <div class="flex-shrink-0 me-3">
                                                            <i class="ri-map-pin-line text-muted fs-16"></i>
                                                        </div>
                                                        <div class="flex-grow-1">
                                                            <h6 class="d-block fw-semibold mb-0">
                                                                <span id="event-location-tag"></span>
                                                            </h6>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex mb-3">
                                                        <div class="flex-shrink-0 me-3">
                                                            <i class="ri-discuss-line text-muted fs-16"></i>
                                                        </div>
                                                        <div class="flex-grow-1">
                                                            <p class="d-block text-muted mb-0" id="event-description-tag"></p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row event-form d-none">
                                                    <div class="col-12">
                                                        <div class="mb-3">
                                                            <select class="form-select d-none" name="category" id="event-category" required>

                                                            </select>
                                                            <div class="invalid-feedback">
                                                                Please select a valid event category
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-12">
                                                        <div class="mb-3">
                                                            <input class="form-control d-none" placeholder="Enter event name" type="text" name="title" id="event-title" required value="" />

                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-12">
                                                        <div class="mb-3">
                                                            <div class="input-group d-none">
                                                                <input type="text" id="event-start-date" class="form-control flatpickr flatpickr-input" placeholder="Select date" readonly required />
                                                                <span class="input-group-text"><i class="ri-calendar-event-line"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-12" id="event-time">
                                                        <div class="row">
                                                            <div class="col-6">
                                                                <div class="mb-3">
                                                                    <div class="input-group d-none">
                                                                        <input id="timepicker1" type="text" class="form-control flatpickr flatpickr-input" placeholder="Select start time" readonly />
                                                                        <span class="input-group-text"><i class="ri-time-line"></i></span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-6">
                                                                <div class="mb-3">
                                                                    <div class="input-group d-none">
                                                                        <input id="timepicker2" type="text" class="form-control flatpickr flatpickr-input" placeholder="Select end time" readonly />
                                                                        <span class="input-group-text"><i class="ri-time-line"></i></span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!--end col-->
                                                </div>
                                                <!--end row-->

                                            </form>
                                        </div>
                                    </div>
                                    <!-- end modal-content-->
                                </div>
                                <!-- end modal dialog-->
                            </div>

                            <!-- end modal-->
                            <!-- end modal-->
                        </div>
                    </div>
                    <!-- end row-->
                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

        </div>
        <!-- end main content-->
    </div>

    <!--start back-to-top-->
    <button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
        <i class="ri-arrow-up-line"></i>
    </button>
    <!--end back-to-top-->

    <!--preloader-->
    <div id="preloader">
        <div id="status">
            <div class="spinner-border text-primary avatar-sm" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>

    <div class="customizer-setting d-none d-md-block">
        <div class="btn-info rounded-pill shadow-lg btn btn-icon btn-lg p-2" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
            <i class='mdi mdi-spin mdi-cog-outline fs-22'></i>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="TMS_Assets/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="TMS_Assets/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="TMS_Assets/assets/libs/node-waves/waves.min.js"></script>
    <script src="TMS_Assets/assets/libs/feather-icons/feather.min.js"></script>
    <script src="TMS_Assets/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="TMS_Assets/assets/js/plugins.js"></script>
    <!-- prismjs plugin -->
    <script src="TMS_Assets/assets/libs/prismjs/prism.js"></script>
    <!-- gridjs js -->
    <script src="TMS_Assets/assets/libs/gridjs/gridjs.umd.js"></script>
    <!-- gridjs init -->
    <script src="TMS_Assets/assets/js/pages/gridjs.init.js"></script>
    <!-- App js -->
    <script src="TMS_Assets/assets/js/app.js"></script>


    <!-- calendar min js -->
    <script src="TMS_Assets/assets/libs/fullcalendar/index.global.min.js"></script>
    <!-- Calendar init -->
    <script src="TMS_Assets/assets/js/pages/calendar.init.js"></script>
    <script src="TMS_Assets/assets/js/pages/flatpickr.min.js"></script>
    <script src="TMS_Assets/assets/js/pages/choice.min.js"></script>


    <!-- DETAILS IN CALENDAR AND COLOR -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            flatPickrInit();

            let calendarDtl = @json($events);
            console.log(calendarDtl);
            let array = [];


            // Define an array of colors
            const colors = ["red", "blue", "green", "orange", "purple", "cyan", "magenta", "yellow"];

            for (let j = 0; j < calendarDtl.length; j++) {
                // Get the Task_Name for the current event
                const Task_Name = calendarDtl[j]["Task_Name"];
                const Duration = calendarDtl[j]["Duration"];

                // Assign a class name based on the index of the event in the calendarDtl array
                const className = "event-color-" + (j % colors.length);

                const rowid = "";
                const Name = "test";
                const description = "test";
                const Tms_calendarName = "test";

                const eventDateTime = calendarDtl[j]["Entry_Date"];
                var eventDate1 = eventDateTime.split(' ')[0];
                const eventDateTime1 = calendarDtl[j]["Due_date"];
                var endeventDates = eventDateTime1.split(' ')[0];
                // console.log(eventDate2);


                const dateParts = eventDate1.split('-');
                const eventDate = new Date(dateParts[2], dateParts[1] - 1, dateParts[0]);

                const dateParts1 = endeventDates.split('-');
                console.log(dateParts1);
                const eventDate2 = new Date(dateParts1[2], dateParts1[1] - 1, dateParts1[0]);
                // eventDate2.setDate(eventDate2.getDate() + 1);
                const months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
                    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
                ];

                const formattedDate = months[eventDate.getMonth()] + " " +
                    eventDate.getDate() + " " +
                    eventDate.getFullYear();
                // console.log(formattedDate);

                ;

                const eventName = calendarDtl[j]["eventName"] || "";
                const location = calendarDtl[j]["location"] || "";
                const tno = calendarDtl[j]["tno"] || "";
                const type = calendarDtl[j]["type"] || "";

                // Adjust the event object creation to create separate events for each day
                for (let currentDate = new Date(eventDate); currentDate <= eventDate2; currentDate.setDate(currentDate.getDate() + 1)) {
                    array.push({
                        id: rowid,
                        title: [Task_Name],
                        start: new Date(currentDate), // Create a new date object for each day
                        end: new Date(currentDate), // Create a new date object for each day
                        allDay: true,
                        className: className, // Assign the class name here
                        location: location,
                        extendedProps: {
                            department: eventName
                        },
                        description: description,
                        sTime: "",
                        eTime: "",
                        Tms_calendarName: Tms_calendarName,
                    });
                }


                var g = new bootstrap.Modal(document.getElementById("event-modal"), {
                        keyboard: !1,
                    }),


                    i =
                    (document.getElementById("event-modal"),
                        document.getElementById("modal-title")),
                    l = document.getElementById("form-event"),
                    v = null,
                    p = document.getElementsByClassName("needs-validation"),
                    e = new Date(),
                    t = e.getDate(),
                    n = e.getMonth(),
                    e = e.getFullYear(),
                    a = FullCalendar.Draggable,
                    d = document.getElementById("external-events"),

                    y = array;


                e =
                    (
                        new a(d, {
                            itemSelector: ".external-event",
                            eventData: function(e) {
                                return {
                                    id: Math.floor(11e3 * Math.random()),
                                    title: e.innerText,
                                    allDay: !0,
                                    start: new Date(),
                                    className: e.getAttribute("data-class"),
                                };
                            },
                        }),
                        document.getElementById("calendar"));

                // console.log(y);

            }


            if (calendarDtl.length == 0) {

                var g = new bootstrap.Modal(document.getElementById("event-modal"), {
                        keyboard: !1,
                    }),


                    i =
                    (document.getElementById("event-modal"),
                        document.getElementById("modal-title")),
                    l = document.getElementById("form-event"),
                    v = null,
                    p = document.getElementsByClassName("needs-validation"),
                    e = new Date(),
                    t = e.getDate(),
                    n = e.getMonth(),
                    e = e.getFullYear(),
                    a = FullCalendar.Draggable,
                    d = document.getElementById("external-events"),

                    y = [{
                        id: "",
                        title: "",
                        start: "",
                        end: "",
                        className: "",
                        location: "",
                        allDay: !0,
                        extendedProps: {
                            department: ""
                        },
                        description: "",
                        sTime: "",
                        eTime: "",
                        Tms_calendarName: "",
                    }, ];

                e =
                    (new a(d, {
                            itemSelector: ".external-event",
                            eventData: function(e) {
                                return {
                                    id: Math.floor(11e3 * Math.random()),
                                    title: e.innerText,
                                    allDay: !0,
                                    start: new Date(),
                                    className: e.getAttribute("data-class"),
                                };
                            },
                        }),
                        document.getElementById("calendar"));

            }

            function o(e) {
                document.getElementById("form-event").reset(),
                    document
                    .getElementById("btn-delete-event")
                    .setAttribute("hidden", !0),
                    g.show(),
                    l.classList.remove("was-validated"),
                    l.reset(),
                    (v = null),
                    (i.innerText = "Add Event"),
                    (newEventData = e),
                    document
                    .getElementById("edit-event-btn")
                    .setAttribute("data-id", "new-event"),
                    document.getElementById("edit-event-btn").click(),
                    document.getElementById("edit-event-btn").setAttribute("hidden", !0);
            }

            function r() {
                return 768 <= window.innerWidth && window.innerWidth < 1200 ?
                    "timeGridWeek" :
                    window.innerWidth <= 768 ?
                    "listMonth" :
                    "dayGridMonth";
            }


            var c = new Choices("#event-category", {
                    searchEnabled: !1
                }),
                b = new FullCalendar.Calendar(e, {
                    timeZone: "local",
                    editable: false,
                    droppable: !0,
                    selectable: false,
                    navLinks: !0,
                    initialView: r(),
                    themeSystem: "bootstrap",
                    headerToolbar: {
                        left: "prev,next today",
                        center: "title",
                        right: "dayGridMonth,timeGridWeek,timeGridDay,listMonth",
                    },
                    windowResize: function(e) {
                        var t = r();
                        b.changeView(t);
                    },
                    eventResize: function(t) {
                        var e = y.findIndex(function(e) {
                            return e.id == t.event.id;
                        });
                        y[e] &&
                            ((y[e].title = t.event.title),
                                (y[e].start = t.event.start),

                                (y[e].end = t.event.end || null),
                                (y[e].allDay = t.event.allDay),
                                (y[e].className = t.event.classNames[0]),
                                (y[e].description =
                                    t.event._def.extendedProps.description || ""),
                                (y[e].location =
                                    t.event._def.extendedProps.location || ""),
                                (y[e].eTime =
                                    t.event._def.extendedProps.eTime || ""),
                                (y[e].Tms_calendarName =
                                    t.event._def.extendedProps.Tms_calendarName || ""),
                                (y[e].sTime =
                                    t.event._def.extendedProps.sTime || ""));
                        // upcomingEvent(y);

                    },
                    eventClick: function(e) {
                        document
                            .getElementById("edit-event-btn")
                            .removeAttribute("hidden"),
                            document
                            .getElementById("btn-save-event")
                            .setAttribute("hidden", !0),
                            document
                            .getElementById("edit-event-btn")
                            .setAttribute("data-id", "edit-event"),
                            (document.getElementById("edit-event-btn").innerHTML =
                                "Edit"),
                            eventClicked(),
                            flatPickrInit(),
                            flatpicekrValueClear(),
                            g.show(),
                            l.reset(),
                            (v = e.event),
                            (document.getElementById("modal-title").innerHTML = ""),
                            (document.getElementById("event-location-tag").innerHTML =
                                void 0 === v.extendedProps.location ?
                                "No Location" :
                                v.extendedProps.location),
                            (document.getElementById(
                                    "event-description-tag"
                                ).innerHTML =
                                void 0 === v.extendedProps.description ?
                                "No Description" :
                                v.extendedProps.description),

                            (document.getElementById("event-timepicker1-tag").innerHTML = void 0 === v.extendedProps.sTime ?
                                "00 : 00" : v.extendedProps.sTime),

                            (document.getElementById("event-timepicker2-tag").innerHTML = void 0 === v.extendedProps.eTime ?
                                "00 : 00" : v.extendedProps.eTime),

                            (document.getElementById("appliName").innerHTML = void 0 === v.extendedProps.Tms_calendarName ?
                                "" : v.extendedProps.Tms_calendarName),

                            (document.getElementById("event-title").value = v.title),
                            (document.getElementById("event-location").value =
                                void 0 === v.extendedProps.location ?
                                "No Location" :
                                v.extendedProps.location),
                            (document.getElementById("event-description").value =
                                void 0 === v.extendedProps.description ?
                                "No Description" :
                                v.extendedProps.description),
                            (document.getElementById("eventid").value = v.id),
                            v.classNames[0] &&
                            (c.destroy(),
                                (c = new Choices("#event-category", {
                                    searchEnabled: !1,
                                })).setChoiceByValue(v.classNames[0]));


                        function t(e) {
                            var t = "" + ((e = new Date(e)).getMonth() + 1),
                                n = "" + e.getDate();
                            return [
                                e.getFullYear(),
                                (t = t.length < 2 ? "0" + t : t),
                                (n = n.length < 2 ? "0" + n : n),
                            ].join("-");
                        }
                        var e = v.start,
                            n = v.end,
                            a = null,
                            d =
                            (null != n &&
                                (a = (d = new Date(n)).setDate(d.getDate() - 1)),
                                null == n ? str_dt(e) : str_dt(e) + " to " + str_dt(a)),
                            n = null == n ? t(e) : t(e) + " to " + t(a),
                            e =
                            (flatpickr(start_date, {
                                    defaultDate: n,
                                    altInput: !0,
                                    altFormat: "j F Y",
                                    dateFormat: "Y-m-d",
                                    mode: "single",
                                    onChange: function(e, t, n) {
                                        1 < t.split("to").length ?
                                            document
                                            .getElementById("event-time")
                                            .setAttribute("hidden", !0) :
                                            (document
                                                .getElementById("timepicker1")
                                                .parentNode.classList.remove(
                                                    "d-none"
                                                ),
                                                document
                                                .getElementById("timepicker1")
                                                .classList.replace(
                                                    "d-none",
                                                    "d-block"
                                                ),
                                                document
                                                .getElementById("timepicker2")
                                                .parentNode.classList.remove(
                                                    "d-none"
                                                ),
                                                document
                                                .getElementById("timepicker2")
                                                .classList.replace(
                                                    "d-none",
                                                    "d-block"
                                                ),
                                                document
                                                .getElementById("event-time")
                                                .removeAttribute("hidden"));
                                    },
                                }),
                                (document.getElementById("event-start-date-tag").innerHTML = d));
                        e == a ?
                            (document.getElementById("event-time")
                                .setAttribute("hidden", !0),
                                flatpickr(document.getElementById("timepicker1"), {
                                    enableTime: !0,
                                    noCalendar: !0,
                                    dateFormat: "H:i",
                                }),
                                flatpickr(document.getElementById("timepicker2"), {
                                    enableTime: !0,
                                    noCalendar: !0,
                                    dateFormat: "H:i",
                                })) :
                            (document.getElementById("event-time")
                                .removeAttribute("hidden"),
                                flatpickr(document.getElementById("timepicker1"), {
                                    enableTime: !0,
                                    noCalendar: !0,
                                    dateFormat: "H:i",
                                    defaultDate: e,
                                }),
                                flatpickr(document.getElementById("timepicker2"), {
                                    enableTime: !0,
                                    noCalendar: !0,
                                    dateFormat: "H:i",
                                    defaultDate: a,
                                })

                            ),
                            (newEventData = null),
                            (i.innerText = v.title),
                            document
                            .getElementById("btn-delete-event")
                            .removeAttribute("hidden");
                    },
                    dateClick: function(e) {
                        o(e);
                    },
                    events: y,
                    eventReceive: function(e) {
                        e = {
                            id: parseInt(e.event.id),
                            title: e.event.title,
                            start: e.event.start,
                            allDay: e.event.allDay,
                            className: e.event.classNames[0],
                        };
                        y.push(e);
                        // upcomingEvent(y);
                    },
                    eventDrop: function(t) {
                        var e = y.findIndex(function(e) {
                            return e.id == t.event.id;
                        });
                        y[e] &&
                            ((y[e].title = t.event.title),
                                (y[e].start = t.event.start),
                                (y[e].end = t.event.end || null),
                                (y[e].allDay = t.event.allDay),
                                (y[e].className = t.event.classNames[0]),
                                (y[e].description =
                                    t.event._def.extendedProps.description || ""),
                                (y[e].location =
                                    t.event._def.extendedProps.location || ""));
                        // upcomingEvent(y);
                    },
                });
            b.render(),
                // upcomingEvent(y),
                l.addEventListener("submit", function(e) {
                    e.preventDefault();
                    var t,
                        n,
                        e = document.getElementById("event-title").value,
                        a = document.getElementById("event-category").value,
                        d = document.getElementById("event-start-date").value.split("to"),
                        i = new Date(d[0].trim()),
                        l = new Date(d[1]),
                        l = (l.setDate(l.getDate() + 1), d[1] ? l : ""),
                        o = null,
                        r = document.getElementById("event-location").value,
                        c = document.getElementById("event-description").value,
                        s = document.getElementById("eventid").value,
                        m = !1,
                        u =
                        (1 < d.length ?
                            ((o = new Date(d[1])).setDate(o.getDate() + 1),
                                (d = new Date(d[0])),
                                (m = !0)) :
                            ((t = d),
                                (u = document
                                    .getElementById("timepicker1")
                                    .value.trim()),
                                (n = document
                                    .getElementById("timepicker2")
                                    .value.trim()),
                                (d = new Date(d + "T" + u)),
                                (o = new Date(t + "T" + n))),
                            y.length + 1);
                    !1 === p[0].checkValidity() ?
                        p[0].classList.add("was-validated") :
                        (v ?
                            (v.setProp("id", s),
                                v.setProp("title", e),
                                v.setProp("classNames", [a]),
                                v.setStart(i),
                                v.setEnd(l),
                                v.setAllDay(m),
                                v.setExtendedProp("description", c),
                                v.setExtendedProp("location", r),
                                (t = y.findIndex(function(e) {
                                    return e.id == v.id;
                                })),
                                y[t] &&
                                ((y[t].title = e),
                                    (y[t].start = i),
                                    (y[t].end = l),
                                    (y[t].allDay = m),
                                    (y[t].className = a),
                                    (y[t].description = c),
                                    (y[t].location = r)),
                                b.render()) :
                            (b.addEvent(
                                    (n = {
                                        id: u,
                                        title: e,
                                        start: d,
                                        end: o,
                                        allDay: m,
                                        className: a,
                                        description: c,
                                        location: r,
                                    })
                                ),
                                y.push(n)),
                            g.hide()
                            // upcomingEvent(y)
                        );
                });


        });
        var str_dt = function(e) {
            var e = new Date(e),
                t =
                "" + [
                    "January",
                    "February",
                    "March",
                    "April",
                    "May",
                    "June",
                    "July",
                    "August",
                    "September",
                    "October",
                    "November",
                    "December",
                ][e.getMonth()],
                n = "" + e.getDate(),
                e = e.getFullYear();
            return (
                t.length < 2 && (t = "0" + t),
                [(n = n.length < 2 ? "0" + n : n) + " " + t, e].join(",")
            );
        };
    </script>

    <!-- SUBMIT THE EMPLOYEE NAME -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var selectEmployee = document.getElementById('employee');
            selectEmployee.addEventListener('change', function() {
                this.form.submit();
            });
        });
    </script>

    <!-- Custom JS -->
    <script src="hwassets/js/app.js"></script>

    
</body>
@endsection

</html>