<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Pie Chart Example</title>
  <!-- Include Chart.js -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
  <canvas id="myPieChart" width="400" height="400"></canvas>

  <script>
    // Data for the pie chart
    var data = {
      labels: ["Red", "Blue", "Yellow", "Green", "Purple", "Orange"],
      datasets: [{
        data: [12, 19, 3, 5, 2, 3],
        backgroundColor: [
          'red',
          'blue',
          'yellow',
          'green',
          'purple',
          'orange'
        ],
        borderColor: 'rgba(255, 255, 255, 0.7)',
        borderWidth: 1
      }]
    };

    // Configuration options
    var options = {
      responsive: true,
      maintainAspectRatio: false,
      title: {
        display: true,
        text: 'My Pie Chart'
      }
    };

    // Get the context of the canvas element we want to select
    var ctx = document.getElementById("myPieChart").getContext('2d');

    // Create the pie chart
    var myPieChart = new Chart(ctx, {
      type: 'pie',
      data: data,
      options: options
    });
  </script>

  
</body>
</html>
