<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0" />
  <meta name="description" content="VMS - Vehicle Management System" />
  <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, management, minimal, modern,  html5, responsive" />
  <title>VMS</title>
  <!-- <link rel="icon" href="gplogofinal.png" type="png"> -->

  <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png" />

  <link rel="stylesheet" href="assets/css/bootstrap.min.css" />

  <link rel="stylesheet" href="assets/css/animate.css" />

  <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css" />

  <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css" />
  <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css" />

  <link rel="stylesheet" href="assets/css/style.css" />

  <!-- Add this in the head section of your HTML file -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


</head>

<body>
  <div id="global-loader">
    <div class="whirly-loader"></div>
  </div>

  <div class="main-wrapper">
    @extends('VMS.navbar')
    @section('content')
    <div class="page-wrapper">
      <div class="content">
        <div class="row">

          <!-- -- TOTAL PURCHASE AMOUNT --- -->
          <div class="col-lg-3 col-sm-6 col-12">
            <div class="dash-widget">
              <div class="dash-widgetimg">
                <span><img src="assets/img/icons/pur_img.png" alt="img" /></span>
              </div>
              <div class="dash-widgetcontent">
                <h5>
                  &#8377;
                  <span id="po_amt_span" data-count=""></span>
                </h5>
                <a href="purchaseReport">
                <h6>Total Purchase Amount</h6>
                </a>
               
              </div>
            </div>
          </div>

          <!-- -- TOTAL GRN AMOUNT --- -->
          <div class="col-lg-3 col-sm-6 col-12">
            <div class="dash-widget dash1">
              <div class="dash-widgetimg">
                <span><img src="assets/img/icons/grn_img.jpg" alt="img" /></span>
              </div>
              <div class="dash-widgetcontent">
                <h5>
                  &#8377;<span id="grn_amt_span" data-count=""></span>
                </h5>
                <a href="GrnReport">
                <h6>Total GRN Amount </h6>
                </a>
              </div>
            </div>
          </div>

          <!-- -- TOTAL INVOICE AMOUNT --- -->
          <div class="col-lg-3 col-sm-6 col-12">
            <div class="dash-widget dash2">
              <div class="dash-widgetimg">
                <span><img src="assets/img/icons/inv2_img.png" alt="img" /></span>
              </div>
              <div class="dash-widgetcontent">
                <h5>
                  &#8377;<span id="inv_amt_span" data-count=""></span>
                </h5>
                <a href="invReport">
                <h6>Total Invoice Amount </h6>
                </a>
              </div>
            </div>
          </div>

          <!-- -- TOTAL OUTSIDE SERVICE AMOUNT --- -->
          <div class="col-lg-3 col-sm-6 col-12">
            <div class="dash-widget dash3">
              <div class="dash-widgetimg">
                <span><img src="assets/img/icons/out_img.png" alt="img" /></span>
              </div>
              <div class="dash-widgetcontent">
                <h5>
                  &#8377;<span id="out_amt_span" data-count=""></span>
                </h5>
                <a href="VMS_out_rep">
                <h6>Total Outside Service Amt</h6>
                </a>
              </div>
            </div>
          </div>
          
          <!-- -- COMPANY  VEHICLE --- -->
          <div class="col-lg-3 col-sm-6 col-12 d-flex">
            <div class="dash-count">
              <div class="dash-counts">
                @foreach ($response as $veh => $row)

                @if ($row['Vehicle_type'] == "COMPANY VEHICLE")

                <h4>{{$row ['Vehicle_no'] }}</h4>

                @endif
                @endforeach
                <h5>COMPANY VEHICLE</h5>
              </div>
              <div class="dash-imgs">
                <i data-feather="truck"></i>
              </div>
            </div>
          </div>

          <!-- -- CONTRACT  VEHICLE --- -->
          <div class="col-lg-3 col-sm-6 col-12 d-flex">
            <div class="dash-count das1">
              <div class="dash-counts">
                @foreach ($response as $veh => $row)

                @if ($row['Vehicle_type'] == "CONTRACT VEHICLE")

                <h4>{{$row ['Vehicle_no'] }}</h4>

                @endif
                @endforeach
                <h5>CONTRACT VEHICLE</h5>
              </div>
              <div class="dash-imgs">
                <i data-feather="users"></i>
              </div>
            </div>
          </div>

          <!-- --OLD VEHICLE --- -->
          <div class="col-lg-3 col-sm-6 col-12 d-flex">
            <div class="dash-count das2">
              <div class="dash-counts">
                @foreach ($response as $veh => $row)

                @if ($row['Vehicle_type'] == "OLD VEHICLE")

                <h4>{{$row ['Vehicle_no'] }}</h4>

                @endif
                @endforeach
                <h5>OLD VEHICLE</h5>
              </div>
              <div class="dash-imgs">

                <i data-feather="file-text"></i>
              </div>
            </div>
          </div>

          <!-- --TOTAL VEHICLE --- -->
          <div class="col-lg-3 col-sm-6 col-12 d-flex">
            <div class="dash-count das3">
              <div class="dash-counts">
                @foreach ($response as $veh => $row)

                @if ($row['Vehicle_type'] == "Total")

                <h4>{{$row ['Vehicle_no'] }}</h4>

                @endif
                @endforeach
                <h5>TOTAL VEHICLE</h5>
              </div>
              <div class="dash-imgs">
                <i data-feather="file"></i>
              </div>
            </div>
          </div>

          <!-- -- MONTH  --- -->
          <div class="col-lg-3 col-sm-6 col-12">
            <div class="dash-widget dash1">
              <div class="dash-widgetimg">
                
              </div>
              <h3 style="font-weight: bold; font-size: 20px;">Month</h3>
              <div class="dash-widgetcontent">

                <!-- Date input field -->
                <input type="date" name="fdate" id="fdate" class="form-control btn-sm mb-1 from_date" value="{{ date('Y-m-01') }}" style="display: none;">
                <input type="date" name="tdate" id="tdate" class="form-control btn-sm mb-1 to_date" value="{{date('Y-m-d') }}" onchange="updateFromDate()">

              </div>
            </div>
          </div>


        </div>

        <div class="row">
          <div class="col-lg-7 col-sm-12 col-12 d-flex">
            <div class="card flex-fill">
              <div class="card-header pb-0 d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">GRN & ISSUE </h5>
                <div class="graph-sets">
                  <ul>
                    <li>
                      <span>GRN</span>
                    </li>
                    <li>
                      <span>ISSUE</span>
                    </li>
                  </ul>

                </div>
                <!-- Other header content -->
              </div>
              <div class="card-body">
                <div id="po_grn"></div>
              </div>
            </div>
          </div>

        <!-- -- RECENTLY ADDED PRODUCTS  --- -->
        <div class="col-lg-5 col-sm-12 col-12 d-flex">
          <div class="card flex-fill">
            <div class="card-header pb-0 d-flex justify-content-between align-items-center">
              <h4 class="card-title mb-0">Recently Added Products</h4>
              <div class="dropdown">
                <a href="javascript:void(0);" data-bs-toggle="dropdown" aria-expanded="false" class="dropset">
                  <i class="fa fa-ellipsis-v"></i>
                </a>
                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                  <li>
                    <a href="ProductList_Report" class="dropdown-item">Product List</a>
                  </li>
                  <li>
                    <a href="ProductList" class="dropdown-item">Product Add</a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-body">
              <div class="table-responsive dataview">
                <table class="table datatable">
                  <thead>
                    <tr>
                      <th>Sno</th>
                      <th>Products</th>
                      <th>Price</th>
                    </tr>
                  </thead>

                  <tbody>
                    @foreach($result as $index => $row)
                    <tr>
                      <td>{{ $index + 1 }}</td>
                      <td class="productimgname">

                        <a href="ProductList_Report">{{ $row ['Product_Name'] }}</a>
                      </td>
                      <td>{{ $row['Price'] }}</td>
                    </tr>

                    @endforeach
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="card mb-0">
        <div class="card-body">
          <h4 class="card-title">Stock Report</h4>
          <div class="table-responsive dataview">
            <table class="table datatable">
              <thead>
                <tr>
                  <th>SNo</th>
                  <th>Product Name</th>
                  <th>Open Quantity</th>
                  <th>GRN Quantity</th>
                  <th>Issue Quantity</th>
                  <th>Close Quantity</th>

                </tr>
              </thead>
              <tbody>
                @foreach($response3 as $index => $row)
                <tr>
                  <td>{{ $index + 1 }}</td>
                  <td>
                    <a href="VMS_stock_rep">{{ $row ['Product_Name'] }}</a>
                  </td>
                  <td>{{ $row['Open_qty'] }}</td>
                  <td>{{ $row['GRN_qty'] }}</td>
                  <td>{{ $row['Iss_qty'] }}</td>
                  <td>{{ $row['Close_qty'] }}</td>
                </tr>

                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
  </div>


 
  <!-- TO_DATE / FROM_DATE DATE ADAPTIVE -->

  <script>
    function updateFromDate() {
      var toDate = document.getElementsByClassName("to_date")[0].value;
      var fromDate = toDate.substring(0, toDate.lastIndexOf("-")) + "-01";
      document.getElementsByClassName("from_date")[0].value = fromDate;
    }
  </script>



  <script src="assets/js/jquery-3.6.0.min.js"></script>

  <script src="assets/js/feather.min.js"></script>

  <script src="assets/js/jquery.slimscroll.min.js"></script>

  <script src="assets/js/jquery.dataTables.min.js"></script>
  <script src="assets/js/dataTables.bootstrap4.min.js"></script>

  <script src="assets/js/bootstrap.bundle.min.js"></script>

  <script src="assets/plugins/apexchart/apexcharts.min.js"></script>
  <script src="assets/plugins/apexchart/chart-data.js"></script>

  <script src="assets/js/script.js"></script>



  <!-- ---AJAX METHOD ---- -->
  <script>
    $(document).ready(function() {
      // Call fetchData when the page loads with initial dates
      fetchData($('#fdate').val(), $('#tdate').val());
     
      // Attach the change event to date inputs
      $('.from_date, .to_date').on('change', function() {
        // Call the fetchData function when the date is changed
        fetchData();
      });
    });

    function fetchData(from_date, to_date) {
      // Use default values if not provided
      from_date = from_date || $('#fdate').val();
      to_date = to_date || $('#tdate').val();
      console.log(to_date);

      $.ajax({
        url: "{{ route('dash_po_rep') }}",
        type: "GET",
        data: {
          from_date: from_date,
          to_date: to_date,
        },
        dataType: 'json',
        success: function(details) {
          console.log(details);
          if (details && details.length > 0) {
            var po_amt = details[0].PO_amt;
            var grn_amt = details[0].grn_amt;
            var inv_amt = details[0].inv_amt;
            var Outside_amt = details[0].Outside_amt;

            // Update the content of the span with id 'po_amt_span'
            $('#po_amt_span').text(po_amt);
            $('#grn_amt_span').text(grn_amt);
            $('#inv_amt_span').text(inv_amt);
            $('#out_amt_span').text(Outside_amt);

          } else {


          }
        }
      });
    }
  </script>


<script>
    var salesData = @json($chartData);
  console.log(salesData);
    if ($('#po_grn').length > 0) {
        var options = {
            series: [
              { name: 'GRN', data: salesData.map(item => item.grn_amt) },
                { name: 'ISSUE', data: salesData.map(item => -item.iss_amt) }
            ],
            colors: ['#38a9d6', '#4038d6'],
            chart: {
                type: 'bar',
                height: 300,
                stacked: true,
                zoom: { enabled: true }
            },
            // Other options remain unchanged
            xaxis: {
                categories: salesData.map(item => item.Month)
            },
            legend: {
            position: 'right',
            offsetY: 40
        },
        fill: { opacity: 1 }
        };

        var chart = new ApexCharts(document.querySelector("#po_grn"), options);
        chart.render();
    }
</script>



  @endsection
</body>

</html>