<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="VMS - Vehicle Management System">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">

    <title>GRN</title>
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">

    <link rel="stylesheet" href="assets/css/animate.css">

    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/selectize.css">

    <style>
        #newRowTemplate td {
            width: 1.5%;
            padding: 8px;

        }

        #newRowTemplate .custom-form-group {
            margin-bottom: 0;
        }

        #newRowTemplate input {
            width: 10%;
        }

        #newRowTemplate select {
            width: 100%;
        }

        td .selectize-input {
            width: 180px !important;
            /* Adjust the width as needed */
            max-width: 90% !important;
            height: 28px !important;
            margin-right: -50px !important;
        }
    </style>
</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">
        @extends('VMS.navbar')
        @section('content')
        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4> GRN Entry </h4>
                        <!-- <h6>Add Purchase</h6> -->
                    </div>
                </div>
                <form action="grnSave" method="post" id="addGrnForm">
                    @csrf
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>GRN No</label>
                                        <input type="text" value="{{ $grnno['GRNNo'] }}" name="GRNNO" readonly>

                                    </div>

                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>GRN Date </label>
                                        <div class="input-groupicon">
                                            <input type="text" name="GrnDate" placeholder="DD-MM-YYYY" class="datetimepicker" id="grnDate" readonly>
                                            <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-xl-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Supplier Name</label>
                                        <div class="row">
                                            <div class="col-lg-12 col-sm-12 col-12">
                                                <select class="" placeholder="--SELECT--" id="Ledger" required onchange="disableSelect(this)">
                                                    <option value="">--SELECT--</option>
                                                    @foreach($decode2 as $decodes3)
                                                    <option value="{{ $decodes3['Ledger_Code'] }}">{{ $decodes3['Ledger_Name'] }}</option>
                                                    @endforeach
                                                </select>
                                                <input type="hidden" name="ledger_code" id="hiddenLedger">
                                            </div>
                                            <!-- <div class="col-lg-2 col-sm-2 col-2 ps-0">
                                            <div class="add-icon">
                                                <a href="javascript:void(0);"><img src="assets/img/icons/plus1.svg" alt="img"></a>
                                            </div>
                                        </div> -->
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Division</label>
                                        <!-- <input type="text" value="" name="gatePassNo" readonly> -->
                                        <select class="" id="division" name="division" required>
                                            <option value="">--SELECT--</option>
                                            @foreach($decode5 as $decode5s)
                                            <option value="{{ $decode5s['Store_DivCode'] }}">{{ $decode5s['DIVISION'] }}</option>
                                            @endforeach

                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>GatePass No</label>
                                        <!-- <input type="text" value="" name="gatePassNo" readonly> -->
                                        <select class="" placeholder="--SELECT--" id="gatePassNo" name="gatePassNo" required onchange="grnGp(this)">

                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>GatePass Date </label>
                                        <div class="input-groupicon">
                                            <input type="text" name="gatePassDate" class="datetimepicker " value="" id="gpDateInput" readonly>
                                            <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Invoice No</label>
                                        <input type="text" value="" name="inwardno" class="invNo" id="invNo" readonly>

                                    </div>
                                </div>
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Reference No.</label>
                                        <input type="text" value="" name="referenceNo" required>
                                    </div>
                                </div> -->

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Invoice Date </label>
                                        <div class="input-groupicon">
                                            <input type="text" name="inwardDate" placeholder="DD-MM-YYYY" class="datetimepicker" id="inwardDate" readonly>

                                            <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- <div class="col-lg-4 col-sm-6 col-10">
                                    <div class="form-group">
                                        <label>Search Product. </label>
                                        <div class="input-groupicon">
                                            
                                            <input type="text" placeholder="Search Data..." id="searchBox">
                                        </div>
                                        <div class="addonset">

                                        </div>
                                    </div>
                                </div> -->

                                <div class="col-lg-2  col-sm-6 col-10 mb-1">
                                    <!-- <label>Add GRN</label> -->
                                    <!-- <div class="add-icon mt-2">
                                        <a href="javascript:void(0);" id="addRowBtn"><img src="assets/img/icons/plus1.svg" alt="img"></a>

                                    </div> -->
                                </div>

                                <!-- <div class="col-lg-2 col-sm-2 col-2 ps-0">
                                <div class="add-icon">
                                    <a href="javascript:void(0);"><img src="assets/img/icons/plus1.svg" alt="img"></a>
                                </div>
                            </div> -->

                            </div>
                            <div class="row">
                                <div class="table-responsive">
                                    <table class="table" id="table">
                                        <thead>
                                            <tr>
                                                <th>Po No</th>
                                                <th>Items</th>
                                                <th>Quantity</th>
                                                <th>Price(₹) </th>
                                                <th>Disc </th>
                                                <!-- <th>Disc Cost </th> -->
                                                <!-- <th>Gross Cost </th> -->
                                                <th>Tax %</th>
                                                <!-- <th>Tax Amount</th> -->
                                                <th>Total Cost </th>
                                                <th>Delete</th>
                                            </tr>
                                        </thead>
                                        <tbody>


                                            <tr id="newRowTemplate">

                                                <td class="" style="display: none;">
                                                    <input type="hidden" value="" class="sno" name="sno[]">
                                                </td>

                                                <td class="" style="display: none;"></td>

                                                <td>
                                                    <!-- Second Select (PONumber) -->
                                                    <select name="PONumber[]" id="poNumber" class="poNumber mt-1" onchange="updatePrice(this)">
                                                        <option value="">--select--</option>
                                                        @foreach($decode2 as $decodes4)
                                                        <option data-ledger-code="{{ $decodes4['Ledger_Code'] }}" value="{{ $decodes4['Rowid'] }}|{{$decodes4['Product_Name']}}|{{ $decodes4['Qty'] }}|{{ $decodes4['product_price'] }}|{{ $decodes4['Disc_Per'] }}|{{ $decodes4['Tax_Per'] }}|{{ $decodes4['Net_Amt'] }}|{{ $decodes4['Prod_Id'] }}">
                                                            {{ $decodes4['PONO'] }} / {{ $decodes4['Product_Name'] }} / {{ $decodes4['Qty'] }}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                </td>

                                                <td class="item-input">

                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style="height: 30px !important; width:70px;" value="" class="qty-input" name="quantity[]" oninput="validateQuantity(this)">
                                                </td>

                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="" class=" purchase-input" name="productPrice[]" readonly>


                                                </td>
                                                <!-- <td id="grandCost" class="grandCost" style="display: none;">

                                                </td> -->
                                                <td style="display: none;">
                                                    <input type="hidden" name="grandCost[]" class="grandCost">
                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="" class="discount-input" name="dicount[]" readonly>
                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="discountCost[]" class="discountCost">

                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="GrossCost[]" class="GrossCost">

                                                </td>

                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="" class="tax-input" name="tax[]" readonly>
                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="taxCost[]" class="taxCost">

                                                </td>
                                                <td class="totalCost">0.00</td>
                                                <td style="display: none;">
                                                    <input type="hidden" name="totalCost[]" class="totalCost-input">

                                                </td>
                                                <td>
                                                    <a class="" onclick="deleteRow(this.closest('tr'))"><img src="assets/img/icons/delete.svg" alt="svg"></a>
                                                </td>
                                            </tr>



                                            @if ($message = Session::get('SuccessMsg'))
                                            <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                                                {{$message}}

                                            </div>

                                            <script>
                                                // Automatically close the alert after 3 seconds
                                                setTimeout(function() {
                                                    var successAlert = document.getElementById('successAlert');
                                                    if (successAlert) {
                                                        successAlert.remove();
                                                    }
                                                }, 3000);
                                            </script>
                                            @endif
                                            @if ($message = Session::get('errorMsg'))
                                            <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                                                {{$message}}

                                            </div>

                                            <script>
                                                setTimeout(function() {
                                                    var successAlert = document.getElementById('successAlert');
                                                    if (successAlert) {
                                                        successAlert.remove();
                                                    }
                                                }, 3000);
                                            </script>
                                            @endif


                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="row">
                                <div class="add-icon mt-2">
                                    <a href="javascript:void(0);" id="addRowBtn"><img src="assets/img/icons/plus1.svg" alt="img"></a>

                                </div>
                                <div class="col-lg-12 float-md-right">
                                    <div class="total-order">
                                        <ul>
                                            <li>
                                                <h4>Order Tax</h4>
                                                <h5 class="totalTaxCost">₹ 0.00 (0.00%)</h5>
                                                <input type="hidden" name="totalTaxCost" class="totalTaxCost-input">

                                            </li>
                                            <li>
                                                <h4>Discount </h4>
                                                <h5 class="totalDiscountCost">₹ 0.00</h5>
                                                <input type="hidden" name="totalDiscountCost" class="totalDiscountCost-input">

                                            </li>
                                            <input type="hidden" name="TCS_Per" class="TCS_Per" value="">
                                            <!-- <li>
                                                <h4>Shipping</h4>
                                                <div class="form-group d-flex justify-content-end mt-3 ">
                                                    <input type="number" class="w-50 ShippingCost" style="height:30px;" value="" name="shippingCost" required readonly>
                                                </div>
                                            </li> -->
                                            <li class="total">
                                                <h4>Grand Total</h4>
                                                <h5 class="totalGrandCost">₹ 0.00</h5>
                                                <input type="hidden" name="totalGrandCost" class="totalGrandCost-input">
                                                <input type="hidden" name="totalGrossCost" class="totalGrossCost-input">
                                                <input type="hidden" class="w-50 ShippingCost" style="height:30px;" value="" name="shippingCost" required readonly>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Order Tax</label>
                                            <input type="text">
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Discount</label>
                                            <input type="text">
                                        </div>
                                    </div> -->
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Shipping</label>
                                            <input type="text">
                                        </div>
                                    </div> -->
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select class="select">
                                                <option>Choose Status</option>
                                                <option>Completed</option>
                                                <option>Inprogress</option>
                                            </select>
                                        </div>
                                    </div> -->
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Description</label>
                                        <textarea class="form-control" name="remarks" required></textarea>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <!-- <a href="" class=" me-2">Submit</a> -->
                                    <input type="submit" value="Submit" class="btn btn-submit" id="submitBtn">
                                    <!-- <a href="javascript:void(0);" class="btn btn-cancel" id="cancelButton">Cancel</a> -->
                                </div>
                            </div>
                </form>

                <!-- Modal for confirmation to delete -->
                <div class="modal fade" id="deleteConfirmationModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Confirmation</h5>
                                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                Are you sure you want to delete this row?
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" id="cancel-btn" data-bs-dismiss="modal">Cancel</button>
                                <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Delete</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- minimum one row limit -->
                <div class="modal fade" id="minimumRowModal" tabindex="-1" role="dialog" aria-labelledby="minimumRowModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="minimumRowModalLabel">Minimum Row Requirement</h5>
                                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                At least one row is required. You cannot delete the last row.
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">OK</button>
                            </div>
                        </div>
                    </div>
                </div>
                <!--   modal end-->
            </div>
        </div>
    </div>
    </div>
    </div>


    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/selectize.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/js/moment.min.js"></script>
    <script src="assets/js/bootstrap-datetimepicker.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>
    <script src="assets/js/Grn/addGrn.js"></script>


    <!-- QTY NOT EXCEED TO QTY -->
    <script>
        function validateQuantity(quantityInput) {
            var enteredQty = parseInt(quantityInput.value);
            var row = quantityInput.closest('tr'); // Get the closest row of the quantity input
            var selectElement = row.querySelector('select[name="PONumber[]"]');
            var availableStock = parseInt(selectElement.value.split('|')[2]);

            // Check if the entered quantity is negative, zero, or exceeds the available stock
            if (enteredQty <= 0 || enteredQty > availableStock) {
                // Set the input value within a valid range
                quantityInput.value = Math.max(1, Math.min(enteredQty, availableStock));
            }
        }
    </script>

    <script>
        function disableSelect(selectElement) {
            selectElement.removeAttribute("onchange");
            selectElement.classList.add("form-select");
            $('#hiddenLedger').val(selectElement.value);
            var selectizeInstance = $("#Ledger")[0].selectize;

        }
    </script>


    <script>
        $(document).ready(function() {
            // Initialize Selectize
            var gatePassNoSelectize = $("#gatePassNo").selectize({
                create: true,
                sortField: "text",
            });

            $("#division").on("change", function() {
                var csrfToken = $('meta[name="csrf-token"]').attr('content');

                // Store the selected gatepassno before making the AJAX request
                var selectedGatePassNo = gatePassNoSelectize[0].selectize.getValue();

                var formData = {
                    divisionCode: $(this).val(),
                    _token: csrfToken
                };

                $.ajax({
                    type: "GET",
                    url: "{{ route('divChoose') }}",
                    data: {
                        divisionCode: formData.divisionCode
                    },
                    success: function(response) {
                        let responseArray = response;

                        // Clear existing options
                        gatePassNoSelectize[0].selectize.clearOptions();

                        for (var i = 0; i < responseArray.length; i++) {
                            let gpno = response[i]['GpNo'];
                            let gpdate = response[i]['GpDate'];
                            let InvDate = response[i]['InvDate'];
                            let InvNo = response[i]['InvNo'];
                            console.log(gpno);

                            // Add new option
                            gatePassNoSelectize[0].selectize.addOption({
                                text: gpno,
                                value: gpno + '|' + gpdate + '|' + InvNo + '|' + InvDate
                            });
                        }

                        // Refresh Selectize dropdown
                        gatePassNoSelectize[0].selectize.refreshItems();

                        // Set the selected gatepassno if it's still valid
                        if (selectedGatePassNo && responseArray.some(item => item.GpNo === selectedGatePassNo)) {
                            gatePassNoSelectize[0].selectize.setValue(selectedGatePassNo);
                        }
                    },
                    error: function(error) {
                        console.log(error);
                    }
                });
            });
        });
    </script>




    <script>
        $(document).ready(function() {
            $('#addRowBtn').hide();
            $('#Ledger').change(function() {
                var selectedLedgerCode = $(this).val();
                $('.poNumber').empty();
                $('.poNumber').append('<option value="">--select--</option>');

                var selectedOptions = [];

                @foreach($decode2 as $index => $decodes2)
                var ledgerCode = '{{ $decodes2["Ledger_Code"] }}';
                var rowId = '{{ $decodes2["Rowid"] }}';
                var productName = '{{ $decodes2["Product_Name"] }}';
                var balanceQty = '{{ $decodes2["balanceQty"] }}';
                var productPrice = '{{ $decodes2["product_price"] }}';
                var discPer = '{{ $decodes2["Disc_Per"] }}';
                var taxPer = '{{ $decodes2["Tax_Per"] }}';
                var netAmt = '{{ $decodes2["Net_Amt"] }}';
                var pono = '{{ $decodes2["PONO"] }}';
                var ProdId = '{{ $decodes2["Prod_Id"] }}';
                var ShipAmt = '{{ $decodes2["ShipAmt"] }}';
                var Tcsper = '{{ $decodes2["TCS_Per"] }}';
                var index = '{{ $index }}';


                if (ledgerCode == selectedLedgerCode) {
                    var optionValue = rowId + '|' + productName + '|' + balanceQty + '|' + productPrice + '|' + discPer + '|' + taxPer + '|' + netAmt + '|' + ledgerCode + '|' + index + '|' + ProdId;
                    $('.poNumber').append('<option data-ledger-code="' + ledgerCode + '" value="' + optionValue + '"> ' + pono + ' / ' + productName + ' / ' + balanceQty + '</option>');

                    var inputElement = document.querySelector('.TCS_Per');
                    if (inputElement) {
                        inputElement.value = Tcsper;
                    }
                    // Save selected option to exclude in the next rows
                    selectedOptions.push(optionValue);
                    // ShippingCost
                }
                @endforeach

                // // Remove selected options from subsequent rows
                // $('.poNumber').each(function() {
                //     var $select = $(this);
                //     var currentValue = $select.val();
                //     if (currentValue && selectedOptions.includes(currentValue)) {
                //         $select.find('option[value="' + currentValue + '"]').remove();
                //     }
                // });
                $(".ShippingCost").val(ShipAmt);
                $('#addRowBtn').show();
            });
        });
    </script>


    <!-- delete btn -->
    <script>
        // delete rows
        let selectedOptions = [];

        function deleteRow(row) {
            // Store the row to be deleted
            rowToDelete = row;

            let rowCount = $('#table tr').length;

            // Show the confirmation modal based on the row count
            if (rowCount > 3) {
                $('#deleteConfirmationModal').modal('show');
            } else {
                $('#minimumRowModal').modal('show');
            }
        }

        // Handle the click event for the "Delete" button in the modal
        $('#confirmDeleteBtn').click(function() {
            // Get the value of the deleted row's select element
            var deletedValue = rowToDelete.querySelector('.poNumber').value;

            // Remove the deleted value from the selectedOptions array
            var index = selectedOptions.indexOf(deletedValue);
            if (index !== -1) {
                selectedOptions.splice(index, 1);
            }

            // Remove the row from the table
            rowToDelete.parentNode.removeChild(rowToDelete);

            // Hide the confirmation modal
            $('#deleteConfirmationModal').modal('hide');

            // Call the updateTotalCost function after deleting a row
            updateTotalCost();
        });
    </script>





    @endsection
</body>

</html>