<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="VMS - Vehicle Management System">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <title>GRN</title>
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">


</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">


        @extends('VMS.navbar')
        @section('content')
        <?php
        $grnViews = Session::get('grnViews');
        $grnEdit = Session::get('grnEdit');
        $grnEntrty = Session::get('grnEntrty');
        ?>
        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>Grn Report</h4>
                        <!-- <h6>Manage your products</h6> -->
                    </div>
                    @if ($grnEntrty == "Y")
                    <div class="page-btn">
                        <a href="addGrn" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img" class="me-1">Add New GRN</a>
                    </div>
                    @endif
                </div>

                <div class="card">
                    <div class="card-body">


                        <div class="table-responsive">
                            <table class="table  datanew">
                                <thead>
                                    <tr>
                                        @if ($grnViews == "Y" || $grnEdit == "Y")
                                        <th>Edit</th>
                                        @endif
                                        <th>Grn No</th>
                                        <th>GrnDate</th>
                                        <th>Gatepass No</th>
                                        <th>Gatepass Date </th>
                                        <th>Inv No</th>
                                        <th>Inv Date</th>
                                        <th>Discount</th>
                                        <th>Tax</th>
                                        <!-- <th>NetAmt</th> -->
                                        <th>NetAmt</th>
                                        <!-- <th>Remarks</th> -->

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($decode as $decodes)
                                    <tr>

                                        @if ($grnViews == "Y" || $grnEdit == "Y")
                                        <td>
                                            @if ($grnViews == "Y")
                                            <a href="grnListView?mode=view&rowid={{ $decodes['rowid'] }}&grnNo={{ $decodes['grnNo'] }}&grnDate={{ $decodes['grnDate'] }}&gpNo={{ $decodes['gpNo'] }}&gpDate={{ $decodes['gpDate'] }}&invNo={{ $decodes['invNo'] }}&invDate={{ $decodes['invDate'] }}&Ledger_Address={{ $decodes['Ledger_Address'] }}&Ledger_Name={{ $decodes['Ledger_Name'] }}&totalDisc={{ $decodes['totalDisc'] }}&totaltax={{ $decodes['totaltax'] }}&GnetAmt={{ $decodes['GnetAmt'] }}&shipping={{ $decodes['shipping'] }}&remarks={{ $decodes['remarks'] }}&GST_No={{ $decodes['GST_No'] }}" class="me-3 viewBtn">
                                                <img src="assets/img/icons/eye.svg" alt="img">
                                            </a>
                                            @endif

                                            @if ($grnEdit == "Y")
                                            <a class="me-5 editBtn" href="grnEdit?mode=edit&rowid={{ $decodes['rowid'] }}&grnNo={{ $decodes['grnNo'] }}&grnDate={{ $decodes['grnDate'] }}&gpDate={{ $decodes['gpDate'] }}&invNo={{ $decodes['invNo'] }}&invDate={{ $decodes['invDate'] }}&gpNo={{ $decodes['gpNo'] }}&Ledger_Name={{ $decodes['Ledger_Name'] }}&totalDisc={{ $decodes['totalDisc'] }}&totaltax={{ $decodes['totaltax'] }}&GnetAmt={{ $decodes['GnetAmt'] }}&shipping={{ $decodes['shipping'] }}&suppliercode={{ $decodes['suppliercode'] }}&remarks={{ $decodes['remarks'] }}">
                                                <img src="assets/img/icons/edit.svg" alt="img">
                                            </a>
                                            @endif
                                        </td>
                                        @endif
                                        <td class="productimgname">

                                            <a href="javascript:void(0);">{{$decodes['grnNo']}}</a>
                                        </td>
                                        <td>{{date('Y-m-d', strtotime($decodes['grnDate']))}}</td>
                                        <td>{{$decodes['gpNo']}}</td>
                                        <td>
                                            {{ date('Y-m-d', strtotime($decodes['gpDate'])) }}
                                        </td>
                                        <td>{{$decodes['invNo']}}</td>
                                        <td> {{ date('Y-m-d', strtotime($decodes['invDate'])) }}</td>
                                        <td>{{$decodes['totalDisc']}}</td>
                                        <td>{{$decodes['totaltax']}}</td>
                                        <!-- <td>{{$decodes['GnetAmt']}}</td> -->
                                        <td>{{$decodes['tnetAmt']}}</td>
                                        <!-- <td>{{$decodes['remarks']}}</td> -->

                                    </tr>
                                    </form>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <script src="assets/js/jquery-3.6.0.min.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>
    <script>
        dataTableInstance.destroy();
        $('#DataTables_Table_0').DataTable();
    </script>

    @endsection
</body>

</html>