<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="VMS - Vehicle Management System">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <title>GRN</title>
    <!-- <link rel="icon" href="gplogofinal.png" type="png"> -->
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">

    <link rel="stylesheet" href="assets/css/animate.css">

    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/selectize.css">

    <style>
        #newRowTemplate td {
            width: 1.5%;
            padding: 8px;

        }

        #newRowTemplate .custom-form-group {
            margin-bottom: 0;
        }

        #newRowTemplate input {
            width: 10%;
        }

        #newRowTemplate select {
            width: 100%;
        }

        td .selectize-input {
            width: 180px !important;
            /* Adjust the width as needed */
            max-width: 90% !important;
            height: 28px !important;
            margin-right: -50px !important;
        }
    </style>
</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">
        @extends('VMS.navbar')
        @section('content')
        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>Edit GRN </h4>
                        <!-- <h6>Add Purchase</h6> -->
                    </div>
                </div>
                <form action="grnEditSave" method="post" id="addGrnForm">
                    @csrf
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>GRN No.</label>
                                        <input type="text" value="{{ request('grnNo') }}" name="GRNNO" readonly>

                                    </div>

                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>GRN Date </label>
                                        <div class="input-groupicon">
                                            <input type="text" name="GrnDate" value="{{ request('grnDate') }}" readonly>
                                            <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-xl-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Supplier Name</label>
                                        <div class="row">
                                            <div class="col-lg-12 col-sm-12 col-12">
                                                <!-- <select class="" placeholder="select" id="Ledger" name="ledger_code" required>
                                                    <option value="">--SELECT--</option>
                                                   
                                                    <option value=""></option>
                                                   
                                                </select> -->

                                                <input type="text" value="{{ request('Ledger_Name') }}" name="" readonly>



                                            </div>
                                            <!-- <div class="col-lg-2 col-sm-2 col-2 ps-0">
                                            <div class="add-icon">
                                                <a href="javascript:void(0);"><img src="assets/img/icons/plus1.svg" alt="img"></a>
                                            </div>
                                        </div> -->
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>GatePass No.</label>
                                        <!-- <input type="text" value="" name="gatePassNo" readonly> -->
                                        <!-- <select class="" placeholder="gatePassNo" id="gatePassNo" name="gatePassNo" required onchange="grnGp(this)">
                                            <option value="">--SELECT--</option>
                                          
                                            <option value=""></option>
                                            

                                        </select> -->

                                        <input type="text" value="{{ request('gpNo') }}" name="GRNNO" readonly>
                                        <input type="hidden" value="{{ request('rowid') }}" name="MasterID" readonly>

                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>GatePass Date </label>
                                        <div class="input-groupicon">
                                            <input type="text" name="gatePassDate" class="" value="{{ date('Y-m-d', strtotime(request('gpDate'))) }}" id="" readonly>
                                            <!-- <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div> -->
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Inward NO</label>
                                        <input type="text" value="{{ request('invNo') }}" name="inwardno" class="invNo" id="invNo" readonly>

                                    </div>
                                </div>
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Reference No.</label>
                                        <input type="text" value="" name="referenceNo" required>
                                    </div>
                                </div> -->

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Inward Date </label>
                                        <div class="input-groupicon">
                                            <input type="text" name="inwardDate" value="{{ date('Y-m-d', strtotime(request('invDate'))) }}" class="" id="inwardDate" readonly>
                                            <!-- 
                                            <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div> -->
                                        </div>
                                    </div>
                                </div>
                                <!-- <div class="col-lg-4 col-sm-6 col-10">
                                    <div class="form-group">
                                        <label>Search Product. </label>
                                        <div class="input-groupicon">
                                            
                                            <input type="text" placeholder="Search Data..." id="searchBox">
                                        </div>
                                        <div class="addonset">

                                        </div>
                                    </div>
                                </div> -->
                                <!-- <div class="col-lg-2  col-sm-6 col-10 mb-1">
                                    <label>Add product</label>
                                    <div class="add-icon mt-2">
                                        <a href="javascript:void(0);" id="addRowBtn"><img src="assets/img/icons/plus1.svg" alt="img"></a>

                                    </div>
                                </div> -->

                                <!-- <div class="col-lg-2 col-sm-2 col-2 ps-0">
                                <div class="add-icon">
                                    <a href="javascript:void(0);"><img src="assets/img/icons/plus1.svg" alt="img"></a>
                                </div>
                            </div> -->
                            </div>
                            <div class="row">
                                <div class="table-responsive">
                                    <table class="table" id="table">
                                        <thead>
                                            <tr>
                                                <th>PO No</th>
                                                <th>Items</th>
                                                <th>Quantity</th>
                                                <th>Price(₹) </th>
                                                <th>Disc </th>
                                                <!-- <th>Disc Cost </th> -->
                                                <!-- <th>Gross Cost </th> -->
                                                <th>Tax %</th>
                                                <!-- <th>Tax Amount</th> -->
                                                <th>Total Cost </th>
                                                <th>Edit</th>
                                            </tr>
                                        </thead>
                                        <tbody>




                                            @foreach ($decode as $decodes)
                                            <tr id="newRowTemplate">

                                                <td class="" style="display: none;">
                                                    <input type="hidden" value="{{$decodes['sno']}}" class="sno" name="sno[]">
                                                    <input type="hidden" value="{{$decodes['MasterId']}}" class="sno" name="MasterID">

                                                    <input type="hidden" name="ledger_code" id="" value="{{ $decodes['suppliercode'] }}">
                                                    <input type="hidden" name="productName[]" id="" value="{{ $decodes['poid'] }}|{{ $decodes['rate'] }}">
                                                    <input type="hidden" name="prodId[]" id="" value="{{ $decodes['prodId'] }}">

                                                </td>

                                                <td class="form-group">
                                                    <input type="text" style="height: 30px !important; width:170px;" name="" value="{{ $decodes['PONO'] }}" readonly>

                                                    <input type="hidden" style="height: 30px !important; width:170px;" name="poNumber[]" class="poNumber" value="{{ $decodes['poid'] }}|{{ $decodes['poid'] }}|{{ $decodes['poid'] }}|{{ $decodes['poid'] }}|{{ $decodes['poid'] }}|{{ $decodes['poid'] }}|{{ $decodes['poid'] }}|{{ $decodes['poid'] }}|{{ $decodes['poid'] }}|{{$decodes['prodId']}}" readonly>
                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style="height: 30px !important; width:170px;" name="" value="{{$decodes['Product_Name']}}" readonly>
                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style="height: 30px !important; width:70px;" value="{{$decodes['qty']}}" class="qty-input" name="quantity[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '');">

                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="{{$decodes['rate']}}" class=" purchase-input" name="productPrice[]" readonly>

                                                </td>
                                                <!-- <td id="grandCost" class="grandCost" style="display: none;">

                                                </td> -->
                                                <td style="display: none;">
                                                    <input type="hidden" name="grandCost[]" class="grandCost" value="{{$decodes['allotAmt']}}" readonly>
                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="{{$decodes['discPer']}}" class="discount-input" name="dicount[]" readonly>
                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="discountCost[]" class="discountCost" value="{{$decodes['discAmt']}}">

                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="GrossCost[]" class="GrossCost" value=" {{$decodes['grsamt']}}">

                                                </td>

                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="{{$decodes['taxPer']}}" class="tax-input" name="tax[]" readonly>
                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="taxCost[]" class="taxCost" value="{{$decodes['taxAmt']}}">

                                                </td>
                                                <td class="totalCost">
                                                    {{$decodes['netAmt']}}

                                                </td>
                                                <td style="display: none;">
                                                    <input type="hidden" name="totalCost[]" value="{{$decodes['netAmt']}}" class="totalCost-input">

                                                </td>
                                                <td>
                                                    <a class="" onclick="deleteRow(this.closest('tr'))"><img src="assets/img/icons/delete.svg" alt="svg"></a>
                                                </td>
                                            </tr>
                                            @endforeach


                                            @if ($message = Session::get('SuccessMsg'))
                                            <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                                                {{$message}}

                                            </div>

                                            <script>
                                                // Automatically close the alert after 3 seconds
                                                setTimeout(function() {
                                                    var successAlert = document.getElementById('successAlert');
                                                    if (successAlert) {
                                                        successAlert.remove();
                                                    }
                                                }, 3000);
                                            </script>
                                            @endif
                                            @if ($message = Session::get('errorMsg'))
                                            <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                                                {{$message}}

                                            </div>

                                            <script>
                                                // Automatically close the alert after 3 seconds
                                                setTimeout(function() {
                                                    var successAlert = document.getElementById('successAlert');
                                                    if (successAlert) {
                                                        successAlert.remove();
                                                    }
                                                }, 3000);
                                            </script>
                                            @endif


                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-lg-12 float-md-right">
                                    <div class="total-order">
                                        <ul>
                                            <li>
                                                <h4>Order Tax</h4>
                                                <h5 class="totalTaxCost">₹ {{ request('totaltax') }}</h5>
                                                <input type="hidden" name="totalTaxCost" class="totalTaxCost-input" value="{{ request('totaltax') }}">

                                            </li>
                                            <li>
                                                <h4>Discount </h4>
                                                <h5 class="totalDiscountCost">₹ {{ request('totalDisc') }}</h5>
                                                <input type="hidden" name="totalDiscountCost" class="totalDiscountCost-input" value="{{ request('totalDisc') }}">

                                            </li>
                                            <!-- <li>
                                                <h4>Shipping</h4>
                                                <div class="form-group d-flex justify-content-end mt-3 ">
                                                   
                                                </div>
                                            </li> -->
                                            <li class="total">
                                                <h4>Grand Total</h4>
                                                <h5 class="totalGrandCost">₹ {{ request('GnetAmt') }}</h5>
                                                <input type="hidden" name="totalGrandCost" value="{{ request('GnetAmt') }}" class="totalGrandCost-input">
                                                <input type="hidden" class="w-50 ShippingCost" style="height:30px;" value="{{ request('shipping') }}" name="shippingCost" required readonly>
                                                <input type="hidden" name="totalGrossCost" class="totalGrossCost-input">

                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Order Tax</label>
                                            <input type="text">
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Discount</label>
                                            <input type="text">
                                        </div>
                                    </div> -->
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Shipping</label>
                                            <input type="text">
                                        </div>
                                    </div> -->
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select class="select">
                                                <option>Choose Status</option>
                                                <option>Completed</option>
                                                <option>Inprogress</option>
                                            </select>
                                        </div>
                                    </div> -->
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Description</label>
                                        <textarea class="form-control" name="remarks" required> {{ request('remarks') }}</textarea>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <!-- <a href="" class=" me-2">Submit</a> -->
                                    <input type="submit" value="Submit" class="btn btn-submit">
                                    <!-- <a href="javascript:void(0);" class="btn btn-cancel" id="cancelButton">Cancel</a> -->
                                </div>
                            </div>
                            <!-- Modal for confirmation to delete -->
                            <div class="modal fade" id="deleteConfirmationModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Confirmation</h5>
                                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            Are you sure you want to delete this row?
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" id="cancel-btn" data-bs-dismiss="modal">Cancel</button>
                                            <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Delete</button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- minimum one row limit -->
                            <div class="modal fade" id="minimumRowModal" tabindex="-1" role="dialog" aria-labelledby="minimumRowModalLabel" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="minimumRowModalLabel">Minimum Row Requirement</h5>
                                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            At least one row is required. You cannot delete the last row.
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">OK</button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!--   modal end -->
                </form>
            </div>
        </div>
    </div>
    </div>
    </div>


    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/selectize.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/js/moment.min.js"></script>
    <script src="assets/js/bootstrap-datetimepicker.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>
    <script src="assets/js/Grn/grnEdit.js"></script>



    <!-- <script>
        $(document).ready(function() {  
            var selectedLedgerCode = $('#Ledger').val();
            console.log(selectedLedgerCode);
            // Clear the options in the second dropdown
            $('#poNumber').empty();
            // Add a default option to the second dropdown
            $('#poNumber').append('<option value="">--select--</option>');
            // Loop through the PHP array and filter options based on the selected ledger code
            @foreach($decode2 as $index => $decodes2)
            // Escape single quotes and output values to JavaScript variables
            var ledgerCode = '{{ $decodes2["Ledger_Code"] }}';
            var rowId = '{{ $decodes2["Rowid"] }}';
            var productName = '{{ $decodes2["Product_Name"] }}';
            var qty = '{{ $decodes2["Qty"] }}';
            var productPrice = '{{ $decodes2["product_price"] }}';
            var discPer = '{{ $decodes2["Disc_Per"] }}';
            var taxPer = '{{ $decodes2["Tax_Per"] }}';
            var netAmt = '{{ $decodes2["Net_Amt"] }}';
            var pono = '{{ $decodes2["PONO"] }}';
            var ProdId = '{{ $decodes2["Prod_Id"] }}';
            var index = '{{ $index }}';

            // Check if the ledger code matches the selected ledger code
            if (ledgerCode == selectedLedgerCode) {
                // Add the option to the second dropdown
                $('#poNumber').append('<option data-ledger-code="' + ledgerCode + '" value="' + rowId + '|' + productName + '|' + qty + '|' + productPrice + '|' + discPer + '|' + taxPer + '|' + netAmt + '|' + ledgerCode + '|' + index +'|'+ ProdId + ' "> ' + pono + ' / ' + productName + ' / ' + qty + '</option>');
            }
            @endforeach

            // $('#addRowBtn').show();
        });
        // });
    </script> -->

    <!-- delete btn -->
    <script>
        // delete rows
        let selectedOptions = [];

        function deleteRow(row) {
            // Store the row to be deleted
            rowToDelete = row;

            let rowCount = $('#table tr').length;
   
            // Show the confirmation modal based on the row count
            if (rowCount > 2) {
                $('#deleteConfirmationModal').modal('show');
            } else {
                $('#minimumRowModal').modal('show');
            }
        }

        // Handle the click event for the "Delete" button in the modal
        $('#confirmDeleteBtn').click(function() {
            // Get the value of the deleted row's select element

            var deletedValue = rowToDelete.querySelector('.poNumber').value;

            // Remove the deleted value from the selectedOptions array
            var index = selectedOptions.indexOf(deletedValue);
            if (index !== -1) {
                selectedOptions.splice(index, 1);
            }

            // Remove the row from the table
            rowToDelete.parentNode.removeChild(rowToDelete);

            // Hide the confirmation modal
            $('#deleteConfirmationModal').modal('hide');

            // Call the updateTotalCost function after deleting a row
            updateTotalCost();
        });

    </script>
    @endsection
</body>

</html>