<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="VMS - Vehicle Management System">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <title>INVOICE</title>
    <!-- <link rel="icon" href="gplogofinal.png" type="png"> -->
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">

    <link rel="stylesheet" href="assets/css/animate.css">

    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/selectize.css">

    <style>
        #newRowTemplate td {
            width: 1.5%;
            padding: 8px;

        }

        #newRowTemplate .custom-form-group {
            margin-bottom: 0;
        }

        #newRowTemplate input {
            width: 10%;
        }

        #newRowTemplate select {
            width: 100%;
        }

        td .selectize-input {
            width: 180px !important;
            /* Adjust the width as needed */
            max-width: 90% !important;
            height: 28px !important;
            margin-right: -50px !important;
        }
    </style>

</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">
        @extends('VMS.navbar')
        @section('content')
        <div class="page-wrapper">
            @if ($decode == "Empty")
            <h1 class="text-center">No Data</h1>
            @endif

            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>Invoice Entry</h4>
                        <!-- <h6>Add Purchase</h6> -->
                    </div>
                </div>
                <form action="invSave" method="post" id="addGrnForm">
                    @csrf
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>ENo</label>
                                        <input type="text" value="{{$invno}}" name="entryNo" readonly>
                                        <!-- <select class="" placeholder="gatePassNo" id="gatePassNo" name="gatePassNo" required onchange="grnGp(this)">
                                            <option value="">--SELECT--</option>
                                        
                                            <option value=""></option>
                                          

                                        </select> -->
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Edate </label>
                                        <div class="input-groupicon">
                                            <input type="text" name="entryDate" class="form-control" value="{{now()->format('Y-m-d')}}" id="gpDateInput" readonly>
                                            <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Invoice No</label>
                                        <input type="text" value="" name="invno" required>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Invoice Date </label>
                                        <div class="input-groupicon">
                                            <!-- <input type="text" name="" placeholder="DD-MM-YYYY" class="datetimepicker" id=""> -->
                                            <input type="date" name="invDate" id="invDate" max="<?= date('Y-m-d'); ?>" required class="form-control">
                                            <!-- <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div> -->
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-xl-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Supplier Name</label>
                                        <div class="row">
                                            <div class="col-lg-12 col-sm-12 col-12">
                                                @if(is_array($decode))
                                                <select class="" placeholder="select" id="Ledger" required onchange="disableSelect(this)">
                                                    <option value="">--SELECT--</option>
                                                    @foreach($decode as $decodes3)
                                                    <option value="{{ $decodes3['Ledger_Code'] }}">{{ $decodes3['Ledger_Name'] }}</option>
                                                    @endforeach
                                                </select>
                                                @else
                                                <!-- Handle the case when $decode is not an array -->
                                                <!-- <p>Error: NO SUPPLIER.</p> -->
                                                @endif
                                                <input type="hidden" name="ledger_code" id="hiddenLedger">
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-3 col-sm-6 col-12">
                                    <!-- <div class="form-group">
                                        <label>Inward NO</label>
                                        <input type="text" value="" name="inwardno" class="invNo" id="invNo" readonly>

                                    </div> -->
                                </div>
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Reference No.</label>
                                        <input type="text" value="" name="referenceNo" required>
                                    </div>
                                </div> -->

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <!-- <div class="form-group">
                                        <label>Inward Date </label>
                                        <div class="input-groupicon">
                                            <input type="text" name="inwardDate" placeholder="DD-MM-YYYY" class="datetimepicker" id="inwardDate" readonly>

                                            <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div>
                                        </div>
                                    </div> -->
                                </div>
                                <!-- <div class="col-lg-4 col-sm-6 col-10">
                                    <div class="form-group">
                                        <label>Search Product. </label>
                                        <div class="input-groupicon">
                                            
                                            <input type="text" placeholder="Search Data..." id="searchBox">
                                        </div>
                                        <div class="addonset">

                                        </div>
                                    </div>
                                </div> -->
                                <div class="col-lg-2  col-sm-6 col-10 mb-1">
                                    <!-- <label>Add Invoice</label> -->
                                    <!-- <div class="add-icon mt-2">
                                        <a href="javascript:void(0);" id="addRowBtn"><img src="assets/img/icons/plus1.svg" alt="img"></a>

                                    </div> -->
                                </div>

                                <!-- <div class="col-lg-2 col-sm-2 col-2 ps-0">
                                <div class="add-icon">
                                    <a href="javascript:void(0);"><img src="assets/img/icons/plus1.svg" alt="img"></a>
                                </div>
                            </div> -->
                            </div>
                            <div class="row">
                                <div class="table-responsive">
                                    <table class="table" id="table">
                                        <thead>
                                            <tr>
                                                <th>GRN No</th>
                                                <th>Items</th>
                                                <th>Quantity</th>
                                                <th>Price(₹) </th>
                                                <th>Disc(%) </th>
                                                <!-- <th>Disc Cost </th> -->
                                                <!-- <th>Gross Cost </th> -->
                                                <th>Tax %</th>
                                                <!-- <th>Tax Amount</th> -->
                                                <th>Total Cost(₹) </th>
                                                <th>Delete</th>
                                            </tr>
                                        </thead>
                                        <tbody>


                                            <tr id="newRowTemplate">

                                                <td class="" style="display: none;">
                                                    <input type="hidden" value="" class="sno" name="sno[]">
                                                </td>
                                                <td class="" style="display: none;"></td>

                                                <td>
                                                    <!-- Second Select (PONumber) -->
                                                        @if(is_array($decode) || is_object($decode))
                                                        <select name="grnNumber[]" id="poNumber" class="poNumber mt-1" onchange="updatePrice(this)">
                                                            <option value="">--select--</option>
                                                            @foreach($decode as $decodes4)
                                                            <option data-ledger-code="{{ $decodes4['Ledger_Code'] }}" data-shipping-cost="{{ $decodes4['shipping'] }}" value="{{ $decodes4['rowid'] }}|{{$decodes4['Product_Name']}}|{{ $decodes4['qty'] }}|{{ $decodes4['rate'] }}|{{ $decodes4['discPer'] }}|{{ $decodes4['taxPer'] }}|{{ $decodes4['netAmt'] }}|{{ $decodes4['prodId'] }}">
                                                                {{ $decodes4['grnNo'] }} / {{ $decodes4['Product_Name'] }} / {{ $decodes4['qty'] }}
                                                            </option>
                                                            @php
                                                            $shippingCost = $decodes4['shipping'];
                                                            @endphp
                                                            @endforeach
                                                        </select>
                                                        @else
                                                        <!-- Handle the case when $decode is not an array or object -->
                                                        <p>Error: NO PO.</p>
                                                        @endif
                                                </td>
                                                <td class="item-input"></td>
                                                <td class="form-group">
                                                    <input type="text" style="height: 30px !important; width:70px;" value="" class="qty-input" name="quantity[]">

                                                    <input type="hidden" style="height: 30px !important; width:70px;" value="" class="grn-qty-input" name="grnquantity[]">

                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="" class="purchase-input" name="productPrice[]">

                                                    <input type="hidden" style=" height: 30px !important; width:70px;" value="" class="grn-price-input" name="grnprice[]">
                                                </td>
                                                <!-- <td id="grandCost" class="grandCost" style="display: none;">

                                                </td> -->
                                                <td style="display: none;">
                                                    <input type="hidden" name="grandCost[]" class="grandCost">
                                                    <input type="hidden" name="grngrandCost[]" class="grn-qtyCost-input">
                                                </td>

                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="" class="discount-input" name="dicount[]">

                                                    <input type="hidden" style=" height: 30px !important; width:70px;" value="" class="grn-discount-input" name="grndicount[]" readonly>
                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="discountCost[]" class="discountCost">

                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="GrossCost[]" class="GrossCost">

                                                </td>

                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="" class="tax-input" name="tax[]">

                                                    <input type="hidden" style=" height: 30px !important; width:70px;" value="" class="grn-tax-input" name="grntax[]" readonly>
                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="taxCost[]" class="taxCost">


                                                </td>
                                                <td class="totalCost">0.00</td>
                                                <td style="display: none;">
                                                    <input type="hidden" name="totalCost[]" class="totalCost-input">
                                                    <input type="hidden" name="totalgrnCost[]" class="grn-totalCost-input">

                                                </td>
                                                <td>
                                                    <a class="" onclick="deleteRow(this.closest('tr'))"><img src="assets/img/icons/delete.svg" alt="svg"></a>
                                                </td>


                                                <!-- rate debit  -->

                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="totalrateDebit" class="rateDebit-input">
                                                    <input type="hidden" name="totalQtyDebit" class="QtyDebit-input">
                                                    <input type="hidden" name="totalDebit" class="tDebit-input">

                                                </td>
                                                <!-- rate debit end  -->
                                            </tr>
                                            @if ($message = Session::get('SuccessMsg'))
                                            <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                                                {{$message}}

                                            </div>

                                            <script>
                                                // Automatically close the alert after 3 seconds
                                                setTimeout(function() {
                                                    var successAlert = document.getElementById('successAlert');
                                                    if (successAlert) {
                                                        successAlert.remove();
                                                    }
                                                }, 3000);
                                            </script>
                                            @endif
                                            @if ($message = Session::get('errorMsg'))
                                            <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                                                {{$message}}

                                            </div>

                                            <script>
                                                // Automatically close the alert after 3 seconds
                                                setTimeout(function() {
                                                    var successAlert = document.getElementById('successAlert');
                                                    if (successAlert) {
                                                        successAlert.remove();
                                                    }
                                                }, 3000);
                                            </script>
                                            @endif


                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="row">
                                <div class="add-icon mt-2">
                                    <a href="javascript:void(0);" id="addRowBtn"><img src="assets/img/icons/plus1.svg" alt="img"></a>

                                </div>
                                <div class="col-lg-6 float-md-left">
                                    <div class="total-order">
                                        <ul>
                                            <li>
                                                <h4>Rate Debit</h4>
                                                <h5 class="rateDebit">₹ 0.00</h5>
                                                <input type="hidden" name="totalrateDebit" class="total-rateDebit-input">

                                            </li>
                                            <li>
                                                <h4>Qty Debit </h4>
                                                <h5 class="totalQtyDebit">₹ 0.00</h5>
                                                <input type="hidden" name="totalQtyDebit" class="total-QtyDebit-input">

                                            </li>
                                            <li>
                                                <!-- <h4>Shipping</h4>
                                                <div class="form-group d-flex justify-content-end mt-3 ">
                                                    <input type="number" class="w-50 ShippingCost" style="height:30px;" value="0" name="shippingCost" required>
                                                </div> -->
                                            </li>
                                            <li class="total">
                                                <h4>Total Debit </h4>
                                                <h5 class="totalDebit">₹ 0.00</h5>
                                                <input type="hidden" name="totalDebit" class="total-Debit-input">
                                                <!-- <input type="hidden" name="totalGrossCost" class="totalGrossCost-input"> -->

                                            </li>
                                        </ul>
                                    </div>
                                </div>

                                <div class="col-lg-6 float-md-right">
                                    <div class="total-order">
                                        <ul>
                                            <li>
                                                <h4>Order Tax</h4>
                                                <h5 class="totalTaxCost">₹ 0.00 (0.00%)</h5>
                                                <input type="hidden" name="totalTaxCost" class="totalTaxCost-input">

                                            </li>
                                            <li>
                                                <h4>Discount </h4>
                                                <h5 class="totalDiscountCost">₹ 0.00</h5>
                                                <input type="hidden" name="totalDiscountCost" class="totalDiscountCost-input">

                                            </li>
                                            <li>
                                                <h4>Shipping</h4>
                                                <div class="form-group d-flex justify-content-end mt-3 ">
                                                    <input type="number" class="w-50 ShippingCost" style="height:30px;" value="0" name="shippingCost" required>
                                                </div>
                                            </li>
                                            <li>
                                                <h4>TCS %</h4>
                                                <div class="form-group d-flex justify-content-end mt-3 ">
                                                    <input type="number" class="w-50 TCSCost" style="height:30px;" value="0" name="TCSCost" required>
                                                </div>
                                            </li>
                                            <li class="total">
                                                <h4>Grand Total</h4>
                                                <h5 class="totalGrandCost">₹ 0.00</h5>
                                                <input type="hidden" name="totalGrandCost" class="totalGrandCost-input">
                                                <input type="hidden" name="totalGrossCost" class="totalGrossCost-input">

                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Order Tax</label>
                                            <input type="text">
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Discount</label>
                                            <input type="text">
                                        </div>
                                    </div> -->
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Shipping</label>
                                            <input type="text">
                                        </div>
                                    </div> -->
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select class="select">
                                                <option>Choose Status</option>
                                                <option>Completed</option>
                                                <option>Inprogress</option>
                                            </select>
                                        </div>
                                    </div> -->
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Description</label>
                                        <textarea class="form-control" name="remarks"></textarea>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <!-- <a href="" class=" me-2">Submit</a> -->
                                    <input type="submit" value="Submit" class="btn btn-submit" id="submitBtn">
                                    <!-- <a href="javascript:void(0);" class="btn btn-cancel" id="cancelButton">Cancel</a> -->
                                </div>
                            </div>
                </form>

            </div>
        </div>
    </div>
    </div>
    </div>

    <!-- Modal for confirmation to delete -->
    <div class="modal fade" id="deleteConfirmationModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Confirmation</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this row?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" id="cancel-btn" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Delete</button>
                </div>
            </div>
        </div>
    </div>

    <!-- minimum one row limit -->
    <div class="modal fade" id="minimumRowModal" tabindex="-1" role="dialog" aria-labelledby="minimumRowModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="minimumRowModalLabel">Minimum Row Requirement</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    At least one row is required. You cannot delete the last row.
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">OK</button>
                </div>
            </div>
        </div>
    </div>

    <!-- add new rowa and avoid duplicate -->


    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/selectize.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/js/moment.min.js"></script>
    <script src="assets/js/bootstrap-datetimepicker.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>
    <script src="assets/js/invoice/addInvoice.js"></script>

    <script>
        function disableSelect(selectElement) {
            selectElement.removeAttribute("onchange");
            selectElement.classList.add("form-select");
            $('#hiddenLedger').val(selectElement.value);
            var selectizeInstance = $("#Ledger")[0].selectize;
        }
    </script>





    @if ($decode != "Empty")
    <script>
        $(document).ready(function() {
            $('#addRowBtn').hide();
            $('#Ledger').change(function() {
                var selectedLedgerCode = $(this).val();

                var selectedShippingCost = 0;

                $('#poNumber').empty();
                $('#poNumber').append('<option value="">--select--</option>');
                @foreach($decode as $index => $decodes2)
                var ledgerCode = '{{ $decodes2["Ledger_Code"] }}';
                var rowId = '{{ $decodes2["rowid"] }}';
                var productName = '{{ $decodes2["Product_Name"] }}';
                var qty = '{{ $decodes2["qty"] }}';
                var productPrice = '{{ $decodes2["rate"] }}';
                var discPer = '{{ $decodes2["discPer"] }}';
                var taxPer = '{{ $decodes2["taxPer"] }}';
                var netAmt = '{{ $decodes2["netAmt"] }}';
                var pono = '{{ $decodes2["grnNo"] }}';
                var ProdId = '{{ $decodes2["prodId"] }}';
                var allotAmt = '{{ $decodes2["allotAmt"] }}';
                var index = '{{ $index }}';

                if (ledgerCode == selectedLedgerCode) {
                    $('#poNumber').append('<option data-ledger-code="' + ledgerCode + '" value="' + rowId + '|' + productName + '|' + qty + '|' + productPrice + '|' + discPer + '|' + taxPer + '|' + netAmt + '|' + ledgerCode + '|' + index + '|' + ProdId + '|' + allotAmt + ' "> ' + pono + ' / ' + productName + ' / ' + qty + '</option>');

                    // Update the selected shipping cost when a matching ledger is found
                    selectedShippingCost = '{{ $decodes2["shipping"] }}';
                    selectedtcsCost = '{{ $decodes2["TCS_per"] }}';
                }
                @endforeach
                $('.ShippingCost').val(selectedShippingCost);
                $('.TCSCost').val(selectedtcsCost);
                $('#addRowBtn').show();
            });
        });
    </script>
    @endif





    <script>
        // Declare a variable to store the row to be deleted
        let rowToDelete;

        // Function to handle row deletion
        function deleteRow(row) {
            // Store the row to be deleted
            rowToDelete = row;

            let rowCount = $('#table tr').length;

            // Show the confirmation modal based on the row count
            if (rowCount > 3) {
                $('#deleteConfirmationModal').modal('show');
            } else {
                $('#minimumRowModal').modal('show');
            }
        }

        let selectedOptions = [];
        // Handle the click event for the "Delete" button in the modal
        $('#confirmDeleteBtn').click(function() {
            // Get the value of the deleted row's select element
            var deletedValue = rowToDelete.querySelector('#poNumber').value;

            // Remove the deleted value from the selectedOptions array
            var index = selectedOptions.indexOf(deletedValue);
            if (index !== -1) {
                selectedOptions.splice(index, 1);
            }

            // Remove the row from the table
            rowToDelete.parentNode.removeChild(rowToDelete);

            // Hide the confirmation modal
            $('#deleteConfirmationModal').modal('hide');

            // Call the updateTotalCost function after deleting a row
            updateTotalCost();
        });
    </script>


    @endsection
</body>

</html>