<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="VMS - Vehicle Management System">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <title>INVOICE</title>
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">


    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">


</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>


    <div class="main-wrapper">
        @extends('VMS.navbar')
        @section('content')
        <?php
        $invoiceViews = Session::get('invoiceViews');
        $invoiceEdit = Session::get('invoiceEdit');
        $invoiceEntry = Session::get('invoiceEntry');
        ?>
        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>Invoice Report</h4>
                        <!-- <h6>Manage your products</h6> -->
                    </div>
                    @if ($invoiceEntry == "Y" )
                    <div class="page-btn">
                        <a href="invAdd" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img" class="me-1">Add New Invoice</a>
                    </div>
                    @endif
                </div>

                <div class="card">
                    <div class="card-body">


                        <div class="table-responsive">
                            <table class="table  datanew">
                                <thead>
                                    <tr>
                                        @if ($invoiceViews == "Y" || $invoiceEdit == "Y")
                                        <th>Edit</th>
                                        @endif
                                        <th>ENo</th>
                                        <th>EDate</th>
                                        <th>Supplier</th>
                                        <th>Inv No</th>
                                        <th>Inv Date </th>
                                        <th>Discount</th>
                                        <th>Tax</th>
                                        <th>NetAmt</th>
                                        <!-- <th>Remarks</th> -->

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($decode as $decodes)
                                    <tr>

                                        @if ($invoiceViews == "Y" || $invoiceEdit == "Y")
                                        <td>
                                            @if ($invoiceViews == "Y")
                                            <a href="invView?mode=view&rowid={{ $decodes['Rowid'] }}&ENo={{ $decodes['ENo'] }}&Edate={{ $decodes['Edate'] }}&Invno={{ $decodes['Invno'] }}&Invdate={{ $decodes['Invdate'] }}&totaltax={{ $decodes['totaltax'] }}&totalDisc={{ $decodes['totalDisc'] }}&netAmt={{ $decodes['netAmt'] }}&Ledger_Name={{ $decodes['Ledger_Name'] }}&Ledger_Address={{ $decodes['Ledger_Address'] }}&remarks={{ $decodes['remarks'] }}&shipping={{ $decodes['shipping'] }}&ratedebit={{ $decodes['ratedebit'] }}&qtydebit={{ $decodes['qtydebit'] }}&tot_debit={{ $decodes['tot_debit'] }}" class="me-3 viewBtn">
                                                <img src="assets/img/icons/eye.svg" alt="img">
                                            </a>
                                            @endif
                                            @if ($invoiceEdit == "Y")
                                            <a class="me-5 editBtn" href="invEdit?mode=edit&rowid={{ $decodes['Rowid'] }}&ENo={{ $decodes['ENo'] }}&Edate={{ $decodes['Edate'] }}&Invno={{ $decodes['Invno'] }}&Invdate={{ $decodes['Invdate'] }}&totaltax={{ $decodes['totaltax'] }}&totalDisc={{ $decodes['totalDisc'] }}&netAmt={{ $decodes['netAmt'] }}&Ledger_Name={{ $decodes['Ledger_Name'] }}&Ledger_Address={{ $decodes['Ledger_Address'] }}&remarks={{ $decodes['remarks'] }}&shipping={{ $decodes['shipping'] }}&ratedebit={{ $decodes['ratedebit'] }}&qtydebit={{ $decodes['qtydebit'] }}&tot_debit={{ $decodes['tot_debit'] }}&grnrate={{ $decodes['grnrate'] }}&grnqty={{ $decodes['grnqty'] }}">
                                                <img src="assets/img/icons/edit.svg" alt="img">
                                            </a>
                                            @endif

                                        </td>
                                        @endif
                                        <td class="productimgname">

                                            <a href="javascript:void(0);">{{$decodes['ENo']}}</a>
                                        </td>
                                        <td>{{date('Y-m-d', strtotime($decodes['Edate']))}}</td>
                                        <td>{{$decodes['Ledger_Name']}}</td>
                                        <td>{{$decodes['Invno']}}</td>
                                        <td>
                                            {{ date('Y-m-d', strtotime($decodes['Invdate'])) }}
                                        </td>
                                        <td>₹.{{$decodes['totalDisc']}}</td>
                                        <td>₹.{{$decodes['totaltax']}}</td>
                                        <td>₹.{{$decodes['netAmt']}}</td>
                                    </tr>
                                    </form>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    @if ($message = Session::get('SuccessMsg'))
                    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                        {{$message}}

                    </div>

                    <script>
                        // Automatically close the alert after 3 seconds
                        setTimeout(function() {
                            var successAlert = document.getElementById('successAlert');
                            if (successAlert) {
                                successAlert.remove();
                            }
                        }, 5000);
                    </script>
                    @endif
                </div>

            </div>
        </div>
    </div>


    <script src="assets/js/jquery-3.6.0.min.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>
    <script>
        dataTableInstance.destroy();
        $('#DataTables_Table_0').DataTable();
    </script>
    @endsection
</body>

</html>