<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="POS - Bootstrap Admin Template">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <meta name="author" content="Dreamguys - Bootstrap Admin Template">
    <meta name="robots" content="noindex, nofollow">
    <title>ISSUE</title>

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">

</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>
    <div class="main-wrapper">
        @extends('VMS.navbar')
        <form action=" {{ route('issue_entry_edit_save')}} " enctype="multipart/form-data" method="post">
            @csrf
            <div class="page-wrapper">
                <div class="content">
                    <div class="page-header">
                        <div class="page-title">
                            <h4>ISSUE ENTRY EDIT</h4>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-2 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>ENO<span style="color:red;font-size: 20px;font-weight:bold"></span></label>
                                        <input type="text" value="{{request('Eno')}}" name="eno" readonly>
                                        <input type="hidden" name="master_id" value="{{ request('id') }}" required>
                                        <input type="hidden" name="details_id" value="{{ request('d_id') }}" required>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Service Name<span style="color:red;font-size: 20px;font-weight:bold">*</span></label>
                                        <div class="form-group">
                                            <input type="hidden" name="" value="{{ request('Service_Name') }}" required>
                                            <select class="select2" name="service" required>
                                                <option value="" disabled>--SELECT--</option>
                                                @foreach($resultS as $service)
                                                <option value="{{ $service['RowID'] }}" {{ $service['Name'] === request('Service_Name') ? 'selected' : '' }}>
                                                    {{ $service['Name'] }}
                                                </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Vehicle No<span style="color:red;font-size: 20px;font-weight:bold">*</span></label>
                                        <div class="form-group">
                                            <input type="hidden" name="" value="{{ request('Vehicle_No') }}" required>
                                            <select class="select2" name="vno" required>
                                                <option value="" disabled>--SELECT--</option>
                                                @foreach($resultV as $vehno)
                                                <option {{ $vehno['vehno'] === request('Vehicle_No') ? 'selected' : '' }}>{{$vehno['vehno']}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group"><label>Date<span style="color:red;font-size: 20px;font-weight:bold"></span></label>
                                        <div class="input-groupicon">
                                            <input type="hidden" name="product_name" value="{{ request('EDate') }}" required>
                                            <input type="text" placeholder="DD-MM-YYYY" class="datetimepicker" name="date" value="{{ request('EDate') }}" required readonly>
                                            <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            
                            <div class="row">
                                <div class="table-responsive">
                                    <table class="table" id="myTable">
                                        <thead>
                                            <tr>
                                                <th>Product <span style="color:red;font-size: 20px;font-weight:bold">*</span></th>
                                                <th>Qty <span style="color:red;font-size: 20px;font-weight:bold">*</span></th>
                                                <th>Attachment</th>
                                                <th>Delete</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($resultSh as $index => $result )
                                            <tr>
                                                <td>
                                                    <input type="hidden" name="products[]" id="products" value="{{$result['ProdId']}}|{{ $result['Stock'] }}|{{ $result['GRN_ID'] }}" required>
                                                    {{$result['grnNo']}}|{{$result['Product_Name']}}|{{ $result['Stock'] }}
                                                </td>
                                                <td>
                                                    <div class="form-group">
                                                        <input type="hidden" name="qty_id[]" required>
                                                        <input type="number" name="qty[]" value="{{ $result['Qty'] }}" style="height: 30px !important; width:70px;" min="1" max="{{ $result['Stock'] }}" oninput="validateQuantity(this)" required>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="col-lg-12 col-sm-12 col-12">
                                                        <div class="form-group">
                                                            <label class="custom-file-container__custom-file">
                                                                <input class="" type="file" id="formFile1" name="formFile1[]">
                                                                <input type="hidden" name="oldimg[]" value="{{ $result['Image'] }}">
                                                                @if($result['Image'] && $result['Image'] != 'No Image')
                                                                <img src="{{ $result['Image'] }}" style="max-width: 100%; height: auto; align-items: center; display:none;" id="previewImage{{$loop->index}}">
                                                                <button type="button" onclick="toggleImageVisibility('{{ $result['Image'] }}')">View Image</button>
                                                                @else
                                                                <span>No Image Uploaded</span>
                                                                @endif
                                                            </label>
                                                            <script>
                                                                function toggleImageVisibility(imageUrl) {
                                                                    window.open(imageUrl, '_blank');
                                                                }
                                                            </script>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <a class="delete-set" onclick="deleteRow(this)"><img src="assets/img/icons/delete.svg" alt="svg"></a>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <br>
                            <div class="row">
                            <div class="col-lg-1  col-sm-12 col-10 mb-5">
                                <label>Add product</label>
                                <div class="add-icon mt-2">
                                    <a href="javascript:void(0);" id="addRowBtn" onclick="addRow()"><img src="assets/img/icons/plus1.svg" alt="img"></a>
                                </div>
                            </div>
                            <div class="col-lg-11">
                                    <label>Description</label>
                                    <textarea class="form-control" value="" name="des">{{ request('Description') }}</textarea>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <button class="btn btn-submit me-2" type="submit">UPDATE</button><br><br>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>

    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/feather.min.js"></script>
    <script src="assets/js/jquery.slimscroll.min.js"></script>
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/plugins/select2/js/select2.min.js"></script>
    <script src="assets/js/moment.min.js"></script>
    <script src="assets/js/bootstrap-datetimepicker.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>
    <script src="assets/js/script.js"></script>


    <!-- ADDING ROWS -->
    <script>
        function addRow() {
            var table = document.getElementById("myTable"); // Assuming your table has an ID "myTable"
            var newRow = table.insertRow(table.rows.length); // Insert a new row at the end

            // Define the cells for the new row
            var cell1 = newRow.insertCell(0);
            var cell2 = newRow.insertCell(1);
            var cell3 = newRow.insertCell(2);
            var cell4 = newRow.insertCell(3);
            // var cell5 = newRow.insertCell(4);

            // Set the content for each cell (you can customize this based on your needs)
            // cell1.innerHTML = table.rows.length - 1; // Serial number
            cell1.innerHTML =  '<div class="col-lg-12 col-sm-12 col-12">' +
                                '<div class="form-group">' +
                                    '<select class="select2" name="products[]"  required>' +
                                        '<option value="" disabled selected>--SELECT--</option>' +
                                        getDropdownOptions() +
                                    '</select>' +
                                '</div>' +
                            '</div>';
            // cell3.innerHTML = `<div class="form-group">
            //                         <input type="text" name="stock" value="{{ request('Stock') }}" style="height: 30px !important; width:70px;" readonly>
            //                     </div>`;
            cell2.innerHTML = '<div class="form-group">'+
                                    '<input type="number" name="qty[]" style="height: 30px !important; width:70px;" min="0" oninput="validateQuantity(this)" required>'+
                                '</div>';
            cell3.innerHTML = `<div class="col-lg-12 col-sm-12 col-12">
                                    <div class="form-group">
                                        <label class="custom-file-container__custom-file">
                                            <input class=" col-lg-6form-control" type="file" id="formFile1" name="formFile1[]">
                                            <!-- <img src="{{ request ('Image') }}" alt="Product Image" style="max-width: 10%; height: 10%; align-items:center"> -->
                                            <!-- <input type="file" name="Prod_Img[]" id="prodImgInput" accept="image/*" onchange="previewImage()"> -->
                                        </label>
                                        <div id="imagePreview" style="display:none; text-align: center;">
                                            <img id="preview" alt="Selected Image" style="max-width: 50%; height: 50px;">
                                        </div>
                                    </div>
                                </div>`;
            cell4.innerHTML = `<a class="delete-set"><img src="assets/img/icons/delete.svg" alt="svg"></a>`

            // After inserting the new row, initialize Select2 for the new dropdown
            $('.select2').select2();
        }
            // Attach event listener for delete-set
            var deleteSetElements = document.querySelectorAll('.delete-set');
            deleteSetElements.forEach(function(deleteSetElement) {
                deleteSetElement.addEventListener('click', function() {
                    var row = deleteSetElement.closest('tr');
                    row.parentNode.removeChild(row);
                });
            });

            function getDropdownOptions() {
                var selectedProducts = [];
                var rows = document.getElementById("myTable").getElementsByTagName("select");
                for (var i = 0; i < rows.length; i++) {
                    var selectedValue = rows[i].value;
                    if (selectedValue) {
                        selectedProducts.push(selectedValue);
                    }
                }

                var optionsHtml = "";
                @foreach($resultP as $product)
                    var productValue = "{{ $product['Prod_ID'] }}|{{ $product['Stock_Qty'] }}|{{ $product['Grn_ID'] }}";
                    if (!selectedProducts.includes(productValue)) {
                        optionsHtml += '<option value="' + productValue + '">' +
                                            '{{ $product['Grn_No'] }}|{{ $product['Product_Name'] }}|{{ $product['Stock_Qty'] }}' +
                                        '</option>';
                    }
                @endforeach

                return optionsHtml;
            }
    

        function getDropdownOptions() {
            var selectedProducts = [];
            var rows = document.getElementById("myTable").getElementsByTagName("select");
            for (var i = 0; i < rows.length; i++) {
                var selectedValue = rows[i].value;
                if (selectedValue) {
                    selectedProducts.push(selectedValue);
                }
            }

        var optionsHtml = "";
        @foreach($resultP as $product)
            var productValue = "{{ $product['Prod_ID'] }}|{{ $product['Stock_Qty'] }}|{{ $product['Grn_ID'] }}";
            if (!selectedProducts.includes(productValue)) {
                optionsHtml += '<option value="' + productValue + '">' +
                                    '{{ $product['Grn_No'] }}|{{ $product['Product_Name'] }}|{{ $product['Stock_Qty'] }}' +
                                '</option>';
            }
        @endforeach

        return optionsHtml;
        }

    </script>

    <!-- QTY NOT EXCEED TO STOCK QTY -->
    <script>
        function validateQuantity(quantityInput) {
            var enteredQty = parseInt(quantityInput.value);
            var row = quantityInput.closest('tr'); // Get the closest row of the quantity input
            var selectElement = row.querySelector('select[name="products[]"]');
            var availableStock = parseInt(selectElement.value.split('|')[1]);

            // Check if the entered quantity is negative, zero, or exceeds the available stock
            if (enteredQty < 0 || enteredQty > availableStock) {
                // SETS THE MAXIMUM AVAILABLE STOCK IN THE QTY FIELD
                // quantityInput.value = Math.max(1, Math.min(enteredQty, availableStock));

                alert("Entered Quantity is Greater than the Available Stock : " + availableStock);
                quantityInput.value = "";
            }
            // Check if the entered quantity is zero
            if (enteredQty === 0) {
                alert("Entered Quantity cannot be zero.");
                quantityInput.value = "";
            }
        }
    </script>


    <!-- SEARCH -->
    <script>
        // Initialize Select2
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('SuccessMsg'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}

    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 3000);
    </script>
    @endif

    @if ($message = Session::get('errorMsg'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}

    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 3000);
    </script>
    @endif


</body>

</html>