<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="POS - Bootstrap Admin Template">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <meta name="author" content="Dreamguys - Bootstrap Admin Template">
    <meta name="robots" content="noindex, nofollow">
    <title>ISSUE</title>

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">
    <!-- <link rel="shortcut icon" type="image/x-icon" href="{{asset('frontend/img/vms (1).png')}}"> -->

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" href="assets/css/animate.css">

    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <link rel="stylesheet" href="assets/css/style.css">

    <!-- FOR EXPORT -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>


</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">

        @extends('VMS.navbar')
        <?php
        $issueEdit = Session::get('issueEdit');
        $issueViews = Session::get('issueViews');
        $issueEntry = Session::get('issueEntry');
        ?>
        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>ISSUE REPORT</h4>
                        <!-- <h6>Manage your products</h6> -->
                    </div>
                    @if ($issueEntry == "Y")
                    <div class="page-btn">
                        <a href="issue_entry" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img" class="me-1">Add New Iss Entry</a>
                    </div>
                    @endif
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="table-top">
                            <div class="search-set">

                                <div class="search-input">
                                    <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                                </div>
                            </div>

                        </div>

                        <div class="table-responsive">

                            <table class="table datanew" id="table">
                                <thead>
                                    <tr>
                                        @if ($issueViews == "Y" || $issueEdit == "Y")
                                        <th>Options</th>
                                        @endif
                                        <th style="display: none;">Rowid</th>
                                        <th>Sno</th>
                                        <th>Eno</th>
                                        <th>Date</th>
                                        <th>Product Name</th>
                                        <th>Vehicle_No</th>
                                        <th>Service Name</th>
                                        <th>Quantity</th>
                                        <th>Description</th>
                                        <th style="display: none;">Image</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($result as $index => $row)
                                    <tr>

                                        @if ($issueViews == "Y" || $issueEdit == "Y")
                                        <td>
                                            @if ($issueViews == "Y")
                                            <a class="me-3" href="issue_entry_view?mode=view&id={{$row['Master_rowid']}}&EDate={{$row['EDate']}}&Eno={{$row['ENo']}}&Product_Name={{$row['Product_Name']}}&Service_Name={{$row['Service_Name']}}&Qty={{$row['Qty']}}&Description={{$row['Description']}}&Image={{$row['Image']}}&Vehicle_No={{$row['Vehicle_No']}}">
                                                <img src="assets/img/icons/eye.svg" alt="View">
                                            </a>

                                            @endif
                                            @if ($issueEdit == "Y")
                                            <a class="me-3" href="issue_entry_edit?mode=view&id={{$row['Master_rowid']}}&d_id={{$row['Detail_rowid']}}&Eno={{$row['ENo']}}&Stock={{$row['Stock']}}&EDate={{$row['EDate']}}&Product_Name={{$row['Product_Name']}}&Service_Name={{$row['Service_Name']}}&Qty={{$row['Qty']}}&Description={{$row['Description']}}&Image={{$row['Image']}}&Vehicle_No={{$row['Vehicle_No']}}">
                                                <img src="assets/img/icons/edit.svg" alt="View">
                                            </a>
                                            @endif
                                        </td>
                                        @endif
                                        <td style="display: none;"> {{ $row ['Master_rowid'] }} </td>
                                        <td> {{ $index + 1 }} </td>
                                        <td> {{ $row ['ENo'] }} </td>
                                        <td> {{ date('Y-m-d', strtotime($row ['EDate'])) }} </td>
                                        <td> {{ $row ['Product_Name'] }} </td>
                                        <td> {{ $row ['Vehicle_No'] }} </td>
                                        <td> {{ $row ['Service_Name'] }} </td>
                                        <td> {{ $row ['Qty'] }} </td>
                                        <td> {{ $row ['Description'] }} </td>
                                        <td style="display: none;">
                                            @if($row['Image'] !== "null")
                                            <a href="{{ $row['Image'] }}" class="mr-5 file-link" id="link2" name="filepath" target="" title="{{ $row['Image'] }}">Image</a>
                                            @else
                                            --
                                            @endif
                                        </td>
                                    </tr>

                                    @endforeach
                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/feather.min.js"></script>
    <script src="assets/js/jquery.slimscroll.min.js"></script>
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/plugins/select2/js/select2.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>
    <script src="assets/js/script.js"></script>


    <!-- PRINT -->
    <script>
        document.getElementById('print').addEventListener('click', function() {
            window.print();
        })
    </script>

    <!-- EXPORT AS EXCEL -->
    <script>
        function export_table_to_xlsx(table, filename) {
            var wb = XLSX.utils.table_to_book(table, {
                sheet: "Sheet1"
            });

            var ws = wb.Sheets["Sheet1"];

            // Calculate column widths based on content
            var range = XLSX.utils.decode_range(ws['!ref']);
            for (var C = range.s.c; C <= range.e.c; ++C) {
                var max_len = 0;
                for (var R = range.s.r; R <= range.e.r; ++R) {
                    var cell = ws[XLSX.utils.encode_cell({
                        r: R,
                        c: C
                    })];
                    if (cell && cell.v) {
                        var len = String(cell.v).length;
                        if (len > max_len) {
                            max_len = len;
                        }
                    }
                }
                if (max_len > 0) {
                    ws['!cols'] = ws['!cols'] || [];
                    ws['!cols'][C] = {
                        wch: max_len + 2
                    };
                }
            }

            XLSX.writeFile(wb, filename);

        }

        document.querySelector("#toEXCEL").addEventListener("click", function() {
            var table = document.querySelector("table");
            export_table_to_xlsx(table, "Issue_Entry.xlsx");
        });
    </script>

</body>

</html>