<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="POS - Bootstrap Admin Template">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <meta name="author" content="Dreamguys - Bootstrap Admin Template">
    <meta name="robots" content="noindex, nofollow">
    <title>ISSUE</title>

    <link rel="shortcut icon" type="image/x-icon" href="/assets/img/favicon.png">
    <link rel="stylesheet" href="/assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="/assets/css/bootstrap-datetimepicker.min.css">
    <link rel="stylesheet" href="/assets/css/animate.css">
    <link rel="stylesheet" href="/assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="/assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="/assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="/assets/plugins/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="/assets/css/style.css">
    <link rel="stylesheet" href="/assets/css/selectize.css">


    <style>
        .form-control {
            height: 15% !important;
        }
    </style>

        <!-- HIDE COMPANY NAME WHEN PRINTING THE PAGE -->
    <style>
        @media print {
            .user-menu {
                display: none !important;
            }
        }
    </style>

</head>

<body>


    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">
        @extends('VMS.navbar')
        <!-- ============================================================================================== -->

        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>ISSUE ENTRY DETAILS</h4>
                        <!-- <h6>Full details of a Issue Entry</h6> -->
                    </div>
                    <a class="printimg" id="print">
                        <img src="/assets/img/icons/printer.svg" alt="print">
                    </a>
                </div>



                <!-- Blade 2 -->
                <!-- Assuming you have a ProductController with a method named edit -->
                <form action="" method="POST">
                    @csrf
                    <div class="container">
                        @foreach ($resultSh as $res)
                        <div class="row">
                            <div class="col-lg-8 col-sm-12">
                                <div class="card">
                                    <div class="card-body">
                                        <!-- <div class="bar-code-view">
                                        <img src="{{asset('frontend/img/barcode1.png')}}" alt="barcode">
                                    </div> -->
                                        <div class="productdetails">
                                            <ul class="product-bar">
                                                <li>
                                                    <h4>ENo</h4>
                                                    <h6>{{ $res['ENo'] }}</h6>
                                                </li>
                                                <li>
                                                    <h4>Date</h4>
                                                    <h6>{{ date('d-m-Y', strtotime($res['EDate'])) }}</h6>
                                                </li>
                                                <li>
                                                    <h4>Product Name</h4>
                                                    <h6>{{ $res['Product_Name'] }}</h6>
                                                </li>
                                                <li>
                                                    <h4>Service Name</h4>
                                                    <h6>{{ $res['Service_Name'] }}</h6>
                                                </li>
                                                <li>
                                                    <h4>Quantity</h4>
                                                    <h6>{{ $res['Qty'] }}</h6>
                                                </li>
                                                <li>
                                                    <h4>Description</h4>
                                                    <h6>{{ $res['Description'] }}</h6>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-4 col-sm-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="slider-product-details">
                                            <div class="slider-product">
                                                <!-- @if($res['Image'])
                                                <img src="{{ $res['Image'] }}" style="max-width: 100%; height: auto; align-items: center;">
                                                <p>Uploaded Image</p>
                                                @else
                                                <p>No Image Uploaded</p>
                                                @endif -->

                                                @if($res['Image'] && $res['Image'] !== 'No Image')
                                                <img src="{{ $res['Image'] }}" style="max-width: 100%; height: auto; align-items: center;">
                                                <p>Uploaded Image</p>
                                                @else
                                                <p>No Image Uploaded</p>
                                                @endif


                                            </div>

                                            <!-- @if(request('prod_img') == 'No Image')
                                            <p>No Image Uploaded</p>
                                            @elseif(request('prod_img'))
                                            <p>Uploaded Image</p>
                                            @else
                                            <p>No Image Uploaded</p>
                                            @endif -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </form>
            </div>
        </div>
    </div>


    <script src="/assets/js/jquery-3.6.0.min.js"></script>
    <script src="/assets/js/selectize.js"></script>
    <script src="/assets/js/feather.min.js"></script>
    <script src="/assets/js/jquery.slimscroll.min.js"></script>
    <script src="/assets/js/jquery.dataTables.min.js"></script>
    <script src="/assets/js/dataTables.bootstrap4.min.js"></script>
    <script src="/assets/js/bootstrap.bundle.min.js"></script>
    <script src="/assets/plugins/select2/js/select2.min.js"></script>
    <script src="/assets/js/moment.min.js"></script>
    <script src="/assets/js/bootstrap-datetimepicker.min.js"></script>
    <script src="/assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="/assets/plugins/sweetalert/sweetalerts.min.js"></script>
    <script src="/assets/plugins/fileupload/fileupload.min.js"></script>
    <script src="/assets/js/script.js"></script>
    <script src="/assets/plugins/fileupload/fileupload.min.js"></script>


    <script>
        document.getElementById('print').addEventListener('click', function() {
            window.print();
        })
    </script>
    <!-- SELECTED PRODUCT SHOWN IN INPUT BOX -->
    <script>
        $(document).ready(function() {
            // Change event for all dropdowns with the class "select"
            $(".select").change(function() {
                updateProductName();
            });

            // Function to update PRODUCT NAME based on selected options
            function updateProductName() {
                var itemText = $(".itemDropdown option:selected").text();
                var typeName = $(".typeDropdown option:selected").text();
                var sizeName = $(".sizeDropdown option:selected").text();

                // Filter out the "Choose Category" option
                var selectedOptions = [itemText, typeName, sizeName].filter(option => option !== 'Choose Category');

                // Concatenate selected options with " | " separator
                var result = selectedOptions.filter(Boolean).join('  ');

                // Set the result as the value of the correct input field (update the ID if needed)
                $("#product_name").val(result);
            }
        });
    </script>


    <!-- .00 for Tax & Price -->
    <script>
        $(document).ready(function() {
            // Attach an event listener to the DISCOUNT input field
            $("#discountInput").on('blur', function() {
                formatDecimalInput($(this));
            });

            // Attach an event listener to the PRICE input field
            $("#priceInput").on('blur', function() {
                formatDecimalInput($(this));
            });

            // Function to format input as a decimal with two decimal places
            function formatDecimalInput(inputField) {
                // Get the entered value
                var inputValue = inputField.val();

                // Convert the value to a decimal with two decimal places
                var formattedValue = parseFloat(inputValue).toFixed(2);

                // Set the formatted value back to the input field
                inputField.val(formattedValue);
            }
        });
    </script>

    <!-- IMAGE -->
    <script>
        function previewImage() {
            var input = document.getElementById('prodImgInput');
            var preview = document.getElementById('preview');
            var previewContainer = document.getElementById('imagePreview');

            var file = input.files[0];

            if (file) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    preview.src = e.target.result;
                    previewContainer.style.display = 'block';
                };

                reader.readAsDataURL(file);

                // } else {
                //     preview.src = '';
                //     previewContainer.style.display = null;
                previewContainer.style.display = 'block';

                // Hide the img2 div
                document.querySelector('.img2').style.display = 'none';
            }
        }
    </script>

</body>

</html>