<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="POS - Bootstrap Admin Template">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <meta name="author" content="Dreamguys - Bootstrap Admin Template">
    <meta name="robots" content="noindex, nofollow">
    <title>MASTER ENTRY</title>

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">

    <link rel="stylesheet" href="assets/css/animate.css">

    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/selectize.css">

</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"></div>
    </div>

    <form id="validate" method="POST" action="{{ route('type_save') }}">
        @csrf

        @extends('VMS.navbar')

        <div class="page-wrapper">
            <div class="content">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            @if ($message = Session::get('success'))
                            <div class="alert alert-success" id="success-alert">
                                <p>{{ $message }}</p>
                            </div>
                            @endif
                            @if(session('alert'))
                            <style>
                                .custom-light-red-alert {
                                    background-color: #ffcccc;
                                    /* Light Red Color */
                                    border-color: #ff9999;
                                    /* Border Color */
                                    color: #0b0b10;
                                    /* Text Color */
                                }
                            </style>

                            <svg xmlns="http://www.w3.org/2000/svg" class="d-none">
                                <symbol id="exclamation-triangle-fill" viewBox="0 0 16 16">
                                    <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                </symbol>
                            </svg>

                            <div class="alert custom-light-red-alert d-flex align-items-center" role="alert">
                                <svg class="bi flex-shrink-0 me-2" role="img" aria-label="Danger:" style="width: 40px; height: 40px;">
                                    <use xlink:href="#exclamation-triangle-fill" />
                                </svg>
                                <div class="mr-3"></div>
                                {{ session('alert') }}
                            </div>
                            @endif
                        </div>
                    </div>

                    <div class="page-header">
                        <div class="page-title">
                            <h4>TYPE EDIT</h4>
                            <h6>Update your Type</h6>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            <div class="row">

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Type Name</label>
                                        <input type="text" id="type" name="type" value="{{ request('Name') }}">
                                        <input type="hidden" id="rowid" name="rowid" value="{{ request('Rowid') }}">
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Description</label>
                                        <input type="text" id="desc" name="desc" value="{{ request('Descrip') !== 'null' ? request('Descrip') : '' }}">
                                        <!-- <textarea class="form-control" id="desc" name="desc"></textarea> -->
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <input type="submit" name="submit" value="SAVE CHANGES" id="saveButton" class="btn btn-submit">
                                    <input type="button" name="reportButton" value="BACK " class="btn btn-dark btn-lg" onclick="window.location.href = '/VMS_type_list'">



                                    <!-- <button type="button" id="reportButton" class="btn btn-dark" onclick="window.location.href = '/VMS_type_list'">Back</button> -->


                                    <script src="assets/js/jquery-3.6.0.min.js"></script>
                                    <script src="assets/js/selectize.js"></script>

                                    <script src="assets/js/feather.min.js"></script>

                                    <script src="assets/js/jquery.slimscroll.min.js"></script>

                                    <script src="assets/js/jquery.dataTables.min.js"></script>
                                    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

                                    <script src="assets/js/bootstrap.bundle.min.js"></script>

                                    <script src="assets/plugins/select2/js/select2.min.js"></script>

                                    <script src="assets/js/moment.min.js"></script>
                                    <script src="assets/js/bootstrap-datetimepicker.min.js"></script>

                                    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
                                    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

                                    <script src="assets/js/script.js"></script>

                                    <script>
                                        function clearPage() {
                                            // Reload the current page
                                            window.location.reload();
                                        }
                                    </script>

                                    <!-- <script>
                                        // Add this script at the end of your HTML file, just before the </body> tag

                                        // Set a timeout function to hide the alert after 45 seconds
                                        setTimeout(function() {
                                            $('#success-alert').fadeOut('slow');
                                        }, 45000); // 45 seconds in milliseconds
                                    </script> -->

                                    <script>
                                        function toggleTable() {
                                            var tableContainer = document.querySelector('.table-container');
                                            tableContainer.style.display = (tableContainer.style.display === 'none' || tableContainer.style.display === '') ? 'block' : 'none';
                                        }
                                    </script>

    </form>
</body>

</html>