<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="POS - Bootstrap Admin Template">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <meta name="author" content="Dreamguys - Bootstrap Admin Template">
    <meta name="robots" content="noindex, nofollow">
    <title>MASTER ENTRY</title>

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">

    <link rel="stylesheet" href="assets/css/animate.css">

    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/selectize.css">

</head>

<body>

    <div id="global-loader">
        <div class="whirly-loader"></div>
    </div>
    @extends('VMS.navbar')
    @section('content')
    <?php
    $masterEntry = Session::get('masterEntry');
    $masterEdit = Session::get('masterEdit');
    $masterViews = Session::get('masterViews');
    ?>

    <div class="page-wrapper">
        <div class="content">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        @if ($message = Session::get('success'))
                        <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                            <p>{{ $message }}</p>
                        </div>
                        @endif

                        @if(session('alert'))
                        <div id="successAlert1" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                            {{ session('alert') }}
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <div class="page-header">
                <div class="page-title">
                    <h4>Sub-Category List</h4>
                </div>
                @if ($masterEntry == "Y" )
                <div class="page-btn">
                    <a href="VMS_add_sub_cat" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img" class="me-1">Add New Sub-Category</a>
                </div>
                @endif
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="table-top">
                        <div class="search-set">
                            <div class="search-path">

                            </div>
                            <div class="search-input">
                                <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                            </div>
                        </div>
                        <div class="wordset">
                            <ul>
                                <li>
                                    <a data-bs-toggle="tooltip" data-bs-placement="top" title="excel" id="toEXCEL"><img src="assets/img/icons/excel.svg" alt="img"></a>
                                </li>
                                <li>
                                    <a data-bs-toggle="tooltip" data-bs-placement="top" title="print" id="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
                                </li>
                            </ul>
                        </div>
                    </div>


                    <table id="app_table" class="table datanew">
                        <thead class="sticky-header">
                            <tr>

                                <th>SNO</th>
                                <th>Sub-Category</th>
                                <th>Description</th>
                                @if ($masterEdit == "Y" || $masterViews == "Y")
                                <th></th>
                                @endif




                            </tr>


                        </thead>
                        <tbody>
                            @foreach($details as $index => $row)
                            <tr>


                                <td>{{ $index + 1 }}</td>
                                <td>{{ $row['Name'] }}</td>
                                <td>
                                    @if($row['Descrip'] !== "null")
                                    {{ $row['Descrip'] }}
                                    @else

                                    @endif
                                </td>

                                  @if ($masterEdit == "Y" || $masterViews == "Y")
                                <td>
                                    @if ( $masterViews == "Y")
                                    <a class="me-3" href="VMS_sub_cat_view?mode=view&Rowid={{ $row['Rowid'] }}&Name={{ $row['Name'] }}&Descrip={{ $row['Descrip'] }}">
                                        <img class="icon-img" src="assets/img/icons/eye.svg" alt="img">
                                    </a>
                                    @endif
                                    @if ($masterEdit == "Y" )
                                    <a class="me-3" href="VMS_edit_sub_cat?mode=view&Rowid={{ $row['Rowid'] }}&Name={{ $row['Name'] }}&Descrip={{ $row['Descrip'] }}">
                                        <img class="icon-img" src="assets/img/icons/edit.svg" alt="img">
                                    </a>
                                    @endif
                                    <!-- <a class="confirm-text" href="javascript:void(0);">
                                            <img class="icon-img" src="assets/img/icons/delete.svg" alt="img">
                                        </a> -->
                                </td>
                                @endif


                            </tr>
                            @endforeach

                        </tbody>

                    </table>
                </div>
            </div>

        </div>
    </div>
    </div>



    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/selectize.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/js/moment.min.js"></script>
    <script src="assets/js/bootstrap-datetimepicker.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>

    <!-- PRINT -->
    <script>
        document.getElementById('print').addEventListener('click', function() {
            window.print();
        })
    </script>

    <!-- EXPORT AS EXCEL -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.5/xlsx.full.min.js"></script>
    <script>
        function export_table_to_xlsx(table, filename) {
            var wb = XLSX.utils.table_to_book(table, {
                sheet: "Sheet1"
            });

            var ws = wb.Sheets["Sheet1"];

            // Calculate column widths based on content
            var range = XLSX.utils.decode_range(ws['!ref']);
            for (var C = range.s.c; C <= range.e.c; ++C) {
                var max_len = 0;
                for (var R = range.s.r; R <= range.e.r; ++R) {
                    var cell = ws[XLSX.utils.encode_cell({
                        r: R,
                        c: C
                    })];
                    if (cell && cell.v) {
                        var len = String(cell.v).length;
                        if (len > max_len) {
                            max_len = len;
                        }
                    }
                }
                if (max_len > 0) {
                    ws['!cols'] = ws['!cols'] || [];
                    ws['!cols'][C] = {
                        wch: max_len + 2
                    };
                }
            }

            XLSX.writeFile(wb, filename);
        }

        document.querySelector("#toEXCEL").addEventListener("click", function() {
            var table = document.querySelector("table");
            export_table_to_xlsx(table, "Sub_Category_list.xlsx");
        });
    </script>

    <!-- HIDE SUCCES MSG -->
    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 3000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('successAlert1');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 3000);
    </script>

@endsection
</body>

</html>