<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="POS - Bootstrap Admin Template">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">

    <title> VMS</title>
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">
    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/selectize.css">

    <style>
        .form-check-container {
            display: flex;
            gap: 20px;
        }
    </style>

</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">

        @extends('VMS.navbar')
        @section('content')


        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>Service Entry</h4>
                        <!-- <h6>Create new product</h6> -->
                    </div>
                    <div class="page-title">
                        <h4>Alloted Amount : <span id="allotAmt">0.0</span></h4>
                    </div>
                    <div class="page-title">
                        <h4>Used Amount : <span id="usedAmt">0.0</span></h4>
                    </div>
                    <div class="page-title">
                        <h4>Balance Amount : <span id="BalAmt">0.0</span></h4>
                    </div>
                </div>

                <form action="ovmSave" method="post">
                    @csrf
                    <div class="card">
                        <div class="card-body">
                            <div class="row">

                                <!-- SPECIAL APPROVAL BUTTON -->
                                <div class="col-lg-3 col-sm-6 col-12" id="approval">
                                    <div>
                                        <label>Special Approve</label>
                                        <div class="form-check mt-2">
                                            <input class="form-check-input" value="Y" type="checkbox" name="specialApprove" id="specialApprove">
                                            <label class="form-check-label">
                                                Check
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <!-- NORMAL MODE -->
                                <div class="col-lg-3 col-sm-6 col-12" id="ch_primary">
                                    <div class="d-flex flex-column">
                                        <div>
                                            <label>Pay Mode </label>
                                            <div class="form-check-container">
                                                <div class="form-check">
                                                    <input class="form-check-input" value="Y" type="radio" name="cashMode" id="flexRadioDefault1" required checked>
                                                    <label class="form-check-label" for="flexRadioDefault1">
                                                        Cash
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" value="N" type="radio" name="cashMode" id="flexRadioDefault2" required>
                                                    <label class="form-check-label" for="flexRadioDefault2">
                                                        Cheque
                                                    </label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="mt-2">
                                            <label>Service Type</label>
                                            <div class="form-check-container">
                                                <div class="form-check">
                                                    <input class="form-check-input" value="N" type="radio" name="spareMode" id="flexRadioDefault3" required checked>
                                                    <label class="form-check-label" for="flexRadioDefault3">
                                                        Tyre
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" value="Y" type="radio" name="spareMode" id="flexRadioDefault4" required>
                                                    <label class="form-check-label" for="flexRadioDefault4">
                                                        Spares
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- SPECIAL MODE -->
                                <div class="col-lg-3 col-sm-6 col-12" id="ch_secondary" style="display: none;">
                                    <div class="d-flex flex-column">
                                        <div>
                                            <label>Special Pay Mode </label>
                                            <div class="form-check-container">
                                                <div class="form-check">
                                                    <input class="form-check-input" value="Y" type="radio" name="sp_cashMode" checked>
                                                    <label class="form-check-label">
                                                        Cash
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" value="N" type="radio" name="sp_cashMode">
                                                    <label class="form-check-label">
                                                        Cheque
                                                    </label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="mt-2">
                                            <label>Special Service Type</label>
                                            <div class="form-check-container">
                                                <div class="form-check">
                                                    <input class="form-check-input" value="N" type="radio" name="sp_spareMode" checked>
                                                    <label class="form-check-label">
                                                        Tyre
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" value="Y" type="radio" name="sp_spareMode">
                                                    <label class="form-check-label">
                                                        Spares
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Eno </label>
                                        <input type="text" value="{{$Eno}}" name="Eno" readonly required>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>EDate </label>
                                        <div class="input-groupicon">
                                            <input type="text" name="Edate" placeholder="DD-MM-YYYY" class="datetimepicker" id="Edate" readonly required>
                                            <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12 mt-4">
                                    <div class="form-group">
                                        <label>Company Name</label>
                                        <?php
                                        $companyName = Session('CompName');
                                        $CompanyCode = Session('CompanyCode');
                                        ?>

                                        <input type="text" name="" value="{{$companyName}}" readonly required>
                                        <input type="hidden" name="compcode" value="{{$CompanyCode}}" readonly required>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12 mt-4">
                                    <div class="form-group">
                                        <label>Vehicle No</label>
                                        <select class="" placeholder="select" id="Vno" name="vehicleNo" required>
                                            <option value="">--SELECT--</option>
                                            @foreach ( $vehicleChoose as $vehicleChooses)
                                            <option value="{{$vehicleChooses['vehcode']}}">{{$vehicleChooses['Vehno']}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12 mt-4">
                                    <div class="form-group">
                                        <label>Nature of Service</label>
                                        <input type="text" name="work" required placeholder="Ex: Repair">
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12 mt-4">
                                    <div class="form-group">
                                        <label>Party</label>
                                        <select class="" placeholder="select" id="party" name="party" required>
                                            <option value="">--SELECT--</option>
                                            @foreach ( $partyChoose as $partys)
                                            <option value="{{$partys['Ledger_Code']}}|{{$partys['Ledger_Name']}}">{{$partys['Ledger_Name']}}</option>
                                            @endforeach

                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Place</label>
                                        <input type="text" name="palce" required placeholder="Ex: BTL">
                                    </div>
                                </div>

                                <!-- COST -->
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Cost</label>
                                        <!-- NORMAL COST -->
                                        <input type="text" name="cost" id="cost" required oninput="this.value = this.value.replace(/[^0-9.]/g, '');" placeholder="Ex: 0.00">
                                        <!-- SPECIAL COST -->
                                        <input type="text" name="sp_cost" id="sp_cost" oninput="this.value = this.value.replace(/[^0-9.]/g, '');" placeholder="Ex: SP 0.00" style="display: none;">
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Inv No</label>
                                        <input type="text" name="invNo" required placeholder="Ex: ASB001">
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Inv Date </label>
                                        <div class="input-groupicon">
                                            <input type="date" name="invDate" placeholder="DD-MM-YYYY" class="form-control" id="invDate" required>
                                            <!-- <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div> -->
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Description</label>
                                        <textarea class="form-control" name="remarks"></textarea>
                                    </div>
                                </div>

                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Tax</label>
                                        <select class="select">
                                            <option>Choose Tax</option>
                                            <option>2%</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Discount Type</label>
                                        <select class="select">
                                            <option>Percentage</option>
                                            <option>10%</option>
                                            <option>20%</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Price</label>
                                        <input type="text">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label> Status</label>
                                        <select class="select">
                                            <option>Closed</option>
                                            <option>Open</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label> Product Image</label>
                                        <div class="image-upload">
                                            <input type="file">
                                            <div class="image-uploads">
                                                <img src="assets/img/icons/upload.svg" alt="img">
                                                <h4>Drag and drop a file to upload</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div> -->

                                <div class="col-lg-12">
                                    <button type="submit" class="btn btn-submit me-2" id="submitBtn">Submit</button>
                                    <!-- <a href="productlist.html" class="btn btn-cancel">Cancel</a> -->
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <script>
        // Get the checkbox element
        const specialApproveCheckbox = document.getElementById('specialApprove');

        // Get the elements to hide/show
        const chPrimary = document.getElementById('ch_primary');
        const chSecondary = document.getElementById('ch_secondary');
        const cost = document.getElementById('cost');
        const sp_cost = document.getElementById('sp_cost');

        // Add an event listener to the checkbox
        specialApproveCheckbox.addEventListener('change', function() {
            // Check if the checkbox is checked
            if (this.checked) {
                // If checked, hide ch_primary and show ch_secondary
                chPrimary.style.display = 'none';
                chSecondary.style.display = 'block';
                cost.style.display = 'none';
                cost.removeAttribute("required");
                cost.value = '';
                sp_cost.style.display = 'block';
                sp_cost.setAttribute("required", "required");
            } else {
                // If not checked, show ch_primary and hide ch_secondary
                chPrimary.style.display = 'block';
                chSecondary.style.display = 'none';
                cost.style.display = 'block';
                cost.setAttribute("required", "required");
                sp_cost.style.display = 'none';
                sp_cost.value = '';
                sp_cost.removeAttribute("required");
            }
        });
    </script>


    @if ($message = Session::get('SuccessMsg'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>

    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 3000);
    </script>
    @endif
    @if ($message = Session::get('errorMsg'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 20000);
    </script>
    @endif

    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/selectize.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/js/moment.min.js"></script>
    <script src="assets/js/bootstrap-datetimepicker.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>
    <script>
        $(document).ready(function() {

            $("#Vno").selectize({
                create: true,
                sortField: "text",
                placeholder: "Select Vehicle Number"
            });
            $("#party").selectize({
                create: true,
                sortField: "text",
                placeholder: "Select Party"
            });

        });

        function getCurrentDate() {
            var today = new Date();
            var dd = String(today.getDate()).padStart(2, "0");
            var mm = String(today.getMonth() + 1).padStart(2, "0");
            var yyyy = today.getFullYear();
            return dd + "-" + mm + "-" + yyyy;
        }

        document.getElementById("Edate").value = getCurrentDate();
    </script>


    <!--  cash update -->
    <script>
        $(document).ready(function() {
            var cashMode;

            // Function to update amounts based on selected cash and spare modes
            function updateAmounts() {
                var formData = {
                    cashMode: cashMode || $("input[name='cashMode']:checked").val(),
                    spareMode: $("input[name='spareMode']:checked").val(),
                    _token: $('meta[name="csrf-token"]').attr('content')
                };

                $.ajax({
                    type: "GET",
                    url: "{{ route('ovmServiceAmt') }}",
                    data: formData,
                    success: function(response) {
                        console.log(response);

                        let allotAmt = response[0]['AppAmt'];
                        let BalAmt = response[0]['BalAmt'];
                        let UsedAmt = response[0]['UsedAmt'];

                        $("#allotAmt").text(allotAmt);
                        $("#usedAmt").text(UsedAmt);
                        $("#BalAmt").text(BalAmt);
                    },
                    error: function(error) {
                        console.log(error);
                    }
                });
            }

            // Trigger AJAX call on page load to fetch and display initial amounts
            updateAmounts();

            var cashBtn = document.getElementsByName('cashMode');

            cashBtn.forEach(function(cashBtn) {
                cashBtn.addEventListener('click', function() {
                    if (cashBtn.checked) {
                        cashMode = cashBtn.value;
                        // Update amounts when cash mode is changed
                        updateAmounts();
                    }
                });
            });

            // If a spare mode is pre-selected via request, trigger the change event
            $("input[name='spareMode']:checked").trigger("change");

            // Add event listener for spare mode change
            $("input[name='spareMode']").on("change", function() {
                // Update amounts when spare mode is changed
                updateAmounts();
            });

            // Add validation for the cost input field
            $('#cost').on('input', function() {
                var enteredCost = parseFloat($(this).val());
                var balanceAmt = parseFloat($("#BalAmt").text());

                if (enteredCost > balanceAmt) {
                    alert("You'll reach the limit! Entered amount exceeds the balance amount.");
                    // Optionally, you can reset the input value to the balance amount
                    $(this).val(balanceAmt);
                }
            });
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var referenceDateInput = document.getElementById('invDate');

            // Set the current date as the maximum allowed date
            referenceDateInput.max = new Date().toISOString().split('T')[0];

            // Set the initial value to the current date
            var currentDate = new Date();
            var dd = String(currentDate.getDate()).padStart(2, '0');
            var mm = String(currentDate.getMonth() + 1).padStart(2, '0');
            var yyyy = currentDate.getFullYear();
            let formattedCurrentDate = yyyy + '-' + mm + '-' + dd;
            referenceDateInput.value = formattedCurrentDate;

            // Listen for changes in the date input
            referenceDateInput.addEventListener('input', function() {
                var selectedDate = new Date(this.value);

                // If the selected date is in the future, reset the input value
                if (selectedDate > currentDate) {
                    this.value = '';
                }
            });
        });
    </script>

    @endsection
</body>

</html>