<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="VMS - Vehicle Management System">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <title>VMS</title>
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">


    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">


</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">
        @section('tittle')

        @extends('VMS.navbar')
        @section('content')
        <?php

        use PHPUnit\TextUI\XmlConfiguration\CodeCoverage\Report\Php;

        $outServiceViews = Session('outServiceViews');
        $outServiceEdit = Session('outServiceEdit');
        $outServiceEntry = Session('outServiceEntry');
        ?>
        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">

                        @if(\Route::currentRouteName() == 'ovmApprove')
                        <h4>Service Approve</h4>
                        @endif
                        @if(\Route::currentRouteName() == 'ovmReport')
                        <h4>Service Report</h4>

                        @endif
                        <!-- <h6>Manage your products</h6> -->
                    </div>
                    @if ($outServiceEntry == "Y")
                    <div class="page-btn">
                        <a href="ovmAdd" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img" class="me-1">Add New Service</a>
                    </div>
                    @endif
                </div>

                <div class="card">
                    <div class="card-body">


                        <div class="table-responsive">
                            <table class="table  datanew">
                                <thead>
                                    <tr>

                                        @if(\Route::currentRouteName() == 'ovmApprove')
                                        <th>Approve</th>
                                        @endif
                                        @if(\Route::currentRouteName() == 'ovmReport')
                                        @if ($outServiceEdit == "Y")
                                        <th>Edit</th>
                                        @endif
                                        @endif
                                        <th>Eno</th>
                                        <th>EDate</th>
                                        <th>Vehicle Name</th>
                                        <th>Work</th>
                                        <th>Company</th>
                                        <th>Cost</th>
                                        <th>Place</th>
                                        <th>InvoiceNo</th>
                                        <th>InvoiceDate</th>
                                        <!-- <th>Remarks</th> -->
                                        <th>Cash</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($decode as $decodes)
                                    <tr>
                                        @if(\Route::currentRouteName() == 'ovmApprove')
                                        <td>
                                            <form action="ovmApproveSave" method="post">
                                                @csrf
                                                <input type="hidden" name="eno" value="{{$decodes['Eno']}}">
                                                <button class="btn btn-primary" type="submit">Approve</button>
                                            </form>
                                        </td>
                                        @endif

                                        @if(\Route::currentRouteName() == 'ovmReport' )
                                        @if ($outServiceEdit == "Y")
                                        <td>

                                            @if ($decodes['Flag'] == 0)
                                            <a class="me-5 editBtn" href="ovmEdit?mode=edit&Eno={{$decodes['Eno']}}&date={{$decodes['date']}}&vehname={{$decodes['vehname']}}
                                            &vehcode={{$decodes['vehcode']}}&Work={{$decodes['Work']}}&Company={{$decodes['Company']}}&AccLedgerCode={{$decodes['AccLedgerCode']}}
                                            &Place={{$decodes['Place']}}&Cost={{$decodes['Cost']}}&InvoiceNo={{$decodes['InvoiceNo']}}&InvoiceDate={{$decodes['InvoiceDate']}}
                                            &Remarks={{$decodes['Remarks']}}&cash={{$decodes['cash']}}&CompName={{$decodes['CompName']}}&AccCompCode={{$decodes['AccCompCode']}}
                                            &spare={{$decodes['spare']}}&vehno={{$decodes['vehno']}}">
                                                <img src="assets/img/icons/edit.svg" alt="img">
                                            </a>
                                            @endif


                                            @if ($outServiceEdit == "Y" || $outServiceViews == "Y")
                                            @if ($decodes['Flag'] == 1)
                                            <?php
                                            // Encrypt the Cost value
                                            $encryptedCost = Illuminate\Support\Facades\Crypt::encrypt($decodes['Cost']);
                                            ?>

                                            <a class="me-5 editBtn" href="ovmView?mode=edit&Eno={{$decodes['Eno']}}&date={{$decodes['date']}}&vehname={{$decodes['vehname']}}
                                            &vehcode={{$decodes['vehcode']}}&Work={{$decodes['Work']}}&Company={{$decodes['Company']}}&AccLedgerCode={{$decodes['AccLedgerCode']}}
                                            &Place={{$decodes['Place']}}&Cost={{$encryptedCost}}&InvoiceNo={{$decodes['InvoiceNo']}}&InvoiceDate={{$decodes['InvoiceDate']}}
                                            &Remarks={{$decodes['Remarks']}}&cash={{$decodes['cash']}}&CompName={{$decodes['CompName']}}&AccCompCode={{$decodes['AccCompCode']}}
                                            &spare={{$decodes['spare']}}&vehno={{$decodes['vehno']}}">
                                                <img src="assets/img/icons/eye.svg" alt="img">
                                            </a>
                                            @endif
                                            @endif

                                        </td>
                                        @endif
                                        @endif
                                        <td class="productimgname">
                                            <a href="javascript:void(0);">{{$decodes['Eno']}}</a>
                                        </td>
                                        <td>{{date('Y-m-d', strtotime($decodes['date']))}}</td>
                                        <td>{{$decodes['vehname']}}</td>
                                        <td>{{$decodes['Work']}}</td>
                                        <td>{{$decodes['Company']}}</td>
                                        <td>{{$decodes['Cost']}}</td>
                                        <td>{{$decodes['Place']}}</td>
                                        <td>{{$decodes['InvoiceNo']}}</td>
                                        <td>
                                            {{ date('Y-m-d', strtotime($decodes['InvoiceDate'])) }}
                                        </td>
                                        <!-- <td>{{$decodes['Remarks']}}</td> -->
                                        <td>{{$decodes['cash']}}</td>

                                    </tr>
                                    </form>
                                    @endforeach
                                </tbody>
                            </table>
                            @if ($message = Session::get('SuccessMsg'))
                            <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                                {{$message}}

                            </div>

                            <script>
                                // Automatically close the alert after 3 seconds
                                setTimeout(function() {
                                    var successAlert = document.getElementById('successAlert');
                                    if (successAlert) {
                                        successAlert.remove();
                                    }
                                }, 20000);
                            </script>
                            @endif
                            @if ($message = Session::get('errorMsg'))
                            <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                                {{$message}}

                            </div>

                            <script>
                                setTimeout(function() {
                                    var successAlert = document.getElementById('successAlert');
                                    if (successAlert) {
                                        successAlert.remove();
                                    }
                                }, 20000);
                            </script>
                            @endif
                        </div>
                    </div>
                </div>

            </div>
        </div>


    </div>


    <script src="assets/js/jquery-3.6.0.min.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>
    <script>
        dataTableInstance.destroy();
        $('#DataTables_Table_0').DataTable();
    </script>
    @endsection
</body>

</html>