<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="VMS - Vehicle Management System">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <title>VMS</title>

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" href="assets/css/animate.css">

    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

    <link rel="stylesheet" href="assets/plugins/owlcarousel/owl.carousel.min.css">

    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        table {
            font-size: 12px;
        }

        table tbody td {
            padding-top: 10px;
        }

        #details {
            display: flex !important;
        }

        #currentDateTime {
            display: none;
        }

        #sign,
        #mdSign,
        #cashierSign {
            width: 150px !important;
        }


        @media print {

            @page {
                margin: 0;
            }

            .main-wrapper .page-wrapper .printableArea {
                margin-top: 150% !important;
            }

            body::after {
                content: none !important;
            }

            .reduce_width {
                width: 40%;
            }

            table tbody td {
                padding-top: 10px;
                padding-right: -100%;
                padding-left: -100px;
            }

            .card-header {
                margin-bottom: -35px;
            }

            .address {
                margin-top: -20px;
            }

            .surya {
                white-space: normal !important;
                word-wrap: break-word !important;
            }

            .header {
                margin: 0;
                visibility: hidden;
            }

            #page-title {
                visibility: hidden;
            }

            #print {
                visibility: hidden;
            }

            .content {
                text-align: center;
                font-size: 18px;
                color: #333;
            }

            #printHead {
                text-align: center;
                margin-left: -10%;
            }

            #printCompName {
                text-align: center;
                margin-left: 23%;
            }

            #details {
                margin-left: 5%;
            }

            #printLogo {
                margin-left: -30% !important;
            }


            #sign,
            #mdSign,
            #cashierSign {
                width: 100px !important;
            }

            #currentDateTime {
                display: block;
            }

        }
    </style>




</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">
        @extends('VMS.navbar')
        @section('content')
        <div class="page-wrapper">

            <div class="content" id="">
                <div class="d-flex justify-content-between">
                    <div class="page-title " id="page-title">
                        <h4>Outside Service View</h4>

                    </div>
                    <div>
                        <a class="printimg" id="print">
                            <img onclick="printDiv('printableArea')" src="/assets/img/icons/printer.svg" alt="print">
                        </a>
                    </div>
                </div>

            </div>
            <div class="row printableArea" id="printableArea">
                <div class="col-lg-12 col-sm-12">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="fw-bold" id="printHead">Outside Service </h6>
                        </div>
                        <div class="card-body">
                            <div class="d-md-flex col-sm-12" id="details">
                                <div class="col-sm-4" id="printCompName">
                                    <p class="fw-bold" style="font-size: 12px;">
                                        <!-- GAINUP INDUSTRIES INDIA PVT LTD -->
                                        <?php
                                        $companyName = Session('CompName');
                                        ?>
                                        {{$companyName}}
                                    </p>
                                    <p class="address" style="font-size: 12px;">
                                        <!-- 13/341,DINDIGUL-BATLAGUNDU HIGHWAY, <br>SITHARAEVU VILLAGE,OTTUPATTI(PO),
                                            <br>DINDIGUL(DT),TAMILNADU
                                            <br>DINDIGUL-624 708 <br>
                                            INDIA -->
                                        <?php
                                        $compAddress = Session('CompanyAddress');
                                        $CompanyCode = Session('CompanyCode');
                                        $CompanyGST = Session('CompanyGST');
                                        $compPANNo = Session('compPANNo');
                                        ?>
                                        <!-- SHOWING COMPANY ADDRESS -->
                                        {{$compAddress}}
                                    </p>
                                </div>
                                <div class="ms-3 mt-4 pt-3 col-sm-7" id="printLogo">
                                    @if ($CompanyCode == 2)
                                    <img src="assets/img/companylogo/alamelu.jpeg" style="max-width: 20%; margin-top: -15%; height: auto; float: right; margin-left: 10px;" alt="img">
                                    @elseif ($CompanyCode == 3)
                                    <img src="assets/img/companylogo/irulappa.jpeg" style="max-width: 20%; margin-top: -15%; height: auto; float: right; margin-left: 10px;" alt="img">
                                    @elseif ($CompanyCode == 1)
                                    <img src="assets/img/companylogo/gainup.jpeg" style="max-width: 20%; margin-top: -15%; height: auto; float: right; margin-left: 10px;" alt="img">
                                    @elseif ($CompanyCode == 8)
                                    <img src="assets/img/companylogo/techno tech.jpeg" style="max-width: 20%; margin-top: -15%; height: auto; float: right; margin-left: 10px;" alt="img">
                                    @elseif ($CompanyCode == 9)
                                    <img src="assets/img/companylogo/richworld.jpeg" style="max-width: 20%; margin-top: -15%; height: auto; float: right; margin-left: 10px;" alt="img">
                                    @endif
                                    <!-- <table class="ms-2">
                                        <tbody>
                                            <tr>
                                                <td>PAN NO </td>
                                                <td>:</td>
                                                <td>{{$compPANNo}}</td>
                                            </tr>
                                            <tr>
                                                <td>GST NO </td>
                                                <td> : </td>
                                                <td>
                                                    {{$CompanyGST}}
                                                </td>
                                            </tr>
                                           
                                        </tbody>
                                    </table> -->
                                </div>
                            </div>


                            <div class="d-md-flex mt-1 col-sm-12" id="details">

                                <div class="mt-2 pt-1 col-sm-12">
                                    <table class="ms-2">
                                        <tbody>
                                            <tr>
                                                <td class="pe-4 fw-bold">ENO </td>
                                                <td class="pe-4 fw-bold"> : </td>
                                                <td class="reduce_width">{{ request('Eno') }}</td>
                                                <td class="pe-4 fw-bold surya"> Print Date</td>
                                                <td class="pe-4 fw-bold"> : </td>
                                                <td id="currentDateTime"> </td>
                                            </tr>
                                            <tr>
                                                <td class="pe-4 fw-bold ">EDate</td>
                                                <td class="pe-4 fw-bold "> :</td>
                                                <td>{{ \Carbon\Carbon::parse(request('date'))->format('Y-m-d') }}</td>

                                                <td class="pe-4 fw-bold ">Vehicle Name</td>
                                                <td class="pe-4 fw-bold "> :</td>
                                                <td>{{ request('vehname') }}</td>
                                            </tr>
                                            <tr>
                                                <td class="pe-4 fw-bold">VehicleNo</td>
                                                <td class="pe-4 fw-bold "> :</td>
                                                <td>{{ request('vehno') }}</td>

                                                <td class="pe-4 fw-bold">Work</td>
                                                <td class="pe-4 fw-bold"> :</td>
                                                <td>{{ request('Work') }}</td>
                                            </tr>
                                            <tr>
                                                <td class="pe-4 fw-bold">Party</td>
                                                <td class="pe-4 fw-bold"> :</td>
                                                <td>{{ request('Company') }}</td>

                                                <td class="pe-4 fw-bold">Place</td>
                                                <td class="pe-4 pb-2 fw-bold"> :</td>
                                                <td>{{ request('Place') }}</td>
                                            </tr>
                                            <tr>
                                                <td class="pe-4 fw-bold">Remarks</td>
                                                <td class="pe-4 pb-1 fw-bold"> :</td>
                                                <td>{{ request('Remarks') }}</td>
                                            </tr>

                                            <tr>
                                                <td class="pe-3" style="border: 2px solid orange;width:110px ">
                                                    <?php
                                                    // Decrypt the Cost value
                                                    $decryptedCost = Illuminate\Support\Facades\Crypt::decrypt(request('Cost'));

                                                    // Round off the amount
                                                    $roundedCost = round($decryptedCost);

                                                    // Convert the rounded cost to words if needed
                                                    $costInWords = convertNumberToWords($roundedCost); // You can use your existing function for converting numbers to words

                                                    // Output the result
                                                    echo "<h4 class='ms-2 fw-bold'>₹ $roundedCost</h4>";
                                                    ?>
                                                </td>

                                                <td class="pe-4 fw-bold"></td>
                                                <td style="width: 400px;">
                                                    <?php
                                                    function convertNumberToWords($number)
                                                    {
                                                        // Array of words for numbers 0 to 19
                                                        $words = array(
                                                            0 => 'zero', 1 => 'one', 2 => 'two', 3 => 'three', 4 => 'four', 5 => 'five', 6 => 'six', 7 => 'seven', 8 => 'eight', 9 => 'nine',
                                                            10 => 'ten', 11 => 'eleven', 12 => 'twelve', 13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen', 16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen', 19 => 'nineteen'
                                                        );

                                                        // Array of words for tens multiples
                                                        $tens = array(
                                                            20 => 'twenty', 30 => 'thirty', 40 => 'forty', 50 => 'fifty', 60 => 'sixty', 70 => 'seventy', 80 => 'eighty', 90 => 'ninety'
                                                        );

                                                        if ($number < 20) {
                                                            return $words[$number];
                                                        }

                                                        if ($number < 100) {
                                                            return $tens[$number - ($number % 10)] . (($number % 10 !== 0) ? ' ' . $words[$number % 10] : '');
                                                        }

                                                        if ($number < 1000) {
                                                            return $words[floor($number / 100)] . ' hundred' . (($number % 100 !== 0) ? ' and ' . convertNumberToWords($number % 100) : '');
                                                        }

                                                        if ($number < 1000000) {
                                                            return convertNumberToWords(floor($number / 1000)) . ' thousand' . (($number % 1000 !== 0) ? ' ' . convertNumberToWords($number % 1000) : '');
                                                        }

                                                        return 'number too large to convert';
                                                    }

                                                    // $cost = request('Cost'); // Assuming this is the cost
                                                    $cost = Illuminate\Support\Facades\Crypt::decrypt(request('Cost'));

                                                    // Convert the cost to an integer for processing
                                                    $costInteger = intval($cost);

                                                    // Convert the cost to words
                                                    $costInWords = convertNumberToWords($costInteger);

                                                    // Output the result in the desired HTML format

                                                    ?>
                                                    <h6>{{$costInWords}}</h6>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>


                                    <div class="mt-1 pt-4">
                                        <table>
                                            <tbody>
                                                <tr>
                                                    <td class="pe-4 fw-bold"> Prepared Signature </td>
                                                    <td style="width: 200px;" id="sign"></td>
                                                    <td class="pe-4 fw-bold"> Asst.Manager Signature </td>
                                                    <td style="width: 200px;" id="sign"></td>
                                                    <td class=" pe-4 fw-bold" id=""> Sr.Manager Signature </td>
                                                    <td style="width: 200px;" id="mdSign"></td>
                                                    <td id="cashierSign" class="pe-4 fw-bold"> Cashier Signature </td>

                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <!-- <div class="productdetails"> -->
            <!-- <div class="row">
                    <div class="table-responsive">
                        <table class="table" id="table">
                            <thead>
                                <tr>

                                    <th>PONO</th>
                                    <th>Product</th>
                                    <th>Quantity</th>
                                    <th>Price(₹) </th>
                                    <th>Discount </th>

                                    <th>Tax %</th>

                                    <th>Total Cost </th>

                                </tr>
                            </thead>
                            <tbody>

                                <tr id="newRowTemplate">
                                    <td class="form-group">

                                    </td>
                                    <td class="form-group">

                                    </td>

                                    <td class="form-group">


                                    </td>
                                    <td class="form-group">



                                    <td class="form-group">

                                    </td>


                                    <td class="form-group">

                                    </td>

                                    <td class="totalCost">


                                    </td>

                                </tr>

                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-11 float-md-right">
                        <div class="total-order">
                            <ul>
                                <li>
                                    <h4>Order Tax</h4>
                                    <h5 class="totalTaxCost">₹ </h5>

                                </li>
                                <li>
                                    <h4>Discount </h4>
                                    <h5 class="totalDiscountCost">₹ </h5>


                                </li>
                                <li>
                                    <h4>Shipping</h4>
                                    <h5></h5>
                                </li>
                                <li class="total">
                                    <h4>Grand Total</h4>
                                    <h5 class="totalGrandCost">₹ </h5>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div> -->
            <!-- </div> -->

        </div>
    </div>


    <script src="assets/js/jquery-3.6.0.min.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/owlcarousel/owl.carousel.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/js/script.js"></script>



    <script>
        function printDiv(divName) {
            var printContents = document.getElementById(divName).innerHTML;
            var originalContents = document.body.innerHTML;
            document.body.innerHTML = printContents;

            var now = new Date();
            var formattedDateTime = now.toLocaleString();
            document.getElementById("currentDateTime").innerText = formattedDateTime;

            window.print();
            document.body.innerHTML = originalContents;
        }
    </script>



    @endsection
</body>

</html>