<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="POS - Bootstrap Admin Template">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <meta name="author" content="Dreamguys - Bootstrap Admin Template">
    <meta name="robots" content="noindex, nofollow">
    <title>PRODUCT ENTRY</title>

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/selectize.css">

    <style>
        .form-control {
            height: 15% !important;
        }
    </style>
</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>
    <div class="main-wrapper">
        @extends('VMS.navbar')
        <form action=" {{ route('ProductList_Save')}} " method="post" enctype="multipart/form-data" onsubmit="return validateForm()">
            @csrf
            <div class="page-wrapper">
                <div class="content">
                    <div class="page-header">
                        <div class="page-title">
                            <h4>PRODUCT ENTRY</h4>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Product Name<span style="color:red;font-size: 20px;font-weight:bold"></span></label>
                                        <input type="text" id="productName" name="Product_Name" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Item<span style="color:red;font-size: 20px;font-weight:bold">*</span></label>
                                        <select class="select2" id="itemDropdown" name="Item_Id" required oninvalid="setCustomValidity('Please choose an Item')" onchange="resetCustomValidity()">
                                            <option value="" disabled selected>Choose Item</option>
                                            @foreach($res1 as $row)
                                            <option value="{{ $row['ID'] }}">{{ $row['Name'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                     <div class="form-group">
                                        <label>Brand<span style="color:red;font-size: 20px;font-weight:bold">*</span></label>
                                        <select class="select2" id="brandDropdown" name="Brand_Id"  required oninvalid="setCustomValidity('Please choose an Brand')" onchange="resetCustomValidity()">
                                            <option value="" disabled selected>Choose Brand</option>
                                            @foreach($res4 as $row)
                                            <option value="{{ $row['ID'] }}">{{ $row['Name'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Size<span style="color:red;font-size: 20px;font-weight:bold">*</span></label>
                                        <select class="select2" id="sizeDropdown" name="Size_Id" required oninvalid="setCustomValidity('Please choose an Size')" onchange="resetCustomValidity()">
                                            <option value="" disabled selected>Choose Size</option>
                                            @foreach($res3 as $row)
                                            <option value="{{ $row['ID'] }}">{{ $row['Name'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Unit<span style="color:red;font-size: 20px;font-weight:bold">*</span></label>
                                        <select class="select2" id="unitDropdown" name="Unit_Id"  required oninvalid="setCustomValidity('Please choose an Unit')" onchange="resetCustomValidity()">
                                            <option value="" disabled selected>Choose Unit</option>
                                            @foreach($res5 as $row)
                                            <option value="{{ $row['ID'] }}">{{ $row['Name'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                   
                                    <div class="form-group">
                                        <label>Type<span style="color:red;font-size: 20px;font-weight:bold">*</span></label>
                                        <select class="select2" id="typeDropdown" name="Type_Id" required oninvalid="setCustomValidity('Please choose an Type')" onchange="resetCustomValidity()">
                                            <option value="" disabled selected>Choose Type</option>
                                            @foreach($res2 as $row)
                                            <option value="{{ $row['ID'] }}">{{ $row['Name'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Category<span style="color:red;font-size: 20px;font-weight:bold">*</span></label>
                                        <select class="select2" id="catDropdown" name="Category_Id" required oninvalid="setCustomValidity('Please choose an Category')" onchange="resetCustomValidity()">
                                            <option value="" disabled selected>Choose Category</option>
                                            @foreach($res6 as $row)
                                            <option value="{{ $row['ID'] }}">{{ $row['Name'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Sub Category<span style="color:red;font-size: 20px;font-weight:bold">*</span></label>
                                        <select class="select2" id="subcatDropdown" name="Sub_Cat_Id" required oninvalid="setCustomValidity('Please choose an Sub-Category')" onchange="resetCustomValidity()">
                                            <option value="" disabled selected>Choose Sub-Category</option>
                                            @foreach($res7 as $row)
                                            <option value="{{ $row['ID'] }}">{{ $row['Name'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Description</label>
                                        <textarea class="form-control" name="Description"></textarea>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Tax %<span style="color:red;font-size: 20px;font-weight:bold">*</span></label>
                                        <select class="select2" id="taxDropdown" name="Tax_Per" required oninvalid="setCustomValidity('Please choose an Tax')" onchange="resetCustomValidity()">
                                            <option value="" disabled selected>Choose Tax</option>
                                            @foreach($res8 as $row)
                                            <option value="{{ $row['ID'] }}">{{ $row['Name'] }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Discount %<span style="color:red;font-size: 20px;font-weight:bold">*</span></label>
                                        <input type="number" id="disDropdown" name="Discount_Per" id="discountInput" required oninvalid="setCustomValidity('Please enter Discount')" onchange="resetCustomValidity()">
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Price<span style="color:red;font-size: 20px;font-weight:bold">*</span></label>
                                        <input type="text" id="priceDropdown" name="Price" id="priceInput" required oninvalid="setCustomValidity('Please enter Price')" onchange="resetCustomValidity()" oninput="validateinput(this)">
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Reorder Level<span style="color:red;font-size: 20px;font-weight:bold"></span></label>
                                        <input type="number" name="re_lev" value="0">
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Reorder Qty<span style="color:red;font-size: 20px;font-weight:bold"></span></label>
                                        <input type="number" name="re_qty" value="0">
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Status<span style="color:red;font-size: 20px;font-weight:bold"></span></label>
                                        <input type="text" placeholder="OPEN" readonly>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <label class="custom-file-container__custom-file">
                                                <input type="file" name="Prod_Img" id="prodImgInput" accept="image/*" onchange="previewImage()">
                                            </label>
                                            <div id="imagePreview" style="display:none; text-align: center;">
                                                <img id="preview" alt="Selected Image" style="max-width: 50%; height: 100px;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-btn col-lg-12">
                                    <button class="btn btn-submit me-2" type="submit">SUBMIT</button><br><br>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>

    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/selectize.js"></script>
    <script src="assets/js/feather.min.js"></script>
    <script src="assets/js/jquery.slimscroll.min.js"></script>
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/plugins/select2/js/select2.min.js"></script>
    <script src="assets/js/moment.min.js"></script>
    <script src="assets/js/bootstrap-datetimepicker.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>
    <script src="assets/js/script.js"></script>

    <!-- VALIDATION INPUT PRICE AND ADD '.' -->
    <script>
        function validateinput(input) {
            input.value = input.value.replace(/[^0-9.]/g, '');
        }
    </script>

    <!-- SEARCH -->
    <script>
        // Initialize Select2
        $(document).ready(function() {
            $('.select2').select2();

            // Restrict input to numbers only in the search field
            $('#taxDropdown').on('select2:open', function(e) {
                $('.select2-search__field').on('keypress', function(e) {
                    var charCode = e.which ? e.which : e.keyCode;
                    if (charCode !== 46 && (charCode < 48 || charCode > 57)) {
                        e.preventDefault();
                        alert('Please enter numbers only.');
                    }
                });
            });
        });
    </script>

    <!-- SELECTED PRODUCT SHOWN IN INPUT BOX -->
    <script>
        $(document).ready(function() {
            // Change event for ITEM dropdown
            $("#itemDropdown").change(function() {
                updateProductName();
            });

            // // Change event for TYPE dropdown
            // $("#typeDropdown").change(function() {
            //     updateProductName();
            // });
            $("#brandDropdown").change(function() {
                updateProductName();
            });

            // Change event for SIZE dropdown
            $("#sizeDropdown").change(function() {
                updateProductName();
            });

            // Function to update PRODUCT NAME based on selected options
            function updateProductName() {
                var itemText = $("#itemDropdown option:selected").text();
                // var typeName = $("#typeDropdown option:selected").text();
                var typeName = $("#brandDropdown option:selected").text();
                var sizeName = $("#sizeDropdown option:selected").text();

                // Filter out the "Choose Category" option
                var selectedOptions = [itemText, typeName, sizeName].filter(option => option !== 'Choose Item' && option !== 'Choose Type' && option !== 'Choose Size');

                // Concatenate selected options with " | " separator
                var result = selectedOptions.filter(Boolean).join(' ');

                // Set the result as the value of PRODUCT NAME input
                $("#productName").val(result);
            }
        });
    </script>

    <!-- .00 for Tax & Price -->
    <script>
        $(document).ready(function() {
            // Attach an event listener to the DISCOUNT input field
            $("#discountInput").on('blur', function() {
                formatDecimalInput($(this));
            });

            // Attach an event listener to the PRICE input field
            $("#priceInput").on('blur', function() {
                formatDecimalInput($(this));
            });

            // Function to format input as a decimal with two decimal places
            function formatDecimalInput(inputField) {
                // Get the entered value
                var inputValue = inputField.val();

                // Convert the value to a decimal with two decimal places
                var formattedValue = parseFloat(inputValue).toFixed(2);

                // Set the formatted value back to the input field
                inputField.val(formattedValue);
            }
        });
    </script>

    <!-- IMAGE -->
    <script>
        function previewImage() {
            var input = document.getElementById('prodImgInput');
            var preview = document.getElementById('preview');
            var previewContainer = document.getElementById('imagePreview');

            var file = input.files[0];

            if (file) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    preview.src = e.target.result;
                    previewContainer.style.display = 'block';
                };

                reader.readAsDataURL(file);
            } else {
                preview.src = '';
                previewContainer.style.display = null;
            }
        }
    </script>

    <script>
        // JavaScript function to reset custom validity
        function resetCustomValidity() {
            document.getElementById('itemDropdown').setCustomValidity('');
            document.getElementById('typeDropdown').setCustomValidity('');
            document.getElementById('sizeDropdown').setCustomValidity('');
            document.getElementById('unitDropdown').setCustomValidity('');
            document.getElementById('brandDropdown').setCustomValidity('');
            document.getElementById('catDropdown').setCustomValidity('');
            document.getElementById('subcatDropdown').setCustomValidity('');
            document.getElementById('taxDropdown').setCustomValidity('');
            document.getElementById('disDropdown').setCustomValidity('');
            document.getElementById('priceDropdown').setCustomValidity('');
        }
    </script>

    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('SuccessMsg'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}

    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 3000);
    </script>
    @endif

    @if ($message = Session::get('errorMsg'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}

    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 3000);
    </script>
    @endif

</body>

</html>