<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <title>PRODUCT EDIT</title>

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/selectize.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

    <style>
        .form-control {
            height: 15% !important;
        }
    </style>

</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>
    <div class="main-wrapper">
        @extends('VMS.navbar')
        <form action=" {{ route('ProductListEdit_Save')}} " method="POST" enctype="multipart/form-data">
            @csrf
            <div class="page-wrapper">
                <div class="content">
                    <div class="page-header">
                        <div class="page-title">
                            <h4>PRODUCT EDIT</h4>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <input type="hidden" name="Rowid" value="{{ request('id') }}" required>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Product Name<span style="color:red;font-size: 20px;font-weight:bold"></span></label>
                                        <input type="text" name="Product_Name" value="{{ request('name') }}" readonly>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Item<span style="color:red;font-size: 20px;font-weight:bold">*</span></label>
                                        <input type="hidden" value="{{ request('item_id') }}" required>
                                        <select class="select" name="Item_Id" required>
                                            <option value="" disabled>Choose Category</option>
                                            @foreach($res1 as $row)
                                            <option value="{{ $row['ID'] }}" {{ $row['Name'] === request('item_id') ? 'selected' : '' }}>
                                                {{ $row['Name'] }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Type
                                            <span style="color:red;font-size: 20px;font-weight:bold">*</span>
                                        </label>
                                        <input type="hidden" value="{{ request('type_id') }}" required>
                                        <select class="select" name="Type_Id" required>
                                            <option value="" disabled>Choose Category</option>
                                            @foreach($res2 as $row)
                                            <option value="{{ $row['ID'] }}" {{ $row['Name'] === request('type_id') ? 'selected' : '' }}>
                                                {{ $row['Name'] }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Size
                                            <span style="color:red;font-size: 20px;font-weight:bold">*</span>
                                        </label>
                                        <input type="hidden" value="{{ request('size_id') }}" required>
                                        <select class="select" name="Size_Id" required>
                                            <option value="" disabled>Choose Category</option>
                                            @foreach($res3 as $row)
                                            <option value="{{ $row['ID'] }}" {{ $row['Name'] === request('size_id') ? 'selected' : '' }}>
                                                {{ $row['Name'] }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Unit
                                            <span style="color:red;font-size: 20px;font-weight:bold">*</span>
                                        </label>
                                        <input type="hidden" value="{{ request('unit_id') }}" required>
                                        <select class="select" name="Unit_Id">
                                            <option disabled selected>Choose Category</option>
                                            @foreach($res5 as $row)
                                            <option value="{{ $row['ID'] }}" {{ $row['Name'] === request('unit_id') ? 'selected' : '' }}>
                                                {{ $row['Name'] }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Brand
                                            <span style="color:red;font-size: 20px;font-weight:bold">*</span>
                                        </label>
                                        <input type="hidden" value="{{ request('brand_id') }}" required>
                                        <select class="select" name="Brand_Id">
                                            <option disabled selected>Choose Category</option>
                                            @foreach($res4 as $row)
                                            <option value="{{ $row['ID'] }}">
                                            <option value="{{ $row['ID'] }}" {{ $row['Name'] === request('brand_id') ? 'selected' : '' }}>
                                                {{ $row['Name'] }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Category
                                            <span style="color:red;font-size: 20px;font-weight:bold">*</span>
                                        </label>
                                        <input type="hidden" value="{{ request('category_id') }}" required>
                                        <select class="select" name="Category_Id">
                                            <option disabled selected>Choose Category</option>
                                            @foreach($res6 as $row)
                                            <option value="{{ $row['ID'] }}">
                                            <option value="{{ $row['ID'] }}" {{ $row['Name'] === request('category_id') ? 'selected' : '' }}>
                                                {{ $row['Name'] }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Sub Category
                                            <span style="color:red;font-size: 20px;font-weight:bold">*</span>
                                        </label>
                                        <input type="hidden" value="{{ request('sub_cat_id') }}" required>
                                        <select class="select" name="Sub_Cat_Id">
                                            <option disabled selected>Choose Category</option>
                                            @foreach($res7 as $row)
                                            <option value="{{ $row['ID'] }}">
                                            <option value="{{ $row['ID'] }}" {{ $row['Name'] === request('sub_cat_id') ? 'selected' : '' }}>
                                                {{ $row['Name'] }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Description</label>
                                        <input type="hidden" value="{{ request('description') }}">
                                        <textarea class="form-control" name="Description">{{request('description') }}</textarea>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Tax %
                                            <span style="color:red;font-size: 20px;font-weight:bold">*</span>
                                        </label>
                                        <input type="hidden" value="{{ request('tax_per') }}" required>
                                        <select class="select" name="Tax_Per">
                                            <option disabled selected>Choose Category</option>
                                            @foreach($res8 as $row)
                                            <option value="{{ $row['ID'] }}">
                                            <option value="{{ $row['ID'] }}" {{ $row['Name'] === request('tax_per') ? 'selected' : '' }}>
                                                {{ $row['Name'] }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Discount %
                                            <span style="color:red;font-size: 20px;font-weight:bold">*</span>
                                        </label>
                                        <input type="hidden" value="{{ request('discount_per') }}" required>
                                        <input type="text" name="Discount_Per" id="discountInput" value="{{ request('discount_per') }}">
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Price
                                            <span style="color:red;font-size: 20px;font-weight:bold">*</span>
                                        </label>
                                        <input type="hidden" value="{{ request('price') }}" required>
                                        <input type="text" name="Price" id="priceInput" value="{{ request('price') }}">
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Reorder Level<span style="color:red;font-size: 20px;font-weight:bold"></label>
                                        <input type="hidden" value="{{ request('Reorder_Level') }}" required>
                                        <input type="text" name="re_lev" value="{{ request('Reorder_Level') }}">
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Reorder Qty<span style="color:red;font-size: 20px;font-weight:bold"></label>
                                        <input type="hidden" value="{{ request('Reorder_Qty') }}" required>
                                        <input type="text" name="re_qty" value="{{ request('Reorder_Qty') }}">
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Status<span style="color:red;font-size: 20px;font-weight:bold"></label>
                                        <input type="hidden" value="{{ request('status') }}" required>
                                        <select class="select" name="Status">
                                            <option value="{{ request('status') }}" selected>{{ request('status') }}</option>
                                            <option value="Close">CLOSE</option>
                                            <option value="Open">OPEN</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <label class="custom-file-container__custom-file">
                                                <!-- SAVING THE EXISTING IMG IF NO IMG UPLOADED -->
                                                <input type="hidden" name="current_image_path" value="{{ (request('prod_img')) }}">

                                                @if(request('prod_img'))
                                                <p>Uploaded Image</p>
                                                @else
                                                <p>No Image Uploaded</p>
                                                @endif

                                                <div id="existingImage">
                                                    <img src="{{ asset('VMS_Prod_img/' . (request('prod_img') )) }}" style="max-width: 50%; height: 100px;">
                                                </div>
                                                <!-- GETTING THE NEW IMAGE -->
                                                <input type="file" name="Prod_Img" id="prodImgInput" accept="image/*" onchange="previewImage()">
                                            </label>
                                            <div id="imagePreview" style="display:none; text-align: center;">
                                                <img id="preview" alt="Selected Image" style="max-width: 50%; height: 100px;">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-btn col-lg-12">
                                    <button class="btn btn-submit me-2" type="submit">UPDATE</button><br><br>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>


    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/selectize.js"></script>
    <script src="assets/js/feather.min.js"></script>
    <script src="assets/js/jquery.slimscroll.min.js"></script>
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/plugins/select2/js/select2.min.js"></script>
    <script src="assets/js/moment.min.js"></script>
    <script src="assets/js/bootstrap-datetimepicker.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>
    <script src="assets/js/script.js"></script>

    <!-- SEARCH -->
    <script>
        // Initialize Select2
        $(document).ready(function() {
            $('.select').select2();
        });
    </script>

    <!-- SELECTED PRODUCT SHOWN IN INPUT BOX -->
    <script>
        $(document).ready(function() {
            // Function to update the Product Name based on selected options
            function updateProductName() {
                var itemName = $('select[name="Item_Id"] option:selected').text().trim();
                var typeName = $('select[name="Type_Id"] option:selected').text().trim();
                var sizeName = $('select[name="Size_Id"] option:selected').text().trim();

                // Concatenate the selected options
                var productName = itemName + ' ' + typeName + ' ' + sizeName;

                // Set the value of the Product Name input
                $('input[name="Product_Name"]').val(productName);
            }

            // Attach the function to the change event of all dropdowns
            $('select[name="Item_Id"], select[name="Type_Id"], select[name="Size_Id"]').change(function() {
                updateProductName();
            });

            // Call the function initially to set the initial value
            updateProductName();
        });
    </script>

    <!-- .00 for Tax & Price -->
    <script>
        $(document).ready(function() {
            // Attach an event listener to the DISCOUNT input field
            $("#discountInput").on('blur', function() {
                formatDecimalInput($(this));
            });

            // Attach an event listener to the PRICE input field
            $("#priceInput").on('blur', function() {
                formatDecimalInput($(this));
            });

            // Function to format input as a decimal with two decimal places
            function formatDecimalInput(inputField) {
                // Get the entered value
                var inputValue = inputField.val();

                // Convert the value to a decimal with two decimal places
                var formattedValue = parseFloat(inputValue).toFixed(2);

                // Set the formatted value back to the input field
                inputField.val(formattedValue);
            }
        });
    </script>

    <!-- IMAGE -->
    <script>
        function previewImage() {
            var input = document.getElementById('prodImgInput');
            var preview = document.getElementById('preview');
            var previewContainer = document.getElementById('imagePreview');
            var existingImage = document.getElementById('existingImage'); // Add this line

            var file = input.files[0];

            if (file) {
                // Remove the existing image
                if (existingImage) {
                    existingImage.remove();
                }

                var reader = new FileReader();

                reader.onload = function(e) {
                    // Display the newly uploaded image
                    preview.src = e.target.result;
                    previewContainer.style.display = 'block';
                };

                reader.readAsDataURL(file);
            } else {
                // If no new file is selected, hide the preview
                preview.src = '';
                previewContainer.style.display = 'none';
            }
        }
    </script>


    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('SuccessMsg'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}

    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 3000);
    </script>
    @endif

    @if ($message = Session::get('errorMsg'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}

    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 3000);
    </script>
    @endif

</body>

</html>